/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.s2m.CallableWhitelistConfig;
import jenkins.security.s2m.ConfigFile;
import jenkins.security.s2m.RejectedCallable;

public class CallableRejectionConfig
extends ConfigFile<Class, Set<Class>> {
    private final CallableWhitelistConfig whitelist;
    private static final Logger LOGGER = Logger.getLogger(CallableRejectionConfig.class.getName());

    CallableRejectionConfig(File file, CallableWhitelistConfig whitelist) {
        super(file);
        this.whitelist = whitelist;
    }

    @Override
    protected Set<Class> create() {
        return new HashSet<Class>();
    }

    @Override
    protected Set<Class> readOnly(Set<Class> base) {
        return ImmutableSet.copyOf(base);
    }

    @Override
    protected Class parse(String line) {
        try {
            line = line.trim();
            if (this.whitelist.contains(line)) {
                return null;
            }
            return Jenkins.getInstance().pluginManager.uberClassLoader.loadClass(line);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    void report(Class c) {
        if (!((Set)this.get()).contains(c)) {
            try {
                this.append(c.getName());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to persist " + this.file, e);
            }
        }
    }

    public List<RejectedCallable> describe() {
        ArrayList<RejectedCallable> l = new ArrayList<RejectedCallable>();
        for (Class c : (Set)this.get()) {
            if (this.whitelist.contains(c.getName())) continue;
            l.add(new RejectedCallable(c));
        }
        return l;
    }
}

