/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.CloseProofOutputStream;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.Pipe;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import hudson.util.ProcessTree;
import hudson.util.QuotedStringTokenizer;
import hudson.util.StreamCopyThread;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class Launcher {
    protected final TaskListener listener;
    protected final VirtualChannel channel;
    public static boolean showFullPath = false;
    private static final NullInputStream NULL_INPUT_STREAM = new NullInputStream(0L);
    private static final Logger LOGGER = Logger.getLogger(Launcher.class.getName());

    public Launcher(TaskListener listener, VirtualChannel channel) {
        this.listener = listener;
        this.channel = channel;
    }

    protected Launcher(Launcher launcher) {
        this(launcher.listener, launcher.channel);
    }

    public VirtualChannel getChannel() {
        return this.channel;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    @Deprecated
    public Computer getComputer() {
        for (Computer c : Jenkins.getInstance().getComputers()) {
            if (c.getChannel() != this.channel) continue;
            return c;
        }
        return null;
    }

    public final ProcStarter launch() {
        return new ProcStarter();
    }

    @Deprecated
    public final Proc launch(String cmd, Map<String, String> env, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(cmd, Util.mapToEnv(env), out, workDir);
    }

    @Deprecated
    public final Proc launch(String[] cmd, Map<String, String> env, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(cmd, Util.mapToEnv(env), out, workDir);
    }

    @Deprecated
    public final Proc launch(String[] cmd, Map<String, String> env, InputStream in, OutputStream out) throws IOException {
        return this.launch(cmd, Util.mapToEnv(env), in, out);
    }

    @Deprecated
    public final Proc launch(String[] cmd, boolean[] mask, Map<String, String> env, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(cmd, mask, Util.mapToEnv(env), out, workDir);
    }

    @Deprecated
    public final Proc launch(String[] cmd, boolean[] mask, Map<String, String> env, InputStream in, OutputStream out) throws IOException {
        return this.launch(cmd, mask, Util.mapToEnv(env), in, out);
    }

    @Deprecated
    public final Proc launch(String cmd, String[] env, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(Util.tokenize(cmd), env, out, workDir);
    }

    @Deprecated
    public final Proc launch(String[] cmd, String[] env, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(cmd, env, null, out, workDir);
    }

    @Deprecated
    public final Proc launch(String[] cmd, String[] env, InputStream in, OutputStream out) throws IOException {
        return this.launch(cmd, env, in, out, null);
    }

    @Deprecated
    public final Proc launch(String[] cmd, boolean[] mask, String[] env, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(cmd, mask, env, null, out, workDir);
    }

    @Deprecated
    public final Proc launch(String[] cmd, boolean[] mask, String[] env, InputStream in, OutputStream out) throws IOException {
        return this.launch(cmd, mask, env, in, out, null);
    }

    @Deprecated
    public Proc launch(String[] cmd, String[] env, InputStream in, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(this.launch().cmds(cmd).envs(env).stdin(in).stdout(out).pwd(workDir));
    }

    @Deprecated
    public Proc launch(String[] cmd, boolean[] mask, String[] env, InputStream in, OutputStream out, FilePath workDir) throws IOException {
        return this.launch(this.launch().cmds(cmd).masks(mask).envs(env).stdin(in).stdout(out).pwd(workDir));
    }

    public abstract Proc launch(ProcStarter var1) throws IOException;

    public abstract Channel launchChannel(String[] var1, OutputStream var2, FilePath var3, Map<String, String> var4) throws IOException, InterruptedException;

    public boolean isUnix() {
        return File.pathSeparatorChar == ':';
    }

    public abstract void kill(Map<String, String> var1) throws IOException, InterruptedException;

    protected final void printCommandLine(String[] cmd, FilePath workDir) {
        StringBuilder buf = new StringBuilder();
        if (workDir != null) {
            buf.append('[');
            if (showFullPath) {
                buf.append(workDir.getRemote());
            } else {
                buf.append(workDir.getRemote().replaceFirst("^.+[/\\\\]", ""));
            }
            buf.append("] ");
        }
        buf.append('$');
        for (String c : cmd) {
            buf.append(' ');
            if (c.indexOf(32) >= 0) {
                if (c.indexOf(34) >= 0) {
                    buf.append('\'').append(c).append('\'');
                    continue;
                }
                buf.append('\"').append(c).append('\"');
                continue;
            }
            buf.append(c);
        }
        this.listener.getLogger().println(buf.toString());
    }

    protected final void maskedPrintCommandLine(List<String> cmd, boolean[] mask, FilePath workDir) {
        if (mask == null) {
            this.printCommandLine(cmd.toArray(new String[cmd.size()]), workDir);
            return;
        }
        assert (mask.length == cmd.size());
        String[] masked = new String[cmd.size()];
        for (int i = 0; i < cmd.size(); ++i) {
            masked[i] = mask[i] ? "********" : cmd.get(i);
        }
        this.printCommandLine(masked, workDir);
    }

    protected final void maskedPrintCommandLine(String[] cmd, boolean[] mask, FilePath workDir) {
        this.maskedPrintCommandLine(Arrays.asList(cmd), mask, workDir);
    }

    public final Launcher decorateFor(Node node) {
        Launcher l = this;
        for (LauncherDecorator d : LauncherDecorator.all()) {
            l = d.decorate(l, node);
        }
        return l;
    }

    public final Launcher decorateByPrefix(final String ... prefix) {
        final Launcher outer = this;
        return new Launcher(outer){

            @Override
            public boolean isUnix() {
                return outer.isUnix();
            }

            @Override
            public Proc launch(ProcStarter starter) throws IOException {
                starter.commands.addAll(0, Arrays.asList(prefix));
                if (starter.masks != null) {
                    starter.masks = this.prefix(starter.masks);
                }
                return outer.launch(starter);
            }

            @Override
            public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
                return outer.launchChannel(this.prefix(cmd), out, workDir, envVars);
            }

            @Override
            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                outer.kill(modelEnvVars);
            }

            private String[] prefix(String[] args) {
                String[] newArgs = new String[args.length + prefix.length];
                System.arraycopy(prefix, 0, newArgs, 0, prefix.length);
                System.arraycopy(args, 0, newArgs, prefix.length, args.length);
                return newArgs;
            }

            private boolean[] prefix(boolean[] args) {
                boolean[] newArgs = new boolean[args.length + prefix.length];
                System.arraycopy(args, 0, newArgs, prefix.length, args.length);
                return newArgs;
            }
        };
    }

    public final Launcher decorateByEnv(EnvVars _env) {
        final EnvVars env = new EnvVars(_env);
        final Launcher outer = this;
        return new Launcher(outer){

            @Override
            public boolean isUnix() {
                return outer.isUnix();
            }

            @Override
            public Proc launch(ProcStarter starter) throws IOException {
                EnvVars e = new EnvVars(env);
                if (starter.envs != null) {
                    for (String env2 : starter.envs) {
                        e.addLine(env2);
                    }
                }
                starter.envs = Util.mapToEnv(e);
                return outer.launch(starter);
            }

            @Override
            public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
                EnvVars e = new EnvVars(env);
                e.putAll(envVars);
                return outer.launchChannel(cmd, out, workDir, e);
            }

            @Override
            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                outer.kill(modelEnvVars);
            }
        };
    }

    private static EnvVars inherit(String[] env) {
        EnvVars m = new EnvVars();
        if (env != null) {
            for (String e : env) {
                int index = e.indexOf(61);
                m.put(e.substring(0, index), e.substring(index + 1));
            }
        }
        return Launcher.inherit(m);
    }

    private static EnvVars inherit(Map<String, String> overrides) {
        EnvVars m = new EnvVars(EnvVars.masterEnvVars);
        m.overrideExpandingAll(overrides);
        return m;
    }

    private static class RemoteChannelLaunchCallable
    extends MasterToSlaveCallable<OutputStream, IOException> {
        private final String[] cmd;
        private final Pipe out;
        private final String workDir;
        private final OutputStream err;
        private final Map<String, String> envOverrides;
        private static final long serialVersionUID = 1L;

        public RemoteChannelLaunchCallable(String[] cmd, Pipe out, OutputStream err, String workDir, Map<String, String> envOverrides) {
            this.cmd = cmd;
            this.out = out;
            this.err = new RemoteOutputStream(err);
            this.workDir = workDir;
            this.envOverrides = envOverrides;
        }

        public OutputStream call() throws IOException {
            Process p = Runtime.getRuntime().exec(this.cmd, Util.mapToEnv(Launcher.inherit(this.envOverrides)), this.workDir == null ? null : new File(this.workDir));
            List<String> cmdLines = Arrays.asList(this.cmd);
            new StreamCopyThread("stdin copier for remote agent on " + cmdLines, p.getInputStream(), this.out.getOut()).start();
            new StreamCopyThread("stderr copier for remote agent on " + cmdLines, p.getErrorStream(), this.err).start();
            return new RemoteOutputStream(p.getOutputStream());
        }
    }

    private static class RemoteLaunchCallable
    extends MasterToSlaveCallable<RemoteProcess, IOException> {
        private final List<String> cmd;
        private final boolean[] masks;
        private final String[] env;
        private final InputStream in;
        private final OutputStream out;
        private final OutputStream err;
        private final String workDir;
        private final TaskListener listener;
        private final boolean reverseStdin;
        private final boolean reverseStdout;
        private final boolean reverseStderr;
        private final boolean quiet;
        private static final long serialVersionUID = 1L;

        RemoteLaunchCallable(List<String> cmd, boolean[] masks, String[] env, InputStream in, boolean reverseStdin, OutputStream out, boolean reverseStdout, OutputStream err, boolean reverseStderr, boolean quiet, String workDir, TaskListener listener) {
            this.cmd = new ArrayList<String>(cmd);
            this.masks = masks;
            this.env = env;
            this.in = in;
            this.out = out;
            this.err = err;
            this.workDir = workDir;
            this.listener = listener;
            this.reverseStdin = reverseStdin;
            this.reverseStdout = reverseStdout;
            this.reverseStderr = reverseStderr;
            this.quiet = quiet;
        }

        public RemoteProcess call() throws IOException {
            ProcStarter ps = new LocalLauncher(this.listener).launch();
            ps.cmds(this.cmd).masks(this.masks).envs(this.env).stdin(this.in).stdout(this.out).stderr(this.err).quiet(this.quiet);
            if (this.workDir != null) {
                ps.pwd(this.workDir);
            }
            if (this.reverseStdin) {
                ps.writeStdin();
            }
            if (this.reverseStdout) {
                ps.readStdout();
            }
            if (this.reverseStderr) {
                ps.readStderr();
            }
            final Proc p = ps.start();
            return (RemoteProcess)Channel.current().export(RemoteProcess.class, (Object)new RemoteProcess(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int join() throws InterruptedException, IOException {
                    try {
                        int n = p.join();
                        return n;
                    }
                    finally {
                        try {
                            Channel.current().syncIO();
                        }
                        catch (Throwable throwable) {}
                    }
                }

                @Override
                public void kill() throws IOException, InterruptedException {
                    p.kill();
                }

                @Override
                public boolean isAlive() throws IOException, InterruptedException {
                    return p.isAlive();
                }

                @Override
                public IOTriplet getIOtriplet() {
                    IOTriplet r = new IOTriplet();
                    if (RemoteLaunchCallable.this.reverseStdout) {
                        r.stdout = new RemoteInputStream(p.getStdout());
                    }
                    if (RemoteLaunchCallable.this.reverseStderr) {
                        r.stderr = new RemoteInputStream(p.getStderr());
                    }
                    if (RemoteLaunchCallable.this.reverseStdin) {
                        r.stdin = new RemoteOutputStream(p.getStdin());
                    }
                    return r;
                }
            });
        }
    }

    public static interface RemoteProcess {
        public int join() throws InterruptedException, IOException;

        public void kill() throws IOException, InterruptedException;

        public boolean isAlive() throws IOException, InterruptedException;

        public IOTriplet getIOtriplet();
    }

    public static class IOTriplet
    implements Serializable {
        InputStream stdout;
        InputStream stderr;
        OutputStream stdin;
        private static final long serialVersionUID = 1L;
    }

    public static class DecoratedLauncher
    extends Launcher {
        private Launcher inner = null;

        public DecoratedLauncher(Launcher inner) {
            super(inner);
            this.inner = inner;
        }

        @Override
        public Proc launch(ProcStarter starter) throws IOException {
            return this.inner.launch(starter);
        }

        @Override
        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
            return this.inner.launchChannel(cmd, out, workDir, envVars);
        }

        @Override
        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
            this.inner.kill(modelEnvVars);
        }

        @Override
        public boolean isUnix() {
            return this.inner.isUnix();
        }

        @Override
        public Proc launch(String[] cmd, boolean[] mask, String[] env, InputStream in, OutputStream out, FilePath workDir) throws IOException {
            return this.inner.launch(cmd, mask, env, in, out, workDir);
        }

        @Override
        public Computer getComputer() {
            return this.inner.getComputer();
        }

        @Override
        public TaskListener getListener() {
            return this.inner.getListener();
        }

        public String toString() {
            return super.toString() + "; decorates " + this.inner.toString();
        }

        @Override
        public VirtualChannel getChannel() {
            return this.inner.getChannel();
        }

        @Override
        public Proc launch(String[] cmd, String[] env, InputStream in, OutputStream out, FilePath workDir) throws IOException {
            return this.inner.launch(cmd, env, in, out, workDir);
        }

        public Launcher getInner() {
            return this.inner;
        }
    }

    public static class RemoteLauncher
    extends Launcher {
        private final boolean isUnix;

        public RemoteLauncher(TaskListener listener, VirtualChannel channel, boolean isUnix) {
            super(listener, channel);
            this.isUnix = isUnix;
        }

        @Override
        public Proc launch(ProcStarter ps) throws IOException {
            RemoteOutputStream out = ps.stdout == null ? null : new RemoteOutputStream((OutputStream)new CloseProofOutputStream(ps.stdout));
            RemoteOutputStream err = ps.stderr == null ? null : new RemoteOutputStream((OutputStream)new CloseProofOutputStream(ps.stderr));
            RemoteInputStream in = ps.stdin == null || ps.stdin == NULL_INPUT_STREAM ? null : new RemoteInputStream(ps.stdin, false);
            String workDir = ps.pwd == null ? null : ps.pwd.getRemote();
            try {
                return new ProcImpl((RemoteProcess)this.getChannel().call((Callable)new RemoteLaunchCallable(ps.commands, ps.masks, ps.envs, (InputStream)in, ps.reverseStdin, (OutputStream)out, ps.reverseStdout, (OutputStream)err, ps.reverseStderr, ps.quiet, workDir, this.listener)));
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }

        @Override
        public Channel launchChannel(String[] cmd, OutputStream err, FilePath _workDir, Map<String, String> envOverrides) throws IOException, InterruptedException {
            this.printCommandLine(cmd, _workDir);
            Pipe out = Pipe.createRemoteToLocal();
            String workDir = _workDir == null ? null : _workDir.getRemote();
            OutputStream os = (OutputStream)this.getChannel().call((Callable)new RemoteChannelLaunchCallable(cmd, out, err, workDir, envOverrides));
            return new Channel("remotely launched channel on " + this.channel, Computer.threadPoolForRemoting, out.getIn(), (OutputStream)new BufferedOutputStream(os));
        }

        @Override
        public boolean isUnix() {
            return this.isUnix;
        }

        @Override
        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
            this.getChannel().call((Callable)new KillTask(modelEnvVars));
        }

        public static final class ProcImpl
        extends Proc {
            private final RemoteProcess process;
            private final IOTriplet io;

            public ProcImpl(RemoteProcess process) {
                this.process = process;
                this.io = process.getIOtriplet();
            }

            @Override
            public void kill() throws IOException, InterruptedException {
                this.process.kill();
            }

            @Override
            public int join() throws IOException, InterruptedException {
                return this.process.join();
            }

            @Override
            public boolean isAlive() throws IOException, InterruptedException {
                return this.process.isAlive();
            }

            @Override
            public InputStream getStdout() {
                return this.io.stdout;
            }

            @Override
            public InputStream getStderr() {
                return this.io.stderr;
            }

            @Override
            public OutputStream getStdin() {
                return this.io.stdin;
            }
        }

        private static final class KillTask
        extends MasterToSlaveCallable<Void, RuntimeException> {
            private final Map<String, String> modelEnvVars;
            private static final long serialVersionUID = 1L;

            public KillTask(Map<String, String> modelEnvVars) {
                this.modelEnvVars = modelEnvVars;
            }

            public Void call() throws RuntimeException {
                try {
                    ProcessTree.get().killAll(this.modelEnvVars);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DummyLauncher
    extends Launcher {
        public DummyLauncher(TaskListener listener) {
            super(listener, null);
        }

        @Override
        public Proc launch(ProcStarter starter) throws IOException {
            throw new IOException("Can not call launch on a dummy launcher.");
        }

        @Override
        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
            throw new IOException("Can not call launchChannel on a dummy launcher.");
        }

        @Override
        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
        }
    }

    public static class LocalLauncher
    extends Launcher {
        public LocalLauncher(TaskListener listener) {
            this(listener, (VirtualChannel)FilePath.localChannel);
        }

        public LocalLauncher(TaskListener listener, VirtualChannel channel) {
            super(listener, channel);
        }

        @Override
        public Proc launch(ProcStarter ps) throws IOException {
            if (!ps.quiet) {
                this.maskedPrintCommandLine(ps.commands, ps.masks, ps.pwd);
            }
            EnvVars jobEnv = Launcher.inherit(ps.envs);
            String[] jobCmd = new String[ps.commands.size()];
            for (int idx = 0; idx < jobCmd.length; ++idx) {
                jobCmd[idx] = jobEnv.expand(ps.commands.get(idx));
            }
            return new Proc.LocalProc(jobCmd, Util.mapToEnv(jobEnv), ps.reverseStdin ? Proc.LocalProc.SELFPUMP_INPUT : ps.stdin, ps.reverseStdout ? Proc.LocalProc.SELFPUMP_OUTPUT : ps.stdout, ps.reverseStderr ? Proc.LocalProc.SELFPUMP_OUTPUT : ps.stderr, this.toFile(ps.pwd));
        }

        private File toFile(FilePath f) {
            return f == null ? null : new File(f.getRemote());
        }

        @Override
        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException {
            this.printCommandLine(cmd, workDir);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(this.toFile(workDir));
            if (envVars != null) {
                pb.environment().putAll(envVars);
            }
            return this.launchChannel(out, pb);
        }

        @Override
        public void kill(Map<String, String> modelEnvVars) throws InterruptedException {
            ProcessTree.get().killAll(modelEnvVars);
        }

        public Channel launchChannel(OutputStream out, ProcessBuilder pb) throws IOException {
            final EnvVars cookie = EnvVars.createCookie();
            pb.environment().putAll(cookie);
            final Process proc = pb.start();
            final StreamCopyThread t2 = new StreamCopyThread(pb.command() + ": stderr copier", proc.getErrorStream(), out);
            t2.start();
            return new Channel("locally launched channel on " + pb.command(), Computer.threadPoolForRemoting, proc.getInputStream(), proc.getOutputStream(), out){

                public synchronized void terminate(IOException e) {
                    super.terminate(e);
                    ProcessTree pt = ProcessTree.get();
                    try {
                        pt.killAll(proc, cookie);
                    }
                    catch (InterruptedException x) {
                        LOGGER.log(Level.INFO, "Interrupted", x);
                    }
                }

                public synchronized void close() throws IOException {
                    super.close();
                    try {
                        t2.join();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
        }
    }

    public final class ProcStarter {
        protected List<String> commands;
        protected boolean[] masks;
        private boolean quiet;
        protected FilePath pwd;
        protected OutputStream stdout = NullOutputStream.NULL_OUTPUT_STREAM;
        protected OutputStream stderr;
        protected InputStream stdin = Launcher.access$000();
        protected String[] envs;
        protected boolean reverseStdin;
        protected boolean reverseStdout;
        protected boolean reverseStderr;

        public ProcStarter cmdAsSingleString(String s) {
            return this.cmds(QuotedStringTokenizer.tokenize(s));
        }

        public ProcStarter cmds(String ... args) {
            return this.cmds(Arrays.asList(args));
        }

        public ProcStarter cmds(File program, String ... args) {
            this.commands = new ArrayList<String>(args.length + 1);
            this.commands.add(program.getPath());
            this.commands.addAll(Arrays.asList(args));
            return this;
        }

        public ProcStarter cmds(List<String> args) {
            this.commands = new ArrayList<String>(args);
            return this;
        }

        public ProcStarter cmds(ArgumentListBuilder args) {
            this.commands = args.toList();
            this.masks = args.toMaskArray();
            return this;
        }

        public List<String> cmds() {
            return this.commands;
        }

        public ProcStarter masks(boolean ... masks) {
            this.masks = masks;
            return this;
        }

        public boolean[] masks() {
            return this.masks;
        }

        public ProcStarter quiet(boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public boolean quiet() {
            return this.quiet;
        }

        public ProcStarter pwd(FilePath workDir) {
            this.pwd = workDir;
            return this;
        }

        public ProcStarter pwd(File workDir) {
            return this.pwd(new FilePath(workDir));
        }

        public ProcStarter pwd(String workDir) {
            return this.pwd(new File(workDir));
        }

        public FilePath pwd() {
            return this.pwd;
        }

        public ProcStarter stdout(OutputStream out) {
            this.stdout = out;
            return this;
        }

        public ProcStarter stdout(TaskListener out) {
            return this.stdout(out.getLogger());
        }

        public OutputStream stdout() {
            return this.stdout;
        }

        public ProcStarter stderr(OutputStream err) {
            this.stderr = err;
            return this;
        }

        public OutputStream stderr() {
            return this.stderr;
        }

        public ProcStarter stdin(InputStream in) {
            this.stdin = in;
            return this;
        }

        public InputStream stdin() {
            return this.stdin;
        }

        public ProcStarter envs(Map<String, String> overrides) {
            this.envs = Util.mapToEnv(overrides);
            return this;
        }

        public ProcStarter envs(String ... overrides) {
            if (overrides != null) {
                for (String override : overrides) {
                    if (override.indexOf(61) != -1) continue;
                    throw new IllegalArgumentException(override);
                }
            }
            this.envs = overrides;
            return this;
        }

        public String[] envs() {
            return this.envs != null ? (String[])this.envs.clone() : new String[]{};
        }

        public ProcStarter readStdout() {
            this.reverseStdout = true;
            this.stderr = null;
            this.stdout = null;
            return this;
        }

        public ProcStarter readStderr() {
            this.reverseStdout = true;
            this.reverseStderr = true;
            return this;
        }

        public ProcStarter writeStdin() {
            this.reverseStdin = true;
            this.stdin = null;
            return this;
        }

        public Proc start() throws IOException {
            return Launcher.this.launch(this);
        }

        public int join() throws IOException, InterruptedException {
            return this.start().join();
        }

        public ProcStarter copy() {
            ProcStarter rhs = new ProcStarter().cmds(this.commands).pwd(this.pwd).masks(this.masks).stdin(this.stdin).stdout(this.stdout).stderr(this.stderr).envs(this.envs).quiet(this.quiet);
            rhs.reverseStdin = this.reverseStdin;
            rhs.reverseStderr = this.reverseStderr;
            rhs.reverseStdout = this.reverseStdout;
            return rhs;
        }
    }
}

