/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.ClassicPluginStrategy;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.LocalPluginManager;
import hudson.Messages;
import hudson.Plugin;
import hudson.PluginManagerStaplerOverride;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.InitStrategy;
import hudson.init.InitializerFinder;
import hudson.model.AbstractModelObject;
import hudson.model.AdministrativeMonitor;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.model.DownloadService;
import hudson.model.Failure;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.util.CyclicGraphDetector;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.PersistedList;
import hudson.util.Service;
import hudson.util.VersionNumber;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jenkins.ClassLoaderReflectionToolkit;
import jenkins.InitReactorRunner;
import jenkins.MissingDependencyException;
import jenkins.RestartRequiredException;
import jenkins.YesNoMaybe;
import jenkins.install.InstallState;
import jenkins.install.InstallUtil;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.io.OnMaster;
import jenkins.util.xml.RestrictiveEntityResolver;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.Symbol;
import org.jenkinsci.bytecode.Transformer;
import org.jvnet.hudson.reactor.Executable;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.ReactorException;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.hudson.reactor.TaskGraphBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ExportedBean
public abstract class PluginManager
extends AbstractModelObject
implements OnMaster,
StaplerOverridable {
    public static final String CUSTOM_PLUGIN_MANAGER = PluginManager.class.getName() + ".className";
    protected final List<PluginWrapper> plugins = new ArrayList<PluginWrapper>();
    protected final List<PluginWrapper> activePlugins = new CopyOnWriteArrayList<PluginWrapper>();
    protected final List<FailedPlugin> failedPlugins = new ArrayList<FailedPlugin>();
    public final File rootDir;
    @CheckForNull
    private final File workDir;
    @Deprecated
    public final ServletContext context;
    public final ClassLoader uberClassLoader = new UberClassLoader();
    private final Transformer compatibilityTransformer = new Transformer();
    public volatile boolean pluginUploaded = false;
    private boolean pluginListed = false;
    private final PluginStrategy strategy;
    private static final Logger LOGGER = Logger.getLogger(PluginManager.class.getName());
    public static boolean FAST_LOOKUP = !SystemProperties.getBoolean(PluginManager.class.getName() + ".noFastLookup");
    public static final Permission UPLOAD_PLUGINS = new Permission(Jenkins.PERMISSIONS, "UploadPlugins", Messages._PluginManager_UploadPluginsPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission CONFIGURE_UPDATECENTER = new Permission(Jenkins.PERMISSIONS, "ConfigureUpdateCenter", Messages._PluginManager_ConfigureUpdateCenterPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);

    @NonNull
    public static PluginManager createDefault(@NonNull Jenkins jenkins) {
        String pmClassName = SystemProperties.getString(CUSTOM_PLUGIN_MANAGER);
        if (!StringUtils.isBlank((String)pmClassName)) {
            LOGGER.log(Level.FINE, String.format("Use of custom plugin manager [%s] requested.", pmClassName));
            try {
                Class<PluginManager> klass = Class.forName(pmClassName).asSubclass(PluginManager.class);
                for (PMConstructor c : PMConstructor.values()) {
                    PluginManager pm = c.create(klass, jenkins);
                    if (pm == null) continue;
                    return pm;
                }
                LOGGER.log(Level.WARNING, String.format("Provided custom plugin manager [%s] does not provide any of the suitable constructors. Using default.", pmClassName));
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.WARNING, String.format("Unable to instantiate custom plugin manager [%s]. Using default.", pmClassName));
            }
            catch (ClassCastException e) {
                LOGGER.log(Level.WARNING, String.format("Provided class [%s] does not extend PluginManager. Using default.", pmClassName));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Unable to instantiate custom plugin manager [%s]. Using default.", pmClassName), e);
            }
        }
        return new LocalPluginManager(jenkins);
    }

    public PluginManager(ServletContext context, File rootDir) {
        String workDir;
        this.context = context;
        this.rootDir = rootDir;
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        this.workDir = StringUtils.isBlank((String)(workDir = SystemProperties.getString(PluginManager.class.getName() + ".workDir"))) ? null : new File(workDir);
        this.strategy = this.createPluginStrategy();
        try {
            this.compatibilityTransformer.loadRules(this.getClass().getClassLoader());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load compatibility rewrite rules", e);
        }
    }

    public Transformer getCompatibilityTransformer() {
        return this.compatibilityTransformer;
    }

    public Api getApi() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        return new Api(this);
    }

    @CheckForNull
    public File getWorkDir() {
        return this.workDir;
    }

    public Collection<PluginManagerStaplerOverride> getOverrides() {
        return PluginManagerStaplerOverride.all();
    }

    public TaskBuilder initTasks(final InitStrategy initStrategy) {
        Object builder = !this.pluginListed ? new TaskGraphBuilder(){
            List<File> archives;
            Collection<String> bundledPlugins;
            {
                TaskGraphBuilder.Handle loadBundledPlugins = this.add("Loading bundled plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        bundledPlugins = PluginManager.this.loadBundledPlugins();
                    }
                });
                TaskGraphBuilder.Handle listUpPlugins = this.requires(new Milestone[]{loadBundledPlugins}).add("Listing up plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        archives = initStrategy.listPluginArchives(PluginManager.this);
                    }
                });
                this.requires(new Milestone[]{listUpPlugins}).attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Preparing plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        TaskGraphBuilder g = new TaskGraphBuilder();
                        final HashMap inspectedShortNames = new HashMap();
                        for (final File arc : archives) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Inspecting plugin " + arc, new Executable(){

                                public void run(Reactor session1) throws Exception {
                                    try {
                                        PluginWrapper p = PluginManager.this.strategy.createPluginWrapper(arc);
                                        if (this.isDuplicate(p)) {
                                            return;
                                        }
                                        p.isBundled = PluginManager.this.containsHpiJpi(bundledPlugins, arc.getName());
                                        PluginManager.this.plugins.add(p);
                                    }
                                    catch (IOException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(arc.getName(), e));
                                        throw e;
                                    }
                                }

                                private boolean isDuplicate(PluginWrapper p) {
                                    String shortName = p.getShortName();
                                    if (inspectedShortNames.containsKey(shortName)) {
                                        LOGGER.info("Ignoring " + arc + " because " + inspectedShortNames.get(shortName) + " is already loaded");
                                        return true;
                                    }
                                    inspectedShortNames.put(shortName, arc);
                                    return false;
                                }
                            });
                        }
                        g.followedBy().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Checking cyclic dependencies", new Executable(){

                            public void run(Reactor reactor) throws Exception {
                                try {
                                    CyclicGraphDetector<PluginWrapper> cgd = new CyclicGraphDetector<PluginWrapper>(){

                                        @Override
                                        protected List<PluginWrapper> getEdges(PluginWrapper p) {
                                            ArrayList<PluginWrapper> next = new ArrayList<PluginWrapper>();
                                            this.addTo(p.getDependencies(), next);
                                            this.addTo(p.getOptionalDependencies(), next);
                                            return next;
                                        }

                                        private void addTo(List<PluginWrapper.Dependency> dependencies, List<PluginWrapper> r) {
                                            for (PluginWrapper.Dependency d : dependencies) {
                                                PluginWrapper p = PluginManager.this.getPlugin(d.shortName);
                                                if (p == null) continue;
                                                r.add(p);
                                            }
                                        }

                                        @Override
                                        protected void reactOnCycle(PluginWrapper q, List<PluginWrapper> cycle) throws CyclicGraphDetector.CycleDetectedException {
                                            LOGGER.log(Level.SEVERE, "found cycle in plugin dependencies: (root=" + q + ", deactivating all involved) " + Util.join(cycle, " -> "));
                                            for (PluginWrapper pluginWrapper : cycle) {
                                                pluginWrapper.setHasCycleDependency(true);
                                                PluginManager.this.failedPlugins.add(new FailedPlugin(pluginWrapper.getShortName(), new CyclicGraphDetector.CycleDetectedException(cycle)));
                                            }
                                        }
                                    };
                                    cgd.run(PluginManager.this.getPlugins());
                                    ListIterator<PluginWrapper> litr = PluginManager.this.getPlugins().listIterator();
                                    for (PluginWrapper p : cgd.getSorted()) {
                                        litr.next();
                                        litr.set(p);
                                        if (!p.isActive()) continue;
                                        PluginManager.this.activePlugins.add(p);
                                    }
                                }
                                catch (CyclicGraphDetector.CycleDetectedException e) {
                                    PluginManager.this.stop();
                                    throw e;
                                }
                            }
                        });
                        session.addAll(g.discoverTasks(session));
                        PluginManager.this.pluginListed = true;
                    }
                });
            }
        } : TaskBuilder.EMPTY_BUILDER;
        final InitializerFinder initializerFinder = new InitializerFinder(this.uberClassLoader);
        return TaskBuilder.union((TaskBuilder[])new TaskBuilder[]{initializerFinder, builder, new TaskGraphBuilder(){
            {
                this.requires(new Milestone[]{InitMilestone.PLUGINS_LISTED}).attains(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).add("Loading plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        Jenkins.getInstance().lookup.set(PluginInstanceStore.class, new PluginInstanceStore());
                        TaskGraphBuilder g = new TaskGraphBuilder();
                        for (final PluginWrapper p : PluginManager.this.activePlugins.toArray(new PluginWrapper[PluginManager.this.activePlugins.size()])) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).add("Loading plugin " + p.getShortName(), new Executable(){

                                public void run(Reactor session) throws Exception {
                                    try {
                                        p.resolvePluginDependencies();
                                        PluginManager.this.strategy.load(p);
                                    }
                                    catch (MissingDependencyException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(p.getShortName(), e));
                                        PluginManager.this.activePlugins.remove(p);
                                        PluginManager.this.plugins.remove(p);
                                        LOGGER.log(Level.SEVERE, "Failed to install {0}: {1}", new Object[]{p.getShortName(), e.getMessage()});
                                        return;
                                    }
                                    catch (IOException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(p.getShortName(), e));
                                        PluginManager.this.activePlugins.remove(p);
                                        PluginManager.this.plugins.remove(p);
                                        throw e;
                                    }
                                }
                            });
                        }
                        for (final PluginWrapper p : PluginManager.this.activePlugins.toArray(new PluginWrapper[PluginManager.this.activePlugins.size()])) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_STARTED}).add("Initializing plugin " + p.getShortName(), new Executable(){

                                public void run(Reactor session) throws Exception {
                                    if (!PluginManager.this.activePlugins.contains(p)) {
                                        return;
                                    }
                                    try {
                                        p.getPlugin().postInitialize();
                                    }
                                    catch (Exception e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(p.getShortName(), e));
                                        PluginManager.this.activePlugins.remove(p);
                                        PluginManager.this.plugins.remove(p);
                                        throw e;
                                    }
                                }
                            });
                        }
                        g.followedBy().attains(new Milestone[]{InitMilestone.PLUGINS_STARTED}).add("Discovering plugin initialization tasks", new Executable(){

                            public void run(Reactor reactor) throws Exception {
                                reactor.addAll((Iterable)initializerFinder.discoverTasks(reactor));
                            }
                        });
                        session.addAll(g.discoverTasks(session));
                    }
                });
                this.requires(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).attains(new Milestone[]{InitMilestone.COMPLETED}).add("Resolving Dependant Plugins Graph", new Executable(){

                    public void run(Reactor reactor) throws Exception {
                        PluginManager.this.resolveDependantPlugins();
                    }
                });
            }
        }});
    }

    @Nonnull
    protected Set<String> loadPluginsFromWar(@Nonnull String fromPath) {
        return this.loadPluginsFromWar(fromPath, null);
    }

    @Nonnull
    protected Set<String> loadPluginsFromWar(@Nonnull String fromPath, @CheckForNull FilenameFilter filter) {
        String fileName;
        HashSet<String> names = new HashSet<String>();
        ServletContext context = Jenkins.getActiveInstance().servletContext;
        Set<String> plugins = Util.fixNull(context.getResourcePaths(fromPath));
        HashSet<URL> copiedPlugins = new HashSet<URL>();
        HashSet<URL> dependencies = new HashSet<URL>();
        for (String pluginPath : plugins) {
            fileName = pluginPath.substring(pluginPath.lastIndexOf(47) + 1);
            if (fileName.length() == 0) continue;
            try {
                URL url = context.getResource(pluginPath);
                if (filter != null && url != null && !filter.accept(new File(url.getFile()).getParentFile(), fileName)) continue;
                names.add(fileName);
                this.copyBundledPlugin(url, fileName);
                copiedPlugins.add(url);
                try {
                    PluginManager.addDependencies(url, fromPath, dependencies);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed to resolve dependencies for the bundled plugin " + fileName, e);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to extract the bundled plugin " + fileName, e);
            }
        }
        for (URL dependency : dependencies) {
            if (copiedPlugins.contains(dependency)) continue;
            fileName = new File(dependency.getFile()).getName();
            try {
                names.add(fileName);
                this.copyBundledPlugin(dependency, fileName);
                copiedPlugins.add(dependency);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to extract the bundled dependency plugin " + fileName, e);
            }
        }
        return names;
    }

    protected static void addDependencies(URL hpiResUrl, String fromPath, Set<URL> dependencySet) throws URISyntaxException, MalformedURLException {
        if (dependencySet.contains(hpiResUrl)) {
            return;
        }
        Manifest manifest = PluginManager.parsePluginManifest(hpiResUrl);
        String dependencySpec = manifest.getMainAttributes().getValue("Plugin-Dependencies");
        if (dependencySpec != null) {
            String[] dependencyTokens = dependencySpec.split(",");
            ServletContext context = Jenkins.getActiveInstance().servletContext;
            for (String dependencyToken : dependencyTokens) {
                if (dependencyToken.endsWith(";resolution:=optional")) continue;
                String artifactId = dependencyToken.split(":")[0];
                URL dependencyURL = context.getResource(fromPath + "/" + artifactId + ".hpi");
                if (dependencyURL == null) {
                    dependencyURL = context.getResource(fromPath + "/" + artifactId + ".jpi");
                }
                if (dependencyURL == null) continue;
                PluginManager.addDependencies(dependencyURL, fromPath, dependencySet);
                dependencySet.add(dependencyURL);
            }
        }
    }

    protected void loadDetachedPlugins() {
        InstallState installState = Jenkins.getActiveInstance().getInstallState();
        if (InstallState.UPGRADE.equals(installState)) {
            VersionNumber lastExecVersion = new VersionNumber(InstallUtil.getLastExecVersion());
            LOGGER.log(Level.INFO, "Upgrading Jenkins. The last running version was {0}. This Jenkins is version {1}.", new Object[]{lastExecVersion, Jenkins.VERSION});
            final List<ClassicPluginStrategy.DetachedPlugin> detachedPlugins = ClassicPluginStrategy.getDetachedPlugins(lastExecVersion);
            Set<String> loadedDetached = this.loadPluginsFromWar("/WEB-INF/detached-plugins", new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (ClassicPluginStrategy.isDetachedPlugin(name = PluginManager.this.normalisePluginName(name))) {
                        VersionNumber installedVersion = PluginManager.this.getPluginVersion(PluginManager.this.rootDir, name);
                        VersionNumber bundledVersion = PluginManager.this.getPluginVersion(dir, name);
                        if (installedVersion != null && bundledVersion != null && installedVersion.isOlderThan(bundledVersion)) {
                            return true;
                        }
                    }
                    for (ClassicPluginStrategy.DetachedPlugin detachedPlugin : detachedPlugins) {
                        if (!detachedPlugin.getShortName().equals(name)) continue;
                        return true;
                    }
                    return false;
                }
            });
            LOGGER.log(Level.INFO, "Upgraded Jenkins from version {0} to version {1}. Loaded detached plugins (and dependencies): {2}", new Object[]{lastExecVersion, Jenkins.VERSION, loadedDetached});
            InstallUtil.saveLastExecVersion();
        }
    }

    private String normalisePluginName(@Nonnull String name) {
        return name.replace(".jpi", "").replace(".hpi", "");
    }

    @CheckForNull
    private VersionNumber getPluginVersion(@Nonnull File dir, @Nonnull String pluginId) {
        VersionNumber version = this.getPluginVersion(new File(dir, pluginId + ".jpi"));
        if (version == null) {
            version = this.getPluginVersion(new File(dir, pluginId + ".hpi"));
        }
        return version;
    }

    @CheckForNull
    private VersionNumber getPluginVersion(@Nonnull File pluginFile) {
        if (!pluginFile.exists()) {
            return null;
        }
        try {
            return this.getPluginVersion(pluginFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @CheckForNull
    private VersionNumber getPluginVersion(@Nonnull URL pluginURL) {
        Manifest manifest = PluginManager.parsePluginManifest(pluginURL);
        if (manifest == null) {
            return null;
        }
        String versionSpec = manifest.getMainAttributes().getValue("Plugin-Version");
        return new VersionNumber(versionSpec);
    }

    private boolean containsHpiJpi(Collection<String> bundledPlugins, String name) {
        return bundledPlugins.contains(name.replaceAll("\\.hpi", ".jpi")) || bundledPlugins.contains(name.replaceAll("\\.jpi", ".hpi"));
    }

    @Deprecated
    @CheckForNull
    public Manifest getBundledPluginManifest(String shortName) {
        return null;
    }

    public void dynamicLoad(File arc) throws IOException, InterruptedException, RestartRequiredException {
        this.dynamicLoad(arc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public void dynamicLoad(File arc, boolean removeExisting) throws IOException, InterruptedException, RestartRequiredException {
        Object i;
        String sn;
        LOGGER.info("Attempting to dynamic load " + arc);
        PluginWrapper p = null;
        try {
            sn = this.strategy.getShortName(arc);
        }
        catch (AbstractMethodError x) {
            LOGGER.log(Level.WARNING, "JENKINS-12753 fix not active: {0}", x.getMessage());
            p = this.strategy.createPluginWrapper(arc);
            sn = p.getShortName();
        }
        PluginWrapper pw = this.getPlugin(sn);
        if (pw != null) {
            if (removeExisting) {
                i = this.plugins.iterator();
                while (i.hasNext()) {
                    pw = i.next();
                    if (!sn.equals(pw.getShortName())) continue;
                    i.remove();
                    pw = null;
                    break;
                }
            } else {
                throw new RestartRequiredException(Messages._PluginManager_PluginIsAlreadyInstalled_RestartRequired(sn));
            }
        }
        if (p == null) {
            p = this.strategy.createPluginWrapper(arc);
        }
        if (p.supportsDynamicLoad() == YesNoMaybe.NO) {
            throw new RestartRequiredException(Messages._PluginManager_PluginDoesntSupportDynamicLoad_RestartRequired(sn));
        }
        this.plugins.add(p);
        this.activePlugins.add(p);
        i = ((UberClassLoader)this.uberClassLoader).loaded;
        synchronized (i) {
            ((UberClassLoader)this.uberClassLoader).loaded.clear();
        }
        try {
            p.resolvePluginDependencies();
            this.strategy.load(p);
            Jenkins.getInstance().refreshExtensions();
            p.getPlugin().postInitialize();
        }
        catch (Exception e) {
            this.failedPlugins.add(new FailedPlugin(sn, e));
            this.activePlugins.remove(p);
            this.plugins.remove(p);
            throw new IOException("Failed to install " + sn + " plugin", e);
        }
        Reactor r = new Reactor(new TaskBuilder[]{InitMilestone.ordering()});
        final ClassLoader loader = p.classLoader;
        r.addAll((Iterable)new InitializerFinder(loader){

            @Override
            protected boolean filter(Method e) {
                return e.getDeclaringClass().getClassLoader() != loader || super.filter(e);
            }
        }.discoverTasks(r));
        try {
            new InitReactorRunner().run(r);
        }
        catch (ReactorException e) {
            throw new IOException("Failed to initialize " + sn + " plugin", e);
        }
        block12: for (PluginWrapper depender : this.plugins) {
            if (depender.equals(p)) continue;
            for (PluginWrapper.Dependency d : depender.getOptionalDependencies()) {
                if (!d.shortName.equals(p.getShortName())) continue;
                try {
                    this.getPluginStrategy().updateDependency(depender, p);
                }
                catch (AbstractMethodError x) {
                    LOGGER.log(Level.WARNING, "{0} does not yet implement updateDependency", this.getPluginStrategy().getClass());
                }
                continue block12;
            }
        }
        this.resolveDependantPlugins();
        LOGGER.info("Plugin " + p.getShortName() + ":" + p.getVersion() + " dynamically installed");
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized void resolveDependantPlugins() {
        for (PluginWrapper plugin : this.plugins) {
            HashSet<String> dependants = new HashSet<String>();
            for (PluginWrapper possibleDependant : this.plugins) {
                if (possibleDependant.isDeleted()) continue;
                List<PluginWrapper.Dependency> dependencies = possibleDependant.getDependencies();
                for (PluginWrapper.Dependency dependency : dependencies) {
                    if (!dependency.shortName.equals(plugin.getShortName())) continue;
                    dependants.add(possibleDependant.getShortName());
                }
            }
            plugin.setDependants(dependants);
        }
    }

    protected abstract Collection<String> loadBundledPlugins() throws Exception;

    protected void copyBundledPlugin(URL src, String fileName) throws IOException {
        fileName = fileName.replace(".hpi", ".jpi");
        String legacyName = fileName.replace(".jpi", ".hpi");
        long lastModified = src.openConnection().getLastModified();
        File file = new File(this.rootDir, fileName);
        this.rename(new File(this.rootDir, legacyName), file);
        if (!file.exists() || file.lastModified() != lastModified) {
            FileUtils.copyURLToFile((URL)src, (File)file);
            file.setLastModified(src.openConnection().getLastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private static Manifest parsePluginManifest(URL bundledJpi) {
        try {
            InputStream in;
            URLClassLoader cl;
            block4: {
                Manifest manifest2;
                cl = new URLClassLoader(new URL[]{bundledJpi});
                in = null;
                try {
                    Manifest manifest;
                    URL res = cl.findResource("META-INF/MANIFEST.MF");
                    if (res == null) break block4;
                    in = res.openStream();
                    manifest2 = manifest = new Manifest(in);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    if (!(cl instanceof Closeable)) throw throwable;
                    cl.close();
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (!(cl instanceof Closeable)) return manifest2;
                cl.close();
                return manifest2;
            }
            IOUtils.closeQuietly(in);
            if (!(cl instanceof Closeable)) return null;
            cl.close();
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to parse manifest of " + bundledJpi, e);
        }
        return null;
    }

    private void rename(File legacyFile, File newFile) throws IOException {
        if (!legacyFile.exists()) {
            return;
        }
        if (newFile.exists()) {
            Util.deleteFile(newFile);
        }
        if (!legacyFile.renameTo(newFile)) {
            LOGGER.warning("Failed to rename " + legacyFile + " to " + newFile);
        }
    }

    protected PluginStrategy createPluginStrategy() {
        String strategyName = SystemProperties.getString(PluginStrategy.class.getName());
        if (strategyName != null) {
            try {
                Class<?> klazz = this.getClass().getClassLoader().loadClass(strategyName);
                Object strategy = klazz.getConstructor(PluginManager.class).newInstance(this);
                if (strategy instanceof PluginStrategy) {
                    LOGGER.info("Plugin strategy: " + strategyName);
                    return (PluginStrategy)strategy;
                }
                LOGGER.warning("Plugin strategy (" + strategyName + ") is not an instance of hudson.PluginStrategy");
            }
            catch (ClassNotFoundException e) {
                LOGGER.warning("Plugin strategy class not found: " + strategyName);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not instantiate plugin strategy: " + strategyName + ". Falling back to ClassicPluginStrategy", e);
            }
            LOGGER.info("Falling back to ClassicPluginStrategy");
        }
        return new ClassicPluginStrategy(this);
    }

    public PluginStrategy getPluginStrategy() {
        return this.strategy;
    }

    public boolean isPluginUploaded() {
        return this.pluginUploaded;
    }

    @Exported
    public List<PluginWrapper> getPlugins() {
        ArrayList<PluginWrapper> out = new ArrayList<PluginWrapper>(this.plugins.size());
        out.addAll(this.plugins);
        return out;
    }

    public List<FailedPlugin> getFailedPlugins() {
        return this.failedPlugins;
    }

    public PluginWrapper getPlugin(String shortName) {
        for (PluginWrapper p : this.getPlugins()) {
            if (!p.getShortName().equals(shortName)) continue;
            return p;
        }
        return null;
    }

    public PluginWrapper getPlugin(Class<? extends Plugin> pluginClazz) {
        for (PluginWrapper p : this.getPlugins()) {
            if (!pluginClazz.isInstance(p.getPlugin())) continue;
            return p;
        }
        return null;
    }

    public List<PluginWrapper> getPlugins(Class<? extends Plugin> pluginSuperclass) {
        ArrayList<PluginWrapper> result = new ArrayList<PluginWrapper>();
        for (PluginWrapper p : this.getPlugins()) {
            if (!pluginSuperclass.isInstance(p.getPlugin())) continue;
            result.add(p);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getDisplayName() {
        return Messages.PluginManager_DisplayName();
    }

    @Override
    public String getSearchUrl() {
        return "pluginManager";
    }

    public <T> Collection<Class<? extends T>> discover(Class<T> spi) {
        HashSet<Class<? extends T>> result = new HashSet<Class<? extends T>>();
        for (PluginWrapper p : this.activePlugins) {
            Service.load(spi, p.classLoader, result);
        }
        return result;
    }

    public PluginWrapper whichPlugin(Class c) {
        PluginWrapper oneAndOnly = null;
        ClassLoader cl = c.getClassLoader();
        for (PluginWrapper p : this.activePlugins) {
            if (p.classLoader != cl) continue;
            if (oneAndOnly != null) {
                return null;
            }
            oneAndOnly = p;
        }
        return oneAndOnly;
    }

    public void stop() {
        for (PluginWrapper p : this.activePlugins) {
            p.stop();
            p.releaseClassLoader();
        }
        this.activePlugins.clear();
        LogFactory.release((ClassLoader)this.uberClassLoader);
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doPlugins() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        JSONArray response = new JSONArray();
        HashMap allPlugins = new HashMap();
        for (PluginWrapper plugin : this.plugins) {
            JSONObject pluginInfo = new JSONObject();
            pluginInfo.put("installed", (Object)true);
            pluginInfo.put("name", (Object)plugin.getShortName());
            pluginInfo.put("title", (Object)plugin.getDisplayName());
            pluginInfo.put("active", (Object)plugin.isActive());
            pluginInfo.put("enabled", (Object)plugin.isEnabled());
            pluginInfo.put("bundled", (Object)plugin.isBundled);
            pluginInfo.put("deleted", (Object)plugin.isDeleted());
            pluginInfo.put("downgradable", (Object)plugin.isDowngradable());
            pluginInfo.put("website", (Object)plugin.getUrl());
            List<PluginWrapper.Dependency> dependencies = plugin.getDependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                HashMap<String, String> dependencyMap = new HashMap<String, String>();
                for (PluginWrapper.Dependency dependency : dependencies) {
                    dependencyMap.put(dependency.shortName, dependency.version);
                }
                pluginInfo.put("dependencies", dependencyMap);
            } else {
                pluginInfo.put("dependencies", Collections.emptyMap());
            }
            response.add((Object)pluginInfo);
        }
        for (UpdateSite site : Jenkins.getActiveInstance().getUpdateCenter().getSiteList()) {
            for (UpdateSite.Plugin plugin : site.getAvailables()) {
                JSONObject pluginInfo = (JSONObject)allPlugins.get(plugin.name);
                if (pluginInfo == null) {
                    pluginInfo = new JSONObject();
                    pluginInfo.put("installed", (Object)false);
                }
                pluginInfo.put("name", (Object)plugin.name);
                pluginInfo.put("title", (Object)plugin.getDisplayName());
                pluginInfo.put("excerpt", (Object)plugin.excerpt);
                pluginInfo.put("site", (Object)site.getId());
                pluginInfo.put("dependencies", plugin.dependencies);
                pluginInfo.put("website", (Object)plugin.wiki);
                response.add((Object)pluginInfo);
            }
        }
        return HttpResponses.okJSON(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doUpdateSources(StaplerRequest req) throws IOException {
        Jenkins.getInstance().checkPermission(CONFIGURE_UPDATECENTER);
        if (req.hasParameter("remove")) {
            UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
            BulkChange bc = new BulkChange(uc);
            try {
                for (String id : req.getParameterValues("sources")) {
                    uc.getSites().remove(uc.getById(id));
                }
            }
            finally {
                bc.commit();
            }
        } else if (req.hasParameter("add")) {
            return new HttpRedirect("addSite");
        }
        return new HttpRedirect("./sites");
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public void doInstallPluginsDone() {
        Jenkins j = Jenkins.getInstance();
        j.checkPermission(Jenkins.ADMINISTER);
        InstallUtil.proceedToNextStateFrom(InstallState.INITIAL_PLUGINS_INSTALLING);
    }

    public void doInstall(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        LinkedHashSet<String> plugins = new LinkedHashSet<String>();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            if (!n.startsWith("plugin.")) continue;
            n = n.substring(7);
            plugins.add(n);
        }
        boolean dynamicLoad = req.getParameter("dynamicLoad") != null;
        this.install(plugins, dynamicLoad);
        rsp.sendRedirect("../updateCenter/");
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public HttpResponse doInstallPlugins(StaplerRequest req) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        String payload = IOUtils.toString((InputStream)req.getInputStream(), (String)req.getCharacterEncoding());
        JSONObject request = JSONObject.fromObject((Object)payload);
        JSONArray pluginListJSON = request.getJSONArray("plugins");
        ArrayList<String> plugins = new ArrayList<String>();
        for (int i = 0; i < pluginListJSON.size(); ++i) {
            plugins.add(pluginListJSON.getString(i));
        }
        UUID correlationId = UUID.randomUUID();
        try {
            boolean dynamicLoad = request.getBoolean("dynamicLoad");
            this.install(plugins, dynamicLoad, correlationId);
            JSONObject responseData = new JSONObject();
            responseData.put("correlationId", (Object)correlationId.toString());
            return HttpResponses.okJSON(responseData);
        }
        catch (Exception e) {
            return HttpResponses.errorJSON(e.getMessage());
        }
    }

    @Restricted(value={NoExternalUse.class})
    public List<Future<UpdateCenter.UpdateCenterJob>> install(@Nonnull Collection<String> plugins, boolean dynamicLoad) {
        return this.install(plugins, dynamicLoad, null);
    }

    private List<Future<UpdateCenter.UpdateCenterJob>> install(@Nonnull Collection<String> plugins, boolean dynamicLoad, @CheckForNull UUID correlationId) {
        ArrayList<Future<UpdateCenter.UpdateCenterJob>> installJobs = new ArrayList<Future<UpdateCenter.UpdateCenterJob>>();
        for (String n : plugins) {
            int index = n.indexOf(46);
            UpdateSite.Plugin p = null;
            if (index == -1) {
                p = this.getPlugin(n, UpdateCenter.ID_DEFAULT);
            } else {
                while (index != -1 && index + 1 < n.length()) {
                    String siteName;
                    String pluginName = n.substring(0, index);
                    UpdateSite.Plugin plugin = this.getPlugin(pluginName, siteName = n.substring(index + 1));
                    if (plugin != null) {
                        if (p != null) {
                            throw new Failure("Ambiguous plugin: " + n);
                        }
                        p = plugin;
                    }
                    index = n.indexOf(46, index + 1);
                }
            }
            if (p == null) {
                throw new Failure("No such plugin: " + n);
            }
            Future<UpdateCenter.UpdateCenterJob> jobFuture = p.deploy(dynamicLoad, correlationId);
            installJobs.add(jobFuture);
        }
        this.trackInitialPluginInstall(installJobs);
        return installJobs;
    }

    private void trackInitialPluginInstall(final @Nonnull List<Future<UpdateCenter.UpdateCenterJob>> installJobs) {
        Jenkins jenkins = Jenkins.getInstance();
        final UpdateCenter updateCenter = jenkins.getUpdateCenter();
        final Authentication currentAuth = Jenkins.getAuthentication();
        if (!Jenkins.getInstance().getInstallState().isSetupComplete()) {
            jenkins.setInstallState(InstallState.INITIAL_PLUGINS_INSTALLING);
            updateCenter.persistInstallStatus();
            new Thread(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 3[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.start();
        }
        new Thread(){

            @Override
            public void run() {
                block2: while (true) {
                    for (Future deployJob : installJobs) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.SEVERE, "Unexpected error while waiting for some plugins to install. Plugin Manager state may be invalid. Please restart Jenkins ASAP.", e);
                        }
                        if (deployJob.isCancelled() || deployJob.isDone()) continue;
                        continue block2;
                    }
                    break;
                }
                PluginManager.this.resolveDependantPlugins();
            }
        }.start();
    }

    private UpdateSite.Plugin getPlugin(String pluginName, String siteName) {
        UpdateSite updateSite = Jenkins.getInstance().getUpdateCenter().getById(siteName);
        if (updateSite == null) {
            throw new Failure("No such update center: " + siteName);
        }
        return updateSite.getPlugin(pluginName);
    }

    @RequirePOST
    public HttpResponse doSiteConfigure(@QueryParameter String site) throws IOException {
        Jenkins hudson = Jenkins.getInstance();
        hudson.checkPermission(CONFIGURE_UPDATECENTER);
        UpdateCenter uc = hudson.getUpdateCenter();
        PersistedList<UpdateSite> sites = uc.getSites();
        for (UpdateSite s : sites) {
            if (!s.getId().equals(UpdateCenter.ID_DEFAULT)) continue;
            sites.remove(s);
        }
        sites.add(new UpdateSite(UpdateCenter.ID_DEFAULT, site));
        return org.kohsuke.stapler.HttpResponses.redirectToContextRoot();
    }

    @RequirePOST
    public HttpResponse doProxyConfigure(StaplerRequest req) throws IOException, ServletException {
        Jenkins jenkins = Jenkins.getInstance();
        jenkins.checkPermission(CONFIGURE_UPDATECENTER);
        ProxyConfiguration pc = (ProxyConfiguration)req.bindJSON(ProxyConfiguration.class, req.getSubmittedForm());
        if (pc.name == null) {
            jenkins.proxy = null;
            ProxyConfiguration.getXmlFile().delete();
        } else {
            jenkins.proxy = pc;
            jenkins.proxy.save();
        }
        return new HttpRedirect("advanced");
    }

    @RequirePOST
    public HttpResponse doUploadPlugin(StaplerRequest req) throws IOException, ServletException {
        try {
            Jenkins.getInstance().checkPermission(UPLOAD_PLUGINS);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            FileItem fileItem = (FileItem)upload.parseRequest((HttpServletRequest)req).get(0);
            String fileName = Util.getFileName(fileItem.getName());
            if ("".equals(fileName)) {
                return new HttpRedirect("advanced");
            }
            if (!fileName.endsWith(".jpi") && !fileName.endsWith(".hpi")) {
                throw new Failure(hudson.model.Messages.Hudson_NotAPlugin(fileName));
            }
            File t = File.createTempFile("uploaded", ".jpi");
            t.deleteOnExit();
            fileItem.write(t);
            fileItem.delete();
            String baseName = this.identifyPluginShortName(t);
            this.pluginUploaded = true;
            JSONArray dependencies = new JSONArray();
            try {
                Manifest m = new JarFile(t).getManifest();
                String deps = m.getMainAttributes().getValue("Plugin-Dependencies");
                if (StringUtils.isNotBlank((String)deps)) {
                    String[] plugins;
                    for (String p : plugins = deps.split(",")) {
                        String[] attrs = p.split("[:;]");
                        dependencies.add((Object)new JSONObject().element("name", (Object)attrs[0]).element("version", (Object)attrs[1]).element("optional", p.contains("resolution:=optional")));
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to setup dependency list for plugin upload", e);
            }
            JSONObject cfg = new JSONObject().element("name", (Object)baseName).element("version", (Object)"0").element("url", (Object)t.toURI().toString()).element("dependencies", (Collection)dependencies);
            UpdateSite updateSite = new UpdateSite("_upload", null);
            updateSite.getClass();
            updateSite.new UpdateSite.Plugin("_upload", cfg).deploy(true);
            return new HttpRedirect("../updateCenter");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doCheckUpdatesServer() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            FormValidation v;
            for (UpdateSite site : Jenkins.getInstance().getUpdateCenter().getSites()) {
                v = site.updateDirectlyNow(DownloadService.signatureCheck);
                if (v.kind == FormValidation.Kind.OK) continue;
                return v;
            }
            for (DownloadService.Downloadable d : DownloadService.Downloadable.all()) {
                v = d.updateNow();
                if (v.kind == FormValidation.Kind.OK) continue;
                return v;
            }
            return org.kohsuke.stapler.HttpResponses.forwardToPreviousPage();
        }
        catch (RuntimeException ex) {
            throw new IOException("Unhandled exception during updates server check", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String identifyPluginShortName(File t) {
        try (JarFile j = new JarFile(t);){
            String name = j.getManifest().getMainAttributes().getValue("Short-Name");
            if (name == null) return FilenameUtils.getBaseName((String)t.getName());
            String string = name;
            return string;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to identify the short name from " + t, e);
        }
        return FilenameUtils.getBaseName((String)t.getName());
    }

    public Descriptor<ProxyConfiguration> getProxyDescriptor() {
        return Jenkins.getInstance().getDescriptor(ProxyConfiguration.class);
    }

    public List<Future<UpdateCenter.UpdateCenterJob>> prevalidateConfig(InputStream configXml) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        ArrayList<Future<UpdateCenter.UpdateCenterJob>> jobs = new ArrayList<Future<UpdateCenter.UpdateCenterJob>>();
        UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
        for (Map.Entry<String, VersionNumber> requestedPlugin : this.parseRequestedPlugins(configXml).entrySet()) {
            UpdateSite.Plugin toInstall;
            PluginWrapper pw = this.getPlugin(requestedPlugin.getKey());
            if (pw == null) {
                toInstall = uc.getPlugin(requestedPlugin.getKey());
                if (toInstall == null) {
                    LOGGER.log(Level.WARNING, "No such plugin {0} to install", requestedPlugin.getKey());
                    continue;
                }
                if (new VersionNumber(toInstall.version).compareTo(requestedPlugin.getValue()) < 0) {
                    LOGGER.log(Level.WARNING, "{0} can only be satisfied in @{1}", new Object[]{requestedPlugin, toInstall.version});
                }
                if (toInstall.isForNewerHudson()) {
                    LOGGER.log(Level.WARNING, "{0}@{1} was built for a newer Jenkins", new Object[]{toInstall.name, toInstall.version});
                }
                jobs.add(toInstall.deploy(true));
                continue;
            }
            if (!pw.isOlderThan(requestedPlugin.getValue())) continue;
            toInstall = uc.getPlugin(requestedPlugin.getKey());
            if (toInstall == null) {
                LOGGER.log(Level.WARNING, "No such plugin {0} to upgrade", requestedPlugin.getKey());
                continue;
            }
            if (!pw.isOlderThan(new VersionNumber(toInstall.version))) {
                LOGGER.log(Level.WARNING, "{0}@{1} is no newer than what we already have", new Object[]{toInstall.name, toInstall.version});
                continue;
            }
            if (new VersionNumber(toInstall.version).compareTo(requestedPlugin.getValue()) < 0) {
                LOGGER.log(Level.WARNING, "{0} can only be satisfied in @{1}", new Object[]{requestedPlugin, toInstall.version});
            }
            if (toInstall.isForNewerHudson()) {
                LOGGER.log(Level.WARNING, "{0}@{1} was built for a newer Jenkins", new Object[]{toInstall.name, toInstall.version});
            }
            if (!toInstall.isCompatibleWithInstalledVersion()) {
                LOGGER.log(Level.WARNING, "{0}@{1} is incompatible with the installed @{2}", new Object[]{toInstall.name, toInstall.version, pw.getVersion()});
            }
            jobs.add(toInstall.deploy(true));
        }
        return jobs;
    }

    @RequirePOST
    public JSONArray doPrevalidateConfig(StaplerRequest req) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        JSONArray response = new JSONArray();
        for (Map.Entry<String, VersionNumber> p : this.parseRequestedPlugins((InputStream)req.getInputStream()).entrySet()) {
            PluginWrapper pw = this.getPlugin(p.getKey());
            JSONObject j = new JSONObject().accumulate("name", (Object)p.getKey()).accumulate("version", (Object)p.getValue().toString());
            if (pw == null) {
                response.add((Object)j.accumulate("mode", (Object)"missing"));
                continue;
            }
            if (!pw.isOlderThan(p.getValue())) continue;
            response.add((Object)j.accumulate("mode", (Object)"old"));
        }
        return response;
    }

    @RequirePOST
    public HttpResponse doInstallNecessaryPlugins(StaplerRequest req) throws IOException {
        this.prevalidateConfig((InputStream)req.getInputStream());
        return org.kohsuke.stapler.HttpResponses.redirectViaContextPath((String)"updateCenter");
    }

    public Map<String, VersionNumber> parseRequestedPlugins(InputStream configXml) throws IOException {
        final TreeMap<String, VersionNumber> requestedPlugins = new TreeMap<String, VersionNumber>();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(configXml, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String plugin = attributes.getValue("plugin");
                    if (plugin == null) {
                        return;
                    }
                    if (!plugin.matches("[^@]+@[^@]+")) {
                        throw new SAXException("Malformed plugin attribute: " + plugin);
                    }
                    int at = plugin.indexOf(64);
                    String shortName = plugin.substring(0, at);
                    VersionNumber existing = (VersionNumber)requestedPlugins.get(shortName);
                    VersionNumber requested = new VersionNumber(plugin.substring(at + 1));
                    if (existing == null || existing.compareTo(requested) < 0) {
                        requestedPlugins.put(shortName, requested);
                    }
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                    return RestrictiveEntityResolver.INSTANCE.resolveEntity(publicId, systemId);
                }
            });
        }
        catch (SAXException x) {
            throw new IOException("Failed to parse XML", x);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return requestedPlugins;
    }

    @Extension
    @Symbol(value={"pluginUpdate"})
    public static final class PluginUpdateMonitor
    extends AdministrativeMonitor {
        private Map<String, PluginUpdateInfo> pluginsToBeUpdated = new HashMap<String, PluginUpdateInfo>();

        public static final PluginUpdateMonitor getInstance() {
            return ExtensionList.lookup(PluginUpdateMonitor.class).get(0);
        }

        public void ifPluginOlderThenReport(String pluginName, String requiredVersion, String message) {
            Plugin plugin = Jenkins.getInstance().getPlugin(pluginName);
            if (plugin != null && plugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber(requiredVersion))) {
                this.pluginsToBeUpdated.put(pluginName, new PluginUpdateInfo(pluginName, message));
            }
        }

        @Override
        public boolean isActivated() {
            return !this.pluginsToBeUpdated.isEmpty();
        }

        public void addPluginToUpdate(String pluginName, String message) {
            this.pluginsToBeUpdated.put(pluginName, new PluginUpdateInfo(pluginName, message));
        }

        public Collection<PluginUpdateInfo> getPluginsToBeUpdated() {
            return this.pluginsToBeUpdated.values();
        }

        public static class PluginUpdateInfo {
            public final String pluginName;
            public final String message;

            private PluginUpdateInfo(String pluginName, String message) {
                this.pluginName = pluginName;
                this.message = message;
            }
        }
    }

    @Extension
    @Symbol(value={"pluginCycleDependencies"})
    public static final class PluginCycleDependenciesMonitor
    extends AdministrativeMonitor {
        private volatile transient boolean isActive = false;
        private volatile transient List<String> pluginsWithCycle;

        @Override
        public boolean isActivated() {
            if (this.pluginsWithCycle == null) {
                this.pluginsWithCycle = new ArrayList<String>();
                for (PluginWrapper p : Jenkins.getInstance().getPluginManager().getPlugins()) {
                    if (!p.hasCycleDependency()) continue;
                    this.pluginsWithCycle.add(p.getShortName());
                    this.isActive = true;
                }
            }
            return this.isActive;
        }

        public List<String> getPluginsWithCycle() {
            return this.pluginsWithCycle;
        }
    }

    static final class PluginInstanceStore {
        final Map<PluginWrapper, Plugin> store = new Hashtable<PluginWrapper, Plugin>();

        PluginInstanceStore() {
        }
    }

    public static final class FailedPlugin {
        public final String name;
        public final Exception cause;

        public FailedPlugin(String name, Exception cause) {
            this.name = name;
            this.cause = cause;
        }

        public String getExceptionString() {
            return Functions.printThrowable(this.cause);
        }
    }

    public final class UberClassLoader
    extends ClassLoader {
        private ConcurrentMap<String, WeakReference<Class>> generatedClasses;
        private final Map<String, Class<?>> loaded;

        public UberClassLoader() {
            super(PluginManager.class.getClassLoader());
            this.generatedClasses = new ConcurrentHashMap<String, WeakReference<Class>>();
            this.loaded = new HashMap();
        }

        public void addNamedClass(String className, Class c) {
            this.generatedClasses.put(className, new WeakReference<Class>(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Object c;
            WeakReference wc = (WeakReference)this.generatedClasses.get(name);
            if (wc != null) {
                c = (Class)wc.get();
                if (c != null) {
                    return c;
                }
                this.generatedClasses.remove(name, wc);
            }
            if (name.startsWith("SimpleTemplateScript")) {
                throw new ClassNotFoundException("ignoring " + name);
            }
            c = this.loaded;
            synchronized (c) {
                if (this.loaded.containsKey(name)) {
                    Class<?> c2 = this.loaded.get(name);
                    if (c2 != null) {
                        return c2;
                    }
                    throw new ClassNotFoundException("cached miss for " + name);
                }
            }
            if (FAST_LOOKUP) {
                for (PluginWrapper p : PluginManager.this.activePlugins) {
                    try {
                        Class<?> c3 = ClassLoaderReflectionToolkit._findLoadedClass(p.classLoader, name);
                        if (c3 != null) {
                            Map<String, Class<?>> map = this.loaded;
                            synchronized (map) {
                                this.loaded.put(name, c3);
                            }
                            return c3;
                        }
                        c3 = ClassLoaderReflectionToolkit._findClass(p.classLoader, name);
                        Map<String, Class<?>> map = this.loaded;
                        synchronized (map) {
                            this.loaded.put(name, c3);
                        }
                        return c3;
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
            } else {
                for (PluginWrapper p : PluginManager.this.activePlugins) {
                    try {
                        return p.classLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
            }
            Map<String, Class<?>> map = this.loaded;
            synchronized (map) {
                this.loaded.put(name, null);
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        protected URL findResource(String name) {
            if (FAST_LOOKUP) {
                for (PluginWrapper p : PluginManager.this.activePlugins) {
                    URL url = ClassLoaderReflectionToolkit._findResource(p.classLoader, name);
                    if (url == null) continue;
                    return url;
                }
            } else {
                for (PluginWrapper p : PluginManager.this.activePlugins) {
                    URL url = p.classLoader.getResource(name);
                    if (url == null) continue;
                    return url;
                }
            }
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            ArrayList<URL> resources = new ArrayList<URL>();
            if (FAST_LOOKUP) {
                for (PluginWrapper p : PluginManager.this.activePlugins) {
                    resources.addAll(Collections.list(ClassLoaderReflectionToolkit._findResources(p.classLoader, name)));
                }
            } else {
                for (PluginWrapper p : PluginManager.this.activePlugins) {
                    resources.addAll(Collections.list(p.classLoader.getResources(name)));
                }
            }
            return Collections.enumeration(resources);
        }

        public String toString() {
            return "classLoader " + this.getClass().getName();
        }
    }

    private static enum PMConstructor {
        JENKINS{

            @Override
            @NonNull
            PluginManager doCreate(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
                return klass.getConstructor(Jenkins.class).newInstance(jenkins);
            }
        }
        ,
        SC_FILE{

            @Override
            @NonNull
            PluginManager doCreate(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
                return klass.getConstructor(ServletContext.class, File.class).newInstance(jenkins.servletContext, jenkins.getRootDir());
            }
        }
        ,
        FILE{

            @Override
            @NonNull
            PluginManager doCreate(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
                return klass.getConstructor(File.class).newInstance(jenkins.getRootDir());
            }
        };


        @CheckForNull
        final PluginManager create(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
            try {
                return this.doCreate(klass, jenkins);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        @NonNull
        abstract PluginManager doCreate(@NonNull Class<? extends PluginManager> var1, @NonNull Jenkins var2) throws ReflectiveOperationException;
    }
}

