/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.CLICommand;
import hudson.model.Job;
import hudson.model.Run;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.kohsuke.args4j.CmdLineException;

public abstract class CommandDuringBuild
extends CLICommand {
    protected Run getCurrentlyBuilding() throws CmdLineException {
        Run r = this.optCurrentlyBuilding();
        if (r == null) {
            throw new IllegalStateException("This CLI command works only when invoked from inside a build");
        }
        return r;
    }

    protected Run optCurrentlyBuilding() throws CmdLineException {
        try {
            CLICommand c = CLICommand.getCurrent();
            if (c == null) {
                throw new IllegalStateException("Not executing a CLI command");
            }
            String[] envs = (String[])c.checkChannel().call((Callable)new GetCharacteristicEnvironmentVariables());
            if (envs[0] == null || envs[1] == null) {
                return null;
            }
            Job j = Jenkins.getActiveInstance().getItemByFullName(envs[0], Job.class);
            if (j == null) {
                throw new IllegalArgumentException("No such job: " + envs[0]);
            }
            try {
                Object r = j.getBuildByNumber(Integer.parseInt(envs[1]));
                if (r == null) {
                    throw new IllegalArgumentException("No such build #" + envs[1] + " in " + envs[0]);
                }
                if (!((Run)r).isBuilding()) {
                    throw new IllegalStateException(r + " is not currently being built");
                }
                return r;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid build number: " + envs[1]);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalArgumentException("Failed to identify the build being executed", e);
        }
    }

    private static final class GetCharacteristicEnvironmentVariables
    extends MasterToSlaveCallable<String[], IOException> {
        private GetCharacteristicEnvironmentVariables() {
        }

        public String[] call() throws IOException {
            return new String[]{System.getenv("JOB_NAME"), System.getenv("BUILD_NUMBER")};
        }
    }
}

