/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Node;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;

@Extension
public class DeleteNodeCommand
extends CLICommand {
    @Argument(usage="Nodes name to delete", required=true, multiValued=true)
    private List<String> nodes;

    @Override
    public String getShortDescription() {
        return Messages.DeleteNodeCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.getActiveInstance();
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(this.nodes);
        for (String node_s : hs) {
            Node node = null;
            try {
                node = jenkins.getNode(node_s);
                if (node == null) {
                    throw new IllegalArgumentException("No such node '" + node_s + "'");
                }
                node.toComputer().doDoDelete();
            }
            catch (Exception e) {
                if (hs.size() == 1) {
                    throw e;
                }
                String errorMsg = String.format(node_s + ": " + e.getMessage(), new Object[0]);
                this.stderr.println(errorMsg);
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            throw new AbortException("Error occured while performing this command, see previous stderr output.");
        }
        return 0;
    }
}

