/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.model.Node;
import hudson.slaves.EphemeralNode;
import hudson.util.RobustCollectionConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;

public final class NodeList
extends ArrayList<Node> {
    private Map<String, Node> map = new HashMap<String, Node>();

    public NodeList() {
    }

    public NodeList(Collection<? extends Node> c) {
        super(c);
        for (Node node : c) {
            if (this.map.put(node.getNodeName(), node) == null) continue;
            throw new IllegalArgumentException(node.getNodeName() + " is defined more than once");
        }
    }

    public NodeList(Node ... toCopyIn) {
        this((Collection<? extends Node>)Arrays.asList(toCopyIn));
    }

    @CheckForNull
    public Node getNode(String nodeName) {
        return this.map.get(nodeName);
    }

    @Override
    public void add(int index, Node element) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public Node remove(int index) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public boolean addAll(Collection<? extends Node> c) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Node> c) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public boolean add(Node node) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    @Override
    public Node set(int index, Node element) {
        throw new UnsupportedOperationException("unmodifiable list");
    }

    public static final class ConverterImpl
    extends RobustCollectionConverter {
        public ConverterImpl(XStream xstream) {
            super(xstream);
        }

        @Override
        public boolean canConvert(Class type) {
            return type == NodeList.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            for (Node o : (NodeList)source) {
                if (o instanceof EphemeralNode) continue;
                this.writeItem(o, context, writer);
            }
        }

        protected Object createCollection(Class type) {
            return new ArrayList();
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return new NodeList((List)super.unmarshal(reader, context));
        }
    }
}

