/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.AgentProtocol;
import jenkins.model.Jenkins;
import jenkins.security.ChannelConfigurator;
import jenkins.slaves.NioChannelSelector;
import jenkins.util.SystemProperties;
import org.jenkinsci.remoting.engine.JnlpServer3Handshake;
import org.jenkinsci.remoting.nio.NioChannelHub;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class JnlpSlaveAgentProtocol3
extends AgentProtocol {
    @Inject
    NioChannelSelector hub;
    private static final Logger LOGGER;
    @Restricted(value={NoExternalUse.class})
    public static boolean ENABLED;

    @Override
    public String getName() {
        if (ENABLED) {
            return "JNLP3-connect";
        }
        return "JNLP3-disabled";
    }

    @Override
    public void handle(Socket socket) throws IOException, InterruptedException {
        new Handler(this.hub.getHub(), socket).run();
    }

    static {
        byte hash;
        LOGGER = Logger.getLogger(JnlpSlaveAgentProtocol3.class.getName());
        String propName = JnlpSlaveAgentProtocol3.class.getName() + ".enabled";
        String propertyString = SystemProperties.getString(propName);
        ENABLED = propertyString != null ? SystemProperties.getBoolean(propName) : (hash = Util.fromHexString(Jenkins.getActiveInstance().getLegacyInstanceId())[0]) % 10 == 0;
    }

    static class Handler
    extends JnlpServer3Handshake {
        private SlaveComputer computer;
        private PrintWriter logw;
        private OutputStream log;

        public Handler(NioChannelHub hub, Socket socket) throws IOException {
            super(hub, Computer.threadPoolForRemoting, socket);
        }

        protected void run() throws IOException, InterruptedException {
            try {
                Channel channel = this.connect();
                this.computer.setChannel(channel, this.log, new Channel.Listener(){

                    public void onClosed(Channel channel, IOException cause) {
                        if (cause != null) {
                            LOGGER.log(Level.WARNING, Thread.currentThread().getName() + " for + " + Handler.this.getNodeName() + " terminated", cause);
                        }
                        try {
                            Handler.this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (AbortException e) {
                this.logw.println(e.getMessage());
                this.logw.println("Failed to establish the connection with the agent");
                throw e;
            }
            catch (IOException e) {
                this.logw.println("Failed to establish the connection with the agent " + this.getNodeName());
                e.printStackTrace(this.logw);
                throw e;
            }
        }

        public ChannelBuilder createChannelBuilder(String nodeName) {
            this.log = this.computer.openLogFile();
            this.logw = new PrintWriter(this.log, true);
            this.logw.println("JNLP agent connected from " + this.socket.getInetAddress());
            ChannelBuilder cb = super.createChannelBuilder(nodeName).withHeaderStream(this.log);
            for (ChannelConfigurator cc : ChannelConfigurator.all()) {
                cc.onChannelBuilding(cb, this.computer);
            }
            return cb;
        }

        protected String getNodeSecret(String nodeName) throws JnlpServer3Handshake.Failure {
            this.computer = (SlaveComputer)Jenkins.getInstance().getComputer(nodeName);
            if (this.computer == null) {
                throw new JnlpServer3Handshake.Failure((JnlpServer3Handshake)this, "Agent trying to register for invalid node: " + nodeName);
            }
            return this.computer.getJnlpMac();
        }
    }
}

