/*
 * Decompiled with CFR 0.152.
 */
package jenkins.triggers;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.SCMedItem;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.scm.NullSCM;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface SCMTriggerItem {
    public Item asItem();

    public int getNextBuildNumber();

    public int getQuietPeriod();

    @CheckForNull
    public QueueTaskFuture<?> scheduleBuild2(int var1, Action ... var2);

    @Nonnull
    public PollingResult poll(@Nonnull TaskListener var1);

    @CheckForNull
    public SCMTrigger getSCMTrigger();

    @Nonnull
    public Collection<? extends SCM> getSCMs();

    public static class SCMTriggerItems {
        @CheckForNull
        public static SCMTriggerItem asSCMTriggerItem(Item item) {
            if (item instanceof SCMTriggerItem) {
                return (SCMTriggerItem)((Object)item);
            }
            if (item instanceof SCMedItem) {
                return new Bridge((SCMedItem)item);
            }
            return null;
        }

        @Nonnull
        public static Collection<? extends SCM> resolveMultiScmIfConfigured(@CheckForNull SCM scm) {
            if (scm == null || scm instanceof NullSCM) {
                return Collections.emptySet();
            }
            if (scm.getClass().getName().equals("org.jenkinsci.plugins.multiplescms.MultiSCM")) {
                try {
                    return (Collection)scm.getClass().getMethod("getConfiguredSCMs", new Class[0]).invoke((Object)scm, new Object[0]);
                }
                catch (Exception x) {
                    Logger.getLogger(SCMTriggerItem.class.getName()).log(Level.WARNING, null, x);
                    return Collections.singleton(scm);
                }
            }
            return Collections.singleton(scm);
        }

        private SCMTriggerItems() {
        }

        private static final class Bridge
        implements SCMTriggerItem {
            private final SCMedItem delegate;

            Bridge(SCMedItem delegate) {
                this.delegate = delegate;
            }

            @Override
            public Item asItem() {
                return this.delegate.asProject();
            }

            @Override
            public int getNextBuildNumber() {
                return this.delegate.asProject().getNextBuildNumber();
            }

            @Override
            public int getQuietPeriod() {
                return this.delegate.asProject().getQuietPeriod();
            }

            @Override
            public QueueTaskFuture<?> scheduleBuild2(int quietPeriod, Action ... actions) {
                return this.delegate.asProject().scheduleBuild2(quietPeriod, null, actions);
            }

            @Override
            public PollingResult poll(TaskListener listener) {
                return this.delegate.poll(listener);
            }

            @Override
            public SCMTrigger getSCMTrigger() {
                return this.delegate.asProject().getTrigger(SCMTrigger.class);
            }

            @Override
            public Collection<? extends SCM> getSCMs() {
                return SCMTriggerItems.resolveMultiScmIfConfigured(this.delegate.asProject().getScm());
            }
        }
    }
}

