/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SystemProperties
implements ServletContextListener {
    @CheckForNull
    private static ServletContext theContext;
    private static final Logger LOGGER;

    public void contextInitialized(ServletContextEvent event) {
        theContext = event.getServletContext();
    }

    @CheckForNull
    public static String getString(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.log(Level.CONFIG, "Property (system): {0} => {1}", new Object[]{key, value});
            }
            return value;
        }
        value = SystemProperties.tryGetValueFromContext(key);
        if (value != null) {
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.log(Level.CONFIG, "Property (context): {0} => {1}", new Object[]{key, value});
            }
            return value;
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, "Property (not found): {0} => {1}", new Object[]{key, value});
        }
        return null;
    }

    public static String getString(String key, @CheckForNull String def) {
        String value = System.getProperty(key);
        if (value != null) {
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.log(Level.CONFIG, "Property (system): {0} => {1}", new Object[]{key, value});
            }
            return value;
        }
        value = SystemProperties.tryGetValueFromContext(key);
        if (value != null) {
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.log(Level.CONFIG, "Property (context): {0} => {1}", new Object[]{key, value});
            }
            return value;
        }
        value = def;
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, "Property (default): {0} => {1}", new Object[]{key, value});
        }
        return value;
    }

    public static boolean getBoolean(String name) {
        return SystemProperties.getBoolean(name, false);
    }

    public static boolean getBoolean(String name, boolean def) {
        String v = SystemProperties.getString(name);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return def;
    }

    @CheckForNull
    public static Integer getInteger(String name) {
        return SystemProperties.getInteger(name, null);
    }

    public static Integer getInteger(String name, Integer def) {
        block3: {
            String v = SystemProperties.getString(name);
            if (v != null) {
                try {
                    return Integer.decode(v);
                }
                catch (NumberFormatException e) {
                    if (!LOGGER.isLoggable(Level.CONFIG)) break block3;
                    LOGGER.log(Level.CONFIG, "Property. Value is not integer: {0} => {1}", new Object[]{name, v});
                }
            }
        }
        return def;
    }

    @CheckForNull
    public static Long getLong(String name) {
        return SystemProperties.getLong(name, null);
    }

    public static Long getLong(String name, Long def) {
        block3: {
            String v = SystemProperties.getString(name);
            if (v != null) {
                try {
                    return Long.decode(v);
                }
                catch (NumberFormatException e) {
                    if (!LOGGER.isLoggable(Level.CONFIG)) break block3;
                    LOGGER.log(Level.CONFIG, "Property. Value is not long: {0} => {1}", new Object[]{name, v});
                }
            }
        }
        return def;
    }

    @CheckForNull
    private static String tryGetValueFromContext(String key) {
        if (StringUtils.isNotBlank((String)key) && theContext != null) {
            try {
                String value = theContext.getInitParameter(key);
                if (value != null) {
                    return value;
                }
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.CONFIG, "Access to the property {0} is prohibited", key);
            }
        }
        return null;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    static {
        LOGGER = Logger.getLogger(SystemProperties.class.getName());
    }
}

