/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.activex.javascript.msxml;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.ScriptException;
import org.htmlunit.WebWindow;
import org.htmlunit.activex.javascript.msxml.MSXMLJavaScriptEnvironment;
import org.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import org.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import org.htmlunit.activex.javascript.msxml.XMLHTTPRequest;
import org.htmlunit.activex.javascript.msxml.XSLTemplate;
import org.htmlunit.corejs.javascript.Scriptable;

public class MSXMLActiveXObjectFactory {
    private static final Log LOG = LogFactory.getLog(MSXMLActiveXObjectFactory.class);
    private MSXMLJavaScriptEnvironment environment_;

    public void init(BrowserVersion browserVersion) throws Exception {
        this.environment_ = new MSXMLJavaScriptEnvironment(browserVersion);
    }

    public boolean supports(String activeXName) {
        return MSXMLActiveXObjectFactory.isXMLDOMDocument(activeXName) || MSXMLActiveXObjectFactory.isXMLHTTPRequest(activeXName) || MSXMLActiveXObjectFactory.isXSLTemplate(activeXName);
    }

    static boolean isXMLDOMDocument(String name) {
        if (name == null) {
            return false;
        }
        return "microsoft.xmldom".equals(name = name.toLowerCase(Locale.ROOT)) || name.startsWith("msxml2.domdocument") || name.startsWith("msxml2.freethreadeddomdocument");
    }

    static boolean isXMLHTTPRequest(String name) {
        if (name == null) {
            return false;
        }
        return "microsoft.xmlhttp".equals(name = name.toLowerCase(Locale.ROOT)) || name.startsWith("msxml2.xmlhttp");
    }

    static boolean isXSLTemplate(String name) {
        if (name == null) {
            return false;
        }
        name = name.toLowerCase(Locale.ROOT);
        return name.startsWith("msxml2.xsltemplate");
    }

    public Scriptable create(String activeXName, WebWindow enclosingWindow) {
        if (MSXMLActiveXObjectFactory.isXMLDOMDocument(activeXName)) {
            return this.createXMLDOMDocument(enclosingWindow);
        }
        if (MSXMLActiveXObjectFactory.isXMLHTTPRequest(activeXName)) {
            return this.createXMLHTTPRequest();
        }
        if (MSXMLActiveXObjectFactory.isXSLTemplate(activeXName)) {
            return this.createXSLTemplate();
        }
        return null;
    }

    private XMLDOMDocument createXMLDOMDocument(WebWindow enclosingWindow) {
        XMLDOMDocument document = new XMLDOMDocument(enclosingWindow);
        this.initObject(document);
        try {
            document.setParentScope((Scriptable)enclosingWindow.getScriptableObject());
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
            throw new ScriptException(null, (Throwable)e);
        }
        return document;
    }

    private Scriptable createXMLHTTPRequest() {
        XMLHTTPRequest request = new XMLHTTPRequest();
        this.initObject(request);
        return request;
    }

    private Scriptable createXSLTemplate() {
        XSLTemplate template = new XSLTemplate();
        this.initObject(template);
        return template;
    }

    private void initObject(MSXMLScriptable scriptable) {
        try {
            scriptable.setPrototype(this.environment_.getPrototype(scriptable.getClass()));
            scriptable.setEnvironment(this.environment_);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
            throw new ScriptException(null, (Throwable)e);
        }
    }
}

