/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

public class HTMLUnicodeEntitiesParser {
    public static final int STATE_START = 0;
    private static final int STATE_ENDS_WITH_SEMICOLON = -2;
    private static final int STATE_HEXADECIMAL_CHAR = -102;
    private static final int STATE_DECIMAL_CHAR = -104;
    private static final int STATE_HEXADECIMAL_START = -103;
    private static final int STATE_NUMERIC_CHAR_END_SEMICOLON_MISSING = -105;
    private static final int STATE_ABSENCE_OF_DIGITS_IN_NUMERIC_CHARACTER_REFERENCE = -106;
    private int state = 0;
    private int consumedCount;
    private String match;
    private int code;
    private int matchLength;

    public String getMatch() {
        return this.match;
    }

    public int getMatchLength() {
        return this.matchLength;
    }

    public int getRewindCount() {
        return this.consumedCount - this.matchLength;
    }

    public boolean endsWithSemicolon() {
        return -2 == this.state;
    }

    public void setMatchFromCode() {
        if (0 == this.code || this.code > 0x10FFFF) {
            this.match = "\ufffd";
            this.matchLength = this.consumedCount;
            return;
        }
        if (Character.isSurrogate((char)this.code)) {
            this.match = "\ufffd";
            return;
        }
        switch (this.code) {
            case 128: {
                this.match = "\u20ac";
                this.matchLength = this.consumedCount;
                return;
            }
            case 130: {
                this.match = "\u201a";
                this.matchLength = this.consumedCount;
                return;
            }
            case 131: {
                this.match = "\u0192";
                this.matchLength = this.consumedCount;
                return;
            }
            case 132: {
                this.match = "\u201e";
                this.matchLength = this.consumedCount;
                return;
            }
            case 133: {
                this.match = "\u2026";
                this.matchLength = this.consumedCount;
                return;
            }
            case 134: {
                this.match = "\u2020";
                this.matchLength = this.consumedCount;
                return;
            }
            case 135: {
                this.match = "\u2021";
                this.matchLength = this.consumedCount;
                return;
            }
            case 136: {
                this.match = "\u02c6";
                this.matchLength = this.consumedCount;
                return;
            }
            case 137: {
                this.match = "\u2030";
                this.matchLength = this.consumedCount;
                return;
            }
            case 138: {
                this.match = "\u0160";
                this.matchLength = this.consumedCount;
                return;
            }
            case 139: {
                this.match = "\u2039";
                this.matchLength = this.consumedCount;
                return;
            }
            case 140: {
                this.match = "\u0152";
                this.matchLength = this.consumedCount;
                return;
            }
            case 142: {
                this.match = "\u017d";
                this.matchLength = this.consumedCount;
                return;
            }
            case 145: {
                this.match = "\u2018";
                this.matchLength = this.consumedCount;
                return;
            }
            case 146: {
                this.match = "\u2019";
                this.matchLength = this.consumedCount;
                return;
            }
            case 147: {
                this.match = "\u201c";
                this.matchLength = this.consumedCount;
                return;
            }
            case 148: {
                this.match = "\u201d";
                this.matchLength = this.consumedCount;
                return;
            }
            case 149: {
                this.match = "\u2022";
                this.matchLength = this.consumedCount;
                return;
            }
            case 150: {
                this.match = "\u2013";
                this.matchLength = this.consumedCount;
                return;
            }
            case 151: {
                this.match = "\u2014";
                this.matchLength = this.consumedCount;
                return;
            }
            case 152: {
                this.match = "\u20dc";
                this.matchLength = this.consumedCount;
                return;
            }
            case 153: {
                this.match = "\u2122";
                this.matchLength = this.consumedCount;
                return;
            }
            case 154: {
                this.match = "\u0161";
                this.matchLength = this.consumedCount;
                return;
            }
            case 155: {
                this.match = "\u203a";
                this.matchLength = this.consumedCount;
                return;
            }
            case 156: {
                this.match = "\u0153";
                this.matchLength = this.consumedCount;
                return;
            }
            case 158: {
                this.match = "\u017e";
                this.matchLength = this.consumedCount;
                return;
            }
            case 159: {
                this.match = "\u0178";
                this.matchLength = this.consumedCount;
                return;
            }
        }
        this.match = new String(Character.toChars(this.code));
        this.matchLength = this.consumedCount;
    }

    public boolean parseNumeric(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 0: {
                if (88 == current || 120 == current) {
                    this.state = -103;
                    this.code = 0;
                    return true;
                }
                if (48 > current || current > 57) break;
                this.state = -104;
                this.code = this.code * 10 + current - 48;
                return true;
            }
            case -103: {
                if (48 <= current && current <= 57) {
                    this.state = -102;
                    this.code = this.code * 16 + current - 48;
                    return true;
                }
                if (65 <= current && current <= 70) {
                    this.state = -102;
                    this.code = this.code * 16 + current - 55;
                    return true;
                }
                if (97 <= current && current <= 102) {
                    this.state = -102;
                    this.code = this.code * 16 + current - 87;
                    return true;
                }
                this.state = -106;
                break;
            }
            case -102: {
                if (48 <= current && current <= 57) {
                    this.code = this.code * 16 + current - 48;
                    return true;
                }
                if (65 <= current && current <= 70) {
                    this.code = this.code * 16 + current - 55;
                    return true;
                }
                if (97 <= current && current <= 102) {
                    this.code = this.code * 16 + current - 87;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state = -105;
                this.setMatchFromCode();
                this.matchLength = this.consumedCount - 1;
                break;
            }
            case -104: {
                if (48 <= current && current <= 57) {
                    this.code = this.code * 10 + current - 48;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state = -105;
                this.setMatchFromCode();
                this.matchLength = this.consumedCount - 1;
            }
        }
        return false;
    }
}

