/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.Map;
import java.util.regex.Pattern;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlSelectableTextInput;
import org.htmlunit.html.LabelableElement;

public class HtmlEmailInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("^[a-zA-Z\\d.!#$%&'*+/=?^_`{|\\}~-]+@[a-zA-Z\\d](?:[a-zA-Z\\d-]{0,61}[a-zA-Z\\d])?(?:\\.[a-zA-Z\\d](?:[a-zA-Z\\d-]{0,61}[a-zA-Z\\d])?)*$");

    HtmlEmailInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public String getValue() {
        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_EMAIL_TRIMMED)) {
            String raw = this.getRawValue();
            if (StringUtils.isBlank(raw)) {
                return "";
            }
            return raw.trim();
        }
        return super.getValue();
    }

    @Override
    public boolean isValid() {
        boolean isValid = super.isValid();
        if (!isValid) {
            return false;
        }
        String val = this.getValue();
        if (StringUtils.isNotBlank(val)) {
            return DEFAULT_PATTERN.matcher(val).matches();
        }
        return true;
    }

    @Override
    protected boolean isPatternSupported() {
        return true;
    }

    @Override
    protected boolean isBlankPatternValidated() {
        return false;
    }

    @Override
    protected boolean isMinMaxLengthSupported() {
        return true;
    }
}

