/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.httpclient;

import hidden.jth.org.apache.http.client.utils.DateUtils;
import hidden.jth.org.apache.http.cookie.MalformedCookieException;
import hidden.jth.org.apache.http.cookie.SetCookie;
import hidden.jth.org.apache.http.impl.cookie.BasicExpiresHandler;
import java.util.Date;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.httpclient.HtmlUnitBrowserCompatCookieSpec;

final class HtmlUnitExpiresHandler
extends BasicExpiresHandler {
    private static final String[] DEFAULT_DATE_PATTERNS = new String[]{"EEE MMM dd yyyy HH mm ss 'GMT'Z", "EEE dd MMM yy HH mm ss zzz", "EEE dd MMM yyyy HH mm ss zzz", "EEE MMM d HH mm ss yyyy", "EEE dd MMM yy HH mm ss z ", "EEE dd MMM yyyy HH mm ss z ", "EEE dd MM yy HH mm ss z ", "EEE dd MM yyyy HH mm ss z "};
    private static final String[] EXTENDED_DATE_PATTERNS_1 = new String[]{"EEE MMM dd yyyy HH mm ss 'GMT'Z", "EEE dd MMM yy HH mm ss zzz", "EEE dd MMM yyyy HH mm ss zzz", "EEE MMM d HH mm ss yyyy", "EEE dd MMM yy HH mm ss z ", "EEE dd MMM yyyy HH mm ss z ", "EEE dd MM yy HH mm ss z ", "EEE dd MM yyyy HH mm ss z ", "d/M/yyyy"};
    private static final String[] EXTENDED_DATE_PATTERNS_2 = new String[]{"EEE MMM dd yyyy HH mm ss 'GMT'Z", "EEE dd MMM yy HH mm ss zzz", "EEE dd MMM yyyy HH mm ss zzz", "EEE MMM d HH mm ss yyyy", "EEE dd MMM yy HH mm ss z ", "EEE dd MMM yyyy HH mm ss z ", "EEE dd MM yy HH mm ss z ", "EEE dd MM yyyy HH mm ss z ", "EEE dd MMM yy HH MM ss z", "MMM dd yy HH mm ss"};
    private final BrowserVersion browserVersion_;

    HtmlUnitExpiresHandler(BrowserVersion browserVersion) {
        super(DEFAULT_DATE_PATTERNS);
        this.browserVersion_ = browserVersion;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        value = value.replaceAll("[ ,:-]+", " ");
        Date startDate = null;
        String[] datePatterns = DEFAULT_DATE_PATTERNS;
        if (null != this.browserVersion_) {
            if (this.browserVersion_.hasFeature(BrowserVersionFeatures.HTTP_COOKIE_START_DATE_1970)) {
                startDate = HtmlUnitBrowserCompatCookieSpec.DATE_1_1_1970;
            }
            if (this.browserVersion_.hasFeature(BrowserVersionFeatures.HTTP_COOKIE_EXTENDED_DATE_PATTERNS_1)) {
                datePatterns = EXTENDED_DATE_PATTERNS_1;
            }
            if (this.browserVersion_.hasFeature(BrowserVersionFeatures.HTTP_COOKIE_EXTENDED_DATE_PATTERNS_2)) {
                datePatterns = EXTENDED_DATE_PATTERNS_2;
            }
        }
        Date expiry = DateUtils.parseDate(value, datePatterns, startDate);
        cookie.setExpiryDate(expiry);
    }
}

