/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Page;
import org.htmlunit.ScriptException;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.IdFunctionObject;
import org.htmlunit.corejs.javascript.NativeConsole;
import org.htmlunit.corejs.javascript.RhinoException;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.StackStyle;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.UniqueTag;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HiddenFunctionObject;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.NativeFunctionToStringFunction;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.RecursiveFunctionObject;
import org.htmlunit.javascript.TimeoutError;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.htmlunit.javascript.background.JavaScriptExecutor;
import org.htmlunit.javascript.configuration.ClassConfiguration;
import org.htmlunit.javascript.configuration.JavaScriptConfiguration;
import org.htmlunit.javascript.host.ActiveXObject;
import org.htmlunit.javascript.host.ConsoleCustom;
import org.htmlunit.javascript.host.DateCustom;
import org.htmlunit.javascript.host.NumberCustom;
import org.htmlunit.javascript.host.URLSearchParams;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.intl.Intl;
import org.htmlunit.javascript.host.xml.FormData;
import org.htmlunit.javascript.polyfill.Polyfill;

public class JavaScriptEngine
implements AbstractJavaScriptEngine<Script> {
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    private WebClient webClient_;
    private HtmlUnitContextFactory contextFactory_;
    private JavaScriptConfiguration jsConfig_;
    private transient ThreadLocal<Boolean> javaScriptRunning_;
    private transient ThreadLocal<List<PostponedAction>> postponedActions_;
    private transient boolean holdPostponedActions_;
    private transient boolean shutdownPending_;
    private transient JavaScriptExecutor javaScriptExecutor_;
    public static final String KEY_STARTING_SCOPE = "startingScope";
    public static final String KEY_STARTING_PAGE = "startingPage";

    public JavaScriptEngine(WebClient webClient) {
        if (webClient == null) {
            throw new IllegalArgumentException("JavaScriptEngine ctor requires a webClient");
        }
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
        this.initTransientFields();
        this.jsConfig_ = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
        RhinoException.setStackStyle(StackStyle.MOZILLA_LF);
    }

    private WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    @Override
    public void initialize(WebWindow webWindow, Page page) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.shutdownPending_) {
            return;
        }
        this.getContextFactory().call(cx -> {
            try {
                this.init(webWindow, page, cx);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
                throw new ScriptException(null, (Throwable)e);
            }
            return null;
        });
    }

    public JavaScriptExecutor getJavaScriptExecutor() {
        return this.javaScriptExecutor_;
    }

    private void init(WebWindow webWindow, Page page, Context context) throws Exception {
        HashMap<String, Scriptable> prototypesPerJSName;
        HashMap<Class<? extends Scriptable>, Scriptable> prototypes;
        Window window;
        BrowserVersion browserVersion;
        WebClient webClient;
        block43: {
            Scriptable scriptable;
            webClient = webWindow.getWebClient();
            browserVersion = webClient.getBrowserVersion();
            window = new Window();
            window.setClassName("Window");
            context.initSafeStandardObjects(window);
            ClassConfiguration windowConfig = this.jsConfig_.getClassConfiguration("Window");
            if (windowConfig.getJsConstructor() != null) {
                RecursiveFunctionObject functionObject = new RecursiveFunctionObject("Window", windowConfig.getJsConstructor(), window, browserVersion);
                ScriptableObject.defineProperty(window, "constructor", functionObject, 7);
            } else {
                JavaScriptEngine.defineConstructor(window, window, new Window());
            }
            JavaScriptEngine.deleteProperties(window, "Continuation", "Iterator", "StopIteration", "BigInt");
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_PROMISE)) {
                JavaScriptEngine.deleteProperties(window, "Promise");
            }
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_SYMBOL)) {
                JavaScriptEngine.deleteProperties(window, "Symbol");
            }
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_REFLECT)) {
                JavaScriptEngine.deleteProperties(window, "Reflect");
                JavaScriptEngine.deleteProperties(window, "Proxy");
            }
            ScriptableObject errorObject = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "Error");
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_ERROR_STACK_TRACE_LIMIT)) {
                errorObject.defineProperty("stackTraceLimit", (Object)10, 0);
            } else {
                ScriptableObject.deleteProperty((Scriptable)errorObject, "stackTraceLimit");
            }
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_ERROR_CAPTURE_STACK_TRACE)) {
                ScriptableObject.deleteProperty((Scriptable)errorObject, "captureStackTrace");
            }
            URLSearchParams.NativeParamsIterator.init(window, "URLSearchParams Iterator");
            FormData.FormDataIterator.init(window, "FormData Iterator");
            Intl intl = new Intl();
            intl.setParentScope(window);
            window.defineProperty(intl.getClassName(), (Object)intl, 2);
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_INTL_NAMED_OBJECT)) {
                intl.setClassName("Object");
            }
            intl.defineProperties(browserVersion);
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_INSTALL_TRIGGER_NULL)) {
                window.put("InstallTrigger", (Scriptable)window, null);
            }
            prototypes = new HashMap<Class<? extends Scriptable>, Scriptable>();
            prototypesPerJSName = new HashMap<String, Scriptable>();
            String windowClassName = Window.class.getName();
            for (ClassConfiguration classConfiguration : this.jsConfig_.getAll()) {
                boolean bl = windowClassName.equals(classConfiguration.getHostClass().getName());
                if (bl) {
                    JavaScriptEngine.configureConstantsPropertiesAndFunctions(classConfiguration, window);
                    HtmlUnitScriptable prototype = JavaScriptEngine.configureClass(classConfiguration, window, browserVersion);
                    prototypesPerJSName.put(classConfiguration.getClassName(), prototype);
                    continue;
                }
                HtmlUnitScriptable prototype2 = JavaScriptEngine.configureClass(classConfiguration, window, browserVersion);
                if (classConfiguration.isJsObject()) {
                    HtmlUnitScriptable obj = classConfiguration.getHostClass().newInstance();
                    prototype2.defineProperty("__proto__", (Object)prototype2, 2);
                    obj.defineProperty("prototype", (Object)prototype2, 2);
                    obj.setParentScope(window);
                    obj.setClassName(classConfiguration.getClassName());
                    ScriptableObject.defineProperty(window, obj.getClassName(), obj, 2);
                    JavaScriptEngine.configureConstants(classConfiguration, obj);
                }
                prototypes.put(classConfiguration.getHostClass(), prototype2);
                prototypesPerJSName.put(classConfiguration.getClassName(), prototype2);
            }
            for (ClassConfiguration classConfiguration : this.jsConfig_.getAll()) {
                BaseFunction function;
                block42: {
                    Member member = classConfiguration.getJsConstructor();
                    String jsClassName = classConfiguration.getClassName();
                    Scriptable prototype3 = (Scriptable)prototypesPerJSName.get(jsClassName);
                    String hostClassSimpleName = classConfiguration.getHostClassSimpleName();
                    if ("Image".equals(hostClassSimpleName)) {
                        prototype3 = (Scriptable)prototypesPerJSName.get("HTMLImageElement");
                    } else if ("Option".equals(hostClassSimpleName)) {
                        prototype3 = (Scriptable)prototypesPerJSName.get("HTMLOptionElement");
                    } else if ("WebKitMutationObserver".equals(hostClassSimpleName)) {
                        prototype3 = (Scriptable)prototypesPerJSName.get("MutationObserver");
                    } else if ("WebkitURL".equals(hostClassSimpleName)) {
                        prototype3 = (Scriptable)prototypesPerJSName.get("URL");
                    }
                    if (prototype3 == null || !classConfiguration.isJsObject()) continue;
                    if (member == null) {
                        ScriptableObject constructor;
                        if ("Window".equals(jsClassName)) {
                            constructor = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "constructor");
                        } else {
                            constructor = classConfiguration.getHostClass().newInstance();
                            ((HtmlUnitScriptable)constructor).setClassName(classConfiguration.getClassName());
                        }
                        JavaScriptEngine.defineConstructor(window, prototype3, constructor);
                        JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(classConfiguration, constructor);
                        continue;
                    }
                    function = "Window".equals(jsClassName) ? (BaseFunction)ScriptableObject.getProperty((Scriptable)window, "constructor") : new RecursiveFunctionObject(jsClassName, member, window, browserVersion);
                    if ("WebKitMutationObserver".equals(hostClassSimpleName) || "WebkitURL".equals(hostClassSimpleName) || "Image".equals(hostClassSimpleName) || "Option".equals(hostClassSimpleName)) {
                        Object prototypeProperty;
                        block41: {
                            prototypeProperty = ScriptableObject.getProperty((Scriptable)window, prototype3.getClassName());
                            if (function instanceof FunctionObject) {
                                try {
                                    ((FunctionObject)function).addAsConstructor(window, prototype3, 2);
                                }
                                catch (Exception e) {
                                    if (!LOG.isWarnEnabled()) break block41;
                                    String newline = System.lineSeparator();
                                    LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype3.getClassName()));
                                }
                            }
                        }
                        ScriptableObject.defineProperty(window, jsClassName, function, 2);
                        if (!hostClassSimpleName.equals(prototype3.getClassName())) {
                            if (prototypeProperty == UniqueTag.NOT_FOUND) {
                                ScriptableObject.deleteProperty((Scriptable)window, prototype3.getClassName());
                            } else {
                                ScriptableObject.defineProperty(window, prototype3.getClassName(), prototypeProperty, 2);
                            }
                        }
                    } else if (function instanceof FunctionObject) {
                        try {
                            ((FunctionObject)function).addAsConstructor(window, prototype3, 2);
                        }
                        catch (Exception e) {
                            if (!LOG.isWarnEnabled()) break block42;
                            String newline = System.lineSeparator();
                            LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype3.getClassName()));
                        }
                    }
                }
                JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(classConfiguration, function);
            }
            window.setPrototype((Scriptable)prototypesPerJSName.get(Window.class.getSimpleName()));
            Scriptable objectPrototype = ScriptableObject.getObjectPrototype(window);
            for (Map.Entry entry : prototypesPerJSName.entrySet()) {
                String name = (String)entry.getKey();
                ClassConfiguration config = this.jsConfig_.getClassConfiguration(name);
                Scriptable prototype4 = (Scriptable)entry.getValue();
                if (!StringUtils.isEmpty(config.getExtendedClassName())) {
                    Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClassName());
                    prototype4.setPrototype(parentPrototype);
                    continue;
                }
                prototype4.setPrototype(objectPrototype);
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_ACTIVEXOBJECT_HIDDEN) && null != (scriptable = (Scriptable)prototypesPerJSName.get("ActiveXObject"))) {
                Method method = ActiveXObject.class.getDeclaredMethod("jsConstructor", Context.class, Scriptable.class, Object[].class, Function.class, Boolean.TYPE);
                HiddenFunctionObject functionObject = new HiddenFunctionObject("ActiveXObject", method, window);
                try {
                    functionObject.addAsConstructor(window, scriptable, 2);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block43;
                    String newline = System.lineSeparator();
                    LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + scriptable.getClassName()));
                }
            }
        }
        JavaScriptEngine.configureRhino(webClient, browserVersion, window);
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_CONSOLE_TIMESTAMP)) {
            ScriptableObject scriptableObject = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "console");
            ScriptableObject.defineProperty(window, "Console", scriptableObject, 2);
        }
        window.setPrototypes(prototypes, prototypesPerJSName);
        window.initialize(webWindow, page);
        JavaScriptEngine.applyPolyfills(webClient, browserVersion, context, window);
    }

    public static void configureRhino(WebClient webClient, BrowserVersion browserVersion, HtmlUnitScriptable scriptable) {
        NativeConsole.init(scriptable, false, webClient.getWebConsole());
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CONSOLE_TIMESTAMP)) {
            ScriptableObject console = (ScriptableObject)ScriptableObject.getProperty((Scriptable)scriptable, "console");
            console.defineFunctionProperties(new String[]{"timeStamp"}, ConsoleCustom.class, 2);
        }
        ScriptableObject stringPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(scriptable, "String");
        JavaScriptEngine.deleteProperties(stringPrototype, "equals", "equalsIgnoreCase", "toSource");
        ScriptableObject numberPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(scriptable, "Number");
        JavaScriptEngine.deleteProperties(numberPrototype, "toSource");
        ScriptableObject datePrototype = (ScriptableObject)ScriptableObject.getClassPrototype(scriptable, "Date");
        JavaScriptEngine.deleteProperties(datePrototype, "toSource");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_INCLUDES)) {
            JavaScriptEngine.deleteProperties(stringPrototype, "includes");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_REPEAT)) {
            JavaScriptEngine.deleteProperties(stringPrototype, "repeat");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_STARTS_ENDS_WITH)) {
            JavaScriptEngine.deleteProperties(stringPrototype, "startsWith", "endsWith");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_TRIM_LEFT_RIGHT)) {
            JavaScriptEngine.deleteProperties(stringPrototype, "trimLeft", "trimRight");
        }
        JavaScriptEngine.deleteProperties(scriptable, "uneval");
        JavaScriptEngine.removePrototypeProperties(scriptable, "Object", "toSource");
        JavaScriptEngine.removePrototypeProperties(scriptable, "Array", "toSource");
        JavaScriptEngine.removePrototypeProperties(scriptable, "Function", "toSource");
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_ACTIVEXOBJECT_HIDDEN)) {
            ((IdFunctionObject)ScriptableObject.getProperty((Scriptable)scriptable, "Object")).delete("assign");
            JavaScriptEngine.deleteProperties(scriptable, "WeakSet");
        }
        JavaScriptEngine.deleteProperties(scriptable, "isXMLName");
        NativeFunctionToStringFunction.installFix(scriptable, browserVersion);
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_GLOBAL_THIS)) {
            JavaScriptEngine.deleteProperties(scriptable, "globalThis");
        }
        datePrototype.defineFunctionProperties(new String[]{"toLocaleDateString", "toLocaleTimeString"}, DateCustom.class, 2);
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_OBJECT_GET_OWN_PROPERTY_SYMBOLS)) {
            ((ScriptableObject)ScriptableObject.getProperty((Scriptable)scriptable, "Object")).delete("getOwnPropertySymbols");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_ARRAY_FROM)) {
            JavaScriptEngine.deleteProperties((ScriptableObject)ScriptableObject.getProperty((Scriptable)scriptable, "Array"), "from", "of");
        }
        numberPrototype.defineFunctionProperties(new String[]{"toLocaleString"}, NumberCustom.class, 2);
        if (!webClient.getOptions().isWebSocketEnabled()) {
            JavaScriptEngine.deleteProperties(scriptable, "WebSocket");
        }
    }

    public static void applyPolyfills(WebClient webClient, BrowserVersion browserVersion, Context context, HtmlUnitScriptable scriptable) throws IOException {
        if (webClient.getOptions().isFetchPolyfillEnabled() && browserVersion.hasFeature(BrowserVersionFeatures.JS_API_FETCH)) {
            Polyfill.getFetchPolyfill().apply(context, scriptable);
        }
    }

    private static void defineConstructor(Window window, Scriptable prototype, ScriptableObject constructor) {
        block5: {
            String newline;
            block4: {
                constructor.setParentScope(window);
                try {
                    ScriptableObject.defineProperty(prototype, "constructor", constructor, 7);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    newline = System.lineSeparator();
                    LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype.getClassName()));
                }
            }
            try {
                ScriptableObject.defineProperty(constructor, "prototype", prototype, 7);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block5;
                newline = System.lineSeparator();
                LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype.getClassName()));
            }
        }
        window.defineProperty(constructor.getClassName(), (Object)constructor, 2);
    }

    private static void deleteProperties(Scriptable scope, String ... propertiesToDelete) {
        for (String property : propertiesToDelete) {
            scope.delete(property);
        }
    }

    private static void removePrototypeProperties(Scriptable scope, String className, String ... properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype(scope, className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    public static HtmlUnitScriptable configureClass(ClassConfiguration config, Scriptable window, BrowserVersion browserVersion) throws InstantiationException, IllegalAccessException {
        HtmlUnitScriptable prototype = config.getHostClass().newInstance();
        prototype.setParentScope(window);
        prototype.setClassName(config.getClassName());
        JavaScriptEngine.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private static void configureConstantsStaticPropertiesAndStaticFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureStaticProperties(config, scriptable);
        JavaScriptEngine.configureStaticFunctions(config, scriptable);
    }

    private static void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureProperties(config, scriptable);
        JavaScriptEngine.configureFunctions(config, scriptable);
        JavaScriptEngine.configureSymbolConstants(config, scriptable);
        JavaScriptEngine.configureSymbols(config, scriptable);
    }

    private static void configureFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        boolean attributes = false;
        Map<String, Method> functionMap = config.getFunctionMap();
        if (functionMap != null) {
            for (Map.Entry<String, Method> functionInfo : functionMap.entrySet()) {
                String functionName = functionInfo.getKey();
                Method method = functionInfo.getValue();
                FunctionObject functionObject = new FunctionObject(functionName, method, scriptable);
                scriptable.defineProperty(functionName, (Object)functionObject, 0);
            }
        }
    }

    private static void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        List<ClassConfiguration.ConstantInfo> constants = config.getConstants();
        if (constants != null) {
            for (ClassConfiguration.ConstantInfo constantInfo : constants) {
                scriptable.defineProperty(constantInfo.getName(), constantInfo.getValue(), constantInfo.getFlag());
            }
        }
    }

    private static void configureProperties(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, ClassConfiguration.PropertyInfo> propertyMap = config.getPropertyMap();
        if (propertyMap != null) {
            for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : propertyMap.entrySet()) {
                ClassConfiguration.PropertyInfo info = propertyEntry.getValue();
                Method readMethod = info.getReadMethod();
                Method writeMethod = info.getWriteMethod();
                scriptable.defineProperty(propertyEntry.getKey(), null, readMethod, writeMethod, 0);
            }
        }
    }

    private static void configureStaticProperties(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, ClassConfiguration.PropertyInfo> staticPropertyMap = config.getStaticPropertyMap();
        if (staticPropertyMap != null) {
            for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : staticPropertyMap.entrySet()) {
                String propertyName = propertyEntry.getKey();
                Method readMethod = propertyEntry.getValue().getReadMethod();
                Method writeMethod = propertyEntry.getValue().getWriteMethod();
                boolean flag = false;
                scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
            }
        }
    }

    private static void configureStaticFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, Method> staticFunctionMap = config.getStaticFunctionMap();
        if (staticFunctionMap != null) {
            for (Map.Entry<String, Method> staticFunctionInfo : staticFunctionMap.entrySet()) {
                String functionName = staticFunctionInfo.getKey();
                Method method = staticFunctionInfo.getValue();
                FunctionObject staticFunctionObject = new FunctionObject(functionName, method, scriptable);
                scriptable.defineProperty(functionName, (Object)staticFunctionObject, 0);
            }
        }
    }

    private static void configureSymbolConstants(ClassConfiguration config, ScriptableObject scriptable) {
        Map<Symbol, String> symbolConstantMap = config.getSymbolConstantMap();
        if (symbolConstantMap != null) {
            for (Map.Entry<Symbol, String> symbolInfo : symbolConstantMap.entrySet()) {
                scriptable.defineProperty(symbolInfo.getKey(), (Object)symbolInfo.getValue(), 2);
            }
        }
    }

    private static void configureSymbols(ClassConfiguration config, ScriptableObject scriptable) {
        Map<Symbol, Method> symbolMap = config.getSymbolMap();
        if (symbolMap != null) {
            for (Map.Entry<Symbol, Method> symbolInfo : symbolMap.entrySet()) {
                Symbol symbol = symbolInfo.getKey();
                Method method = symbolInfo.getValue();
                String methodName = method.getName();
                Callable symbolFunction = scriptable.has(methodName, (Scriptable)scriptable) ? (Callable)scriptable.get(methodName, (Scriptable)scriptable) : new FunctionObject(symbol.toString(), method, scriptable);
                scriptable.defineProperty(symbol, (Object)symbolFunction, 2);
            }
        }
    }

    @Override
    public synchronized void registerWindowAndMaybeStartEventLoop(WebWindow webWindow) {
        if (this.shutdownPending_) {
            return;
        }
        WebClient webClient = this.getWebClient();
        if (webClient != null) {
            if (this.javaScriptExecutor_ == null) {
                this.javaScriptExecutor_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptExecutor(webClient);
            }
            this.javaScriptExecutor_.addWindow(webWindow);
        }
    }

    @Override
    public void prepareShutdown() {
        this.shutdownPending_ = true;
    }

    @Override
    public void shutdown() {
        this.webClient_ = null;
        this.contextFactory_ = null;
        this.jsConfig_ = null;
        if (this.javaScriptExecutor_ != null) {
            this.javaScriptExecutor_.shutdown();
            this.javaScriptExecutor_ = null;
        }
        if (this.postponedActions_ != null) {
            this.postponedActions_.remove();
        }
        if (this.javaScriptRunning_ != null) {
            this.javaScriptRunning_.remove();
        }
        this.holdPostponedActions_ = false;
    }

    @Override
    public Script compile(HtmlPage page, String sourceCode, String sourceName, int startLine) {
        Scriptable scope = JavaScriptEngine.getScope(page, null);
        return this.compile(page, scope, sourceCode, sourceName, startLine);
    }

    public Script compile(HtmlPage owningPage, Scriptable scope, final String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        if (LOG.isTraceEnabled()) {
            String newline = System.lineSeparator();
            LOG.trace((Object)("Javascript compile " + sourceName + newline + sourceCode + newline));
        }
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, owningPage){

            @Override
            public Object doRun(Context cx) {
                return cx.compileString(sourceCode, sourceName, startLine, null);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return sourceCode;
            }
        };
        return (Script)this.getContextFactory().callSecured(action, owningPage);
    }

    @Override
    public Object execute(HtmlPage page, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(page, sourceCode, sourceName, startLine);
        if (script == null) {
            return null;
        }
        return this.execute(page, script);
    }

    @Override
    public Object execute(HtmlPage page, Script script) {
        Scriptable scope = JavaScriptEngine.getScope(page, null);
        return this.execute(page, scope, script);
    }

    public Object execute(HtmlPage page, final Scriptable scope, final Script script) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().callSecured(action, page);
    }

    public Object callFunction(HtmlPage page, Function javaScriptFunction, Scriptable thisObject, Object[] args, DomNode node) {
        Scriptable scope = JavaScriptEngine.getScope(page, node);
        return this.callFunction(page, javaScriptFunction, scope, thisObject, args);
    }

    public Object callFunction(HtmlPage page, final Function function, final Scriptable scope, final Scriptable thisObject, final Object[] args) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                if (ScriptRuntime.hasTopCall(cx)) {
                    return function.call(cx, scope, thisObject, args);
                }
                return ScriptRuntime.doTopCall(function, cx, scope, thisObject, args, cx.isStrictMode());
            }

            @Override
            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().callSecured(action, page);
    }

    private static Scriptable getScope(HtmlPage page, DomNode node) {
        if (node != null) {
            return (Scriptable)node.getScriptableObject();
        }
        return (Scriptable)page.getEnclosingWindow().getScriptableObject();
    }

    @Override
    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(this.javaScriptRunning_.get());
    }

    void doProcessPostponedActions() {
        this.holdPostponedActions_ = false;
        WebClient webClient = this.getWebClient();
        if (webClient == null) {
            this.postponedActions_.set(null);
            return;
        }
        try {
            webClient.loadDownloadedResponses();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions != null) {
            this.postponedActions_.set(null);
            try {
                for (PostponedAction action : actions) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Processing PostponedAction " + action));
                    }
                    if (!action.isStillAlive()) continue;
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx(e);
            }
        }
    }

    @Override
    public void addPostponedAction(PostponedAction action) {
        if (this.shutdownPending_) {
            return;
        }
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions == null) {
            actions = new ArrayList<PostponedAction>();
            this.postponedActions_.set(actions);
        }
        actions.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException, boolean triggerOnError) {
        Window w;
        WebWindow window;
        WebClient webClient = this.getWebClient();
        if (webClient == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("handleJavaScriptException('" + scriptException.getMessage() + "') called after the shutdown of the Javascript engine - exception ignored."));
            }
            return;
        }
        HtmlPage page = scriptException.getPage();
        if (triggerOnError && page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptableObject()) != null) {
            try {
                w.triggerOnError(scriptException);
            }
            catch (Exception e) {
                this.handleJavaScriptException(new ScriptException(page, e, null), false);
            }
        }
        webClient.getJavaScriptErrorListener().scriptException(page, scriptException);
        if (webClient.getOptions().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
    }

    protected void handleJavaScriptTimeoutError(HtmlPage page, TimeoutError e) {
        WebClient webClient = this.getWebClient();
        if (webClient == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Caught script timeout error after the shutdown of the Javascript engine - ignored.");
            }
            return;
        }
        webClient.getJavaScriptErrorListener().timeoutError(page, e.getAllowedTime(), e.getExecutionTime());
        if (webClient.getOptions().isThrowExceptionOnScriptError()) {
            throw new RuntimeException(e);
        }
        LOG.info((Object)"Caught script timeout error", (Throwable)e);
    }

    @Override
    public void holdPosponedActions() {
        this.holdPostponedActions_ = true;
    }

    @Override
    public void processPostponedActions() {
        this.doProcessPostponedActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.javaScriptRunning_ = new ThreadLocal();
        this.postponedActions_ = new ThreadLocal();
        this.holdPostponedActions_ = false;
        this.shutdownPending_ = false;
    }

    public Class<? extends HtmlUnitScriptable> getJavaScriptClass(Class<?> c) {
        return this.jsConfig_.getDomJavaScriptMappingFor(c);
    }

    @Override
    public JavaScriptConfiguration getJavaScriptConfiguration() {
        return this.jsConfig_;
    }

    @Override
    public long getJavaScriptTimeout() {
        return this.getContextFactory().getTimeout();
    }

    @Override
    public void setJavaScriptTimeout(long timeout) {
        this.getContextFactory().setTimeout(timeout);
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction<Object> {
        private final Scriptable scope_;
        private final HtmlPage page_;

        HtmlUnitContextAction(Scriptable scope, HtmlPage page) {
            this.scope_ = scope;
            this.page_ = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object run(Context cx) {
            Boolean javaScriptAlreadyRunning = (Boolean)JavaScriptEngine.this.javaScriptRunning_.get();
            JavaScriptEngine.this.javaScriptRunning_.set(Boolean.TRUE);
            try {
                Object response;
                Object object;
                ArrayDeque<Scriptable> stack = (ArrayDeque<Scriptable>)cx.getThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE);
                if (null == stack) {
                    stack = new ArrayDeque<Scriptable>();
                    cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE, stack);
                }
                stack.push(this.scope_);
                try {
                    cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_PAGE, this.page_);
                    object = this.page_;
                    synchronized (object) {
                        block18: {
                            if (this.page_ == this.page_.getEnclosingWindow().getEnclosedPage()) break block18;
                            Object var6_7 = null;
                            return var6_7;
                        }
                        response = this.doRun(cx);
                    }
                    cx.processMicrotasks();
                }
                finally {
                    stack.pop();
                }
                if (!JavaScriptEngine.this.holdPostponedActions_) {
                    JavaScriptEngine.this.doProcessPostponedActions();
                }
                object = response;
                return object;
            }
            catch (Exception e) {
                JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.page_, e, this.getSourceCode(cx)), true);
                Object var4_9 = null;
                return var4_9;
            }
            catch (TimeoutError e) {
                JavaScriptEngine.this.handleJavaScriptTimeoutError(this.page_, e);
                Object var4_10 = null;
                return var4_10;
            }
            finally {
                JavaScriptEngine.this.javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

