/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.io.IOException;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.parser.HTMLParser;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.javascript.host.xml.XMLDocument;

@JsxClass
public class DOMParser
extends HtmlUnitScriptable {
    @JsxConstructor
    public DOMParser() {
    }

    @JsxFunction
    public Document parseFromString(String str, Object type) {
        try {
            Document document = DOMParser.parseFromString(this, str, type);
            if (document == null) {
                throw Context.reportRuntimeError("Invalid 'type' parameter: " + type);
            }
            return document;
        }
        catch (IOException e) {
            throw Context.reportRuntimeError("Parsing failed" + e.getMessage());
        }
    }

    public static Document parseFromString(HtmlUnitScriptable scriptable, String str, Object type) throws IOException {
        if (type == null || Undefined.isUndefined(type)) {
            throw Context.reportRuntimeError("Missing 'type' parameter");
        }
        if ("text/xml".equals(type) || "application/xml".equals(type) || "application/xhtml+xml".equals(type) || "image/svg+xml".equals(type)) {
            XMLDocument document = new XMLDocument();
            document.setParentScope(scriptable.getParentScope());
            document.setPrototype(scriptable.getPrototype(XMLDocument.class));
            document.loadXML(str);
            return document;
        }
        if ("text/html".equals(type)) {
            WebWindow webWindow = scriptable.getWindow().getWebWindow();
            WebClient webClient = webWindow.getWebClient();
            StringWebResponse webResponse = new StringWebResponse(str, webWindow.getEnclosedPage().getUrl());
            HtmlPage page = new HtmlPage(webResponse, webWindow);
            page.setEnclosingWindow(null);
            Window window = (Window)webWindow.getScriptableObject();
            HTMLDocument document = new HTMLDocument();
            document.setParentScope(window);
            document.setPrototype(window.getPrototype(document.getClass()));
            document.setDomNode(page);
            HTMLParser htmlParser = webClient.getPageCreator().getHtmlParser();
            htmlParser.parse(webResponse, page, false, true);
            return (Document)page.getScriptableObject();
        }
        return null;
    }
}

