/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.event;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.WindowProxy;
import org.htmlunit.javascript.host.event.Event;

@JsxClass
public class MessageEvent
extends Event {
    private Object data_;
    private String origin_;
    private String lastEventId_;
    private Window source_;
    private Object ports_;

    public MessageEvent() {
        this.setType("message");
        this.origin_ = "";
        this.lastEventId_ = "";
        this.data_ = Undefined.instance;
    }

    public MessageEvent(Object data) {
        this();
        this.data_ = data;
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONMESSAGE_DEFAULT_DATA_NULL)) {
            this.data_ = null;
        }
        String origin = "";
        String lastEventId = "";
        if (details != null && !Undefined.isUndefined(details)) {
            Object detailLastEventId;
            this.data_ = details.get("data");
            String detailOrigin = (String)details.get("origin");
            if (detailOrigin != null) {
                origin = detailOrigin;
            }
            if ((detailLastEventId = details.get("lastEventId")) != null) {
                lastEventId = Context.toString(detailLastEventId);
            }
            this.source_ = null;
            Object detailSource = details.get("source");
            if (detailSource instanceof Window) {
                this.source_ = (Window)detailSource;
            } else if (detailSource instanceof WindowProxy) {
                this.source_ = ((WindowProxy)detailSource).getDelegee();
            }
            this.ports_ = details.get("ports");
        }
        this.origin_ = origin;
        this.lastEventId_ = lastEventId;
    }

    @JsxFunction
    public void initMessageEvent(String type, boolean canBubble, boolean cancelable, Object data, String origin, String lastEventId, Window source, Object ports) {
        this.initEvent(type, canBubble, cancelable);
        this.data_ = data;
        this.origin_ = origin;
        this.lastEventId_ = lastEventId;
        this.source_ = source;
        if (!(Undefined.isUndefined(ports) || ports instanceof NativeArray || ports instanceof Scriptable && ScriptableObject.hasProperty((Scriptable)ports, "length"))) {
            throw ScriptRuntime.typeError("Argument 8 of MessageEvent.initMessageEvent can't be converted to a sequence.");
        }
        this.ports_ = ports;
    }

    @JsxGetter
    public Object getData() {
        return this.data_;
    }

    @JsxGetter
    public String getOrigin() {
        return this.origin_;
    }

    public void setOrigin(String origin) {
        this.origin_ = origin;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getLastEventId() {
        return this.lastEventId_;
    }

    @JsxGetter
    public Window getSource() {
        return this.source_;
    }

    @JsxGetter
    public Object getPorts() {
        return this.ports_;
    }
}

