/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.event;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.EventTarget;

@JsxClass
public class PopStateEvent
extends Event {
    private Object state_;

    public PopStateEvent() {
        this.setEventType("");
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        if (details != null && !Undefined.isUndefined(details)) {
            this.state_ = details.get("state");
        }
    }

    public PopStateEvent(EventTarget target, String type, Object state) {
        super(target, type);
        if (state instanceof NativeObject && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_POP_STATE_EVENT_CLONE_STATE)) {
            NativeObject old = (NativeObject)state;
            NativeObject newState = new NativeObject();
            WebClient client = this.getWindow().getWebWindow().getWebClient();
            HtmlUnitContextFactory cf = ((JavaScriptEngine)client.getJavaScriptEngine()).getContextFactory();
            ContextAction<Object> contextAction = cx -> {
                for (Object o : ScriptableObject.getPropertyIds(old)) {
                    String property = Context.toString(o);
                    newState.defineProperty(property, ScriptableObject.getProperty((Scriptable)old, property), 0);
                }
                return null;
            };
            cf.call(contextAction);
            this.state_ = newState;
        } else {
            this.state_ = state;
        }
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void initPopStateEvent(String type, boolean bubbles, boolean cancelable, Object state) {
        this.initEvent(type, bubbles, cancelable);
        this.state_ = state;
    }

    @JsxGetter
    public Object getState() {
        return this.state_;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!"state".equals(name)) {
            super.put(name, start, value);
        }
    }
}

