/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import hidden.jth.org.apache.commons.lang3.ArrayUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.HtmlBreak;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlBreak.class)
public class HTMLBRElement
extends HTMLElement {
    private static final String[] VALID_CLEAR_VALUES = new String[]{"left", "right", "all", "none"};

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLBRElement() {
    }

    @JsxGetter
    public String getClear() {
        String clear = this.getDomNodeOrDie().getAttributeDirect("clear");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLEAR_RESTRICT) && !ArrayUtils.contains(VALID_CLEAR_VALUES, clear)) {
            return "";
        }
        return clear;
    }

    @JsxSetter
    public void setClear(String clear) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLEAR_RESTRICT) && !ArrayUtils.contains(VALID_CLEAR_VALUES, clear)) {
            throw Context.reportRuntimeError("Invalid clear property value: '" + clear + "'.");
        }
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }
}

