/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import hidden.jth.org.apache.commons.lang3.ArrayUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.HtmlExample;
import org.htmlunit.html.HtmlListing;
import org.htmlunit.html.HtmlPreformattedText;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLCanvasElement;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClasses(value={@JsxClass(domClass=HtmlExample.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(domClass=HtmlPreformattedText.class), @JsxClass(domClass=HtmlListing.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})})
public class HTMLPreElement
extends HTMLElement {
    private static final String[] VALID_CLEAR_VALUES = new String[]{"left", "right", "all", "none"};

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLPreElement() {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getCite() {
        return this.getDomNodeOrDie().getAttributeDirect("cite");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setCite(String cite) {
        this.getDomNodeOrDie().setAttribute("cite", cite);
    }

    @JsxGetter(propertyName="width")
    public Object getWidth_js() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_PRE_WIDTH_STRING)) {
            return this.getWidthOrHeight("width", Boolean.TRUE);
        }
        String value = this.getDomNodeOrDie().getAttributeDirect("width");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_PRE_WIDTH_STRING)) {
            this.setWidthOrHeight("width", width, true);
        } else {
            this.getDomNodeOrDie().setAttribute("width", width);
        }
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getClear() {
        String clear = this.getDomNodeOrDie().getAttributeDirect("clear");
        if (!ArrayUtils.contains(VALID_CLEAR_VALUES, clear)) {
            return "";
        }
        return clear;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setClear(String clear) {
        if (!ArrayUtils.contains(VALID_CLEAR_VALUES, clear)) {
            throw Context.reportRuntimeError("Invalid clear property value: '" + clear + "'.");
        }
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }
}

