/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlTitle;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlTitle.class)
public class HTMLTitleElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLTitleElement() {
    }

    @JsxGetter
    public Object getText() {
        DomNode firstChild = this.getDomNodeOrDie().getFirstChild();
        if (firstChild != null) {
            return firstChild.getNodeValue();
        }
        return "";
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        DomNode firstChild = htmlElement.getFirstChild();
        if (firstChild == null) {
            firstChild = new DomText(htmlElement.getPage(), text);
            htmlElement.appendChild(firstChild);
        } else {
            firstChild.setNodeValue(text);
        }
    }
}

