/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.worker;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import org.htmlunit.javascript.configuration.ClassConfiguration;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.WindowOrWorkerGlobalScope;
import org.htmlunit.javascript.host.WindowOrWorkerGlobalScopeMixin;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.event.MessageEvent;
import org.htmlunit.javascript.host.worker.Worker;
import org.htmlunit.javascript.host.worker.WorkerJob;
import org.htmlunit.util.MimeType;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(className="WorkerGlobalScope", value={SupportedBrowser.IE})})
public class DedicatedWorkerGlobalScope
extends EventTarget
implements WindowOrWorkerGlobalScope {
    private static final Log LOG = LogFactory.getLog(DedicatedWorkerGlobalScope.class);
    private final Window owningWindow_;
    private final String origin_;
    private final Worker worker_;

    public DedicatedWorkerGlobalScope() {
        this.owningWindow_ = null;
        this.origin_ = null;
        this.worker_ = null;
    }

    DedicatedWorkerGlobalScope(Window owningWindow, Context context, WebClient webClient, Worker worker) throws Exception {
        context.initSafeStandardObjects(this);
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(DedicatedWorkerGlobalScope.class.getSuperclass(), browserVersion);
        HtmlUnitScriptable parentPrototype = JavaScriptEngine.configureClass(config, this, browserVersion);
        config = AbstractJavaScriptConfiguration.getClassConfiguration(DedicatedWorkerGlobalScope.class, browserVersion);
        HtmlUnitScriptable prototype = JavaScriptEngine.configureClass(config, this, browserVersion);
        prototype.setPrototype(parentPrototype);
        this.setPrototype(prototype);
        JavaScriptEngine.configureRhino(webClient, browserVersion, this);
        this.owningWindow_ = owningWindow;
        URL currentURL = owningWindow.getWebWindow().getEnclosedPage().getUrl();
        this.origin_ = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
        this.worker_ = worker;
    }

    @JsxGetter
    public Object getSelf() {
        return this;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setEventHandler("message", onmessage);
    }

    @Override
    @JsxFunction
    public String btoa(String stringToEncode) {
        return WindowOrWorkerGlobalScopeMixin.btoa(stringToEncode);
    }

    @Override
    @JsxFunction
    public String atob(String encodedData) {
        return WindowOrWorkerGlobalScopeMixin.atob(encodedData);
    }

    @JsxFunction
    public void postMessage(Object message) {
        MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, Undefined.instance);
        event.setParentScope(this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[DedicatedWorker] postMessage: {}" + message));
        }
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction<Object> action = cx -> {
            this.worker_.getEventListenersContainer().executeCapturingListeners(event, null);
            Object[] args = new Object[]{event};
            this.worker_.getEventListenersContainer().executeBubblingListeners(event, args);
            return null;
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, action, "postMessage: " + Context.toString(message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    void messagePosted(Object message) {
        MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, Undefined.instance);
        event.setParentScope(this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction<Object> action = cx -> {
            this.executeEvent(cx, event);
            return null;
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, action, "messagePosted: " + Context.toString(message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    void executeEvent(Context cx, MessageEvent event) {
        Function handlerFunction;
        List<Scriptable> handlers = this.getEventListenersContainer().getListeners("message", false);
        if (handlers != null) {
            Object[] args = new Object[]{event};
            for (Scriptable scriptable : handlers) {
                if (!(scriptable instanceof Function)) continue;
                Function handlerFunction2 = (Function)scriptable;
                handlerFunction2.call(cx, this, this, args);
            }
        }
        if ((handlerFunction = this.getEventHandler("message")) != null) {
            Object[] args = new Object[]{event};
            handlerFunction.call(cx, this, this, args);
        }
    }

    @JsxFunction
    public static void importScripts(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        DedicatedWorkerGlobalScope workerScope = (DedicatedWorkerGlobalScope)thisObj;
        WebClient webClient = workerScope.owningWindow_.getWebWindow().getWebClient();
        boolean checkContentType = !webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WORKER_IMPORT_SCRIPTS_ACCEPTS_ALL);
        for (Object arg : args) {
            String url = Context.toString(arg);
            workerScope.loadAndExecute(webClient, url, cx, checkContentType);
        }
    }

    void loadAndExecute(WebClient webClient, String url, Context context, boolean checkMimeType) throws IOException {
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        URL fullUrl = page.getFullyQualifiedUrl(url);
        WebRequest webRequest = new WebRequest(fullUrl);
        WebResponse response = webClient.loadWebResponse(webRequest);
        if (checkMimeType && !MimeType.isJavascriptMimeType(response.getContentType())) {
            throw Context.reportRuntimeError("NetworkError: importScripts response is not a javascript response");
        }
        String scriptCode = response.getContentAsString();
        JavaScriptEngine javaScriptEngine = (JavaScriptEngine)webClient.getJavaScriptEngine();
        DedicatedWorkerGlobalScope thisScope = this;
        ContextAction<Object> action = cx -> {
            Script script = javaScriptEngine.compile(page, thisScope, scriptCode, fullUrl.toExternalForm(), 1);
            if (script != null) {
                return javaScriptEngine.execute(page, thisScope, script);
            }
            return null;
        };
        HtmlUnitContextFactory cf = javaScriptEngine.getContextFactory();
        if (context != null) {
            action.run(context);
        } else {
            WorkerJob job = new WorkerJob(cf, action, "loadAndExecute " + url);
            this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
        }
    }

    @JsxFunction
    public static Object setTimeout(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        return WindowOrWorkerGlobalScopeMixin.setTimeout(context, ((DedicatedWorkerGlobalScope)thisObj).owningWindow_, args, function);
    }

    @JsxFunction
    public static Object setInterval(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        return WindowOrWorkerGlobalScopeMixin.setInterval(context, ((DedicatedWorkerGlobalScope)thisObj).owningWindow_, args, function);
    }
}

