/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.xml;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.dom.Attr;
import org.htmlunit.javascript.host.dom.DOMException;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.svg.SvgElement;
import org.htmlunit.xml.XmlPage;

@JsxClass
public class XMLDocument
extends Document {
    private static final Log LOG = LogFactory.getLog(XMLDocument.class);

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public XMLDocument() {
        this(null);
    }

    public XMLDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage((WebResponse)null, enclosingWindow);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("IOException: " + e);
            }
        }
    }

    public boolean loadXML(String strXML) {
        WebWindow webWindow = this.getWindow().getWebWindow();
        try {
            if (StringUtils.isEmpty(strXML) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_EMPTY_STRING_IS_ERROR)) {
                throw new IOException("Error parsing XML '" + strXML + "'");
            }
            StringWebResponse webResponse = new StringWebResponse(strXML, webWindow.getEnclosedPage().getUrl());
            XmlPage page = new XmlPage(webResponse, webWindow, false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing XML\n" + strXML), (Throwable)e);
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_EXCEPTION_ON_ERROR)) {
                throw this.asJavaScriptException(new DOMException("Syntax Error", 12));
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_PARSERERROR_ON_ERROR)) {
                try {
                    XmlPage page = XMLDocument.createParserErrorXmlPage("Syntax Error", webWindow);
                    this.setDomNode(page);
                }
                catch (IOException eI) {
                    LOG.error((Object)"Could not handle ParserError", (Throwable)e);
                }
            }
            return false;
        }
    }

    private static XmlPage createParserErrorXmlPage(String message, WebWindow webWindow) throws IOException {
        String xml = "<parsererror xmlns=\"http://www.mozilla.org/newlayout/xml/parsererror.xml\">\n" + message + "\n<sourcetext></sourcetext>\n</parsererror>";
        StringWebResponse webResponse = new StringWebResponse(xml, webWindow.getEnclosedPage().getUrl());
        return new XmlPage(webResponse, webWindow, false);
    }

    @Override
    public HtmlUnitScriptable makeScriptableFor(DomNode domNode) {
        HtmlUnitScriptable scriptable;
        if (domNode instanceof DomElement && !(domNode instanceof HtmlElement)) {
            if (domNode instanceof SvgElement) {
                Class<? extends HtmlUnitScriptable> javaScriptClass = ((JavaScriptEngine)this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine()).getJavaScriptClass(domNode.getClass());
                try {
                    scriptable = javaScriptClass.newInstance();
                }
                catch (Exception e) {
                    throw Context.throwAsScriptRuntimeEx(e);
                }
            } else {
                scriptable = new Element();
            }
        } else if (domNode instanceof DomAttr) {
            scriptable = new Attr();
        } else {
            return super.makeScriptableFor(domNode);
        }
        scriptable.setPrototype(this.getPrototype(scriptable.getClass()));
        scriptable.setParentScope(this.getParentScope());
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    @Override
    protected void initParentScope(DomNode domNode, HtmlUnitScriptable scriptable) {
        scriptable.setParentScope(this.getParentScope());
    }

    @Override
    @JsxFunction
    public HTMLCollection getElementsByTagName(String tagName) {
        DomNode firstChild = this.getDomNodeOrDie().getFirstChild();
        if (firstChild == null) {
            return HTMLCollection.emptyCollection(this.getWindow().getDomNodeOrDie());
        }
        HTMLCollection elements = new HTMLCollection(this.getDomNodeOrDie(), false);
        elements.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> {
            String nodeName = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_GET_ELEMENTS_BY_TAG_NAME_LOCAL) ? node.getLocalName() : node.getNodeName();
            return nodeName.equals(tagName);
        });
        return elements;
    }
}

