/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.platform.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.htmlunit.platform.XmlUtilsHelperAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XmlUtilsXercesHelper
implements XmlUtilsHelperAPI {
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public XmlUtilsXercesHelper() {
        Objects.hash(DeferredDocumentImpl.class, DeferredNode.class);
    }

    @Override
    public Map<Integer, List<String>> getAttributesOrderMap(Document document) {
        if (document instanceof DeferredDocumentImpl) {
            HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
            DeferredDocumentImpl deferredDocument = (DeferredDocumentImpl)document;
            int fNodeCount = (Integer)this.getPrivate(deferredDocument, "fNodeCount");
            for (int i = 0; i < fNodeCount; ++i) {
                short type = deferredDocument.getNodeType(i, false);
                if (type != 1) continue;
                int attrIndex = deferredDocument.getNodeExtra(i, false);
                ArrayList<String> attributes = new ArrayList<String>();
                map.put(i, attributes);
                while (attrIndex != -1) {
                    attributes.add(deferredDocument.getNodeName(attrIndex, false));
                    attrIndex = deferredDocument.getPrevSibling(attrIndex, false);
                }
            }
            return map;
        }
        return null;
    }

    @Override
    public int getIndex(NamedNodeMap namedNodeMap, Map<Integer, List<String>> attributesOrderMap, Node element, int requiredIndex) {
        if (attributesOrderMap != null && element instanceof DeferredNode) {
            int elementIndex = ((DeferredNode)element).getNodeIndex();
            List<String> attributesOrderList = attributesOrderMap.get(elementIndex);
            if (attributesOrderList != null) {
                String attributeName = attributesOrderList.get(requiredIndex);
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    if (!namedNodeMap.item(i).getNodeName().equals(attributeName)) continue;
                    return i;
                }
            }
            return requiredIndex;
        }
        return -1;
    }
}

