/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.svg;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.ElementFactory;
import org.htmlunit.svg.SvgAltGlyph;
import org.htmlunit.svg.SvgAltGlyphDef;
import org.htmlunit.svg.SvgAltGlyphItem;
import org.htmlunit.svg.SvgAnchor;
import org.htmlunit.svg.SvgAnimate;
import org.htmlunit.svg.SvgAnimateColor;
import org.htmlunit.svg.SvgAnimateMotion;
import org.htmlunit.svg.SvgAnimateTransform;
import org.htmlunit.svg.SvgCircle;
import org.htmlunit.svg.SvgClipPath;
import org.htmlunit.svg.SvgColorProfile;
import org.htmlunit.svg.SvgCursor;
import org.htmlunit.svg.SvgDefs;
import org.htmlunit.svg.SvgDesc;
import org.htmlunit.svg.SvgElement;
import org.htmlunit.svg.SvgEllipse;
import org.htmlunit.svg.SvgFeBlend;
import org.htmlunit.svg.SvgFeColorMatrix;
import org.htmlunit.svg.SvgFeComponentTransfer;
import org.htmlunit.svg.SvgFeComposite;
import org.htmlunit.svg.SvgFeConvolveMatrix;
import org.htmlunit.svg.SvgFeDiffuseLighting;
import org.htmlunit.svg.SvgFeDisplacementMap;
import org.htmlunit.svg.SvgFeDistantLight;
import org.htmlunit.svg.SvgFeFlood;
import org.htmlunit.svg.SvgFeFuncA;
import org.htmlunit.svg.SvgFeFuncB;
import org.htmlunit.svg.SvgFeFuncG;
import org.htmlunit.svg.SvgFeFuncR;
import org.htmlunit.svg.SvgFeGaussianBlur;
import org.htmlunit.svg.SvgFeImage;
import org.htmlunit.svg.SvgFeMerge;
import org.htmlunit.svg.SvgFeMergeNode;
import org.htmlunit.svg.SvgFeMorphology;
import org.htmlunit.svg.SvgFeOffset;
import org.htmlunit.svg.SvgFePointLight;
import org.htmlunit.svg.SvgFeSpecularLighting;
import org.htmlunit.svg.SvgFeSpotLight;
import org.htmlunit.svg.SvgFeTile;
import org.htmlunit.svg.SvgFeTurbulence;
import org.htmlunit.svg.SvgFilter;
import org.htmlunit.svg.SvgFont;
import org.htmlunit.svg.SvgFontFace;
import org.htmlunit.svg.SvgFontFaceFormat;
import org.htmlunit.svg.SvgFontFaceName;
import org.htmlunit.svg.SvgFontFaceSrc;
import org.htmlunit.svg.SvgFontFaceURI;
import org.htmlunit.svg.SvgForeignObject;
import org.htmlunit.svg.SvgGlyph;
import org.htmlunit.svg.SvgGlyphRef;
import org.htmlunit.svg.SvgGroup;
import org.htmlunit.svg.SvgHKern;
import org.htmlunit.svg.SvgImage;
import org.htmlunit.svg.SvgLine;
import org.htmlunit.svg.SvgLinearGradient;
import org.htmlunit.svg.SvgMPath;
import org.htmlunit.svg.SvgMarker;
import org.htmlunit.svg.SvgMask;
import org.htmlunit.svg.SvgMetadata;
import org.htmlunit.svg.SvgMissingGlyph;
import org.htmlunit.svg.SvgPath;
import org.htmlunit.svg.SvgPattern;
import org.htmlunit.svg.SvgPolygon;
import org.htmlunit.svg.SvgPolyline;
import org.htmlunit.svg.SvgRadialGradient;
import org.htmlunit.svg.SvgRect;
import org.htmlunit.svg.SvgScript;
import org.htmlunit.svg.SvgSet;
import org.htmlunit.svg.SvgStop;
import org.htmlunit.svg.SvgStyle;
import org.htmlunit.svg.SvgSwitch;
import org.htmlunit.svg.SvgSymbol;
import org.htmlunit.svg.SvgTRef;
import org.htmlunit.svg.SvgTSpan;
import org.htmlunit.svg.SvgText;
import org.htmlunit.svg.SvgTextPath;
import org.htmlunit.svg.SvgTitle;
import org.htmlunit.svg.SvgUse;
import org.htmlunit.svg.SvgVKern;
import org.htmlunit.svg.SvgView;
import org.htmlunit.util.StringUtils;
import org.xml.sax.Attributes;

public class SvgElementFactory
implements ElementFactory {
    private static final Class<?>[] CLASSES_ = new Class[]{SvgAltGlyph.class, SvgAltGlyphDef.class, SvgAltGlyphItem.class, SvgAnchor.class, SvgAnimate.class, SvgAnimateColor.class, SvgAnimateMotion.class, SvgAnimateTransform.class, SvgCircle.class, SvgClipPath.class, SvgColorProfile.class, SvgCursor.class, SvgDefs.class, SvgDesc.class, SvgEllipse.class, SvgFeBlend.class, SvgFeColorMatrix.class, SvgFeComponentTransfer.class, SvgFeComposite.class, SvgFeConvolveMatrix.class, SvgFeDiffuseLighting.class, SvgFeDisplacementMap.class, SvgFeDistantLight.class, SvgFeFlood.class, SvgFeFuncA.class, SvgFeFuncB.class, SvgFeFuncG.class, SvgFeFuncR.class, SvgFeGaussianBlur.class, SvgFeImage.class, SvgFeMerge.class, SvgFeMergeNode.class, SvgFeMorphology.class, SvgFeOffset.class, SvgFePointLight.class, SvgFeSpecularLighting.class, SvgFeSpotLight.class, SvgFeTile.class, SvgFeTurbulence.class, SvgFilter.class, SvgFont.class, SvgFontFace.class, SvgFontFaceFormat.class, SvgFontFaceName.class, SvgFontFaceSrc.class, SvgFontFaceURI.class, SvgForeignObject.class, SvgGlyph.class, SvgGlyphRef.class, SvgGroup.class, SvgHKern.class, SvgImage.class, SvgLine.class, SvgLinearGradient.class, SvgMarker.class, SvgMask.class, SvgMetadata.class, SvgMissingGlyph.class, SvgMPath.class, SvgPath.class, SvgPattern.class, SvgPolygon.class, SvgPolyline.class, SvgRadialGradient.class, SvgRect.class, SvgScript.class, SvgSet.class, SvgStop.class, SvgStyle.class, SvgSwitch.class, SvgSymbol.class, SvgText.class, SvgTextPath.class, SvgTitle.class, SvgTRef.class, SvgTSpan.class, SvgUse.class, SvgView.class, SvgVKern.class};
    private static final Map<String, Class<?>> ELEMENTS_ = new HashMap();

    @Override
    public DomElement createElement(SgmlPage page, String tagName, Attributes attributes) {
        throw new IllegalStateException("SVG.createElement not yet implemented!");
    }

    @Override
    public DomElement createElementNS(SgmlPage page, String namespaceURI, String qualifiedName, Attributes attributes) {
        return this.createElementNS(page, namespaceURI, qualifiedName, attributes, false);
    }

    @Override
    public DomElement createElementNS(SgmlPage page, String namespaceURI, String qualifiedNameLC, Attributes attributes, boolean checkBrowserCompatibility) {
        Map<String, DomAttr> attributeMap = SvgElementFactory.toMap(page, attributes);
        String tagNameLC = qualifiedNameLC = StringUtils.toRootLowerCaseWithCache(qualifiedNameLC);
        if (tagNameLC.indexOf(58) != -1) {
            tagNameLC = tagNameLC.substring(tagNameLC.indexOf(58) + 1);
        }
        DomElement element = null;
        Class<?> klass = ELEMENTS_.get(tagNameLC);
        if (klass != null) {
            try {
                element = (DomElement)klass.getDeclaredConstructors()[0].newInstance(namespaceURI, qualifiedNameLC, page, attributeMap);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (element == null) {
            element = page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.SVG_UNKNOWN_ARE_DOM) ? new DomElement(namespaceURI, qualifiedNameLC, page, attributeMap) : new SvgElement(namespaceURI, qualifiedNameLC, page, attributeMap);
        }
        return element;
    }

    private static Map<String, DomAttr> toMap(SgmlPage page, Attributes attributes) {
        LinkedHashMap<String, DomAttr> attributeMap = null;
        if (attributes != null) {
            attributeMap = new LinkedHashMap<String, DomAttr>(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qName = attributes.getQName(i);
                if (attributeMap.containsKey(qName)) continue;
                String namespaceURI = attributes.getURI(i);
                if (namespaceURI != null && namespaceURI.isEmpty()) {
                    namespaceURI = null;
                }
                DomAttr newAttr = new DomAttr(page, namespaceURI, qName, attributes.getValue(i), true);
                attributeMap.put(qName, newAttr);
            }
        }
        return attributeMap;
    }

    public boolean isSupported(String tagNameLowerCase) {
        return ELEMENTS_.containsKey(tagNameLowerCase);
    }

    static {
        try {
            for (Class<?> klass : CLASSES_) {
                String key = klass.getField("TAG_NAME").get(null).toString();
                ELEMENTS_.put(StringUtils.toRootLowerCaseWithCache(key), klass);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

