/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.commons.net.telnet;

import hidden.jth.org.apache.commons.net.telnet.TelnetClient;
import java.io.IOException;
import java.io.OutputStream;

final class TelnetOutputStream
extends OutputStream {
    private final TelnetClient client;
    private final boolean convertCRtoCRLF = true;
    private boolean lastWasCR;

    TelnetOutputStream(TelnetClient client) {
        this.client = client;
    }

    @Override
    public void close() throws IOException {
        this.client.closeOutputStream();
    }

    @Override
    public void flush() throws IOException {
        this.client.flushOutputStream();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        TelnetClient telnetClient = this.client;
        synchronized (telnetClient) {
            while (length-- > 0) {
                this.write(buffer[offset++]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int ch) throws IOException {
        TelnetClient telnetClient = this.client;
        synchronized (telnetClient) {
            ch &= 0xFF;
            if (this.client.requestedWont(0)) {
                if (this.lastWasCR) {
                    this.client.sendByte(10);
                    if (ch == 10) {
                        this.lastWasCR = false;
                        return;
                    }
                }
                switch (ch) {
                    case 13: {
                        this.client.sendByte(13);
                        this.lastWasCR = true;
                        break;
                    }
                    case 10: {
                        if (!this.lastWasCR) {
                            this.client.sendByte(13);
                        }
                        this.client.sendByte(ch);
                        this.lastWasCR = false;
                        break;
                    }
                    case 255: {
                        this.client.sendByte(255);
                        this.client.sendByte(255);
                        this.lastWasCR = false;
                        break;
                    }
                    default: {
                        this.client.sendByte(ch);
                        this.lastWasCR = false;
                        break;
                    }
                }
            } else if (ch == 255) {
                this.client.sendByte(ch);
                this.client.sendByte(255);
            } else {
                this.client.sendByte(ch);
            }
        }
    }
}

