/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.DefaultPageCreator;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponseData;
import org.htmlunit.util.EncodingSniffer;
import org.htmlunit.util.NameValuePair;

public class WebResponse
implements Serializable {
    @Deprecated
    public static final int OK = 200;
    @Deprecated
    public static final int FORBIDDEN = 403;
    @Deprecated
    public static final int NOT_FOUND = 404;
    @Deprecated
    public static final int NO_CONTENT = 204;
    @Deprecated
    public static final int INTERNAL_SERVER_ERROR = 500;
    private static final Log LOG = LogFactory.getLog(WebResponse.class);
    private static final ByteOrderMark[] BOM_HEADERS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE};
    private final long loadTime_;
    private final WebResponseData responseData_;
    private final WebRequest request_;
    private boolean wasContentCharsetTentative_;
    private boolean wasBlocked_;
    private String blockReason_;

    public WebResponse(WebResponseData responseData, URL url, HttpMethod requestMethod, long loadTime) {
        this(responseData, new WebRequest(url, requestMethod), loadTime);
    }

    public WebResponse(WebResponseData responseData, WebRequest request, long loadTime) {
        this.responseData_ = responseData;
        this.request_ = request;
        this.loadTime_ = loadTime;
    }

    public WebRequest getWebRequest() {
        return this.request_;
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    public String getResponseHeaderValue(String headerName) {
        for (NameValuePair pair : this.responseData_.getResponseHeaders()) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    public Charset getHeaderContentCharset() {
        String contentType = this.getResponseHeaderValue("content-type");
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        if (index == -1) {
            return null;
        }
        return EncodingSniffer.extractEncodingFromContentType(contentType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public Charset getContentCharsetOrNull() {
        try (InputStream is = this.getContentAsStream();){
            Charset charset = EncodingSniffer.sniffEncoding(this.getResponseHeaders(), is);
            return charset;
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to sniff encoding.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Charset getContentCharset() {
        this.wasContentCharsetTentative_ = false;
        try (InputStream is = this.getContentAsStreamWithBomIfApplicable();){
            String bomCharsetName;
            if (is instanceof BOMInputStream && (bomCharsetName = ((BOMInputStream)is).getBOMCharsetName()) != null) {
                Charset charset = Charset.forName(bomCharsetName);
                return charset;
            }
            Charset charset = this.getHeaderContentCharset();
            if (charset != null) {
                Charset charset2 = charset;
                return charset2;
            }
            String contentType = this.getContentType();
            switch (DefaultPageCreator.determinePageType(contentType)) {
                case HTML: {
                    charset = EncodingSniffer.sniffEncodingFromMetaTag(is);
                    this.wasContentCharsetTentative_ = true;
                    break;
                }
                case XML: {
                    charset = EncodingSniffer.sniffEncodingFromXmlDeclaration(is);
                    if (charset != null) break;
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                default: {
                    if (!"text/css".equals(contentType)) break;
                    charset = EncodingSniffer.sniffEncodingFromCssDeclaration(is);
                }
            }
            if (charset == null) return this.getWebRequest().getDefaultResponseContentCharset();
            Charset charset3 = charset;
            return charset3;
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to sniff encoding.", (Throwable)e);
            this.wasContentCharsetTentative_ = true;
        }
        return this.getWebRequest().getDefaultResponseContentCharset();
    }

    public boolean wasContentCharsetTentative() {
        return this.wasContentCharsetTentative_;
    }

    public String getContentAsString() {
        return this.getContentAsString(this.getContentCharset());
    }

    public String getContentAsString(Charset encoding) {
        return this.getContentAsString(encoding, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContentAsString(Charset encoding, boolean ignoreUtf8Bom) {
        if (this.responseData_ == null) return null;
        try (InputStream in = this.responseData_.getInputStreamWithBomIfApplicable(BOM_HEADERS);){
            if (in instanceof BOMInputStream) {
                try (BOMInputStream bomIn = (BOMInputStream)in;){
                    if (bomIn.hasBOM()) {
                        if (!ignoreUtf8Bom && bomIn.hasBOM(ByteOrderMark.UTF_8)) {
                            String string = IOUtils.toString((InputStream)bomIn, (Charset)StandardCharsets.UTF_8);
                            return string;
                        }
                        if (bomIn.hasBOM(ByteOrderMark.UTF_16BE)) {
                            String string = IOUtils.toString((InputStream)bomIn, (Charset)StandardCharsets.UTF_16BE);
                            return string;
                        }
                        if (bomIn.hasBOM(ByteOrderMark.UTF_16LE)) {
                            String string = IOUtils.toString((InputStream)bomIn, (Charset)StandardCharsets.UTF_16LE);
                            return string;
                        }
                    }
                    String string = IOUtils.toString((InputStream)bomIn, (Charset)encoding);
                    return string;
                }
            }
            String string = IOUtils.toString((InputStream)in, (Charset)encoding);
            return string;
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public long getContentLength() {
        if (this.responseData_ == null) {
            return 0L;
        }
        return this.responseData_.getContentLength();
    }

    public InputStream getContentAsStream() throws IOException {
        return this.responseData_.getInputStream();
    }

    public InputStream getContentAsStreamWithBomIfApplicable() throws IOException {
        if (this.responseData_ != null) {
            return this.responseData_.getInputStreamWithBomIfApplicable(BOM_HEADERS);
        }
        return null;
    }

    public long getLoadTime() {
        return this.loadTime_;
    }

    public void cleanUp() {
        if (this.responseData_ != null) {
            this.responseData_.cleanUp();
        }
    }

    @Deprecated
    public void defaultCharsetUtf8() {
        this.getWebRequest().setDefaultResponseContentCharset(StandardCharsets.UTF_8);
    }

    public boolean isSuccess() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean isSuccessOrUseProxy() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300 || statusCode == 305;
    }

    public boolean isSuccessOrUseProxyOrNotModified() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300 || statusCode == 305 || statusCode == 304;
    }

    public boolean wasBlocked() {
        return this.wasBlocked_;
    }

    public String getBlockReason() {
        return this.blockReason_;
    }

    public void markAsBlocked(String blockReason) {
        this.wasBlocked_ = true;
        this.blockReason_ = blockReason;
    }
}

