/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.htmlunit.css.AbstractCssStyleDeclaration;
import org.htmlunit.css.CssColors;
import org.htmlunit.css.CssPixelValueConverter;
import org.htmlunit.css.ElementCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.css.StyleElement;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.dom.Property;
import org.htmlunit.cssparser.parser.selector.Selector;
import org.htmlunit.cssparser.parser.selector.SelectorSpecificity;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlAbbreviated;
import org.htmlunit.html.HtmlAcronym;
import org.htmlunit.html.HtmlAddress;
import org.htmlunit.html.HtmlArticle;
import org.htmlunit.html.HtmlAside;
import org.htmlunit.html.HtmlBaseFont;
import org.htmlunit.html.HtmlBidirectionalIsolation;
import org.htmlunit.html.HtmlBidirectionalOverride;
import org.htmlunit.html.HtmlBig;
import org.htmlunit.html.HtmlBlink;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlBold;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlButtonInput;
import org.htmlunit.html.HtmlCanvas;
import org.htmlunit.html.HtmlCenter;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlCitation;
import org.htmlunit.html.HtmlCode;
import org.htmlunit.html.HtmlData;
import org.htmlunit.html.HtmlDefinition;
import org.htmlunit.html.HtmlDefinitionDescription;
import org.htmlunit.html.HtmlDefinitionTerm;
import org.htmlunit.html.HtmlDivision;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlEmphasis;
import org.htmlunit.html.HtmlFigure;
import org.htmlunit.html.HtmlFigureCaption;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlFooter;
import org.htmlunit.html.HtmlHeader;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlInlineFrame;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlItalic;
import org.htmlunit.html.HtmlKeyboard;
import org.htmlunit.html.HtmlLayer;
import org.htmlunit.html.HtmlLegend;
import org.htmlunit.html.HtmlMain;
import org.htmlunit.html.HtmlMark;
import org.htmlunit.html.HtmlNav;
import org.htmlunit.html.HtmlNoBreak;
import org.htmlunit.html.HtmlNoEmbed;
import org.htmlunit.html.HtmlNoFrames;
import org.htmlunit.html.HtmlNoLayer;
import org.htmlunit.html.HtmlNoScript;
import org.htmlunit.html.HtmlOutput;
import org.htmlunit.html.HtmlPasswordInput;
import org.htmlunit.html.HtmlPlainText;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlRb;
import org.htmlunit.html.HtmlResetInput;
import org.htmlunit.html.HtmlRp;
import org.htmlunit.html.HtmlRt;
import org.htmlunit.html.HtmlRtc;
import org.htmlunit.html.HtmlRuby;
import org.htmlunit.html.HtmlS;
import org.htmlunit.html.HtmlSample;
import org.htmlunit.html.HtmlSection;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlSlot;
import org.htmlunit.html.HtmlSmall;
import org.htmlunit.html.HtmlSpan;
import org.htmlunit.html.HtmlStrike;
import org.htmlunit.html.HtmlStrong;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlSubscript;
import org.htmlunit.html.HtmlSummary;
import org.htmlunit.html.HtmlSuperscript;
import org.htmlunit.html.HtmlTableCell;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.html.HtmlTeletype;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.HtmlTextInput;
import org.htmlunit.html.HtmlTime;
import org.htmlunit.html.HtmlUnderlined;
import org.htmlunit.html.HtmlUnknownElement;
import org.htmlunit.html.HtmlVariable;
import org.htmlunit.html.HtmlWordBreak;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.platform.Platform;

public class ComputedCssStyleDeclaration
extends AbstractCssStyleDeclaration {
    private static final Set<StyleAttributes.Definition> INHERITABLE_DEFINITIONS = EnumSet.of(StyleAttributes.Definition.BORDER_COLLAPSE, new StyleAttributes.Definition[]{StyleAttributes.Definition.BORDER_SPACING, StyleAttributes.Definition.CAPTION_SIDE, StyleAttributes.Definition.COLOR, StyleAttributes.Definition.CURSOR, StyleAttributes.Definition.DIRECTION, StyleAttributes.Definition.EMPTY_CELLS, StyleAttributes.Definition.FONT_FAMILY, StyleAttributes.Definition.FONT_SIZE, StyleAttributes.Definition.FONT_STYLE, StyleAttributes.Definition.FONT_VARIANT, StyleAttributes.Definition.FONT_WEIGHT, StyleAttributes.Definition.FONT, StyleAttributes.Definition.LETTER_SPACING, StyleAttributes.Definition.LINE_HEIGHT, StyleAttributes.Definition.LIST_STYLE_IMAGE, StyleAttributes.Definition.LIST_STYLE_POSITION, StyleAttributes.Definition.LIST_STYLE_TYPE, StyleAttributes.Definition.LIST_STYLE, StyleAttributes.Definition.ORPHANS, StyleAttributes.Definition.QUOTES, StyleAttributes.Definition.SPEAK, StyleAttributes.Definition.TEXT_ALIGN, StyleAttributes.Definition.TEXT_INDENT, StyleAttributes.Definition.TEXT_TRANSFORM, StyleAttributes.Definition.VISIBILITY, StyleAttributes.Definition.WHITE_SPACE, StyleAttributes.Definition.WIDOWS, StyleAttributes.Definition.WORD_SPACING});
    public static final String EMPTY_FINAL = new String("");
    private Integer width_;
    private Integer height_;
    private Integer height2_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;
    private Integer top_;
    private final SortedMap<String, StyleElement> localModifications_ = new TreeMap<String, StyleElement>();
    private ElementCssStyleDeclaration elementStyleDeclaration_;

    public ComputedCssStyleDeclaration(ElementCssStyleDeclaration styleDeclaration) {
        this.elementStyleDeclaration_ = styleDeclaration;
        this.getDomElement().setDefaults(this);
    }

    @Override
    public String getStylePriority(String name) {
        return this.elementStyleDeclaration_.getStylePriority(name);
    }

    @Override
    public String getCssText() {
        return this.elementStyleDeclaration_.getCssText();
    }

    @Override
    public String getStyleAttribute(String name) {
        StyleElement element = this.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            String value = element.getValue();
            if (!"content".equals(name) && !value.contains("url")) {
                return org.htmlunit.util.StringUtils.toRootLowerCase(value);
            }
            return value;
        }
        return "";
    }

    @Override
    public String getStyleAttribute(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty) {
        BrowserVersion browserVersion = this.getDomElement().getPage().getWebClient().getBrowserVersion();
        boolean isDefInheritable = INHERITABLE_DEFINITIONS.contains((Object)definition);
        ComputedCssStyleDeclaration[] queue = new ComputedCssStyleDeclaration[]{this};
        String value = null;
        while (queue[0] != null) {
            value = ComputedCssStyleDeclaration.getStyleAttributeWorker(definition, getDefaultValueIfEmpty, browserVersion, true, isDefInheritable, queue);
        }
        return value;
    }

    private static String getStyleAttributeWorker(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty, BrowserVersion browserVersion, boolean feature, boolean isDefInheritable, ComputedCssStyleDeclaration[] queue) {
        ComputedCssStyleDeclaration decl = queue[0];
        queue[0] = null;
        DomElement domElem = decl.getDomElement();
        if (!domElem.isAttachedToPage() && feature) {
            return EMPTY_FINAL;
        }
        String value = decl.getStyleAttribute(definition.getAttributeName());
        if (value.isEmpty()) {
            DomNode parent = domElem.getParentNode();
            if (isDefInheritable && parent instanceof DomElement) {
                WebWindow window = domElem.getPage().getEnclosingWindow();
                queue[0] = window.getComputedStyle((DomElement)parent, null);
            } else if (getDefaultValueIfEmpty) {
                value = definition.getDefaultComputedValue(browserVersion);
            }
        }
        return value;
    }

    private String getStyleAttribute(StyleAttributes.Definition definition, String toReturnIfEmptyOrDefault, String defaultValue) {
        DomElement domElement = this.getDomElement();
        if (!domElement.isAttachedToPage()) {
            return EMPTY_FINAL;
        }
        boolean isDefInheritable = INHERITABLE_DEFINITIONS.contains((Object)definition);
        BrowserVersion browserVersion = domElement.getPage().getWebClient().getBrowserVersion();
        ComputedCssStyleDeclaration[] queue = new ComputedCssStyleDeclaration[]{this};
        String value = null;
        while (queue[0] != null) {
            value = ComputedCssStyleDeclaration.getStyleAttributeWorker(definition, false, browserVersion, true, isDefInheritable, queue);
        }
        if (value == null || value.isEmpty() || value.equals(defaultValue)) {
            return toReturnIfEmptyOrDefault;
        }
        return value;
    }

    @Override
    public void setCssText(String value) {
    }

    @Override
    public void setStyleAttribute(String name, String newValue, String important) {
    }

    @Override
    public String removeStyleAttribute(String name) {
        return null;
    }

    @Override
    public int getLength() {
        return this.elementStyleDeclaration_.getLength();
    }

    @Override
    public String getWidth() {
        if ("none".equals(this.getDisplay())) {
            return "auto";
        }
        final DomElement domElem = this.getDomElement();
        if (!domElem.isAttachedToPage()) {
            return "";
        }
        int windowWidth = domElem.getPage().getEnclosingWindow().getInnerWidth();
        return CssPixelValueConverter.pixelString(domElem, new CssPixelValueConverter.CssValue(0, windowWidth){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                String value = style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
                if (StringUtils.isEmpty(value)) {
                    String content;
                    String position = ComputedCssStyleDeclaration.this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
                    if (("absolute".equals(position) || "fixed".equals(position)) && null != (content = domElem.getVisibleText()) && content.length() < 13) {
                        return content.length() * 7 + "px";
                    }
                    int windowDefaultValue = this.getWindowDefaultValue();
                    if (domElem instanceof HtmlBody) {
                        windowDefaultValue -= 16;
                    }
                    return windowDefaultValue + "px";
                }
                if ("auto".equals(value)) {
                    int windowDefaultValue = this.getWindowDefaultValue();
                    if (domElem instanceof HtmlBody) {
                        windowDefaultValue -= 16;
                    }
                    return windowDefaultValue + "px";
                }
                return value;
            }
        });
    }

    @Override
    public Object item(int index) {
        return this.elementStyleDeclaration_.item(index);
    }

    @Override
    public AbstractCSSRuleImpl getParentRule() {
        return this.elementStyleDeclaration_.getParentRule();
    }

    @Override
    public StyleElement getStyleElement(String name) {
        StyleElement existent = this.elementStyleDeclaration_.getStyleElement(name);
        if (this.localModifications_ != null) {
            StyleElement localStyleMod = (StyleElement)this.localModifications_.get(name);
            if (localStyleMod == null) {
                return existent;
            }
            if (existent == null) {
                return localStyleMod;
            }
            if ("important".equals(localStyleMod.getPriority())) {
                if (existent.isImportant()) {
                    if (existent.getSpecificity().compareTo(localStyleMod.getSpecificity()) < 0) {
                        return localStyleMod;
                    }
                } else {
                    return localStyleMod;
                }
            }
        }
        return existent;
    }

    @Override
    public StyleElement getStyleElementCaseInSensitive(String name) {
        return this.elementStyleDeclaration_.getStyleElementCaseInSensitive(name);
    }

    @Override
    public Map<String, StyleElement> getStyleMap() {
        return this.elementStyleDeclaration_.getStyleMap();
    }

    public DomElement getDomElement() {
        return this.elementStyleDeclaration_.getDomElement();
    }

    @Override
    public String getBackgroundAttachment() {
        return this.defaultIfEmpty(super.getBackgroundAttachment(), StyleAttributes.Definition.BACKGROUND_ATTACHMENT);
    }

    @Override
    public String getBackgroundColor() {
        String value = super.getBackgroundColor();
        if (StringUtils.isEmpty(value)) {
            return StyleAttributes.Definition.BACKGROUND_COLOR.getDefaultComputedValue(this.getBrowserVersion());
        }
        return CssColors.toRGBColor(value);
    }

    @Override
    public String getBackgroundImage() {
        return this.defaultIfEmpty(super.getBackgroundImage(), StyleAttributes.Definition.BACKGROUND_IMAGE);
    }

    @Override
    public String getBackgroundPosition() {
        return this.defaultIfEmpty(super.getBackgroundPosition(), StyleAttributes.Definition.BACKGROUND_POSITION);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.defaultIfEmpty(super.getBackgroundRepeat(), StyleAttributes.Definition.BACKGROUND_REPEAT);
    }

    @Override
    public String getBorderBottomColor() {
        return this.defaultIfEmpty(super.getBorderBottomColor(), StyleAttributes.Definition.BORDER_BOTTOM_COLOR);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.defaultIfEmpty(super.getBorderBottomStyle(), StyleAttributes.Definition.BORDER_BOTTOM_STYLE);
    }

    @Override
    public String getBorderBottomWidth() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderBottomWidth(), StyleAttributes.Definition.BORDER_BOTTOM_WIDTH));
    }

    @Override
    public String getBorderLeftColor() {
        return this.defaultIfEmpty(super.getBorderLeftColor(), StyleAttributes.Definition.BORDER_LEFT_COLOR);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.defaultIfEmpty(super.getBorderLeftStyle(), StyleAttributes.Definition.BORDER_LEFT_STYLE);
    }

    @Override
    public String getBorderLeftWidth() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderLeftWidth(), "0px", null));
    }

    @Override
    public String getBorderRightColor() {
        return this.defaultIfEmpty(super.getBorderRightColor(), "rgb(0, 0, 0)", null);
    }

    @Override
    public String getBorderRightStyle() {
        return this.defaultIfEmpty(super.getBorderRightStyle(), "none", null);
    }

    @Override
    public String getBorderRightWidth() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderRightWidth(), "0px", null));
    }

    @Override
    public String getBorderTopColor() {
        return this.defaultIfEmpty(super.getBorderTopColor(), "rgb(0, 0, 0)", null);
    }

    @Override
    public String getBorderTopStyle() {
        return this.defaultIfEmpty(super.getBorderTopStyle(), "none", null);
    }

    @Override
    public String getBorderTopWidth() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getBorderTopWidth(), "0px", null));
    }

    @Override
    public String getBottom() {
        return this.getStyleAttribute(StyleAttributes.Definition.BOTTOM, "auto", null);
    }

    @Override
    public String getColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.COLOR, "rgb(0, 0, 0)", null);
        return CssColors.toRGBColor(value);
    }

    @Override
    public String getCssFloat() {
        return this.defaultIfEmpty(super.getCssFloat(), StyleAttributes.Definition.CSS_FLOAT);
    }

    @Override
    public String getDisplay() {
        DomElement domElem = this.getDomElement();
        if (!domElem.isAttachedToPage()) {
            return "";
        }
        String value = this.getStyleAttribute(StyleAttributes.Definition.DISPLAY.getAttributeName());
        if (StringUtils.isEmpty(value)) {
            if (domElem instanceof HtmlElement) {
                return ((HtmlElement)domElem).getDefaultStyleDisplay().value();
            }
            return "";
        }
        return value;
    }

    @Override
    public String getFont() {
        DomElement domElem = this.getDomElement();
        if (domElem.isAttachedToPage()) {
            return this.getStyleAttribute(StyleAttributes.Definition.FONT, true);
        }
        return "";
    }

    @Override
    public String getFontFamily() {
        return this.getStyleAttribute(StyleAttributes.Definition.FONT_FAMILY, true);
    }

    @Override
    public String getFontSize() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.FONT_SIZE, true);
        if (!value.isEmpty()) {
            value = CssPixelValueConverter.pixelValue(value) + "px";
        }
        return value;
    }

    @Override
    public String getLineHeight() {
        return this.defaultIfEmpty(super.getLineHeight(), StyleAttributes.Definition.LINE_HEIGHT);
    }

    @Override
    public String getHeight() {
        if ("none".equals(this.getDisplay())) {
            return "auto";
        }
        final DomElement elem = this.getDomElement();
        if (!elem.isAttachedToPage()) {
            return "";
        }
        int windowHeight = elem.getPage().getEnclosingWindow().getInnerHeight();
        return CssPixelValueConverter.pixelString(elem, new CssPixelValueConverter.CssValue(0, windowHeight){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                String offsetHeight = ((HTMLElement)elem.getScriptableObject()).getOffsetHeight() + "px";
                return ComputedCssStyleDeclaration.this.defaultIfEmpty(style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true), offsetHeight, "auto");
            }
        });
    }

    @Override
    public String getLeft() {
        String superLeft = super.getLeft();
        if (!superLeft.endsWith("%")) {
            return this.defaultIfEmpty(superLeft, "auto", null);
        }
        final DomElement element = this.getDomElement();
        return CssPixelValueConverter.pixelString(element, new CssPixelValueConverter.CssValue(0, 0){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                if (style.getDomElement() == element) {
                    return style.getStyleAttribute(StyleAttributes.Definition.LEFT, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
            }
        });
    }

    @Override
    public String getLetterSpacing() {
        return this.defaultIfEmpty(super.getLetterSpacing(), "normal", null);
    }

    @Override
    public String getMargin() {
        return this.defaultIfEmpty(super.getMargin(), StyleAttributes.Definition.MARGIN, true);
    }

    @Override
    public String getMarginBottom() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getMarginBottom(), "0px", null));
    }

    @Override
    public String getMarginLeft() {
        return this.getMarginX(super.getMarginLeft(), StyleAttributes.Definition.MARGIN_LEFT);
    }

    @Override
    public String getMarginRight() {
        return this.getMarginX(super.getMarginRight(), StyleAttributes.Definition.MARGIN_RIGHT);
    }

    private String getMarginX(String superMarginX, final StyleAttributes.Definition definition) {
        if (!superMarginX.endsWith("%")) {
            return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(superMarginX, "0px", null));
        }
        final DomElement element = this.getDomElement();
        if (!element.isAttachedToPage()) {
            return "";
        }
        int windowWidth = element.getPage().getEnclosingWindow().getInnerWidth();
        return CssPixelValueConverter.pixelString(element, new CssPixelValueConverter.CssValue(0, windowWidth){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                if (style.getDomElement() == element) {
                    return style.getStyleAttribute(definition, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
            }
        });
    }

    @Override
    public String getMarginTop() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getMarginTop(), "0px", null));
    }

    @Override
    public String getMaxHeight() {
        return this.defaultIfEmpty(super.getMaxHeight(), "none", null);
    }

    @Override
    public String getMaxWidth() {
        return this.defaultIfEmpty(super.getMaxWidth(), "none", null);
    }

    @Override
    public String getMinHeight() {
        return this.defaultIfEmpty(super.getMinHeight(), "0px", null);
    }

    @Override
    public String getMinWidth() {
        return this.defaultIfEmpty(super.getMinWidth(), "0px", null);
    }

    @Override
    public String getOpacity() {
        return this.defaultIfEmpty(super.getOpacity(), "1", null);
    }

    @Override
    public String getOrphans() {
        return this.defaultIfEmpty(super.getOrphans(), StyleAttributes.Definition.ORPHANS);
    }

    @Override
    public String getOutlineWidth() {
        return this.defaultIfEmpty(super.getOutlineWidth(), "0px", null);
    }

    @Override
    public String getPadding() {
        return this.defaultIfEmpty(super.getPadding(), StyleAttributes.Definition.PADDING, true);
    }

    @Override
    public String getPaddingBottom() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingBottom(), "0px", null));
    }

    @Override
    public String getPaddingLeft() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingLeft(), "0px", null));
    }

    @Override
    public String getPaddingRight() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingRight(), "0px", null));
    }

    @Override
    public String getPaddingTop() {
        return ComputedCssStyleDeclaration.pixelString(this.defaultIfEmpty(super.getPaddingTop(), "0px", null));
    }

    @Override
    public String getRight() {
        return this.defaultIfEmpty(super.getRight(), "auto", null);
    }

    @Override
    public String getTextIndent() {
        return this.defaultIfEmpty(super.getTextIndent(), "0px", null);
    }

    @Override
    public String getTop() {
        final DomElement element = this.getDomElement();
        if (!element.isAttachedToPage()) {
            return "";
        }
        String superTop = super.getTop();
        if (!superTop.endsWith("%")) {
            return this.defaultIfEmpty(superTop, StyleAttributes.Definition.TOP);
        }
        return CssPixelValueConverter.pixelString(element, new CssPixelValueConverter.CssValue(0, 0){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                if (style.getDomElement() == element) {
                    return style.getStyleAttribute(StyleAttributes.Definition.TOP, true);
                }
                return style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true);
            }
        });
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        Integer cachedTop = this.getCachedTop();
        int top = 0;
        if (null == cachedTop) {
            String position = this.getPositionWithInheritance();
            if ("absolute".equals(position) || "fixed".equals(position)) {
                top = this.getTopForAbsolutePositionWithInheritance();
            } else if (this.getDomElement() instanceof HtmlTableCell) {
                top = 0;
            } else {
                boolean prevHadComputedTop = false;
                for (DomNode prev = this.getDomElement().getPreviousSibling(); prev != null && !prevHadComputedTop; prev = prev.getPreviousSibling()) {
                    ComputedCssStyleDeclaration style;
                    String display;
                    if (!(prev instanceof HtmlElement) || !ComputedCssStyleDeclaration.isBlock(display = (style = prev.getPage().getEnclosingWindow().getComputedStyle((DomElement)prev, null)).getDisplay())) continue;
                    int prevTop = 0;
                    Integer eCachedTop = style.getCachedTop();
                    if (eCachedTop == null) {
                        String prevPosition = style.getPositionWithInheritance();
                        if ("absolute".equals(prevPosition) || "fixed".equals(prevPosition)) {
                            prevTop += style.getTopForAbsolutePositionWithInheritance();
                        } else if ("relative".equals(prevPosition)) {
                            String t = style.getTopWithInheritance();
                            prevTop += CssPixelValueConverter.pixelValue(t);
                        }
                    } else {
                        prevHadComputedTop = true;
                        prevTop += eCachedTop.intValue();
                    }
                    prevTop += style.getCalculatedHeight(true, true);
                    int margin = CssPixelValueConverter.pixelValue(style.getMarginTop());
                    top += (prevTop += margin);
                }
                if ("relative".equals(position)) {
                    String t = this.getTopWithInheritance();
                    top += CssPixelValueConverter.pixelValue(t);
                }
            }
            cachedTop = top;
            this.setCachedTop(cachedTop);
        } else {
            top = cachedTop;
        }
        if (includeMargin) {
            int margin = CssPixelValueConverter.pixelValue(this.getMarginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = CssPixelValueConverter.pixelValue(this.getBorderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTopValue();
            top += padding;
        }
        return top;
    }

    private static boolean isBlock(String display) {
        return display != null && !"inline".equals(display) && !"none".equals(display);
    }

    public String getTopWithInheritance() {
        String top = this.getTop();
        if ("inherit".equals(top)) {
            HtmlElement parent = (HtmlElement)this.getDomElement().getParentNode();
            if (parent == null) {
                top = "auto";
            } else {
                ComputedCssStyleDeclaration style = parent.getPage().getEnclosingWindow().getComputedStyle(parent, null);
                top = style.getTopWithInheritance();
            }
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.getBottom();
        if ("inherit".equals(bottom)) {
            DomNode parent = this.getDomElement().getParentNode();
            if (parent == null) {
                bottom = "auto";
            } else {
                ComputedCssStyleDeclaration style = parent.getPage().getEnclosingWindow().getComputedStyle((DomElement)parent, null);
                bottom = style.getBottomWithInheritance();
            }
        }
        return bottom;
    }

    @Override
    public String getVerticalAlign() {
        return this.defaultIfEmpty(super.getVerticalAlign(), "baseline", null);
    }

    @Override
    public String getWidows() {
        return this.defaultIfEmpty(super.getWidows(), StyleAttributes.Definition.WIDOWS);
    }

    @Override
    public String getWordSpacing() {
        return this.defaultIfEmpty(super.getWordSpacing(), StyleAttributes.Definition.WORD_SPACING);
    }

    @Override
    public Object getZIndex() {
        Object response = super.getZIndex();
        if (response.toString().isEmpty()) {
            return "auto";
        }
        return response;
    }

    public int getMarginLeftValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginLeft());
    }

    public int getMarginRightValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginRight());
    }

    public int getMarginTopValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginTop());
    }

    public int getMarginBottomValue() {
        return CssPixelValueConverter.pixelValue(this.getMarginBottom());
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        DomNode parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if (("absolute".equals(p) || "fixed".equals(p)) && !"auto".equals(l)) {
            left = CssPixelValueConverter.pixelValue(l);
        } else if (("absolute".equals(p) || "fixed".equals(p)) && !"auto".equals(r)) {
            int parentWidth;
            parent = this.getDomElement().getParentNode();
            if (parent == null) {
                parentWidth = this.getDomElement().getPage().getEnclosingWindow().getInnerWidth();
            } else if (parent instanceof Page) {
                parentWidth = ((Page)((Object)parent)).getEnclosingWindow().getInnerWidth();
            } else {
                ComputedCssStyleDeclaration parentStyle = parent.getPage().getEnclosingWindow().getComputedStyle((DomElement)parent, null);
                parentWidth = parentStyle.getCalculatedWidth(false, false);
            }
            left = parentWidth - CssPixelValueConverter.pixelValue(r);
        } else if ("fixed".equals(p) && !"auto".equals(r)) {
            int parentWidth;
            DomElement e = this.getDomElement();
            WebWindow win = e.getPage().getEnclosingWindow();
            ComputedCssStyleDeclaration style = win.getComputedStyle(e, null);
            DomNode parent2 = e.getParentNode();
            if (parent2 == null) {
                parentWidth = win.getInnerWidth();
            } else {
                ComputedCssStyleDeclaration parentStyle = win.getComputedStyle((DomElement)parent2, null);
                parentWidth = CssPixelValueConverter.pixelValue(parentStyle.getWidth()) - CssPixelValueConverter.pixelValue(style.getWidth());
            }
            left = parentWidth - CssPixelValueConverter.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = this.getDomElement().getParentNode();
            if (parent == null || parent instanceof Page) {
                left = 0;
            } else {
                ComputedCssStyleDeclaration style = parent.getPage().getEnclosingWindow().getComputedStyle((DomElement)parent, null);
                left = CssPixelValueConverter.pixelValue(style.getLeftWithInheritance());
            }
        } else if ("static".equals(p)) {
            left = 0;
            for (DomNode prev = this.getDomElement().getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                String content;
                if (prev instanceof HtmlElement) {
                    ComputedCssStyleDeclaration style = prev.getPage().getEnclosingWindow().getComputedStyle((DomElement)prev, null);
                    String d = style.getDisplay();
                    if (!ComputedCssStyleDeclaration.isBlock(d)) {
                        if ("none".equals(d)) continue;
                        left += style.getCalculatedWidth(true, true);
                        continue;
                    }
                    break;
                }
                if (!(prev instanceof DomText) || (content = prev.getVisibleText()) == null) continue;
                left += content.trim().length() * this.getDomElement().getPage().getWebClient().getBrowserVersion().getPixesPerChar();
            }
        } else {
            left = CssPixelValueConverter.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeftValue();
            left += margin;
        }
        if (includeBorder) {
            int border = CssPixelValueConverter.pixelValue(this.getBorderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeftValue();
            left += padding;
        }
        return left;
    }

    @Override
    public String getPosition() {
        return this.defaultIfEmpty(super.getPosition(), StyleAttributes.Definition.POSITION);
    }

    public String getPositionWithInheritance() {
        String p = this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
        if ("inherit".equals(p)) {
            DomNode parent = this.getDomElement().getParentNode();
            if (parent == null) {
                p = "static";
            } else {
                ComputedCssStyleDeclaration style = parent.getPage().getEnclosingWindow().getComputedStyle((DomElement)parent, null);
                p = style.getPositionWithInheritance();
            }
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.getLeft();
        if ("inherit".equals(left)) {
            DomNode parent = this.getDomElement().getParentNode();
            if (parent == null) {
                left = "auto";
            } else {
                ComputedCssStyleDeclaration style = parent.getPage().getEnclosingWindow().getComputedStyle((DomElement)parent, null);
                left = style.getLeftWithInheritance();
            }
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.getRight();
        if ("inherit".equals(right)) {
            DomNode parent = this.getDomElement().getParentNode();
            if (parent == null) {
                right = "auto";
            } else {
                ComputedCssStyleDeclaration style = parent.getPage().getEnclosingWindow().getComputedStyle((DomElement)parent, null);
                right = style.getRightWithInheritance();
            }
        }
        return right;
    }

    private int getTopForAbsolutePositionWithInheritance() {
        String t = this.getTopWithInheritance();
        if (!"auto".equals(t)) {
            return CssPixelValueConverter.pixelValue(t);
        }
        String b = this.getBottomWithInheritance();
        if (!"auto".equals(b)) {
            int top = 0;
            for (DomNode child = this.getDomElement().getParentNode().getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof HtmlElement) || !child.mayBeDisplayed()) continue;
                top += 20;
            }
            return top -= CssPixelValueConverter.pixelValue(b);
        }
        return 0;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        DomElement element = this.getDomElement();
        if (!element.isAttachedToPage()) {
            return 0;
        }
        int height = this.getCalculatedHeight();
        if (!"border-box".equals(this.getStyleAttribute(StyleAttributes.Definition.BOX_SIZING, true))) {
            if (includeBorder) {
                height += this.getBorderVertical();
            } else if (this.isScrollable(false, true) && !(element instanceof HtmlBody)) {
                height -= 17;
            }
            if (includePadding) {
                height += this.getPaddingVertical();
            }
        }
        return height;
    }

    private int getCalculatedHeight() {
        int contentHeight;
        boolean isInline;
        Integer cachedHeight = this.getCachedHeight();
        if (cachedHeight != null) {
            return cachedHeight;
        }
        DomElement element = this.getDomElement();
        if (element instanceof HtmlImage) {
            return this.setCachedHeight(((HtmlImage)element).getHeightOrDefault());
        }
        boolean bl = isInline = "inline".equals(this.getDisplay()) && !(element instanceof HtmlInlineFrame);
        if ((isInline || super.getHeight().isEmpty()) && (contentHeight = this.getContentHeight()) > 0) {
            return this.setCachedHeight(contentHeight);
        }
        return this.setCachedHeight(this.getEmptyHeight());
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        DomElement element = this.getDomElement();
        if (!element.isAttachedToPage()) {
            return 0;
        }
        int width = this.getCalculatedWidth();
        if (!"border-box".equals(this.getStyleAttribute(StyleAttributes.Definition.BOX_SIZING, true))) {
            if (includeBorder) {
                width += this.getBorderHorizontal();
            } else if (this.isScrollable(true, true) && !(element instanceof HtmlBody)) {
                width -= 17;
            }
            if (includePadding) {
                width += this.getPaddingHorizontal();
            }
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        Integer cachedWidth = this.getCachedWidth();
        if (cachedWidth != null) {
            return cachedWidth;
        }
        DomElement element = this.getDomElement();
        if (!element.mayBeDisplayed()) {
            return this.setCachedWidth(0);
        }
        String display = this.getDisplay();
        if ("none".equals(display)) {
            return this.setCachedWidth(0);
        }
        String styleWidth = this.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
        DomNode parent = element.getParentNode();
        if (("inline".equals(display) || StringUtils.isEmpty(styleWidth)) && parent instanceof HtmlElement) {
            if (element instanceof HtmlCanvas) {
                return 300;
            }
            String cssFloat = this.getCssFloat();
            String position = this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
            if ("right".equals(cssFloat) || "left".equals(cssFloat) || "absolute".equals(position) || "fixed".equals(position)) {
                BrowserVersion browserVersion = this.getDomElement().getPage().getWebClient().getBrowserVersion();
                width = element.getVisibleText().length() * browserVersion.getPixesPerChar();
            } else if ("block".equals(display)) {
                int windowWidth = element.getPage().getEnclosingWindow().getInnerWidth();
                width = element instanceof HtmlBody ? windowWidth - 16 : CssPixelValueConverter.pixelValue((DomElement)parent, new CssPixelValueConverter.CssValue(0, windowWidth){

                    @Override
                    public String get(ComputedCssStyleDeclaration style) {
                        return style.getWidth();
                    }
                }) - (this.getBorderHorizontal() + this.getPaddingHorizontal());
            } else if (element instanceof HtmlSubmitInput || element instanceof HtmlResetInput || element instanceof HtmlButtonInput || element instanceof HtmlButton || element instanceof HtmlFileInput) {
                String text = element.asNormalizedText();
                BrowserVersion browserVersion = this.getDomElement().getPage().getWebClient().getBrowserVersion();
                width = 10 + (int)((double)(text.length() * browserVersion.getPixesPerChar()) * 0.9);
            } else if (element instanceof HtmlTextInput || element instanceof HtmlPasswordInput) {
                BrowserVersion browserVersion = this.getDomElement().getPage().getWebClient().getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_CLIENTWIDTH_INPUT_TEXT_173)) {
                    return 173;
                }
                width = 154;
            } else {
                BrowserVersion browserVersion;
                width = element instanceof HtmlRadioButtonInput || element instanceof HtmlCheckBoxInput ? ((browserVersion = this.getDomElement().getPage().getWebClient().getBrowserVersion()).hasFeature(BrowserVersionFeatures.JS_CLIENTWIDTH_RADIO_CHECKBOX_10) ? 10 : 13) : (element instanceof HtmlTextArea ? 100 : (element instanceof HtmlImage ? ((HtmlImage)element).getWidthOrDefault() : this.getContentWidth()));
            }
        } else {
            width = "auto".equals(styleWidth) ? element.getPage().getEnclosingWindow().getInnerWidth() : CssPixelValueConverter.pixelValue(element, new CssPixelValueConverter.CssValue(0, element.getPage().getEnclosingWindow().getInnerWidth()){

                @Override
                public String get(ComputedCssStyleDeclaration style) {
                    return style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
                }
            });
        }
        return this.setCachedWidth(width);
    }

    public int getContentWidth() {
        Page enclosedPage;
        int width = 0;
        DomElement element = this.getDomElement();
        Iterable<DomNode> children = element.getChildren();
        if (element instanceof BaseFrameElement && (enclosedPage = ((BaseFrameElement)element).getEnclosedPage()) != null && enclosedPage.isHtmlPage()) {
            children = ((DomNode)((Object)enclosedPage)).getChildren();
        }
        WebWindow webWindow = element.getPage().getEnclosingWindow();
        for (DomNode child : children) {
            if (child instanceof HtmlElement) {
                HtmlElement e = (HtmlElement)child;
                ComputedCssStyleDeclaration style = webWindow.getComputedStyle(e, null);
                int w = style.getCalculatedWidth(true, true);
                width += w;
                continue;
            }
            if (!(child instanceof DomText)) continue;
            BrowserVersion browserVersion = this.getDomElement().getPage().getWebClient().getBrowserVersion();
            DomNode parent = child.getParentNode();
            if (parent instanceof HtmlElement) {
                ComputedCssStyleDeclaration style = webWindow.getComputedStyle((DomElement)parent, null);
                int height = browserVersion.getFontHeight(style.getFontSize());
                width += child.getVisibleText().length() * (int)((float)height / 1.8f);
                continue;
            }
            width += child.getVisibleText().length() * browserVersion.getPixesPerChar();
        }
        return width;
    }

    private int getEmptyHeight() {
        int defaultHeight;
        boolean explicitHeightSpecified;
        Integer cachedHeight2 = this.getCachedHeight2();
        if (cachedHeight2 != null) {
            return cachedHeight2;
        }
        DomElement element = this.getDomElement();
        if (!element.mayBeDisplayed()) {
            return this.setCachedHeight2(0);
        }
        String display = this.getDisplay();
        if ("none".equals(display)) {
            return this.setCachedHeight2(0);
        }
        WebWindow webWindow = element.getPage().getEnclosingWindow();
        int windowHeight = webWindow.getInnerHeight();
        if (element instanceof HtmlBody) {
            return this.setCachedHeight2(windowHeight);
        }
        final boolean isInline = "inline".equals(display) && !(element instanceof HtmlInlineFrame);
        boolean bl = explicitHeightSpecified = !isInline && !super.getHeight().isEmpty();
        if ((element instanceof HtmlAbbreviated || element instanceof HtmlAcronym || element instanceof HtmlAddress || element instanceof HtmlArticle || element instanceof HtmlAside || element instanceof HtmlBaseFont || element instanceof HtmlBidirectionalIsolation || element instanceof HtmlBidirectionalOverride || element instanceof HtmlBig || element instanceof HtmlBlink || element instanceof HtmlBold || element instanceof HtmlCenter || element instanceof HtmlCitation || element instanceof HtmlCode || element instanceof HtmlDefinition || element instanceof HtmlDefinitionDescription || element instanceof HtmlDefinitionTerm || element instanceof HtmlEmphasis || element instanceof HtmlFigure || element instanceof HtmlFigureCaption || element instanceof HtmlFooter || element instanceof HtmlHeader || element instanceof HtmlItalic || element instanceof HtmlKeyboard || element instanceof HtmlLayer || element instanceof HtmlMark || element instanceof HtmlNav || element instanceof HtmlNoBreak || element instanceof HtmlNoEmbed || element instanceof HtmlNoFrames || element instanceof HtmlNoLayer || element instanceof HtmlNoScript || element instanceof HtmlPlainText || element instanceof HtmlRuby || element instanceof HtmlRb || element instanceof HtmlRp || element instanceof HtmlRt || element instanceof HtmlRtc || element instanceof HtmlS || element instanceof HtmlSample || element instanceof HtmlSection || element instanceof HtmlSmall || element instanceof HtmlStrike || element instanceof HtmlStrong || element instanceof HtmlSubscript || element instanceof HtmlSummary || element instanceof HtmlSuperscript || element instanceof HtmlTeletype || element instanceof HtmlUnderlined || element instanceof HtmlUnknownElement || element instanceof HtmlWordBreak || element instanceof HtmlMain || element instanceof HtmlVariable || element instanceof HtmlDivision || element instanceof HtmlUnknownElement || element instanceof HtmlData || element instanceof HtmlTime || element instanceof HtmlOutput || element instanceof HtmlSlot || element instanceof HtmlLegend) && StringUtils.isBlank(element.getTextContent())) {
            defaultHeight = 0;
        } else if (element.getFirstChild() == null) {
            BrowserVersion browser;
            defaultHeight = element instanceof HtmlRadioButtonInput || element instanceof HtmlCheckBoxInput ? (webWindow.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTHEIGHT_RADIO_CHECKBOX_10) ? 10 : 13) : (element instanceof HtmlButton ? 20 : (element instanceof HtmlInput && !(element instanceof HtmlHiddenInput) ? ((browser = webWindow.getWebClient().getBrowserVersion()).hasFeature(BrowserVersionFeatures.JS_CLIENTHEIGHT_INPUT_17) ? 17 : (browser.hasFeature(BrowserVersionFeatures.JS_CLIENTHEIGHT_INPUT_18) ? 18 : 20)) : (element instanceof HtmlSelect ? 20 : (element instanceof HtmlTextArea ? 49 : (element instanceof HtmlInlineFrame ? 154 : 0)))));
        } else {
            String fontSize = this.getFontSize();
            defaultHeight = webWindow.getWebClient().getBrowserVersion().getFontHeight(fontSize);
            if (element instanceof HtmlDivision || element instanceof HtmlSpan) {
                String width = this.getStyleAttribute(StyleAttributes.Definition.WIDTH, false);
                DomNode parent = this.getDomElement().getParentNode();
                WebWindow win = parent.getPage().getEnclosingWindow();
                while (width.isEmpty() && parent != null) {
                    if (parent instanceof DomElement) {
                        ComputedCssStyleDeclaration computedCss = win.getComputedStyle((DomElement)parent, null);
                        width = computedCss.getStyleAttribute(StyleAttributes.Definition.WIDTH, false);
                    }
                    if (!((parent = parent.getParentNode()) instanceof Page)) continue;
                }
                int pixelWidth = CssPixelValueConverter.pixelValue(width);
                String content = element.getVisibleText();
                if (pixelWidth > 0 && !width.isEmpty() && StringUtils.isNotBlank(content)) {
                    int lineCount = Platform.getFontUtil().countLines(content, pixelWidth, fontSize);
                    defaultHeight *= lineCount;
                } else {
                    defaultHeight = element instanceof HtmlSpan && StringUtils.isEmpty(content) ? 0 : (defaultHeight *= StringUtils.countMatches((CharSequence)content, '\n') + 1);
                }
            }
        }
        int defaultWindowHeight = element instanceof HtmlCanvas ? 150 : windowHeight;
        int height = CssPixelValueConverter.pixelValue(element, new CssPixelValueConverter.CssValue(defaultHeight, defaultWindowHeight){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                DomElement elem = style.getDomElement();
                if (elem instanceof HtmlBody) {
                    return String.valueOf(elem.getPage().getEnclosingWindow().getInnerHeight());
                }
                if (isInline) {
                    return "";
                }
                return style.getStyleAttribute(StyleAttributes.Definition.HEIGHT, true);
            }
        });
        if (height == 0 && !explicitHeightSpecified) {
            height = defaultHeight;
        }
        return this.setCachedHeight2(height);
    }

    public int getContentHeight() {
        ComputedCssStyleDeclaration style;
        DomElement node = this.getDomElement();
        if (!node.mayBeDisplayed()) {
            return 0;
        }
        ComputedCssStyleDeclaration lastFlowing = null;
        HashSet<ComputedCssStyleDeclaration> styles = new HashSet<ComputedCssStyleDeclaration>();
        if (node instanceof HtmlTableRow) {
            HtmlTableRow row = (HtmlTableRow)node;
            for (HtmlTableCell cell : row.getCellIterator()) {
                if (!cell.mayBeDisplayed()) continue;
                style = cell.getPage().getEnclosingWindow().getComputedStyle(cell, null);
                styles.add(style);
            }
        } else {
            for (DomNode child : node.getChildren()) {
                if (!child.mayBeDisplayed() || !(child instanceof HtmlElement)) continue;
                HtmlElement e = (HtmlElement)child;
                style = e.getPage().getEnclosingWindow().getComputedStyle(e, null);
                String position = style.getPositionWithInheritance();
                if ("static".equals(position) || "relative".equals(position)) {
                    lastFlowing = style;
                    continue;
                }
                if (!"absolute".equals(position) && !"fixed".equals(position)) continue;
                styles.add(style);
            }
            if (lastFlowing != null) {
                styles.add(lastFlowing);
            }
        }
        int max = 0;
        for (ComputedCssStyleDeclaration style2 : styles) {
            int h = style2.getTop(true, false, false) + style2.getCalculatedHeight(true, true);
            if (h <= max) continue;
            max = h;
        }
        return max;
    }

    public boolean isScrollable(boolean horizontal) {
        return this.isScrollable(horizontal, false);
    }

    private boolean isScrollable(boolean horizontal, boolean ignoreSize) {
        DomElement element = this.getDomElement();
        String overflow = this.getStyleAttribute(StyleAttributes.Definition.OVERFLOW, true);
        boolean scrollable = horizontal ? !(!(element instanceof HtmlBody) && !"scroll".equals(overflow) && !"auto".equals(overflow) || !ignoreSize && this.getContentWidth() <= this.getCalculatedWidth()) : !(!(element instanceof HtmlBody) && !"scroll".equals(overflow) && !"auto".equals(overflow) || !ignoreSize && this.getContentHeight() <= this.getEmptyHeight());
        return scrollable;
    }

    private int getBorderHorizontal() {
        Integer borderHorizontal = this.getCachedBorderHorizontal();
        if (borderHorizontal != null) {
            return borderHorizontal;
        }
        int border = "none".equals(this.getDisplay()) ? 0 : this.getBorderLeftValue() + this.getBorderRightValue();
        return this.setCachedBorderHorizontal(border);
    }

    private int getBorderVertical() {
        Integer borderVertical = this.getCachedBorderVertical();
        if (borderVertical != null) {
            return borderVertical;
        }
        int border = "none".equals(this.getDisplay()) ? 0 : this.getBorderTopValue() + this.getBorderBottomValue();
        return this.setCachedBorderVertical(border);
    }

    public int getBorderLeftValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderLeftWidth());
    }

    public int getBorderRightValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderRightWidth());
    }

    public int getBorderTopValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderTopWidth());
    }

    public int getBorderBottomValue() {
        return CssPixelValueConverter.pixelValue(this.getBorderBottomWidth());
    }

    private int getPaddingHorizontal() {
        Integer paddingHorizontal = this.getCachedPaddingHorizontal();
        if (paddingHorizontal != null) {
            return paddingHorizontal;
        }
        int padding = "none".equals(this.getDisplay()) ? 0 : this.getPaddingLeftValue() + this.getPaddingRightValue();
        return this.setCachedPaddingHorizontal(padding);
    }

    private int getPaddingVertical() {
        Integer paddingVertical = this.getCachedPaddingVertical();
        if (paddingVertical != null) {
            return paddingVertical;
        }
        int padding = "none".equals(this.getDisplay()) ? 0 : this.getPaddingTopValue() + this.getPaddingBottomValue();
        return this.setCachedPaddingVertical(padding);
    }

    public int getPaddingLeftValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingLeft());
    }

    public int getPaddingRightValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingRight());
    }

    public int getPaddingTopValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingTop());
    }

    public int getPaddingBottomValue() {
        return CssPixelValueConverter.pixelValue(this.getPaddingBottom());
    }

    public Integer getCachedWidth() {
        return this.width_;
    }

    public int setCachedWidth(int width) {
        this.width_ = width;
        return width;
    }

    public Integer getCachedHeight() {
        return this.height_;
    }

    public int setCachedHeight(int height) {
        this.height_ = height;
        return height;
    }

    public Integer getCachedHeight2() {
        return this.height2_;
    }

    public int setCachedHeight2(int height) {
        this.height2_ = height;
        return height;
    }

    public Integer getCachedTop() {
        return this.top_;
    }

    public void setCachedTop(Integer top) {
        this.top_ = top;
    }

    public Integer getCachedPaddingHorizontal() {
        return this.paddingHorizontal_;
    }

    public int setCachedPaddingHorizontal(int paddingHorizontal) {
        this.paddingHorizontal_ = paddingHorizontal;
        return paddingHorizontal;
    }

    public Integer getCachedPaddingVertical() {
        return this.paddingVertical_;
    }

    public int setCachedPaddingVertical(int paddingVertical) {
        this.paddingVertical_ = paddingVertical;
        return paddingVertical;
    }

    public Integer getCachedBorderHorizontal() {
        return this.borderHorizontal_;
    }

    public int setCachedBorderHorizontal(int borderHorizontal) {
        this.borderHorizontal_ = borderHorizontal;
        return borderHorizontal;
    }

    public Integer getCachedBorderVertical() {
        return this.borderVertical_;
    }

    public int setCachedBorderVertical(int borderVertical) {
        this.borderVertical_ = borderVertical;
        return borderVertical;
    }

    public void applyStyleFromSelector(CSSStyleDeclarationImpl declaration, Selector selector) {
        SelectorSpecificity specificity = selector.getSelectorSpecificity();
        for (Property prop : declaration.getProperties()) {
            String name = prop.getName();
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (StyleElement)this.localModifications_.get(name)) != null) {
            if (existingElement.isImportant()) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        StyleElement element = new StyleElement(name, newValue, priority, specificity);
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        StyleElement element = new StyleElement(name, newValue, "", SelectorSpecificity.DEFAULT_STYLE_ATTRIBUTE);
        this.localModifications_.put(name, element);
    }

    @Override
    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.getDomElement().hasFeature(property);
    }

    @Override
    public BrowserVersion getBrowserVersion() {
        return this.getDomElement().getPage().getWebClient().getBrowserVersion();
    }

    @Override
    public boolean isComputed() {
        return true;
    }

    public String toString() {
        return "ComputedCssStyleDeclaration for '" + this.getDomElement() + "'";
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition) {
        return this.defaultIfEmpty(str, definition, false);
    }

    private String defaultIfEmpty(String str, StyleAttributes.Definition definition, boolean isPixel) {
        if (!this.getDomElement().isAttachedToPage()) {
            return EMPTY_FINAL;
        }
        if (str == null || str.isEmpty()) {
            return definition.getDefaultComputedValue(this.getBrowserVersion());
        }
        if (isPixel) {
            return ComputedCssStyleDeclaration.pixelString(str);
        }
        return str;
    }

    private String defaultIfEmpty(String str, String toReturnIfEmptyOrDefault, String defaultValue) {
        if (!this.getDomElement().isAttachedToPage()) {
            return EMPTY_FINAL;
        }
        if (str == null || str.isEmpty() || str.equals(defaultValue)) {
            return toReturnIfEmptyOrDefault;
        }
        return str;
    }

    private static String pixelString(String value) {
        if (EMPTY_FINAL == value || value.endsWith("px")) {
            return value;
        }
        return CssPixelValueConverter.pixelValue(value) + "px";
    }
}

