/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.html.HTMLDialogElement;

public class HtmlDialog
extends HtmlElement {
    public static final String TAG_NAME = "dialog";
    private boolean modal_;
    private String returnValue_ = "";

    HtmlDialog(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.NONE;
    }

    public boolean isOpen() {
        return this.hasAttribute("open");
    }

    public boolean isModal() {
        return this.modal_;
    }

    public void setOpen(boolean newValue) {
        if (newValue) {
            this.setAttribute("open", "");
        } else {
            this.removeAttribute("open");
            this.modal_ = false;
        }
    }

    public void show() {
        if (!this.isOpen()) {
            this.setOpen(true);
        }
    }

    public void showModal() {
        if (!this.isOpen()) {
            this.setOpen(true);
            this.modal_ = true;
        }
    }

    public void close(String returnValue) {
        if (this.isOpen()) {
            this.setReturnValue(returnValue);
            this.setOpen(false);
            SgmlPage page = this.getPage();
            WebClient client = page.getWebClient();
            if (client.isJavaScriptEnabled()) {
                final HTMLDialogElement dialogElement = (HTMLDialogElement)this.getScriptableObject();
                final Event event = new Event(dialogElement, "close");
                final AbstractJavaScriptEngine<?> jsEngine = client.getJavaScriptEngine();
                PostponedAction action = new PostponedAction(page, "Dialog.CloseEvent"){

                    @Override
                    public void execute() {
                        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                        cf.call(cx -> dialogElement.dispatchEvent(event));
                    }
                };
                jsEngine.addPostponedAction(action);
            }
        }
        this.modal_ = false;
    }

    public String getReturnValue() {
        return this.returnValue_;
    }

    public void setReturnValue(String newValue) {
        if (newValue == null) {
            this.returnValue_ = "";
            return;
        }
        this.returnValue_ = newValue;
    }
}

