/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlTableRow;

public abstract class HtmlTableCell
extends HtmlElement {
    protected HtmlTableCell(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public int getColumnSpan() {
        String spanString = StringUtils.replaceChars(this.getAttributeDirect("colspan"), "\r\n\t ", null);
        if (spanString == null || spanString.isEmpty()) {
            return 1;
        }
        try {
            int span = (int)Double.parseDouble(spanString);
            if (span < 1) {
                return 1;
            }
            if (span > 1000) {
                return 1000;
            }
            return span;
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getRowSpan() {
        String spanString = StringUtils.replaceChars(this.getAttributeDirect("rowspan"), "\r\n\t ", null);
        if (spanString == null || spanString.isEmpty()) {
            return 1;
        }
        try {
            int span = (int)Double.parseDouble(spanString);
            if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_SET_ZERO_IF_INVALID)) {
                if (span < 0) {
                    return 1;
                }
                if (span < 1) {
                    return 0;
                }
            } else if (span < 1) {
                return 1;
            }
            if (span > 65534) {
                return 65534;
            }
            return span;
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public HtmlTableRow getEnclosingRow() {
        return (HtmlTableRow)this.getEnclosingElement("tr");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.TABLE_CELL;
    }
}

