/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import java.lang.reflect.Member;
import java.util.LinkedHashSet;
import java.util.List;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import org.htmlunit.javascript.configuration.ClassConfiguration;

public class RecursiveFunctionObject
extends FunctionObject {
    private final BrowserVersion browserVersion_;

    public RecursiveFunctionObject(String name, Member methodOrConstructor, Scriptable scope, BrowserVersion browserVersion) {
        super(name, methodOrConstructor, scope);
        this.browserVersion_ = browserVersion;
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        for (Class<?> c = this.getMethodOrConstructor().getDeclaringClass().getSuperclass(); c != null; c = c.getSuperclass()) {
            Object scripatble = this.getParentScope().get(c.getSimpleName(), (Scriptable)this);
            if (!(scripatble instanceof Scriptable) || !((Scriptable)scripatble).has(name, start)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getIds() {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        for (Object obj : super.getIds()) {
            objects.add(obj);
        }
        for (Class<?> c = this.getMethodOrConstructor().getDeclaringClass().getSuperclass(); c != null; c = c.getSuperclass()) {
            Object scripatble = this.getParentScope().get(c.getSimpleName(), (Scriptable)this);
            if (!(scripatble instanceof Scriptable)) continue;
            for (Object obj : ((Scriptable)scripatble).getIds()) {
                objects.add(obj);
            }
        }
        return objects.toArray(new Object[0]);
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object value = super.get(name, start);
        if (value != NOT_FOUND) {
            return value;
        }
        Class<?> klass = this.getPrototypeProperty().getClass();
        while (value == NOT_FOUND && HtmlUnitScriptable.class.isAssignableFrom(klass)) {
            List<ClassConfiguration.ConstantInfo> constants;
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(klass.asSubclass(HtmlUnitScriptable.class), this.browserVersion_);
            if (config != null && (constants = config.getConstants()) != null) {
                for (ClassConfiguration.ConstantInfo constantInfo : constants) {
                    if (!constantInfo.getName().equals(name)) continue;
                    value = ScriptableObject.getProperty((Scriptable)this.getPrototypeProperty(), name);
                    break;
                }
            }
            klass = klass.getSuperclass();
        }
        return value;
    }

    @Override
    public Scriptable getClassPrototype() {
        return super.getClassPrototype();
    }
}

