/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.io.IOException;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.parser.HTMLParser;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.dom.DocumentType;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.javascript.host.xml.XMLDocument;
import org.htmlunit.util.UrlUtils;
import org.htmlunit.xml.XmlPage;

@JsxClass
public class DOMImplementation
extends HtmlUnitScriptable {
    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction
    public boolean hasFeature(String feature, String version) {
        switch (feature) {
            case "Core": 
            case "HTML": 
            case "XHTML": 
            case "XML": {
                switch (version) {
                    case "1.0": 
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "Views": {
                switch (version) {
                    case "1.0": {
                        return true;
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "StyleSheets": {
                return true;
            }
            case "CSS": {
                switch (version) {
                    case "1.0": {
                        return true;
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "CSS2": {
                switch (version) {
                    case "1.0": {
                        return true;
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "CSS3": {
                switch (version) {
                    case "1.0": {
                        return true;
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "Events": 
            case "HTMLEvents": 
            case "MouseEvents": 
            case "MutationEvents": {
                switch (version) {
                    case "1.0": {
                        return true;
                    }
                    case "2.0": 
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "UIEvents": {
                switch (version) {
                    case "1.0": 
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "KeyboardEvents": {
                return true;
            }
            case "MutationNameEvents": {
                return true;
            }
            case "TextEvents": {
                return true;
            }
            case "LS": 
            case "LS-Async": {
                return true;
            }
            case "Range": 
            case "Traversal": {
                switch (version) {
                    case "1.0": {
                        return true;
                    }
                    case "2.0": {
                        return true;
                    }
                    case "3.0": {
                        return true;
                    }
                }
                break;
            }
            case "Validation": {
                return true;
            }
            case "XPath": {
                return true;
            }
            case "http://www.w3.org/TR/SVG11/feature#BasicStructure": 
            case "http://www.w3.org/TR/SVG11/feature#Shape": {
                switch (version) {
                    case "1.0": 
                    case "1.1": {
                        return true;
                    }
                    case "1.2": {
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    @JsxFunction
    public XMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) {
        XMLDocument document = new XMLDocument(this.getWindow().getWebWindow());
        document.setParentScope(this.getParentScope());
        document.setPrototype(this.getPrototype(document.getClass()));
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            XmlPage page = (XmlPage)document.getDomNodeOrDie();
            page.appendChild(page.createElementNS("".equals(namespaceURI) ? null : namespaceURI, qualifiedName));
        }
        return document;
    }

    @JsxFunction
    public HTMLDocument createHTMLDocument(Object titleObj) {
        try {
            WebWindow webWindow = this.getWindow().getWebWindow();
            String html = JavaScriptEngine.isUndefined(titleObj) ? "<html><head></head><body></body></html>" : "<html><head><title>" + JavaScriptEngine.toString(titleObj) + "</title></head><body></body></html>";
            StringWebResponse webResponse = new StringWebResponse(html, UrlUtils.URL_ABOUT_BLANK);
            HtmlPage page = new HtmlPage(webResponse, webWindow);
            page.setEnclosingWindow(null);
            HTMLDocument document = new HTMLDocument();
            document.setParentScope(this.getWindow());
            document.setPrototype(this.getPrototype(document.getClass()));
            document.setDomNode(page);
            HTMLParser htmlParser = webWindow.getWebClient().getPageCreator().getHtmlParser();
            htmlParser.parse(webResponse, page, false, false);
            return (HTMLDocument)page.getScriptableObject();
        }
        catch (IOException e) {
            throw JavaScriptEngine.reportRuntimeError("Parsing failed" + e.getMessage());
        }
    }
}

