/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlTableCell;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.htmlunit.javascript.host.html.HTMLTableComponent;

@JsxClass(domClass=HtmlTableCell.class)
public class HTMLTableCellElement
extends HTMLTableComponent {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    public int getOffsetHeight() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return super.getOffsetHeight();
        }
        if (this.isDisplayNone()) {
            return 0;
        }
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        return style.getCalculatedHeight(false, true);
    }

    @Override
    public int getOffsetWidth() {
        HtmlTableRow row;
        float w = super.getOffsetWidth();
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return (int)w;
        }
        if (this.isDisplayNone()) {
            return 0;
        }
        ComputedCssStyleDeclaration style = this.getWindow().getWebWindow().getComputedStyle(this.getDomNodeOrDie(), null);
        if ("collapse".equals(style.getStyleAttribute(StyleAttributes.Definition.BORDER_COLLAPSE, true)) && (row = this.getRow()) != null) {
            w = (float)((double)w - 0.5 * (double)style.getBorderLeftValue());
            w = (float)((double)w - 0.5 * (double)style.getBorderRightValue());
        }
        return (int)w;
    }

    @JsxGetter
    public int getCellIndex() {
        HtmlTableCell cell = (HtmlTableCell)this.getDomNodeOrDie();
        HtmlTableRow row = cell.getEnclosingRow();
        if (row == null) {
            return -1;
        }
        return row.getCells().indexOf(cell);
    }

    @JsxGetter
    public String getAbbr() {
        return this.getDomNodeOrDie().getAttributeDirect("abbr");
    }

    @JsxSetter
    public void setAbbr(String abbr) {
        this.getDomNodeOrDie().setAttribute("abbr", abbr);
    }

    @JsxGetter
    public String getAxis() {
        return this.getDomNodeOrDie().getAttributeDirect("axis");
    }

    @JsxSetter
    public void setAxis(String axis) {
        this.getDomNodeOrDie().setAttribute("axis", axis);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter
    public int getColSpan() {
        return ((HtmlTableCell)this.getDomNodeOrDie()).getColumnSpan();
    }

    @JsxSetter
    public void setColSpan(String colSpan) {
        try {
            int i = (int)Double.parseDouble(colSpan);
            if (i <= 0) {
                throw new NumberFormatException(colSpan);
            }
            this.getDomNodeOrDie().setAttribute("colSpan", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            this.getDomNodeOrDie().setAttribute("colSpan", "1");
        }
    }

    @JsxGetter
    public int getRowSpan() {
        return ((HtmlTableCell)this.getDomNodeOrDie()).getRowSpan();
    }

    @JsxSetter
    public void setRowSpan(String rowSpan) {
        try {
            int i = (int)Double.parseDouble(rowSpan);
            if (i < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_SET_ZERO_IF_INVALID)) {
                this.getDomNodeOrDie().setAttribute("rowSpan", "1");
                return;
            }
            if (i <= 0) {
                throw new NumberFormatException(rowSpan);
            }
            this.getDomNodeOrDie().setAttribute("rowSpan", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_SET_ZERO_IF_INVALID)) {
                this.getDomNodeOrDie().setAttribute("rowSpan", "0");
            }
            this.getDomNodeOrDie().setAttribute("rowSpan", "1");
        }
    }

    @JsxGetter
    public boolean isNoWrap() {
        return this.getDomNodeOrDie().hasAttribute("noWrap");
    }

    @JsxSetter
    public void setNoWrap(boolean noWrap) {
        if (noWrap) {
            this.getDomNodeOrDie().setAttribute("noWrap", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("noWrap");
        }
    }

    private HtmlTableRow getRow() {
        DomNode node;
        for (node = this.getDomNodeOrDie(); node != null && !(node instanceof HtmlTableRow); node = node.getParentNode()) {
        }
        return (HtmlTableRow)node;
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", null);
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        this.setWidthOrHeight("width", width, true);
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        return this.getWidthOrHeight("height", null);
    }

    @JsxSetter(propertyName="height")
    public void setHeight_js(String height) {
        this.setWidthOrHeight("height", height, true);
    }

    @Override
    public void setOuterHTML(Object value) {
        throw JavaScriptEngine.reportRuntimeError("outerHTML is read-only for tag '" + this.getDomNodeOrDie().getTagName() + "'");
    }

    @JsxGetter
    public String getHeaders() {
        return this.getDomNodeOrDie().getAttributeDirect("headers");
    }

    @JsxSetter
    public void setHeaders(String headers) {
        this.getDomNodeOrDie().setAttribute("headers", headers);
    }

    @JsxGetter
    public String getScope() {
        return this.getDomNodeOrDie().getAttributeDirect("scope");
    }

    @JsxSetter
    public void setScope(String scope) {
        this.getDomNodeOrDie().setAttribute("scope", scope);
    }
}

