/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.xml;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.AjaxController;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.FormEncodingType;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.json.JsonParser;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.httpclient.HtmlUnitUsernamePasswordCredentials;
import org.htmlunit.httpclient.HttpClientConverter;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.htmlunit.javascript.background.JavaScriptJob;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.URLSearchParams;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.dom.DOMParser;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.ProgressEvent;
import org.htmlunit.javascript.host.file.Blob;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.javascript.host.xml.FormData;
import org.htmlunit.javascript.host.xml.XMLDocument;
import org.htmlunit.javascript.host.xml.XMLHttpRequestEventTarget;
import org.htmlunit.javascript.host.xml.XMLHttpRequestUpload;
import org.htmlunit.javascript.host.xml.XMLSerializer;
import org.htmlunit.util.EncodingSniffer;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.WebResponseWrapper;
import org.htmlunit.xml.XmlPage;

@JsxClass
public class XMLHttpRequest
extends XMLHttpRequestEventTarget {
    private static final Log LOG = LogFactory.getLog(XMLHttpRequest.class);
    @JsxConstant
    public static final int UNSENT = 0;
    @JsxConstant
    public static final int OPENED = 1;
    @JsxConstant
    public static final int HEADERS_RECEIVED = 2;
    @JsxConstant
    public static final int LOADING = 3;
    @JsxConstant
    public static final int DONE = 4;
    private static final String RESPONSE_TYPE_DEFAULT = "";
    private static final String RESPONSE_TYPE_ARRAYBUFFER = "arraybuffer";
    private static final String RESPONSE_TYPE_BLOB = "blob";
    private static final String RESPONSE_TYPE_DOCUMENT = "document";
    private static final String RESPONSE_TYPE_JSON = "json";
    private static final String RESPONSE_TYPE_TEXT = "text";
    private static final String ALLOW_ORIGIN_ALL = "*";
    private static final String[] ALL_PROPERTIES_ = new String[]{"onreadystatechange", "readyState", "responseText", "responseXML", "status", "statusText", "abort", "getAllResponseHeaders", "getResponseHeader", "open", "send", "setRequestHeader"};
    private static final HashSet<String> PROHIBITED_HEADERS_ = new HashSet<String>(Arrays.asList("accept-charset", "accept-encoding", "connection", "content-length", "cookie", "cookie2", "content-transfer-encoding", "date", "expect", "host", "keep-alive", "referer", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "via"));
    private int state_;
    private WebRequest webRequest_;
    private boolean async_;
    private int jobID_;
    private WebResponse webResponse_;
    private String overriddenMimeType_;
    private final boolean caseSensitiveProperties_;
    private boolean withCredentials_;
    private boolean isSameOrigin_;
    private int timeout_;
    private boolean aborted_;
    private String responseType_;

    public XMLHttpRequest() {
        this(true);
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
    }

    public XMLHttpRequest(boolean caseSensitiveProperties) {
        this.caseSensitiveProperties_ = caseSensitiveProperties;
        this.state_ = 0;
        this.responseType_ = RESPONSE_TYPE_DEFAULT;
    }

    private void setState(int state) {
        if (state == 0 || state == 1 || state == 2 || state == 3 || state == 4) {
            this.state_ = state;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("State changed to : " + state));
            }
            return;
        }
        LOG.error((Object)("Received an unknown state " + state + ", the state is not implemented, please check setState() implementation."));
    }

    private void fireJavascriptEvent(String eventName) {
        if (this.aborted_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Firing javascript XHR event: " + eventName + " for an already aborted request - ignored."));
            }
            return;
        }
        this.fireJavascriptEventIgnoreAbort(eventName);
    }

    private void fireJavascriptEventIgnoreAbort(String eventName) {
        Event event;
        boolean isReadyStateChange;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Firing javascript XHR event: " + eventName));
        }
        if (isReadyStateChange = "readystatechange".equalsIgnoreCase(eventName)) {
            event = new Event(this, "readystatechange");
        } else {
            ProgressEvent progressEvent = new ProgressEvent(this, eventName);
            if (this.webResponse_ != null) {
                long contentLength = this.webResponse_.getContentLength();
                progressEvent.setLoaded(contentLength);
            }
            event = progressEvent;
        }
        this.executeEventLocally(event);
    }

    @JsxGetter
    public int getReadyState() {
        return this.state_;
    }

    @JsxGetter
    public String getResponseType() {
        return this.responseType_;
    }

    @JsxSetter
    public void setResponseType(String responseType) {
        if (this.state_ == 3 || this.state_ == 4) {
            throw JavaScriptEngine.reportRuntimeError("InvalidStateError");
        }
        if (RESPONSE_TYPE_DEFAULT.equals(responseType) || RESPONSE_TYPE_ARRAYBUFFER.equals(responseType) || RESPONSE_TYPE_BLOB.equals(responseType) || RESPONSE_TYPE_DOCUMENT.equals(responseType) || RESPONSE_TYPE_JSON.equals(responseType) || RESPONSE_TYPE_TEXT.equals(responseType)) {
            if (this.state_ == 1 && !this.async_) {
                throw JavaScriptEngine.reportRuntimeError("InvalidAccessError: synchronous XMLHttpRequests do not support responseType");
            }
            this.responseType_ = responseType;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsxGetter
    public Object getResponse() {
        if (RESPONSE_TYPE_DEFAULT.equals(this.responseType_)) return this.getResponseText();
        if (RESPONSE_TYPE_TEXT.equals(this.responseType_)) {
            return this.getResponseText();
        }
        if (this.state_ != 4) {
            return null;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            if (!LOG.isDebugEnabled()) return null;
            LOG.debug((Object)("XMLHttpRequest.responseXML returns of a network error (" + ((NetworkErrorWebResponse)this.webResponse_).getError() + ")"));
            return null;
        }
        if (RESPONSE_TYPE_ARRAYBUFFER.equals(this.responseType_)) {
            long contentLength = this.webResponse_.getContentLength();
            NativeArrayBuffer nativeArrayBuffer = new NativeArrayBuffer(contentLength);
            try {
                int bufferLength = Math.min(1024, (int)contentLength);
                byte[] buffer = new byte[bufferLength];
                int offset = 0;
                try (InputStream inputStream2 = this.webResponse_.getContentAsStream();){
                    int readLen;
                    while ((readLen = inputStream2.read(buffer, 0, bufferLength)) != -1) {
                        long newLength = offset + readLen;
                        if (newLength > contentLength) {
                            NativeArrayBuffer expanded = new NativeArrayBuffer(newLength);
                            System.arraycopy(nativeArrayBuffer.getBuffer(), 0, expanded.getBuffer(), 0, (int)contentLength);
                            contentLength = newLength;
                            nativeArrayBuffer = expanded;
                        }
                        System.arraycopy(buffer, 0, nativeArrayBuffer.getBuffer(), offset, readLen);
                        offset = (int)newLength;
                    }
                }
                if ((long)offset < contentLength) {
                    NativeArrayBuffer shrinked = new NativeArrayBuffer(offset);
                    System.arraycopy(nativeArrayBuffer.getBuffer(), 0, shrinked.getBuffer(), 0, offset);
                    nativeArrayBuffer = shrinked;
                }
                nativeArrayBuffer.setParentScope(this.getParentScope());
                nativeArrayBuffer.setPrototype(ScriptableObject.getClassPrototype(this.getWindow(), nativeArrayBuffer.getClassName()));
                return nativeArrayBuffer;
            }
            catch (IOException e) {
                this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
                return null;
            }
        }
        if (RESPONSE_TYPE_BLOB.equals(this.responseType_)) {
            try {
                if (this.webResponse_ == null) return RESPONSE_TYPE_DEFAULT;
                try (InputStream inputStream = this.webResponse_.getContentAsStream();){
                    Blob blob2 = new Blob(IOUtils.toByteArray((InputStream)inputStream), this.webResponse_.getContentType());
                    blob2.setParentScope(this.getParentScope());
                    blob2.setPrototype(ScriptableObject.getClassPrototype(this.getWindow(), blob2.getClassName()));
                    Blob blob = blob2;
                    return blob;
                }
            }
            catch (IOException e) {
                this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
                return null;
            }
        }
        if (RESPONSE_TYPE_DOCUMENT.equals(this.responseType_)) {
            if (this.webResponse_ == null) return RESPONSE_TYPE_DEFAULT;
            try {
                Charset encoding = this.webResponse_.getContentCharset();
                if (encoding == null) {
                    return RESPONSE_TYPE_DEFAULT;
                }
                String content = this.webResponse_.getContentAsString(encoding);
                if (content != null) return DOMParser.parseFromString(this, content, this.webResponse_.getContentType());
                return RESPONSE_TYPE_DEFAULT;
            }
            catch (IOException e) {
                this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
                return null;
            }
        }
        if (!RESPONSE_TYPE_JSON.equals(this.responseType_)) return RESPONSE_TYPE_DEFAULT;
        if (this.webResponse_ == null) return RESPONSE_TYPE_DEFAULT;
        Charset encoding = this.webResponse_.getContentCharset();
        if (encoding == null) {
            return null;
        }
        String content = this.webResponse_.getContentAsString(encoding);
        if (content == null) {
            return null;
        }
        try {
            return new JsonParser(Context.getCurrentContext(), this).parseValue(content);
        }
        catch (JsonParser.ParseException e) {
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, new IOException(e));
            return null;
        }
    }

    @JsxGetter
    public String getResponseText() {
        if ((this.state_ == 0 || this.state_ == 1) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_RESPONSE_TEXT_EMPTY_UNSENT)) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (!RESPONSE_TYPE_DEFAULT.equals(this.responseType_) && !RESPONSE_TYPE_TEXT.equals(this.responseType_)) {
            throw JavaScriptEngine.reportRuntimeError("InvalidStateError: Failed to read the 'responseText' property from 'XMLHttpRequest': The value is only accessible if the object's 'responseType' is '' or 'text' (was '" + this.getResponseType() + "').");
        }
        if (this.state_ == 0 || this.state_ == 1) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            NetworkErrorWebResponse resp;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XMLHttpRequest.responseXML returns of a network error (" + ((NetworkErrorWebResponse)this.webResponse_).getError() + ")"));
            }
            if ((resp = (NetworkErrorWebResponse)this.webResponse_).getError() != null && resp.getError() instanceof NoPermittedHeaderException) {
                return RESPONSE_TYPE_DEFAULT;
            }
            return null;
        }
        if (this.webResponse_ != null) {
            Charset encoding = this.webResponse_.getContentCharset();
            if (encoding == null) {
                return RESPONSE_TYPE_DEFAULT;
            }
            String content = this.webResponse_.getContentAsString(encoding);
            if (content == null) {
                return RESPONSE_TYPE_DEFAULT;
            }
            return content;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"XMLHttpRequest.responseText was retrieved before the response was available.");
        }
        return RESPONSE_TYPE_DEFAULT;
    }

    @JsxGetter
    public Object getResponseXML() {
        if (this.webResponse_ == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"XMLHttpRequest.responseXML returns null because there in no web resonse so far (has send() been called?)");
            }
            return null;
        }
        if (this.webResponse_ instanceof NetworkErrorWebResponse) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XMLHttpRequest.responseXML returns of a network error (" + ((NetworkErrorWebResponse)this.webResponse_).getError() + ")"));
            }
            return null;
        }
        String contentType = this.webResponse_.getContentType();
        if (contentType.isEmpty() || contentType.contains("xml")) {
            Window w = this.getWindow();
            try {
                XmlPage page = new XmlPage(this.webResponse_, w.getWebWindow());
                XMLDocument document = new XMLDocument();
                document.setPrototype(this.getPrototype(document.getClass()));
                document.setParentScope(w);
                document.setDomNode(page);
                return document;
            }
            catch (IOException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Failed parsing XML document " + this.webResponse_.getWebRequest().getUrl() + ": " + e.getMessage()));
                }
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("XMLHttpRequest.responseXML was called but the response is " + this.webResponse_.getContentType()));
        }
        return null;
    }

    @JsxGetter
    public int getStatus() {
        if (this.state_ == 0 || this.state_ == 1) {
            return 0;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusCode();
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.status was retrieved without a response available (readyState: " + this.state_ + ")."));
        }
        return 0;
    }

    @JsxGetter
    public String getStatusText() {
        if (this.state_ == 0 || this.state_ == 1) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusMessage();
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.statusText was retrieved without a response available (readyState: " + this.state_ + ")."));
        }
        return null;
    }

    @JsxFunction
    public void abort() {
        this.getWindow().getWebWindow().getJobManager().stopJob(this.jobID_);
        if (this.state_ == 1 || this.state_ == 2 || this.state_ == 3) {
            this.setState(4);
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, null);
            this.fireJavascriptEvent("readystatechange");
            this.fireJavascriptEvent("abort");
            this.fireJavascriptEvent("loadend");
        }
        this.setState(0);
        this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, null);
        this.aborted_ = true;
    }

    @JsxFunction
    public String getAllResponseHeaders() {
        if (this.state_ == 0 || this.state_ == 1) {
            return RESPONSE_TYPE_DEFAULT;
        }
        if (this.webResponse_ != null) {
            StringBuilder builder = new StringBuilder();
            for (NameValuePair header : this.webResponse_.getResponseHeaders()) {
                builder.append(header.getName()).append(": ").append(header.getValue());
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.XHR_ALL_RESPONSE_HEADERS_SEPARATE_BY_LF)) {
                    builder.append('\r');
                }
                builder.append('\n');
            }
            return builder.toString();
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.getAllResponseHeaders() was called without a response available (readyState: " + this.state_ + ")."));
        }
        return null;
    }

    @JsxFunction
    public String getResponseHeader(String headerName) {
        if (this.state_ == 0 || this.state_ == 1) {
            return null;
        }
        if (this.webResponse_ != null) {
            return this.webResponse_.getResponseHeaderValue(headerName);
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("XMLHttpRequest.getAllResponseHeaders(..) was called without a response available (readyState: " + this.state_ + ")."));
        }
        return null;
    }

    @JsxFunction
    public void open(String method, Object urlParam, Object asyncParam, Object user, Object password) {
        boolean async = true;
        if (!JavaScriptEngine.isUndefined(asyncParam)) {
            async = JavaScriptEngine.toBoolean(asyncParam);
        }
        String url = JavaScriptEngine.toString(urlParam);
        HtmlPage containingPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        try {
            boolean alwaysAddOrigin;
            URL fullUrl = containingPage.getFullyQualifiedUrl(url);
            WebRequest request = new WebRequest(fullUrl, this.getBrowserVersion().getXmlHttpRequestAcceptHeader(), this.getBrowserVersion().getAcceptEncodingHeader());
            request.setCharset(StandardCharsets.UTF_8);
            request.setDefaultResponseContentCharset(StandardCharsets.UTF_8);
            request.setRefererlHeader(containingPage.getUrl());
            try {
                request.setHttpMethod(HttpMethod.valueOf(method.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Incorrect HTTP Method '" + method + "'"));
                }
                return;
            }
            URL pageRequestUrl = containingPage.getUrl();
            this.isSameOrigin_ = XMLHttpRequest.isSameOrigin(pageRequestUrl, fullUrl);
            boolean bl = alwaysAddOrigin = HttpMethod.GET != request.getHttpMethod() && HttpMethod.PATCH != request.getHttpMethod() && HttpMethod.HEAD != request.getHttpMethod();
            if (alwaysAddOrigin || !this.isSameOrigin_) {
                StringBuilder origin = new StringBuilder().append(pageRequestUrl.getProtocol()).append("://").append(pageRequestUrl.getHost());
                if (pageRequestUrl.getPort() != -1) {
                    origin.append(':').append(pageRequestUrl.getPort());
                }
                request.setAdditionalHeader("Origin", origin.toString());
            }
            if (user != null && !JavaScriptEngine.isUndefined(user)) {
                String userCred = user.toString();
                String passwordCred = RESPONSE_TYPE_DEFAULT;
                if (password != null && !JavaScriptEngine.isUndefined(password)) {
                    passwordCred = password.toString();
                }
                request.setCredentials(new HtmlUnitUsernamePasswordCredentials(userCred, passwordCred));
            }
            this.webRequest_ = request;
        }
        catch (MalformedURLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Unable to initialize XMLHttpRequest using malformed URL '" + url + "'."));
            }
            return;
        }
        this.async_ = async;
        this.setState(1);
        this.fireJavascriptEvent("readystatechange");
    }

    private static boolean isSameOrigin(URL originUrl, URL newUrl) {
        int newPort;
        if (!originUrl.getHost().equals(newUrl.getHost())) {
            return false;
        }
        int originPort = originUrl.getPort();
        if (originPort == -1) {
            originPort = originUrl.getDefaultPort();
        }
        if ((newPort = newUrl.getPort()) == -1) {
            newPort = newUrl.getDefaultPort();
        }
        return originPort == newPort;
    }

    @JsxFunction
    public void send(Object content) {
        HtmlPage page;
        Window w;
        WebWindow ww;
        WebClient client;
        AjaxController ajaxController;
        boolean synchron;
        if (this.webRequest_ == null) {
            return;
        }
        if (!this.async_ && this.timeout_ > 0) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(new RuntimeException("Synchronous requests must not set a timeout."));
        }
        this.prepareRequestContent(content);
        if (this.timeout_ > 0) {
            this.webRequest_.setTimeout(this.timeout_);
        }
        if (synchron = (ajaxController = (client = (ww = (w = this.getWindow()).getWebWindow()).getWebClient()).getAjaxController()).processSynchron(page = (HtmlPage)ww.getEnclosedPage(), this.webRequest_, this.async_)) {
            this.doSend();
        } else {
            HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
            ContextAction<Object> action = new ContextAction<Object>(){

                @Override
                public Object run(Context cx) {
                    ArrayDeque<Window> stack = (ArrayDeque<Window>)cx.getThreadLocal("startingScope");
                    if (null == stack) {
                        stack = new ArrayDeque<Window>();
                        cx.putThreadLocal("startingScope", stack);
                    }
                    stack.push(w);
                    try {
                        XMLHttpRequest.this.doSend();
                    }
                    finally {
                        stack.pop();
                    }
                    return null;
                }

                public String toString() {
                    return "XMLHttpRequest " + (Object)((Object)XMLHttpRequest.this.webRequest_.getHttpMethod()) + " '" + XMLHttpRequest.this.webRequest_.getUrl() + "'";
                }
            };
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavascriptXMLHttpRequestJob(cf, action);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Starting XMLHttpRequest thread for asynchronous request");
            }
            this.jobID_ = ww.getJobManager().addJob(job, page);
            this.fireJavascriptEvent("loadstart");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareRequestContent(Object content) {
        boolean setEncodingType;
        if (content == null || HttpMethod.POST != this.webRequest_.getHttpMethod() && HttpMethod.PUT != this.webRequest_.getHttpMethod() && HttpMethod.PATCH != this.webRequest_.getHttpMethod() || JavaScriptEngine.isUndefined(content)) return;
        boolean bl = setEncodingType = this.webRequest_.getAdditionalHeader("Content-Type") == null;
        if (content instanceof HTMLDocument) {
            String body = new XMLSerializer().serializeToString((HTMLDocument)content);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting request body to: " + body));
            }
            this.webRequest_.setRequestBody(body);
            if (!setEncodingType) return;
            this.webRequest_.setAdditionalHeader("Content-Type", "text/html;charset=UTF-8");
            return;
        } else if (content instanceof XMLDocument) {
            try (StringWriter writer = new StringWriter();){
                XMLDocument xmlDocument = (XMLDocument)content;
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "no");
                transformer.transform(new DOMSource(xmlDocument.getDomNodeOrDie().getFirstChild()), new StreamResult(writer));
                String body = writer.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting request body to: " + body));
                }
                this.webRequest_.setRequestBody(body);
                if (!setEncodingType) return;
                this.webRequest_.setAdditionalHeader("Content-Type", "application/xml;charset=UTF-8");
                return;
            }
            catch (Exception e) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
            }
        } else if (content instanceof FormData) {
            ((FormData)content).fillRequest(this.webRequest_);
            return;
        } else if (content instanceof NativeArrayBufferView) {
            NativeArrayBufferView view = (NativeArrayBufferView)content;
            this.webRequest_.setRequestBody(new String(view.getBuffer().getBuffer(), StandardCharsets.UTF_8));
            if (!setEncodingType) return;
            this.webRequest_.setEncodingType(null);
            return;
        } else if (content instanceof URLSearchParams) {
            ((URLSearchParams)content).fillRequest(this.webRequest_);
            this.webRequest_.addHint(WebRequest.HttpHint.IncludeCharsetInContentTypeHeader);
            return;
        } else if (content instanceof Blob) {
            ((Blob)content).fillRequest(this.webRequest_);
            return;
        } else {
            String body = JavaScriptEngine.toString(content);
            if (body.isEmpty()) return;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting request body to: " + body));
            }
            this.webRequest_.setRequestBody(body);
            this.webRequest_.setCharset(StandardCharsets.UTF_8);
            if (!setEncodingType) return;
            this.webRequest_.setEncodingType(FormEncodingType.TEXT_PLAIN);
        }
    }

    void doSend() {
        BrowserVersion browserVersion = this.getBrowserVersion();
        WebClient wc = this.getWindow().getWebWindow().getWebClient();
        boolean preflighted = false;
        try {
            if (!this.isSameOrigin_ && this.isPreflight()) {
                WebResponse preflightResponse;
                preflighted = true;
                WebRequest preflightRequest = new WebRequest(this.webRequest_.getUrl(), HttpMethod.OPTIONS);
                preflightRequest.addHint(WebRequest.HttpHint.BlockCookies);
                String originHeaderValue = this.webRequest_.getAdditionalHeaders().get("Origin");
                preflightRequest.setAdditionalHeader("Origin", originHeaderValue);
                preflightRequest.setAdditionalHeader("Access-Control-Request-Method", this.webRequest_.getHttpMethod().name());
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, String> header : new TreeMap<String, String>(this.webRequest_.getAdditionalHeaders()).entrySet()) {
                    String name = org.htmlunit.util.StringUtils.toRootLowerCase(header.getKey());
                    if (!XMLHttpRequest.isPreflightHeader(name, header.getValue())) continue;
                    if (builder.length() != 0) {
                        builder.append(',');
                    }
                    builder.append(name);
                }
                preflightRequest.setAdditionalHeader("Access-Control-Request-Headers", builder.toString());
                if (this.timeout_ > 0) {
                    preflightRequest.setTimeout(this.timeout_);
                }
                if (!(preflightResponse = wc.loadWebResponse(preflightRequest)).isSuccessOrUseProxyOrNotModified() || !this.isPreflightAuthorized(preflightResponse)) {
                    this.setState(4);
                    if (this.async_ || browserVersion.hasFeature(BrowserVersionFeatures.XHR_HANDLE_SYNC_NETWORK_ERRORS)) {
                        this.fireJavascriptEvent("readystatechange");
                        this.fireJavascriptEvent("error");
                        this.fireJavascriptEvent("loadend");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No permitted request for URL " + this.webRequest_.getUrl()));
                    }
                    throw JavaScriptEngine.throwAsScriptRuntimeEx(new RuntimeException("No permitted \"Access-Control-Allow-Origin\" header."));
                }
            }
            if (!this.isSameOrigin_ && !this.isWithCredentials()) {
                this.webRequest_.addHint(WebRequest.HttpHint.BlockCookies);
            }
            this.webResponse_ = wc.loadWebResponse(this.webRequest_);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Web response loaded successfully.");
            }
            boolean allowOriginResponse = true;
            if (!this.isSameOrigin_) {
                String value = this.webResponse_.getResponseHeaderValue("Access-Control-Allow-Origin");
                allowOriginResponse = this.webRequest_.getAdditionalHeaders().get("Origin").equals(value);
                if (this.isWithCredentials()) {
                    value = this.webResponse_.getResponseHeaderValue("Access-Control-Allow-Credentials");
                    allowOriginResponse = allowOriginResponse && Boolean.parseBoolean(value);
                } else {
                    boolean bl = allowOriginResponse = allowOriginResponse || ALLOW_ORIGIN_ALL.equals(value);
                }
            }
            if (allowOriginResponse && this.overriddenMimeType_ != null) {
                int index = this.overriddenMimeType_.toLowerCase(Locale.ROOT).indexOf("charset=");
                String charsetName = RESPONSE_TYPE_DEFAULT;
                if (index != -1) {
                    charsetName = this.overriddenMimeType_.substring(index + "charset=".length());
                }
                final Charset charset = EncodingSniffer.toCharset(charsetName);
                final String charsetNameFinal = charsetName;
                this.webResponse_ = new WebResponseWrapper(this.webResponse_){

                    @Override
                    public String getContentType() {
                        return XMLHttpRequest.this.overriddenMimeType_;
                    }

                    @Override
                    public Charset getContentCharset() {
                        if (charsetNameFinal.isEmpty() || charset == null) {
                            return super.getContentCharset();
                        }
                        return charset;
                    }
                };
            }
            if (!allowOriginResponse) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No permitted \"Access-Control-Allow-Origin\" header for URL " + this.webRequest_.getUrl()));
                }
                throw new NoPermittedHeaderException("No permitted \"Access-Control-Allow-Origin\" header.");
            }
            this.setState(2);
            if (this.async_) {
                this.fireJavascriptEvent("readystatechange");
                this.setState(3);
                this.fireJavascriptEvent("readystatechange");
                this.fireJavascriptEvent("progress");
            }
            this.setState(4);
            this.fireJavascriptEvent("readystatechange");
            if (!this.async_ && this.aborted_ && browserVersion.hasFeature(BrowserVersionFeatures.XHR_SEND_NETWORK_ERROR_IF_ABORTED)) {
                throw JavaScriptEngine.constructError("Error", "Failed to execute 'send' on 'XMLHttpRequest': Failed to load '" + this.webRequest_.getUrl() + "'");
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.XHR_LOAD_ALWAYS_AFTER_DONE)) {
                this.fireJavascriptEventIgnoreAbort("load");
                this.fireJavascriptEventIgnoreAbort("loadend");
            } else {
                this.fireJavascriptEvent("load");
                this.fireJavascriptEvent("loadend");
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"IOException: returning a network error response.", (Throwable)e);
            }
            if (this.async_ && !preflighted && HttpClientConverter.isNoHttpResponseException(e) && browserVersion.hasFeature(BrowserVersionFeatures.XHR_PROGRESS_ON_NETWORK_ERROR_ASYNC)) {
                this.fireJavascriptEvent("progress");
            }
            this.webResponse_ = new NetworkErrorWebResponse(this.webRequest_, e);
            if (this.async_) {
                this.setState(4);
                this.fireJavascriptEvent("readystatechange");
                if (e instanceof SocketTimeoutException) {
                    this.fireJavascriptEvent("timeout");
                } else {
                    this.fireJavascriptEvent("error");
                }
                this.fireJavascriptEvent("loadend");
            }
            this.setState(4);
            if (browserVersion.hasFeature(BrowserVersionFeatures.XHR_HANDLE_SYNC_NETWORK_ERRORS)) {
                this.fireJavascriptEvent("readystatechange");
                if (e instanceof SocketTimeoutException) {
                    this.fireJavascriptEvent("timeout");
                } else {
                    this.fireJavascriptEvent("error");
                }
                this.fireJavascriptEvent("loadend");
            }
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
    }

    private boolean isPreflight() {
        HttpMethod method = this.webRequest_.getHttpMethod();
        if (method != HttpMethod.GET && method != HttpMethod.HEAD && method != HttpMethod.POST) {
            return true;
        }
        for (Map.Entry<String, String> header : this.webRequest_.getAdditionalHeaders().entrySet()) {
            if (!XMLHttpRequest.isPreflightHeader(header.getKey().toLowerCase(Locale.ROOT), header.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isPreflightAuthorized(WebResponse preflightResponse) {
        String originHeader = preflightResponse.getResponseHeaderValue("Access-Control-Allow-Origin");
        if (!ALLOW_ORIGIN_ALL.equals(originHeader) && !this.webRequest_.getAdditionalHeaders().get("Origin").equals(originHeader)) {
            return false;
        }
        HashSet<String> accessControlValues = new HashSet<String>();
        for (NameValuePair nameValuePair : preflightResponse.getResponseHeaders()) {
            String[] values;
            String value;
            if (!"Access-Control-Allow-Headers".equalsIgnoreCase(nameValuePair.getName()) || (value = nameValuePair.getValue()) == null) continue;
            value = org.htmlunit.util.StringUtils.toRootLowerCase(value);
            for (String part : values = org.htmlunit.util.StringUtils.splitAtComma(value)) {
                if (!StringUtils.isNotEmpty(part = part.trim())) continue;
                accessControlValues.add(part);
            }
        }
        for (Map.Entry entry : this.webRequest_.getAdditionalHeaders().entrySet()) {
            String key = org.htmlunit.util.StringUtils.toRootLowerCase((String)entry.getKey());
            if (!XMLHttpRequest.isPreflightHeader(key, (String)entry.getValue()) || accessControlValues.contains(key)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPreflightHeader(String name, String value) {
        if ("content-type".equals(name)) {
            String lcValue = value.toLowerCase(Locale.ROOT);
            return !lcValue.startsWith(FormEncodingType.URL_ENCODED.getName()) && !lcValue.startsWith(FormEncodingType.MULTIPART.getName()) && !lcValue.startsWith(FormEncodingType.TEXT_PLAIN.getName());
        }
        return !"accept".equals(name) && !"accept-language".equals(name) && !"content-language".equals(name) && !"referer".equals(name) && !"accept-encoding".equals(name) && !"origin".equals(name);
    }

    @JsxFunction
    public void setRequestHeader(String name, String value) {
        if (!XMLHttpRequest.isAuthorizedHeader(name)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Ignoring XMLHttpRequest.setRequestHeader for " + name + ": it is a restricted header"));
            }
            return;
        }
        if (this.webRequest_ == null) {
            throw JavaScriptEngine.reportRuntimeError("The open() method must be called before setRequestHeader().");
        }
        this.webRequest_.setAdditionalHeader(name, value);
    }

    static boolean isAuthorizedHeader(String name) {
        String nameLowerCase = org.htmlunit.util.StringUtils.toRootLowerCase(name);
        if (PROHIBITED_HEADERS_.contains(nameLowerCase)) {
            return false;
        }
        return !nameLowerCase.startsWith("proxy-") && !nameLowerCase.startsWith("sec-");
    }

    @JsxFunction
    public void overrideMimeType(String mimeType) {
        if (this.state_ != 0 && this.state_ != 1) {
            throw JavaScriptEngine.reportRuntimeError("Property 'overrideMimeType' not writable after sent.");
        }
        this.overriddenMimeType_ = mimeType;
    }

    @JsxGetter
    public boolean isWithCredentials() {
        return this.withCredentials_;
    }

    @JsxSetter
    public void setWithCredentials(boolean withCredentials) {
        this.withCredentials_ = withCredentials;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!this.caseSensitiveProperties_) {
            for (String property : ALL_PROPERTIES_) {
                if (!property.equalsIgnoreCase(name)) continue;
                name = property;
                break;
            }
        }
        super.put(name, start, value);
    }

    @JsxGetter
    public XMLHttpRequestUpload getUpload() {
        XMLHttpRequestUpload upload = new XMLHttpRequestUpload();
        upload.setParentScope(this.getParentScope());
        upload.setPrototype(this.getPrototype(upload.getClass()));
        return upload;
    }

    @Override
    @JsxGetter
    public Function getOnreadystatechange() {
        return super.getOnreadystatechange();
    }

    @Override
    @JsxSetter
    public void setOnreadystatechange(Function readyStateChangeHandler) {
        super.setOnreadystatechange(readyStateChangeHandler);
    }

    @JsxGetter
    public int getTimeout() {
        return this.timeout_;
    }

    @JsxSetter
    public void setTimeout(int timeout) {
        this.timeout_ = timeout;
    }

    private static final class NoPermittedHeaderException
    extends IOException {
        private NoPermittedHeaderException(String msg) {
            super(msg);
        }
    }

    private static final class NetworkErrorWebResponse
    extends WebResponse {
        private final WebRequest request_;
        private final IOException error_;

        NetworkErrorWebResponse(WebRequest webRequest, IOException error) {
            super(null, null, 0L);
            this.request_ = webRequest;
            this.error_ = error;
        }

        @Override
        public int getStatusCode() {
            return 0;
        }

        @Override
        public String getStatusMessage() {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public String getContentType() {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public String getContentAsString() {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public InputStream getContentAsStream() {
            return null;
        }

        @Override
        public List<NameValuePair> getResponseHeaders() {
            return Collections.emptyList();
        }

        @Override
        public String getResponseHeaderValue(String headerName) {
            return XMLHttpRequest.RESPONSE_TYPE_DEFAULT;
        }

        @Override
        public long getLoadTime() {
            return 0L;
        }

        @Override
        public Charset getContentCharset() {
            return null;
        }

        @Override
        public Charset getContentCharsetOrNull() {
            return null;
        }

        @Override
        public WebRequest getWebRequest() {
            return this.request_;
        }

        public IOException getError() {
            return this.error_;
        }
    }
}

