/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.jetty.websocket.common.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.htmlunit.jetty.util.BufferUtil;
import org.htmlunit.jetty.util.log.Log;
import org.htmlunit.jetty.util.log.Logger;
import org.htmlunit.jetty.websocket.api.BatchMode;
import org.htmlunit.jetty.websocket.api.WebSocketPolicy;
import org.htmlunit.jetty.websocket.api.annotations.WebSocket;
import org.htmlunit.jetty.websocket.api.extensions.Frame;
import org.htmlunit.jetty.websocket.common.CloseInfo;
import org.htmlunit.jetty.websocket.common.events.AbstractEventDriver;
import org.htmlunit.jetty.websocket.common.events.JettyAnnotatedMetadata;
import org.htmlunit.jetty.websocket.common.message.MessageInputStream;
import org.htmlunit.jetty.websocket.common.message.MessageReader;
import org.htmlunit.jetty.websocket.common.message.NullMessage;
import org.htmlunit.jetty.websocket.common.message.SimpleBinaryMessage;
import org.htmlunit.jetty.websocket.common.message.SimpleTextMessage;
import org.htmlunit.jetty.websocket.common.util.TextUtil;

public class JettyAnnotatedEventDriver
extends AbstractEventDriver {
    private static final Logger LOG = Log.getLogger(JettyAnnotatedEventDriver.class);
    private final JettyAnnotatedMetadata events;
    private boolean hasCloseBeenCalled = false;
    private final BatchMode batchMode;

    public JettyAnnotatedEventDriver(WebSocketPolicy policy, Object websocket, JettyAnnotatedMetadata events) {
        super(policy, websocket);
        this.events = Objects.requireNonNull(events, "JettyAnnotatedMetadata may not be null");
        WebSocket anno = websocket.getClass().getAnnotation(WebSocket.class);
        if (anno.maxTextMessageSize() > 0) {
            this.policy.setMaxTextMessageSize(anno.maxTextMessageSize());
        }
        if (anno.maxBinaryMessageSize() > 0) {
            this.policy.setMaxBinaryMessageSize(anno.maxBinaryMessageSize());
        }
        if (anno.inputBufferSize() > 0) {
            this.policy.setInputBufferSize(anno.inputBufferSize());
        }
        if (anno.maxIdleTime() > 0) {
            this.policy.setIdleTimeout(anno.maxIdleTime());
        }
        this.batchMode = anno.batchMode();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ctor / object={}, policy={}, batchMode={}, events={}", new Object[]{websocket, policy, this.batchMode, events});
        }
    }

    @Override
    public BatchMode getBatchMode() {
        return this.batchMode;
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryFrame({}, {}) - events.onBinary={}, activeMessage={}", BufferUtil.toDetailString(buffer), fin, this.events.onBinary, this.activeMessage);
        }
        if (this.activeMessage == null) {
            if (this.events.onBinary == null) {
                this.activeMessage = NullMessage.INSTANCE;
            } else if (this.events.onBinary.isStreaming()) {
                MessageInputStream inputStream = new MessageInputStream(this.session);
                this.activeMessage = inputStream;
                this.dispatch(() -> {
                    try {
                        this.events.onBinary.call(this.websocket, this.session, inputStream);
                    }
                    catch (Throwable t) {
                        this.session.close(t);
                        return;
                    }
                    inputStream.handlerComplete();
                });
            } else {
                this.activeMessage = new SimpleBinaryMessage(this);
            }
        }
        this.appendMessage(buffer, fin);
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryMessage([{}]) - events.onBinary={}", data.length, this.events.onBinary);
        }
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, data, 0, data.length);
        }
    }

    @Override
    public void onClose(CloseInfo close) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose({}) - events.onClose={}", close, this.events.onClose);
        }
        if (this.events.onClose != null) {
            this.events.onClose.call(this.websocket, this.session, close.getStatusCode(), close.getReason());
        }
    }

    @Override
    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect() - events.onConnect={}", this.events.onConnect);
        }
        if (this.events.onConnect != null) {
            this.events.onConnect.call(this.websocket, this.session);
        }
    }

    @Override
    public void onError(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onError({}) - events.onError={}", cause.getClass().getName(), this.events.onError);
        }
        if (this.events.onError != null) {
            this.events.onError.call(this.websocket, this.session, cause);
        } else {
            LOG.warn("Unable to report throwable to websocket (no @OnWebSocketError handler declared): " + this.websocket.getClass().getName(), cause);
        }
    }

    @Override
    public void onFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFrame({}) - events.onFrame={}", frame, this.events.onFrame);
        }
        if (this.events.onFrame != null) {
            this.events.onFrame.call(this.websocket, this.session, frame);
        }
    }

    @Override
    public void onInputStream(InputStream stream) {
        Objects.requireNonNull(stream, "InputStream may not be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("onInputStream({}) - events.onBinary={}", stream.getClass().getName(), this.events.onBinary);
        }
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, stream);
        }
    }

    @Override
    public void onReader(Reader reader) {
        Objects.requireNonNull(reader, "Reader may not be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("onReader({}) - events.onText={}", reader.getClass().getName(), this.events.onText);
        }
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, reader);
        }
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextFrame({}, {}) - events.onText={}, activeMessage={}", BufferUtil.toDetailString(buffer), fin, this.events.onText, this.activeMessage);
        }
        if (this.activeMessage == null) {
            if (this.events.onText == null) {
                this.activeMessage = NullMessage.INSTANCE;
            } else if (this.events.onText.isStreaming()) {
                MessageReader reader = new MessageReader(this.session);
                this.activeMessage = reader;
                this.dispatch(() -> {
                    try {
                        this.events.onText.call(this.websocket, this.session, reader);
                    }
                    catch (Throwable t) {
                        this.session.close(t);
                        return;
                    }
                    reader.handlerComplete();
                });
            } else {
                this.activeMessage = new SimpleTextMessage(this);
            }
        }
        this.appendMessage(buffer, fin);
    }

    @Override
    public void onTextMessage(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextMessage([{}] \"{}\") - events.onText={}", message.length(), TextUtil.maxStringLength(60, message), this.events.onText);
        }
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, message);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.websocket);
    }
}

