/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import org.htmlunit.cyberneko.util.FastHashMap;
import org.htmlunit.util.StringUtils;

public final class MimeType {
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XHTML = "application/xhtml+xml";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    private static final FastHashMap<String, String> type2extension = MimeType.buildMap();
    private static final FastHashMap<String, Boolean> lookupMap = new FastHashMap(33, 0.7f);

    public static boolean isJavascriptMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        String mimeTypeLC = StringUtils.toRootLowerCase(mimeType);
        return TEXT_JAVASCRIPT.equals(mimeTypeLC) || "application/javascript".equals(mimeTypeLC) || "application/x-ecmascript".equals(mimeTypeLC) || "application/x-javascript".equals(mimeTypeLC) || "text/ecmascript".equals(mimeTypeLC) || "application/ecmascript".equals(mimeTypeLC) || "text/javascript1.0".equals(mimeTypeLC) || "text/javascript1.1".equals(mimeTypeLC) || "text/javascript1.2".equals(mimeTypeLC) || "text/javascript1.3".equals(mimeTypeLC) || "text/javascript1.4".equals(mimeTypeLC) || "text/javascript1.5".equals(mimeTypeLC) || "text/jscript".equals(mimeTypeLC) || "text/livescript".equals(mimeTypeLC) || "text/x-ecmascript".equals(mimeTypeLC) || "text/x-javascript".equals(mimeTypeLC);
    }

    public static boolean isObsoleteJavascriptMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (lookupMap.get(mimeType) != null) {
            return true;
        }
        String mimeTypeLC = mimeType.toLowerCase();
        return "application/javascript".equals(mimeTypeLC) || "application/ecmascript".equals(mimeTypeLC) || "application/x-ecmascript".equals(mimeTypeLC) || "application/x-javascript".equals(mimeTypeLC) || "text/ecmascript".equals(mimeTypeLC) || "text/javascript1.0".equals(mimeTypeLC) || "text/javascript1.1".equals(mimeTypeLC) || "text/javascript1.2".equals(mimeTypeLC) || "text/javascript1.3".equals(mimeTypeLC) || "text/javascript1.4".equals(mimeTypeLC) || "text/javascript1.5".equals(mimeTypeLC) || "text/jscript".equals(mimeTypeLC) || "text/livescript".equals(mimeTypeLC) || "text/x-ecmascript".equals(mimeTypeLC) || "text/x-javascript".equals(mimeTypeLC);
    }

    private static FastHashMap<String, String> buildMap() {
        FastHashMap<String, String> map = new FastHashMap<String, String>(23, 0.7f);
        map.put("application/pdf", "pdf");
        map.put("application/x-javascript", "js");
        map.put(IMAGE_GIF, "gif");
        map.put("image/jpg", "jpeg");
        map.put(IMAGE_JPEG, "jpeg");
        map.put(IMAGE_PNG, "png");
        map.put("image/svg+xml", "svg");
        map.put(TEXT_CSS, "css");
        map.put(TEXT_HTML, "html");
        map.put(TEXT_PLAIN, "txt");
        map.put("image/x-icon", "ico");
        for (String k : map.keys()) {
            map.put(k.toUpperCase(), map.get(k));
        }
        return map;
    }

    private MimeType() {
    }

    public static String getFileExtension(String contentType) {
        if (contentType == null) {
            return "unknown";
        }
        String value = type2extension.get(contentType);
        if (value == null) {
            String uppercased = contentType.toLowerCase();
            value = type2extension.get(uppercased);
        }
        return value == null ? "unknown" : value;
    }

    static {
        lookupMap.put("application/javascript", true);
        lookupMap.put("application/x-ecmascript", true);
        lookupMap.put("application/x-javascript", true);
        lookupMap.put("text/ecmascript", true);
        lookupMap.put("application/ecmascript", true);
        lookupMap.put("text/javascript1.0", true);
        lookupMap.put("text/javascript1.1", true);
        lookupMap.put("text/javascript1.2", true);
        lookupMap.put("text/javascript1.3", true);
        lookupMap.put("text/javascript1.4", true);
        lookupMap.put("text/javascript1.5", true);
        lookupMap.put("text/jscript", true);
        lookupMap.put("text/livescript", true);
        lookupMap.put("text/x-ecmascript", true);
        lookupMap.put("text/x-javascript", true);
        for (String k : lookupMap.keys()) {
            lookupMap.put(k.toUpperCase(), true);
        }
    }
}

