/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.htmlunit.WebAssert;
import org.htmlunit.protocol.AnyHandler;
import org.htmlunit.protocol.about.Handler;
import org.htmlunit.util.StringUtils;

public final class UrlUtils {
    public static final String ABOUT = "about";
    public static final String ABOUT_SCHEME = "about:";
    public static final String ABOUT_BLANK = "about:blank";
    public static final URL URL_ABOUT_BLANK;
    private static final URLStreamHandler JS_HANDLER;
    private static final URLStreamHandler ABOUT_HANDLER;
    private static final URLStreamHandler DATA_HANDLER;
    private static final BitSet PATH_ALLOWED_CHARS;
    private static final BitSet QUERY_ALLOWED_CHARS;
    private static final BitSet ANCHOR_ALLOWED_CHARS;
    private static final BitSet HASH_ALLOWED_CHARS;

    private UrlUtils() {
    }

    public static URL toUrlSafe(String url) {
        try {
            return UrlUtils.toUrlUnsafe(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toUrlUnsafe(String url) throws MalformedURLException {
        WebAssert.notNull("url", url);
        String protocol = hidden.jth.org.apache.commons.lang3.StringUtils.substringBefore(url, ":").toLowerCase(Locale.ROOT);
        if (protocol.isEmpty() || UrlUtils.isNormalUrlProtocol(protocol)) {
            URL response = new URL(url);
            if (response.getProtocol().startsWith("http") && hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(response.getHost())) {
                throw new MalformedURLException("Missing host name in url: " + url);
            }
            return response;
        }
        if ("javascript:".equals(protocol + ":")) {
            return new URL(null, url, JS_HANDLER);
        }
        if (ABOUT.equals(protocol)) {
            if (hidden.jth.org.apache.commons.lang3.StringUtils.equalsIgnoreCase(ABOUT_BLANK, url)) {
                return URL_ABOUT_BLANK;
            }
            return new URL(null, url, ABOUT_HANDLER);
        }
        if ("data".equals(protocol)) {
            return new URL(null, url, DATA_HANDLER);
        }
        return new URL(null, url, AnyHandler.INSTANCE);
    }

    public static URL encodeUrl(URL url, Charset charset) {
        if (!UrlUtils.isNormalUrlProtocol(url.getProtocol())) {
            return url;
        }
        try {
            String anchor;
            String query;
            String path = url.getPath();
            if (path != null) {
                path = UrlUtils.encode(path, PATH_ALLOWED_CHARS, StandardCharsets.UTF_8);
            }
            if ((query = url.getQuery()) != null) {
                query = UrlUtils.encode(query, QUERY_ALLOWED_CHARS, charset);
            }
            if ((anchor = url.getRef()) != null) {
                anchor = UrlUtils.encode(anchor, ANCHOR_ALLOWED_CHARS, StandardCharsets.UTF_8);
            }
            return UrlUtils.createNewUrl(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), path, anchor, query);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeAnchor(String anchor) {
        if (anchor == null) {
            return null;
        }
        return UrlUtils.encode(anchor, ANCHOR_ALLOWED_CHARS, StandardCharsets.UTF_8);
    }

    public static String encodeHash(String hash) {
        if (hash == null) {
            return null;
        }
        return UrlUtils.encode(hash, HASH_ALLOWED_CHARS, StandardCharsets.UTF_8);
    }

    public static String encodeQuery(String query) {
        if (query == null) {
            return null;
        }
        return UrlUtils.encode(query, QUERY_ALLOWED_CHARS, StandardCharsets.UTF_8);
    }

    public static String decode(String escaped) {
        try {
            byte[] bytes = escaped.getBytes(StandardCharsets.US_ASCII);
            byte[] bytes2 = URLCodec.decodeUrl((byte[])bytes);
            return new String(bytes2, StandardCharsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    private static String encode(String unescaped, BitSet allowed, Charset charset) {
        byte[] bytes = unescaped.getBytes(charset);
        byte[] bytes2 = URLCodec.encodeUrl((BitSet)allowed, (byte[])bytes);
        return UrlUtils.encodePercentSign(bytes2);
    }

    private static String encodePercentSign(byte[] input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(new String(input, StandardCharsets.US_ASCII));
        int state = 0;
        int offset = 0;
        for (int i = 0; i < input.length; ++i) {
            byte b = input[i];
            if (state == 0 && b == 37) {
                state = 1;
                continue;
            }
            if (state != 1 && state != 2) continue;
            if (48 <= b && b <= 57 || 65 <= b && b <= 70 || 97 <= b && b <= 102) {
                if (++state != 3) continue;
                state = 0;
                continue;
            }
            int st = i - state + offset;
            result.replace(st, st + 1, "%25");
            offset += 2;
            state = b == 37 ? 1 : 0;
        }
        if (state == 1 || state == 2) {
            int st = input.length - state + offset;
            result.replace(st, st + 1, "%25");
        }
        return result.toString();
    }

    public static URL getUrlWithoutPathRefQuery(URL u) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getAuthority(), null, null, null);
    }

    public static URL getUrlWithoutRef(URL u) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getAuthority(), u.getPath(), null, u.getQuery());
    }

    public static URL getUrlWithNewProtocol(URL u, String newProtocol) throws MalformedURLException {
        return UrlUtils.createNewUrl(newProtocol, u.getAuthority(), u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewHost(URL u, String newHost) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getUserInfo(), newHost, u.getPort(), u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewHostAndPort(URL u, String newHost, int newPort) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getUserInfo(), newHost, newPort, u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewPort(URL u, int newPort) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getUserInfo(), u.getHost(), newPort, u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewPath(URL u, String newPath) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getAuthority(), newPath, u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewRef(URL u, String newRef) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getAuthority(), u.getPath(), newRef, u.getQuery());
    }

    public static URL getUrlWithNewQuery(URL u, String newQuery) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getAuthority(), u.getPath(), u.getRef(), newQuery);
    }

    public static URL getUrlWithProtocolAndAuthority(URL u) throws MalformedURLException {
        return UrlUtils.createNewUrl(u.getProtocol(), u.getAuthority(), null, null, null);
    }

    public static URL getUrlWithNewUserName(URL u, String newUserName) throws MalformedURLException {
        int colonIdx;
        String newUserInfo = newUserName == null ? "" : newUserName;
        String userInfo = u.getUserInfo();
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(userInfo) && (colonIdx = userInfo.indexOf(58)) > -1) {
            newUserInfo = newUserInfo + userInfo.substring(colonIdx);
        }
        return UrlUtils.createNewUrl(u.getProtocol(), newUserInfo.isEmpty() ? null : newUserInfo, u.getHost(), u.getPort(), u.getPath(), u.getRef(), u.getQuery());
    }

    public static URL getUrlWithNewUserPassword(URL u, String newUserPassword) throws MalformedURLException {
        String newUserInfo = newUserPassword == null ? "" : ':' + newUserPassword;
        String userInfo = u.getUserInfo();
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isNotBlank(userInfo)) {
            int colonIdx = userInfo.indexOf(58);
            newUserInfo = colonIdx > -1 ? userInfo.substring(0, colonIdx) + newUserInfo : userInfo + newUserInfo;
        }
        return UrlUtils.createNewUrl(u.getProtocol(), newUserInfo.isEmpty() ? null : newUserInfo, u.getHost(), u.getPort(), u.getPath(), u.getRef(), u.getQuery());
    }

    private static URL createNewUrl(String protocol, String userInfo, String host, int port, String path, String ref, String query) throws MalformedURLException {
        StringBuilder s = new StringBuilder();
        s.append(protocol).append("://");
        if (userInfo != null) {
            s.append(userInfo).append('@');
        }
        s.append(host);
        if (port != -1) {
            s.append(':').append(port);
        }
        if (path != null && !path.isEmpty()) {
            if ('/' != path.charAt(0)) {
                s.append('/');
            }
            s.append(path);
        }
        if (query != null) {
            s.append('?').append(query);
        }
        if (ref != null) {
            if (ref.isEmpty() || ref.charAt(0) != '#') {
                s.append('#');
            }
            s.append(ref);
        }
        return new URL(s.toString());
    }

    private static URL createNewUrl(String protocol, String authority, String path, String ref, String query) throws MalformedURLException {
        int len = protocol.length() + 1;
        if (authority != null && !authority.isEmpty()) {
            len += 2 + authority.length();
        }
        if (path != null) {
            len += path.length();
        }
        if (query != null) {
            len += 1 + query.length();
        }
        if (ref != null) {
            len += 1 + ref.length();
        }
        StringBuilder s = new StringBuilder(len);
        s.append(protocol).append(':');
        if (authority != null && !authority.isEmpty()) {
            s.append("//");
            s.append(authority);
        }
        if (path != null) {
            s.append(path);
        }
        if (query != null) {
            s.append('?');
            s.append(query);
        }
        if (ref != null) {
            if (ref.isEmpty() || ref.charAt(0) != '#') {
                s.append('#');
            }
            s.append(ref);
        }
        return UrlUtils.toUrlSafe(s.toString());
    }

    public static String resolveUrl(String baseUrl, String relativeUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null");
        }
        if (relativeUrl == null) {
            throw new IllegalArgumentException("Relative URL must not be null");
        }
        Url url = UrlUtils.resolveUrl(UrlUtils.parseUrl(baseUrl), relativeUrl);
        return url.toString();
    }

    public static String resolveUrl(URL baseUrl, String relativeUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null");
        }
        return UrlUtils.resolveUrl(baseUrl.toExternalForm(), relativeUrl);
    }

    private static Url parseUrl(String spec) {
        int semicolonIndex;
        int questionMarkIndex;
        int locationEndIndex;
        int locationStartIndex;
        String scheme;
        int colonIndex;
        int crosshatchIndex;
        Url url = new Url();
        int startIndex = 0;
        int endIndex = spec.length();
        if (endIndex > startIndex) {
            StringBuilder sb = null;
            boolean before = true;
            int trailing = 0;
            for (int i = 0; i < endIndex; ++i) {
                char c = spec.charAt(i);
                boolean remove = false;
                if (c == '\t' | c == '\r' | c == '\n') {
                    remove = true;
                } else if ('\u0000' <= c && c <= ' ') {
                    if (before) {
                        remove = true;
                    } else {
                        ++trailing;
                    }
                } else {
                    before = false;
                    trailing = 0;
                }
                if (remove) {
                    if (sb != null) continue;
                    sb = new StringBuilder(spec.substring(0, i));
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
            }
            if (sb == null) {
                if (trailing > 0) {
                    endIndex = spec.length() - trailing;
                    spec = spec.substring(0, endIndex);
                }
            } else {
                spec = trailing > 0 ? sb.substring(0, sb.length() - trailing) : sb.toString();
                endIndex = spec.length();
            }
        }
        if ((crosshatchIndex = StringUtils.indexOf(spec, '#', startIndex, endIndex)) >= 0) {
            url.fragment_ = spec.substring(crosshatchIndex + 1, endIndex);
            endIndex = crosshatchIndex;
        }
        if ((colonIndex = StringUtils.indexOf(spec, ':', startIndex, endIndex)) > 0 && UrlUtils.isValidScheme(scheme = spec.substring(startIndex, colonIndex))) {
            url.scheme_ = scheme;
            startIndex = colonIndex + 1;
        }
        if (spec.startsWith("//", startIndex)) {
            locationStartIndex = startIndex + 2;
            locationEndIndex = StringUtils.indexOf(spec, '/', locationStartIndex, endIndex);
            if (locationEndIndex >= 0) {
                startIndex = locationEndIndex;
            }
        } else {
            locationStartIndex = -1;
            locationEndIndex = -1;
        }
        if ((questionMarkIndex = StringUtils.indexOf(spec, '?', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = questionMarkIndex;
                startIndex = questionMarkIndex;
            }
            url.query_ = spec.substring(questionMarkIndex + 1, endIndex);
            endIndex = questionMarkIndex;
        }
        if ((semicolonIndex = StringUtils.indexOf(spec, ';', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = semicolonIndex;
                startIndex = semicolonIndex;
            }
            url.parameters_ = spec.substring(semicolonIndex + 1, endIndex);
            endIndex = semicolonIndex;
        }
        if (locationStartIndex >= 0 && locationEndIndex < 0) {
            locationEndIndex = endIndex;
        } else if (startIndex < endIndex) {
            url.path_ = spec.substring(startIndex, endIndex);
        }
        if (locationStartIndex >= 0 && locationEndIndex >= 0) {
            url.location_ = spec.substring(locationStartIndex, locationEndIndex);
        }
        return url;
    }

    public static boolean isValidScheme(String scheme) {
        boolean isValid;
        int length = scheme.length();
        if (length < 1) {
            return false;
        }
        char c = scheme.charAt(0);
        boolean bl = isValid = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
        if (!isValid) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = scheme.charAt(i);
            boolean bl2 = isValid = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '+' || c == '.' || c == '-';
            if (isValid) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpecialScheme(String scheme) {
        int length = scheme.length();
        if (length < 2 || length > 5) {
            return false;
        }
        String schemeLC = scheme.toLowerCase(Locale.ROOT);
        return "ftp".equals(schemeLC) || "file".equals(schemeLC) || "http".equals(schemeLC) || "https".equals(schemeLC) || "ws".equals(schemeLC) || "wss".equals(schemeLC);
    }

    private static Url resolveUrl(Url baseUrl, String relativeUrl) {
        int slashIndex;
        String pathSegment;
        int pathSegmentIndex;
        Url url = UrlUtils.parseUrl(relativeUrl);
        if (baseUrl == null) {
            return url;
        }
        if (relativeUrl.isEmpty()) {
            return new Url(baseUrl);
        }
        if (url.scheme_ != null) {
            return url;
        }
        url.scheme_ = baseUrl.scheme_;
        if (url.location_ != null) {
            return url;
        }
        url.location_ = baseUrl.location_;
        if (url.path_ != null && !url.path_.isEmpty() && url.path_.charAt(0) == '/') {
            url.path_ = UrlUtils.removeLeadingSlashPoints(url.path_);
            return url;
        }
        if (url.path_ == null) {
            url.path_ = baseUrl.path_;
            if (url.parameters_ != null) {
                return url;
            }
            url.parameters_ = baseUrl.parameters_;
            if (url.query_ != null) {
                return url;
            }
            url.query_ = baseUrl.query_;
            return url;
        }
        String basePath = baseUrl.path_;
        String path = "";
        if (basePath == null) {
            path = "/";
        } else {
            int lastSlashIndex = basePath.lastIndexOf(47);
            if (lastSlashIndex >= 0) {
                path = basePath.substring(0, lastSlashIndex + 1);
            }
        }
        path = path.concat(url.path_);
        while ((pathSegmentIndex = path.indexOf("/./")) >= 0) {
            path = path.substring(0, pathSegmentIndex + 1).concat(path.substring(pathSegmentIndex + 3));
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        while ((pathSegmentIndex = path.indexOf("/../")) > 0) {
            pathSegment = path.substring(0, pathSegmentIndex);
            slashIndex = pathSegment.lastIndexOf(47);
            if (slashIndex >= 0) {
                if ("..".equals(pathSegment.substring(slashIndex))) continue;
                path = path.substring(0, slashIndex + 1).concat(path.substring(pathSegmentIndex + 4));
                continue;
            }
            path = path.substring(pathSegmentIndex + 4);
        }
        if (path.endsWith("/..") && (slashIndex = (pathSegment = path.substring(0, path.length() - 3)).lastIndexOf(47)) >= 0) {
            path = path.substring(0, slashIndex + 1);
        }
        path = UrlUtils.removeLeadingSlashPoints(path);
        url.path_ = path;
        return url;
    }

    private static String removeLeadingSlashPoints(String path) {
        int i = 1;
        while (path.startsWith("../", i)) {
            i += 3;
        }
        if (i > 1) {
            return "/" + path.substring(i);
        }
        return path;
    }

    static boolean isNormalUrlProtocol(String protocol) {
        return "http".equals(protocol) || "https".equals(protocol) || "file".equals(protocol);
    }

    public static boolean sameFile(URL u1, URL u2) {
        String f2;
        String h2;
        int port2;
        String p2;
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        String p1 = u1.getProtocol();
        if (!(p1 == (p2 = u2.getProtocol()) || p1 != null && p1.equalsIgnoreCase(p2))) {
            return false;
        }
        int port1 = u1.getPort() == -1 ? u1.getDefaultPort() : u1.getPort();
        int n = port2 = u2.getPort() == -1 ? u2.getDefaultPort() : u2.getPort();
        if (port1 != port2) {
            return false;
        }
        String h1 = u1.getHost();
        if (!(h1 == (h2 = u2.getHost()) || h1 != null && h1.equalsIgnoreCase(h2))) {
            return false;
        }
        String f1 = u1.getFile();
        if (f1.isEmpty()) {
            f1 = "/";
        }
        if ((f2 = u2.getFile()).isEmpty()) {
            f2 = "/";
        }
        if (f1.indexOf(46) > 0 || f2.indexOf(46) > 0) {
            try {
                f1 = u1.toURI().normalize().toURL().getFile();
                f2 = u2.toURI().normalize().toURL().getFile();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Objects.equals(f1, f2);
    }

    public static String normalize(URL url) {
        StringBuilder result = new StringBuilder();
        result.append(url.getProtocol()).append("://").append(url.getHost()).append(':').append(url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
        String f = url.getFile();
        if (f.isEmpty()) {
            result.append('/');
        } else {
            if (f.indexOf(46) > 0) {
                try {
                    f = url.toURI().normalize().toURL().getFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result.append(f);
        }
        return result.toString();
    }

    public static URI toURI(URL url, String query) throws URISyntaxException {
        String scheme = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        StringBuilder buffer = new StringBuilder();
        if (host != null) {
            if (scheme != null) {
                buffer.append(scheme);
                buffer.append("://");
            }
            buffer.append(host);
            if (port > 0) {
                buffer.append(':');
                buffer.append(port);
            }
        }
        if (path == null || path.isEmpty() || path.charAt(0) != '/') {
            buffer.append('/');
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        return new URI(buffer.toString());
    }

    public static String encodeQueryPart(String part) {
        if (part == null || part.isEmpty()) {
            return "";
        }
        try {
            return URLEncoder.encode(part, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return part;
        }
    }

    public static URL removeRedundantPort(URL url) throws MalformedURLException {
        if ("https".equals(url.getProtocol()) && url.getPort() == 443 || "http".equals(url.getProtocol()) && url.getPort() == 80) {
            return UrlUtils.getUrlWithNewPort(url, -1);
        }
        return url;
    }

    static {
        int i;
        int i2;
        PATH_ALLOWED_CHARS = new BitSet(256);
        QUERY_ALLOWED_CHARS = new BitSet(256);
        ANCHOR_ALLOWED_CHARS = new BitSet(256);
        HASH_ALLOWED_CHARS = new BitSet(256);
        JS_HANDLER = new org.htmlunit.protocol.javascript.Handler();
        ABOUT_HANDLER = new Handler();
        DATA_HANDLER = new org.htmlunit.protocol.data.Handler();
        try {
            URL_ABOUT_BLANK = new URL(null, ABOUT_BLANK, ABOUT_HANDLER);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        BitSet reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        BitSet mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        BitSet alpha = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            alpha.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            alpha.set(i2);
        }
        BitSet digit = new BitSet(256);
        for (int i3 = 48; i3 <= 57; ++i3) {
            digit.set(i3);
        }
        BitSet alphanumeric = new BitSet(256);
        alphanumeric.or(alpha);
        alphanumeric.or(digit);
        BitSet unreserved = new BitSet(256);
        unreserved.or(alphanumeric);
        unreserved.or(mark);
        BitSet hex = new BitSet(256);
        hex.or(digit);
        for (i = 97; i <= 102; ++i) {
            hex.set(i);
        }
        for (i = 65; i <= 70; ++i) {
            hex.set(i);
        }
        BitSet escaped = new BitSet(256);
        escaped.set(37);
        escaped.or(hex);
        BitSet uric = new BitSet(256);
        uric.or(reserved);
        uric.or(unreserved);
        uric.or(escaped);
        BitSet pchar = new BitSet(256);
        pchar.or(unreserved);
        pchar.or(escaped);
        pchar.set(58);
        pchar.set(64);
        pchar.set(38);
        pchar.set(61);
        pchar.set(43);
        pchar.set(36);
        pchar.set(44);
        BitSet segment = new BitSet(256);
        segment.or(pchar);
        segment.set(59);
        segment.or(pchar);
        BitSet pathSegments = new BitSet(256);
        pathSegments.set(47);
        pathSegments.or(segment);
        BitSet absPath = new BitSet(256);
        absPath.set(47);
        absPath.or(pathSegments);
        BitSet allowedAbsPath = new BitSet(256);
        allowedAbsPath.or(absPath);
        BitSet allowedFragment = new BitSet(256);
        allowedFragment.or(uric);
        BitSet allowedQuery = new BitSet(256);
        allowedQuery.or(uric);
        BitSet allowedHash = new BitSet(256);
        allowedHash.or(uric);
        PATH_ALLOWED_CHARS.or(allowedAbsPath);
        QUERY_ALLOWED_CHARS.or(allowedQuery);
        ANCHOR_ALLOWED_CHARS.or(allowedFragment);
        HASH_ALLOWED_CHARS.or(allowedHash);
    }

    private static class Url {
        private String scheme_;
        private String location_;
        private String path_;
        private String parameters_;
        private String query_;
        private String fragment_;

        Url() {
        }

        Url(Url url) {
            this.scheme_ = url.scheme_;
            this.location_ = url.location_;
            this.path_ = url.path_;
            this.parameters_ = url.parameters_;
            this.query_ = url.query_;
            this.fragment_ = url.fragment_;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.scheme_ != null) {
                sb.append(this.scheme_);
                sb.append(':');
            }
            if (this.location_ != null) {
                sb.append("//");
                sb.append(this.location_);
            }
            if (this.path_ != null) {
                sb.append(this.path_);
            }
            if (this.parameters_ != null) {
                sb.append(';');
                sb.append(this.parameters_);
            }
            if (this.query_ != null) {
                sb.append('?');
                sb.append(this.query_);
            }
            if (this.fragment_ != null) {
                sb.append('#');
                sb.append(this.fragment_);
            }
            return sb.toString();
        }
    }
}

