/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.websocket;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.htmlunit.WebClient;
import org.htmlunit.WebClientOptions;
import org.htmlunit.jetty.util.ssl.SslContextFactory;
import org.htmlunit.jetty.websocket.api.Session;
import org.htmlunit.jetty.websocket.api.WebSocketPolicy;
import org.htmlunit.jetty.websocket.client.WebSocketClient;
import org.htmlunit.websocket.WebSocketAdapter;
import org.htmlunit.websocket.WebSocketCookieStore;

public abstract class JettyWebSocketAdapter
implements WebSocketAdapter {
    private final Object clientLock_ = new Object();
    private WebSocketClient client_;
    private volatile Session incomingSession_;
    private Session outgoingSession_;

    public JettyWebSocketAdapter(WebClient webClient) {
        WebClientOptions options = webClient.getOptions();
        this.client_ = webClient.getOptions().isUseInsecureSSL() ? new WebSocketClient(new SslContextFactory(true), null, null) : new WebSocketClient();
        this.client_.setExecutor(webClient.getExecutor());
        this.client_.getHttpClient().setCookieStore(new WebSocketCookieStore(webClient));
        WebSocketPolicy policy = this.client_.getPolicy();
        int size = options.getWebSocketMaxBinaryMessageSize();
        if (size > 0) {
            policy.setMaxBinaryMessageSize(size);
        }
        if ((size = options.getWebSocketMaxBinaryMessageBufferSize()) > 0) {
            policy.setMaxBinaryMessageBufferSize(size);
        }
        if ((size = options.getWebSocketMaxTextMessageSize()) > 0) {
            policy.setMaxTextMessageSize(size);
        }
        if ((size = options.getWebSocketMaxTextMessageBufferSize()) > 0) {
            policy.setMaxTextMessageBufferSize(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.clientLock_;
        synchronized (object) {
            this.client_.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(URI url) throws Exception {
        Object object = this.clientLock_;
        synchronized (object) {
            Future<Session> connectFuture = this.client_.connect(new JettyWebSocketAdapterImpl(), url);
            this.client_.getExecutor().execute(() -> {
                try {
                    this.onWebSocketConnecting();
                    this.incomingSession_ = (Session)connectFuture.get();
                }
                catch (Exception e) {
                    this.onWebSocketConnectError(e);
                }
            });
        }
    }

    @Override
    public void send(Object content) throws IOException {
        if (content instanceof String) {
            this.outgoingSession_.getRemote().sendString((String)content);
        } else if (content instanceof ByteBuffer) {
            this.outgoingSession_.getRemote().sendBytes((ByteBuffer)content);
        } else {
            throw new IllegalStateException("Not Yet Implemented: WebSocket.send() was used to send non-string value");
        }
    }

    @Override
    public void closeIncommingSession() {
        if (this.incomingSession_ != null) {
            this.incomingSession_.close();
        }
    }

    @Override
    public void closeOutgoingSession() {
        if (this.outgoingSession_ != null) {
            this.outgoingSession_.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeClient() throws Exception {
        Object object = this.clientLock_;
        synchronized (object) {
            if (this.client_ != null) {
                this.client_.stop();
                this.client_.destroy();
                this.client_ = null;
            }
        }
    }

    private class JettyWebSocketAdapterImpl
    extends org.htmlunit.jetty.websocket.api.WebSocketAdapter {
        JettyWebSocketAdapterImpl() {
        }

        @Override
        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            JettyWebSocketAdapter.this.outgoingSession_ = session;
            JettyWebSocketAdapter.this.onWebSocketConnect();
        }

        @Override
        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            JettyWebSocketAdapter.this.outgoingSession_ = null;
            JettyWebSocketAdapter.this.onWebSocketClose(statusCode, reason);
        }

        @Override
        public void onWebSocketText(String message) {
            super.onWebSocketText(message);
            JettyWebSocketAdapter.this.onWebSocketText(message);
        }

        @Override
        public void onWebSocketBinary(byte[] data, int offset, int length) {
            super.onWebSocketBinary(data, offset, length);
            JettyWebSocketAdapter.this.onWebSocketBinary(data, offset, length);
        }

        @Override
        public void onWebSocketError(Throwable cause) {
            super.onWebSocketError(cause);
            JettyWebSocketAdapter.this.outgoingSession_ = null;
            JettyWebSocketAdapter.this.onWebSocketError(cause);
        }
    }
}

