/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.FF, minVersion=38.0f)}), @JsxClass(isJSObject=false, isDefinedInStandardsMode=false, browsers={@WebBrowser(value=BrowserName.FF, maxVersion=31.0f)}), @JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class NamedNodeMap
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private final org.w3c.dom.NamedNodeMap attributes_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f)})
    public NamedNodeMap() {
        this.attributes_ = null;
    }

    public NamedNodeMap(DomElement element) {
        this.setParentScope(element.getScriptObject());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributes_ = element.getAttributes();
        this.setDomNode(element, false);
    }

    @Override
    public final Object get(int index, Scriptable start) {
        NamedNodeMap startMap = (NamedNodeMap)start;
        Object response = startMap.item(index);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    @Override
    public Object getWithFallback(String name) {
        Object response = this.getNamedItem(name);
        if (response != null) {
            if (response instanceof Attr && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ATTRIBUTES_BY_NAME_CASE_SENSITIVE)) {
                Attr attr = (Attr)response;
                if (attr.getName().equals(name)) {
                    return response;
                }
            } else {
                return response;
            }
        }
        if (this.getDomNodeOrNull() != null && this.useRecursiveAttributeForIE() && this.isRecursiveAttribute(name)) {
            return this.getUnspecifiedAttributeNode(name);
        }
        return NOT_FOUND;
    }

    public Object getNamedItemWithoutSytheticClassAttr(String name) {
        if (this.attributes_ != null) {
            DomNode attr = (DomNode)this.attributes_.getNamedItem(name);
            if (attr != null) {
                return attr.getScriptObject();
            }
            if (!"className".equals(name) && this.useRecursiveAttributeForIE() && this.isRecursiveAttribute(name)) {
                return this.getUnspecifiedAttributeNode(name);
            }
        }
        return null;
    }

    @JsxFunction
    public Object getNamedItem(String name) {
        Object attr = this.getNamedItemWithoutSytheticClassAttr(name);
        if (null != attr) {
            return attr;
        }
        if ("class".equals(name) && this.useRecursiveAttributeForIE()) {
            return this.getUnspecifiedAttributeNode(name);
        }
        return null;
    }

    @JsxFunction
    public void setNamedItem(Node node) {
        this.attributes_.setNamedItem(node.getDomNodeOrDie());
    }

    @JsxFunction
    public void removeNamedItem(String name) {
        this.attributes_.removeNamedItem(name);
    }

    @JsxFunction
    public Object item(int index) {
        String name;
        DomNode attr = (DomNode)this.attributes_.item(index);
        if (attr != null) {
            return attr.getScriptObject();
        }
        if (this.useRecursiveAttributeForIE() && (name = this.getRecusiveAttributeNameAt(index -= this.attributes_.getLength())) != null) {
            return this.getUnspecifiedAttributeNode(name);
        }
        return null;
    }

    private boolean useRecursiveAttributeForIE() {
        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ATTRIBUTES_CONTAINS_EMPTY_ATTR_FOR_PROPERTIES) && this.getDomNodeOrDie() instanceof HtmlElement;
    }

    private Attr getUnspecifiedAttributeNode(String attrName) {
        HtmlElement domNode = (HtmlElement)this.getDomNodeOrDie();
        DomAttr attr = domNode.getPage().createAttribute(attrName);
        domNode.setAttributeNode(attr);
        return (Attr)attr.getScriptObject();
    }

    @JsxGetter
    public int getLength() {
        int length = this.attributes_.getLength();
        if (this.useRecursiveAttributeForIE()) {
            length += this.getRecursiveAttributesLength();
        }
        return length;
    }

    private boolean isRecursiveAttribute(String name) {
        for (Scriptable object = this.getDomNodeOrDie().getScriptObject(); object != null; object = object.getPrototype()) {
            for (Object id : object.getIds()) {
                if (!name.equals(Context.toString(id))) continue;
                return true;
            }
        }
        return false;
    }

    private int getRecursiveAttributesLength() {
        int length = 0;
        for (Scriptable object = this.getDomNodeOrDie().getScriptObject(); object != null; object = object.getPrototype()) {
            length += object.getIds().length;
        }
        return length;
    }

    private String getRecusiveAttributeNameAt(int index) {
        int i = 0;
        for (Scriptable object = this.getDomNodeOrDie().getScriptObject(); object != null; object = object.getPrototype()) {
            for (Object id : object.getIds()) {
                if (i == index) {
                    return Context.toString(id);
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getLength();
    }
}

