/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.Map;
import java.util.WeakHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Delegator;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class WeakMap
extends SimpleScriptable {
    private transient Map<Object, Object> map_ = new WeakHashMap<Object, Object>();

    public WeakMap() {
    }

    @JsxConstructor
    public WeakMap(Object iterable) {
        Window window;
        if (iterable != Undefined.instance && (window = (Window)ScriptRuntime.getTopCallScope(Context.getCurrentContext())).getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WEAKMAP_CONSTRUCTOR_ARGUMENT)) {
            if (iterable instanceof NativeArray) {
                NativeArray array = (NativeArray)iterable;
                int i = 0;
                while ((long)i < array.getLength()) {
                    Object entryObject = array.get(i);
                    if (entryObject instanceof NativeArray) {
                        Object[] entry = ((NativeArray)entryObject).toArray();
                        if (entry.length > 0) {
                            Object key = entry[0];
                            Object value = entry.length > 1 ? entry[1] : null;
                            this.set(key, value);
                        }
                    } else {
                        throw Context.reportRuntimeError("TypeError: object is not iterable");
                    }
                    ++i;
                }
            } else {
                throw Context.reportRuntimeError("TypeError: object is not iterable");
            }
        }
    }

    @Override
    @JsxFunction
    public Object get(Object key) {
        Object o = this.map_.get(key);
        if (o == null) {
            o = Undefined.instance;
        }
        return o;
    }

    @JsxFunction
    public WeakMap set(Object key, Object value) {
        if (key instanceof Delegator) {
            key = ((Delegator)key).getDelegee();
        }
        if (!(key instanceof ScriptableObject)) {
            throw Context.reportRuntimeError("TypeError: key is not an object");
        }
        this.map_.put(key, value);
        return this;
    }

    @JsxFunction
    public void clear() {
        this.map_.clear();
    }

    @JsxFunction
    public boolean delete(Object key) {
        return this.map_.remove(key) != null;
    }

    @JsxFunction
    public boolean has(Object key) {
        return this.map_.remove(key) != null;
    }
}

