/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlWeekInput
extends HtmlInput
implements LabelableElement {
    private static DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-'W'ww");

    HtmlWeekInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        if (!this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED) || StringUtils.isEmpty(newValue)) {
            super.setValueAttribute(newValue);
            return;
        }
        try {
            FORMATTER_.parse(newValue);
            super.setValueAttribute(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED) && !this.getMin().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getValueAttribute() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                LocalDate minDate = LocalDate.parse(this.getMin() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                return minDate.isEqual(dateValue) || minDate.isBefore(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED) && !this.getMax().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getValueAttribute() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                LocalDate maxDate = LocalDate.parse(this.getMax() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                return maxDate.isEqual(dateValue) || maxDate.isAfter(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }
}

