/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.parser.neko;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParser;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParserDOMBuilder;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.parser.neko.HtmlUnitNekoHTMLErrorHandler;
import com.gargoylesoftware.htmlunit.html.parser.neko.HtmlUnitNekoHtmlParser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLElements;
import net.sourceforge.htmlunit.cyberneko.HTMLEventInfo;
import net.sourceforge.htmlunit.cyberneko.HTMLTagBalancingListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

final class HtmlUnitNekoDOMBuilder
extends AbstractSAXParser
implements ContentHandler,
LexicalHandler,
HTMLTagBalancingListener,
HTMLParserDOMBuilder {
    private static final Map<Triple<Boolean, Boolean, Boolean>, HTMLElements> ELEMENTS = new HashMap<Triple<Boolean, Boolean, Boolean>, HTMLElements>();
    private final HTMLParser htmlParser_;
    private final HtmlPage page_;
    private Locator locator_;
    private final Deque<DomNode> stack_ = new ArrayDeque<DomNode>();
    private boolean snippetStartNodeOverwritten_;
    private final int initialSize_;
    private DomNode currentNode_;
    private StringBuilder characters_;
    private HeadParsed headParsed_ = HeadParsed.NO;
    private HtmlElement body_;
    private boolean lastTagWasSynthesized_;
    private HtmlForm formWaitingForLostChildren_;
    private boolean insideSvg_;
    private static final String FEATURE_AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final String FEATURE_PARSE_NOSCRIPT = "http://cyberneko.org/html/features/parse-noscript-content";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushInputString(String html) {
        this.page_.registerParsingStart();
        this.page_.registerInlineSnippetParsingStart();
        try {
            WebResponse webResponse = this.page_.getWebResponse();
            Charset charset = webResponse.getContentCharset();
            String url = webResponse.getWebRequest().getUrl().toString();
            XMLInputSource in = new XMLInputSource(null, url, null, new StringReader(html), charset.name());
            ((HTMLConfiguration)this.fConfiguration).evaluateInputSource(in);
        }
        finally {
            this.page_.registerParsingEnd();
            this.page_.registerInlineSnippetParsingEnd();
        }
    }

    HtmlUnitNekoDOMBuilder(HTMLParser htmlParser, DomNode node, URL url, String htmlContent) {
        super(HtmlUnitNekoDOMBuilder.createConfiguration(node.getPage().getWebClient().getBrowserVersion()));
        boolean reportErrors;
        this.htmlParser_ = htmlParser;
        this.page_ = (HtmlPage)node.getPage();
        this.currentNode_ = node;
        for (Node ancestor : this.currentNode_.getAncestors()) {
            this.stack_.push((DomNode)ancestor);
        }
        WebClient webClient = this.page_.getWebClient();
        HTMLParserListener listener = webClient.getHTMLParserListener();
        boolean bl = reportErrors = listener != null;
        if (reportErrors) {
            this.fConfiguration.setErrorHandler(new HtmlUnitNekoHTMLErrorHandler(listener, url, htmlContent));
        }
        try {
            this.setFeature(FEATURE_AUGMENTATIONS, true);
            if (!webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_ATTRIBUTE_LOWER_CASE)) {
                this.setProperty("http://cyberneko.org/html/properties/names/attrs", "no-change");
            }
            this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
            this.setFeature(FEATURE_PARSE_NOSCRIPT, !webClient.isJavaScriptEnabled());
            this.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe", false);
            this.setContentHandler(this);
            this.setLexicalHandler(this);
        }
        catch (SAXException e) {
            throw new ObjectInstantiationException("unable to create HTML parser", e);
        }
        this.initialSize_ = this.stack_.size();
    }

    private static XMLParserConfiguration createConfiguration(BrowserVersion browserVersion) {
        HTMLElements elements = ELEMENTS.get(Triple.of(browserVersion.hasFeature(BrowserVersionFeatures.HTML_COMMAND_TAG), browserVersion.hasFeature(BrowserVersionFeatures.HTML_ISINDEX_TAG), browserVersion.hasFeature(BrowserVersionFeatures.HTML_MAIN_TAG)));
        return new HTMLConfiguration(elements);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.lastTagWasSynthesized_ = HtmlUnitNekoDOMBuilder.isSynthesized(augs);
        super.startElement(element, attributes, augs);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String content;
        HtmlMeta meta;
        ElementFactory factory;
        if (this.snippetStartNodeOverwritten_) {
            this.snippetStartNodeOverwritten_ = false;
            return;
        }
        this.handleCharacters();
        String tagLower = localName.toLowerCase(Locale.ROOT);
        if (this.page_.isParsingHtmlSnippet() && ("html".equals(tagLower) || "body".equals(tagLower))) {
            return;
        }
        if ("head".equals(tagLower)) {
            if (this.headParsed_ == HeadParsed.YES || this.page_.isParsingHtmlSnippet()) {
                return;
            }
            HeadParsed headParsed = this.headParsed_ = this.lastTagWasSynthesized_ ? HeadParsed.SYNTHESIZED : HeadParsed.YES;
        }
        if (namespaceURI != null) {
            namespaceURI = namespaceURI.trim();
        } else if (this.headParsed_ == HeadParsed.NO && ("body".equals(tagLower) || "frameset".equals(tagLower))) {
            ElementFactory factory2 = this.htmlParser_.getElementFactory(this.page_, null, "head", this.insideSvg_, false);
            DomElement newElement = factory2.createElement(this.page_, "head", null);
            this.currentNode_.appendChild(newElement);
            this.headParsed_ = HeadParsed.SYNTHESIZED;
        }
        HtmlBody oldBody = null;
        if ("body".equals(qName) && this.page_.getBody() instanceof HtmlBody) {
            oldBody = (HtmlBody)this.page_.getBody();
        }
        if ("form".equals(tagLower)) {
            this.formWaitingForLostChildren_ = null;
        }
        if (!(this.page_ instanceof XHtmlPage) && "http://www.w3.org/1999/xhtml".equals(namespaceURI)) {
            namespaceURI = null;
        }
        if ((factory = this.htmlParser_.getElementFactory(this.page_, namespaceURI, qName, this.insideSvg_, false)) == HtmlUnitNekoHtmlParser.SVG_FACTORY) {
            namespaceURI = "http://www.w3.org/2000/svg";
        }
        DomElement newElement = factory.createElementNS(this.page_, namespaceURI, qName, atts, true);
        newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        this.addNodeToRightParent(this.currentNode_, newElement);
        if ("svg".equals(tagLower)) {
            this.insideSvg_ = true;
        }
        if (oldBody != null) {
            oldBody.quietlyRemoveAndMoveChildrenTo(newElement);
        }
        if ("body".equals(tagLower)) {
            this.body_ = (HtmlElement)newElement;
        } else if ("meta".equals(tagLower) && this.page_.hasFeature(BrowserVersionFeatures.META_X_UA_COMPATIBLE) && "X-UA-Compatible".equals((meta = (HtmlMeta)newElement).getHttpEquivAttribute()) && (content = meta.getContentAttribute()).startsWith("IE=")) {
            String mode = content.substring(3).trim();
            int version = this.page_.getWebClient().getBrowserVersion().getBrowserVersionNumeric();
            try {
                int value = Integer.parseInt(mode);
                if (value > version) {
                    value = version;
                }
                ((HTMLDocument)this.page_.getScriptableObject()).forceDocumentMode(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentNode_ = newElement;
        this.stack_.push(this.currentNode_);
    }

    private void addNodeToRightParent(DomNode currentNode, DomElement newElement) {
        String currentNodeName = currentNode.getNodeName();
        String newNodeName = newElement.getNodeName();
        DomNode parent = currentNode;
        if ("tr".equals(newNodeName) && !HtmlUnitNekoDOMBuilder.isTableChild(currentNodeName)) {
            parent = this.findElementOnStack("tbody", "thead", "tfoot");
        } else if (HtmlUnitNekoDOMBuilder.isTableChild(newNodeName) && !"table".equals(currentNodeName)) {
            parent = this.findElementOnStack("table");
        } else if (HtmlUnitNekoDOMBuilder.isTableCell(newNodeName) && !"tr".equals(currentNodeName)) {
            parent = this.findElementOnStack("tr");
        }
        if (parent != currentNode && "form".equals(currentNodeName)) {
            this.formWaitingForLostChildren_ = (HtmlForm)currentNode;
        }
        String parentNodeName = parent.getNodeName();
        if (!"script".equals(newNodeName) && ("table".equals(parentNodeName) && !HtmlUnitNekoDOMBuilder.isTableChild(newNodeName) || !"tr".equals(newNodeName) && ("thead".equals(parentNodeName) || "tbody".equals(parentNodeName) || "tfoot".equals(parentNodeName)) || "colgroup".equals(parentNodeName) && !"col".equals(newNodeName) || "tr".equals(parentNodeName) && !HtmlUnitNekoDOMBuilder.isTableCell(newNodeName))) {
            if ("form".equals(newNodeName)) {
                this.formWaitingForLostChildren_ = (HtmlForm)newElement;
                parent.appendChild(newElement);
            } else if (newElement instanceof SubmittableElement) {
                if (this.formWaitingForLostChildren_ != null) {
                    this.formWaitingForLostChildren_.addLostChild((HtmlElement)newElement);
                }
                parent.appendChild(newElement);
            } else {
                parent = this.findElementOnStack("table");
                parent.insertBefore(newElement);
            }
        } else if (this.formWaitingForLostChildren_ != null && "form".equals(parentNodeName)) {
            if (newElement instanceof SubmittableElement) {
                this.formWaitingForLostChildren_.addLostChild((HtmlElement)newElement);
                parent.getParentNode().appendChild(newElement);
            } else {
                parent = this.findElementOnStack("table");
                parent.insertBefore(newElement);
            }
        } else if (this.formWaitingForLostChildren_ != null && newElement instanceof SubmittableElement) {
            this.formWaitingForLostChildren_.addLostChild((HtmlElement)newElement);
            parent.appendChild(newElement);
        } else {
            parent.appendChild(newElement);
        }
    }

    private DomNode findElementOnStack(String ... searchedElementNames) {
        DomNode searchedNode = null;
        for (DomNode node : this.stack_) {
            if (!ArrayUtils.contains(searchedElementNames, node.getNodeName())) continue;
            searchedNode = node;
            break;
        }
        if (searchedNode == null) {
            searchedNode = this.stack_.peek();
        }
        return searchedNode;
    }

    private static boolean isTableChild(String nodeName) {
        return "thead".equals(nodeName) || "tbody".equals(nodeName) || "tfoot".equals(nodeName) || "caption".equals(nodeName) || "colgroup".equals(nodeName);
    }

    private static boolean isTableCell(String nodeName) {
        return "td".equals(nodeName) || "th".equals(nodeName);
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.lastTagWasSynthesized_ = HtmlUnitNekoDOMBuilder.isSynthesized(augs);
        super.endElement(element, augs);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handleCharacters();
        String tagLower = localName.toLowerCase(Locale.ROOT);
        if (this.page_.isParsingHtmlSnippet()) {
            if ("html".equals(tagLower) || "body".equals(tagLower)) {
                return;
            }
            if (this.stack_.size() == this.initialSize_) {
                this.snippetStartNodeOverwritten_ = !"p".equals(tagLower);
                return;
            }
        }
        if ("svg".equals(tagLower)) {
            this.insideSvg_ = false;
        }
        if ("form".equals(tagLower)) {
            this.formWaitingForLostChildren_ = null;
        }
        DomNode previousNode = this.stack_.pop();
        previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        if (previousNode instanceof HtmlForm && this.lastTagWasSynthesized_) {
            this.formWaitingForLostChildren_ = (HtmlForm)previousNode;
        }
        if (!this.stack_.isEmpty()) {
            this.currentNode_ = this.stack_.peek();
        }
        boolean postponed = this.page_.isParsingInlineHtmlSnippet();
        previousNode.onAllChildrenAddedToPage(postponed);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characters_ == null) {
            this.characters_ = new StringBuilder();
        }
        this.characters_.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.characters_ == null) {
            this.characters_ = new StringBuilder();
        }
        this.characters_.append(ch, start, length);
    }

    private void handleCharacters() {
        if (this.characters_ != null && this.characters_.length() != 0) {
            if (this.currentNode_ instanceof HtmlHtml) {
                this.characters_.setLength(0);
            } else {
                String textValue = this.characters_.toString();
                DomText text = new DomText(this.page_, textValue);
                this.characters_.setLength(0);
                if (StringUtils.isNotBlank(textValue)) {
                    if (this.currentNode_ instanceof HtmlTableRow) {
                        HtmlTableRow row = (HtmlTableRow)this.currentNode_;
                        HtmlTable enclosingTable = row.getEnclosingTable();
                        if (enclosingTable != null) {
                            if (enclosingTable.getPreviousSibling() instanceof DomText) {
                                DomText domText = (DomText)enclosingTable.getPreviousSibling();
                                domText.setTextContent(domText + textValue);
                            } else {
                                enclosingTable.insertBefore(text);
                            }
                        }
                    } else if (this.currentNode_ instanceof HtmlTable) {
                        HtmlTable enclosingTable = (HtmlTable)this.currentNode_;
                        if (enclosingTable.getPreviousSibling() instanceof DomText) {
                            DomText domText = (DomText)enclosingTable.getPreviousSibling();
                            domText.setTextContent(domText + textValue);
                        } else {
                            enclosingTable.insertBefore(text);
                        }
                    } else if (this.currentNode_ instanceof HtmlImage) {
                        this.currentNode_.setNextSibling(text);
                    } else {
                        this.currentNode_.appendChild(text);
                    }
                } else {
                    this.currentNode_.appendChild(text);
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.handleCharacters();
        HtmlPage currentPage = this.page_;
        currentPage.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.handleCharacters();
        String data = new String(ch, start, length);
        DomComment comment = new DomComment(this.page_, data);
        this.currentNode_.appendChild(comment);
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        DomDocumentType type = new DomDocumentType(this.page_, name, publicId, systemId);
        this.page_.setDocumentType(type);
        DomDocumentType child = type;
        this.page_.appendChild(child);
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void ignoredEndElement(QName element, Augmentations augs) {
        if ("form".equals(element.localpart)) {
            this.formWaitingForLostChildren_ = null;
        }
    }

    @Override
    public void ignoredStartElement(QName elem, XMLAttributes attrs, Augmentations augs) {
        if (this.body_ != null && "body".equalsIgnoreCase(elem.localpart) && attrs != null) {
            HtmlUnitNekoDOMBuilder.copyAttributes(this.body_, attrs);
        }
        if (this.body_ != null && "html".equalsIgnoreCase(elem.localpart) && attrs != null) {
            HtmlUnitNekoDOMBuilder.copyAttributes((DomElement)this.body_.getParentNode(), attrs);
        }
    }

    private static void copyAttributes(DomElement to, XMLAttributes attrs) {
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String attrName = attrs.getLocalName(i).toLowerCase(Locale.ROOT);
            if (to.getAttributes().getNamedItem(attrName) != null) continue;
            to.setAttribute(attrName, attrs.getValue(i));
            if (!attrName.startsWith("on") || !to.getPage().getWebClient().isJavaScriptEngineEnabled() || !(to.getScriptableObject() instanceof HTMLBodyElement)) continue;
            HTMLBodyElement jsBody = (HTMLBodyElement)to.getScriptableObject();
            jsBody.createEventHandlerFromAttribute(attrName, attrs.getValue(i));
        }
    }

    @Override
    public void parse(XMLInputSource inputSource) throws XNIException, IOException {
        HTMLParserDOMBuilder oldBuilder = this.page_.getDOMBuilder();
        this.page_.setDOMBuilder(this);
        try {
            super.parse(inputSource);
        }
        finally {
            this.page_.setDOMBuilder(oldBuilder);
        }
    }

    HtmlElement getBody() {
        return this.body_;
    }

    private static boolean isSynthesized(Augmentations augs) {
        HTMLEventInfo info = augs == null ? null : (HTMLEventInfo)augs.getItem(FEATURE_AUGMENTATIONS);
        return info != null && info.isSynthesized();
    }

    static {
        HTMLElements.Element command = new HTMLElements.Element(25, "COMMAND", 4, 16, null);
        HTMLElements.Element isIndex = new HTMLElements.Element(62, "ISINDEX", 1, 16, null);
        HTMLElements.Element main = new HTMLElements.Element(71, "MAIN", 1, 16, null);
        Triple<Boolean, Boolean, Boolean> key = Triple.of(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
        HTMLElements value = new HTMLElements();
        ELEMENTS.put(key, value);
        key = Triple.of(Boolean.FALSE, Boolean.FALSE, Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(main);
        ELEMENTS.put(key, value);
        key = Triple.of(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE);
        value = new HTMLElements();
        value.setElement(isIndex);
        ELEMENTS.put(key, value);
        key = Triple.of(Boolean.FALSE, Boolean.TRUE, Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(isIndex);
        value.setElement(main);
        ELEMENTS.put(key, value);
        key = Triple.of(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
        value = new HTMLElements();
        value.setElement(command);
        ELEMENTS.put(key, value);
        key = Triple.of(Boolean.TRUE, Boolean.FALSE, Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(command);
        value.setElement(main);
        ELEMENTS.put(key, value);
        key = Triple.of(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
        value = new HTMLElements();
        value.setElement(command);
        value.setElement(isIndex);
        ELEMENTS.put(key, value);
        key = Triple.of(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(command);
        value.setElement(isIndex);
        value.setElement(main);
        ELEMENTS.put(key, value);
    }

    private static enum HeadParsed {
        YES,
        SYNTHESIZED,
        NO;

    }
}

