/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParser;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class DOMParser
extends SimpleScriptable {
    @JsxConstructor
    public DOMParser() {
    }

    @JsxFunction
    public Document parseFromString(String str, Object type) {
        if (type == null || Undefined.isUndefined(type)) {
            throw Context.reportRuntimeError("Missing 'type' parameter");
        }
        if ("text/xml".equals(type) || "application/xml".equals(type) || "application/xhtml+xml".equals(type) || "image/svg+xml".equals(type)) {
            XMLDocument document = new XMLDocument();
            document.setParentScope(this.getParentScope());
            document.setPrototype(this.getPrototype(XMLDocument.class));
            document.loadXML(str);
            return document;
        }
        if ("text/html".equals(type)) {
            WebWindow webWindow = this.getWindow().getWebWindow();
            WebClient webClient = webWindow.getWebClient();
            StringWebResponse webResponse = new StringWebResponse(str, webWindow.getEnclosedPage().getUrl());
            try {
                HtmlPage page = new HtmlPage(webResponse, webWindow);
                page.setEnclosingWindow(null);
                Window window = (Window)webWindow.getScriptableObject();
                HTMLDocument document = new HTMLDocument();
                document.setParentScope(window);
                document.setPrototype(window.getPrototype(document.getClass()));
                document.setDomNode(page);
                HTMLParser htmlParser = webClient.getPageCreator().getHtmlParser();
                htmlParser.parse(webResponse, page, false);
                return (HTMLDocument)page.getScriptableObject();
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("Parsing failed" + e.getMessage());
            }
        }
        throw Context.reportRuntimeError("Invalid 'type' parameter: " + type);
    }
}

