/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class CloseEvent
extends Event {
    private String reason_;
    private int code_;
    private boolean wasClean_;

    public CloseEvent() {
        this.setType("close");
        this.reason_ = "";
    }

    @Override
    public void eventCreated() {
        super.eventCreated();
        this.setType("");
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        if (details != null && !Undefined.isUndefined(details)) {
            this.code_ = ScriptRuntime.toInt32(details.get("code"));
            this.reason_ = ScriptRuntime.toString(details.get("reason"));
            this.wasClean_ = ScriptRuntime.toBoolean(details.get("wasClean"));
        }
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void initCloseEvent(String type, boolean bubbles, boolean cancelable, boolean wasClean, int reasonCode, String reason) {
        super.initEvent(type, bubbles, cancelable);
        this.wasClean_ = wasClean;
        this.code_ = reasonCode;
        this.reason_ = reason;
    }

    @JsxGetter
    public int getCode() {
        return this.code_;
    }

    public void setCode(int code) {
        this.code_ = code;
    }

    @JsxGetter
    public String getReason() {
        return this.reason_;
    }

    public void setReason(String reason) {
        this.reason_ = reason;
    }

    @JsxGetter
    public boolean isWasClean() {
        return this.wasClean_;
    }

    public void setWasClean(boolean wasClean) {
        this.wasClean_ = wasClean;
    }
}

