/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(isJSObject=false)
public class RowContainer
extends HTMLElement {
    @JsxGetter
    public Object getRows() {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlTableRow && RowContainer.this.isContainedRow((HtmlTableRow)node);
            }
        };
    }

    protected boolean isContainedRow(HtmlTableRow row) {
        return row.getParentNode() == this.getDomNodeOrDie();
    }

    @JsxFunction
    public void deleteRow(int rowIndex) {
        boolean rowIndexValid;
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        if (rowIndex == -1) {
            rowIndex = rowCount - 1;
        }
        boolean bl = rowIndexValid = rowIndex >= 0 && rowIndex < rowCount;
        if (rowIndexValid) {
            SimpleScriptable row = (SimpleScriptable)rows.item(rowIndex);
            row.getDomNodeOrDie().remove();
        }
    }

    @JsxFunction
    public Object insertRow(Object index) {
        int rowIndex = -1;
        if (!Undefined.isUndefined(index)) {
            rowIndex = (int)Context.toNumber(index);
        }
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        int r = rowIndex == -1 || rowIndex == rowCount ? Math.max(0, rowCount) : rowIndex;
        if (r < 0 || r > rowCount) {
            throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount (index: " + rowIndex + ", " + rowCount + " rows)");
        }
        return this.insertRow(r);
    }

    public Object insertRow(int index) {
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        DomElement newRow = ((HtmlPage)this.getDomNodeOrDie().getPage()).createElement("tr");
        if (rowCount == 0) {
            this.getDomNodeOrDie().appendChild(newRow);
        } else if (index == rowCount) {
            SimpleScriptable row = (SimpleScriptable)rows.item(index - 1);
            row.getDomNodeOrDie().getParentNode().appendChild(newRow);
        } else {
            SimpleScriptable row = (SimpleScriptable)rows.item(index);
            if (index > rowCount - 1) {
                row.getDomNodeOrDie().getParentNode().appendChild(newRow);
            } else {
                row.getDomNodeOrDie().insertBefore(newRow);
            }
        }
        return this.getScriptableFor(newRow);
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object moveRow(int sourceIndex, int targetIndex) {
        boolean targetIndexValid;
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        boolean sourceIndexValid = sourceIndex >= 0 && sourceIndex < rowCount;
        boolean bl = targetIndexValid = targetIndex >= 0 && targetIndex < rowCount;
        if (sourceIndexValid && targetIndexValid) {
            SimpleScriptable sourceRow = (SimpleScriptable)rows.item(sourceIndex);
            SimpleScriptable targetRow = (SimpleScriptable)rows.item(targetIndex);
            targetRow.getDomNodeOrDie().insertBefore(sourceRow.getDomNodeOrDie());
            return sourceRow;
        }
        return null;
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }
}

