/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.util.Set;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.WebClientUtil;
import org.htmlunit.html.HtmlElement;

public class HtmlElementUtil {
    public static Page click(HtmlElement element) throws IOException {
        if (element == null) {
            return null;
        }
        try {
            Page page = element.click();
            return page;
        }
        finally {
            WebClient webClient = element.getPage().getWebClient();
            WebClientUtil.waitForJSExec(webClient);
        }
    }

    public static boolean hasClassName(HtmlElement element, String className) {
        String classAttribute = element.getAttribute("class");
        Set<String> classes = Set.of(classAttribute.split(" "));
        return classes.contains(className);
    }
}

