/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jvnet.hudson.test.ExtractChangeLogSet;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.xml.sax.SAXException;

public class ExtractChangeLogParser
extends ChangeLogParser {
    public ExtractChangeLogSet parse(AbstractBuild build, File changeLogFile) throws IOException, SAXException {
        if (changeLogFile.exists()) {
            ExtractChangeLogSet logSet;
            try (FileInputStream fis = new FileInputStream(changeLogFile);){
                logSet = this.parse(build, fis);
            }
            return logSet;
        }
        return new ExtractChangeLogSet(build, new ArrayList<ExtractChangeLogEntry>());
    }

    public ExtractChangeLogSet parse(AbstractBuild build, InputStream changeLogStream) throws IOException, SAXException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(changeLogStream, build.getCharset()));){
            String fileName;
            ExtractChangeLogEntry entry = new ExtractChangeLogEntry(br.readLine());
            while ((fileName = br.readLine()) != null) {
                entry.addFile(new FileInZip(fileName));
            }
            ExtractChangeLogSet extractChangeLogSet = new ExtractChangeLogSet(build, List.of(entry));
            return extractChangeLogSet;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class FileInZip {
        private final String fileName;

        FileInZip(String fileName) {
            this.fileName = fileName;
        }

        @Exported
        public String getFileName() {
            return this.fileName;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class ExtractChangeLogEntry
    extends ChangeLogSet.Entry {
        private final List<FileInZip> files = new ArrayList<FileInZip>();
        private final String zipFile;

        ExtractChangeLogEntry(String zipFile) {
            this.zipFile = zipFile;
        }

        @Exported
        public String getZipFile() {
            return this.zipFile;
        }

        public void setParent(ChangeLogSet parent) {
            super.setParent(parent);
        }

        public Collection<String> getAffectedPaths() {
            ArrayList<String> paths = new ArrayList<String>(this.files.size());
            for (FileInZip file : this.files) {
                paths.add(file.getFileName());
            }
            return paths;
        }

        @Exported
        public User getAuthor() {
            return User.get((String)"testuser");
        }

        @Exported
        public String getMsg() {
            return "Extracted from " + this.zipFile;
        }

        public void addFile(FileInZip fileName) {
            this.files.add(fileName);
        }
    }
}

