/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.NullSCM;
import hudson.scm.SCMDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jvnet.hudson.test.ExtractChangeLogParser;

public class ExtractResourceWithChangesSCM
extends NullSCM {
    private final URL firstZip;
    private final URL secondZip;
    private final String moduleRoot;

    public ExtractResourceWithChangesSCM(URL firstZip, URL secondZip) {
        if (firstZip == null || secondZip == null) {
            throw new IllegalArgumentException();
        }
        this.firstZip = firstZip;
        this.secondZip = secondZip;
        this.moduleRoot = null;
    }

    public ExtractResourceWithChangesSCM(URL firstZip, URL secondZip, String moduleRoot) {
        if (firstZip == null || secondZip == null) {
            throw new IllegalArgumentException();
        }
        this.firstZip = firstZip;
        this.secondZip = secondZip;
        this.moduleRoot = moduleRoot;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.moduleRoot != null) {
            return workspace.child(this.moduleRoot);
        }
        return workspace;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, @NonNull File changeLogFile) throws IOException, InterruptedException {
        if (workspace.exists()) {
            listener.getLogger().println("Deleting existing workspace " + workspace.getRemote());
            workspace.deleteRecursive();
        }
        listener.getLogger().println("Staging first zip: " + this.firstZip);
        workspace.unzipFrom(this.firstZip.openStream());
        listener.getLogger().println("Staging second zip: " + this.secondZip);
        workspace.unzipFrom(this.secondZip.openStream());
        ExtractChangeLogParser.ExtractChangeLogEntry changeLog = new ExtractChangeLogParser.ExtractChangeLogEntry(this.secondZip.toString());
        try (ZipInputStream zip = new ZipInputStream(this.secondZip.openStream());){
            ZipEntry e;
            while ((e = zip.getNextEntry()) != null) {
                if (e.isDirectory()) continue;
                changeLog.addFile(new ExtractChangeLogParser.FileInZip(e.getName()));
            }
        }
        this.saveToChangeLog(changeLogFile, build.getCharset(), changeLog);
        return true;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ExtractChangeLogParser();
    }

    @Deprecated
    public void saveToChangeLog(File changeLogFile, ExtractChangeLogParser.ExtractChangeLogEntry changeLog) throws IOException {
        this.saveToChangeLog(changeLogFile, Charset.defaultCharset(), changeLog);
    }

    public void saveToChangeLog(File changeLogFile, Charset charset, ExtractChangeLogParser.ExtractChangeLogEntry changeLog) throws IOException {
        try (PrintStream ps = new PrintStream(changeLogFile, charset);){
            ps.println(changeLog.getZipFile());
            for (String fileName : changeLog.getAffectedPaths()) {
                ps.println(fileName);
            }
        }
    }

    protected Object writeReplace() {
        return new Object();
    }

    public SCMDescriptor<?> getDescriptor() {
        return new SCMDescriptor<ExtractResourceWithChangesSCM>(ExtractResourceWithChangesSCM.class, null){};
    }
}

