/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Logger;

class IOUtil {
    private static final Logger LOGGER = Logger.getLogger(IOUtil.class.getName());

    IOUtil() {
    }

    public static int randomTcpPort(int from, int to) {
        from = from <= 0 ? 49152 : from;
        int n = to = to <= 0 ? 65535 : to;
        int candidate;
        while (!IOUtil.isTcpPortFree(candidate = (int)(Math.random() * (double)(to - from) + (double)from))) {
            LOGGER.info(String.format("Port %s is in use", candidate));
        }
        return candidate;
    }

    public static int randomTcpPort() {
        return IOUtil.randomTcpPort(-1, -1);
    }

    public static boolean isTcpPortFree(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

