/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.util.FormValidation;
import hudson.util.Secret;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class JenkinsMatchers {
    public static Matcher<Class<?>> privateConstructorThrows(Class<? extends Throwable> cause) {
        return new PrivateConstructorThrows(cause);
    }

    public static Matcher<FormValidation> causedBy(Class<? extends Throwable> cause) {
        return new FormValidationCauseMatcher(cause);
    }

    public static Matcher<FormValidation> hasKind(FormValidation.Kind kind) {
        return new FormValidationKindMatcher(kind);
    }

    public static Matcher<Class<?>> isUtilityClass() {
        return Matchers.allOf(JenkinsMatchers.isFinalClass(), JenkinsMatchers.isClassWithOnlyPrivateConstructors());
    }

    public static Matcher<Class<?>> isClassWithOnlyPrivateConstructors() {
        return new IsClassWithOnlyPrivateConstructors();
    }

    public static Matcher<Class<?>> isFinalClass() {
        return new IsFinalClass();
    }

    public static Matcher<Class<?>> hasDefaultConstructor() {
        return new HasDefaultConstructor();
    }

    public static Matcher<Throwable> hasCause(Class<? extends Throwable> cause) {
        return new HasCause(cause);
    }

    public static Matcher<Object> hasImplementedEquals() {
        return new HasImplementedEquals();
    }

    public static Matcher<Object> hasReflexiveEquals() {
        return new HasReflexiveEquals();
    }

    public static Matcher<Object> hasNonEqualityWithNulls() {
        return new HasNonNullEquals();
    }

    public static Matcher<Object> hasSymmetricEquals(Object other) {
        return new HasSymmetricEquals(other);
    }

    public static Matcher<Object> hasConsistentEquals(Object other) {
        return new HasConsistentEquals(other);
    }

    public static Matcher<Object> hasTransitiveEquals(Object a, Object b) {
        return new HasTransitiveEquals(a, b);
    }

    public static Matcher<Object> hasImplementedHashCode() {
        return new HasImplementedHashCode();
    }

    public static Matcher<Object> hasHashCodeContract(Object other) {
        return new HasHashCodeContract(other);
    }

    public static Matcher<Secret> hasPlainText(Matcher<? super String> matcher) {
        return new HasPlainText(matcher);
    }

    public static Matcher<Secret> hasPlainText(String expected) {
        return new HasPlainText((Matcher<? super String>)Matchers.equalTo((Object)expected));
    }

    public static Matcher<String> matchesPattern(String pattern) {
        return new MatchesPattern(Pattern.compile(pattern));
    }

    private static class MatchesPattern
    extends TypeSafeMatcher<String> {
        private final Pattern pattern;

        private MatchesPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        protected boolean matchesSafely(String item) {
            return this.pattern.matcher(item).find();
        }

        public void describeTo(Description description) {
            description.appendText("matches pattern ").appendText(this.pattern.pattern());
        }
    }

    private static class HasPlainText
    extends FeatureMatcher<Secret, String> {
        private HasPlainText(Matcher<? super String> matcher) {
            super(matcher, "has plain text", "has plain text");
        }

        protected String featureValueOf(Secret actual) {
            return actual.getPlainText();
        }
    }

    private static class HasHashCodeContract
    extends BaseMatcher<Object> {
        private final Object other;

        public HasHashCodeContract(Object other) {
            this.other = other;
        }

        public boolean matches(Object o) {
            return o == null ? this.other == null : !o.equals(this.other) || o.hashCode() == this.other.hashCode();
        }

        public void describeTo(Description description) {
            description.appendText("follows the hashCode contract when compared to ");
            description.appendValue(this.other);
        }
    }

    private static class HasTransitiveEquals
    extends BaseMatcher<Object> {
        private final Object a;
        private final Object b;

        public HasTransitiveEquals(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public boolean matches(Object o) {
            return o != null && (!o.equals(this.a) || !this.a.equals(this.b) || o.equals(this.b));
        }

        public void describeTo(Description description) {
            description.appendText("has a transitive equals(Object) method with ");
            description.appendValue(this.a);
            description.appendText(" and ");
            description.appendValue(this.b);
        }
    }

    private static class HasConsistentEquals
    extends BaseMatcher<Object> {
        private final Object other;

        public HasConsistentEquals(Object other) {
            this.other = other;
        }

        public boolean matches(Object o) {
            return o == null ? this.other == null : (o.equals(this.other) ? o.equals(this.other) : !o.equals(this.other));
        }

        public void describeTo(Description description) {
            description.appendText("has a symmetric equals(Object) method with ");
            description.appendValue(this.other);
        }
    }

    private static class HasSymmetricEquals
    extends BaseMatcher<Object> {
        private final Object other;

        public HasSymmetricEquals(Object other) {
            this.other = other;
        }

        public boolean matches(Object o) {
            return o == null ? this.other == null : (o.equals(this.other) ? this.other.equals(o) : !this.other.equals(o));
        }

        public void describeTo(Description description) {
            description.appendText("has a symmetric equals(Object) method with ");
            description.appendValue(this.other);
        }
    }

    private static class HasReflexiveEquals
    extends BaseMatcher<Object> {
        private HasReflexiveEquals() {
        }

        public boolean matches(Object o) {
            return o != null && o.equals(o);
        }

        public void describeTo(Description description) {
            description.appendText("has a reflexive equals(Object) method");
        }
    }

    private static class HasNonNullEquals
    extends BaseMatcher<Object> {
        private HasNonNullEquals() {
        }

        public boolean matches(Object o) {
            return o != null && !o.equals(null);
        }

        public void describeTo(Description description) {
            description.appendText("has an equals(Object) method that returns false for null");
        }
    }

    private static class HasCause
    extends BaseMatcher<Throwable> {
        private final Class<? extends Throwable> cause;

        public HasCause(Class<? extends Throwable> cause) {
            this.cause = cause;
        }

        public boolean matches(Object item) {
            Throwable throwable;
            for (throwable = (Throwable)item; throwable != null && !this.cause.isInstance(throwable); throwable = throwable.getCause()) {
            }
            return this.cause.isInstance(throwable);
        }

        public void describeTo(Description description) {
            description.appendText("was caused by a ").appendValue(this.cause).appendText(" being thrown");
        }
    }

    private static class IsFinalClass
    extends BaseMatcher<Class<?>> {
        private IsFinalClass() {
        }

        public boolean matches(Object item) {
            Class clazz = (Class)item;
            return Modifier.isFinal(clazz.getModifiers());
        }

        public void describeTo(Description description) {
            description.appendText("a final class");
        }
    }

    private static class IsClassWithOnlyPrivateConstructors
    extends BaseMatcher<Class<?>> {
        private IsClassWithOnlyPrivateConstructors() {
        }

        public boolean matches(Object item) {
            Class clazz = (Class)item;
            for (Constructor<?> c : clazz.getConstructors()) {
                if (Modifier.isPrivate(c.getModifiers())) continue;
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("a class with only private constructors");
        }
    }

    private static class HasImplementedHashCode
    extends BaseMatcher<Object> {
        private HasImplementedHashCode() {
        }

        public boolean matches(Object item) {
            if (item == null) {
                return false;
            }
            Class<?> clazz = item instanceof Class ? (Class<?>)item : item.getClass();
            try {
                return !clazz.getMethod("hashCode", new Class[0]).equals(Object.class.getMethod("hashCode", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("has overridden the default hashCode() method");
        }
    }

    private static class HasImplementedEquals
    extends BaseMatcher<Object> {
        private HasImplementedEquals() {
        }

        public boolean matches(Object item) {
            if (item == null) {
                return false;
            }
            Class<?> clazz = item instanceof Class ? (Class<?>)item : item.getClass();
            try {
                return !clazz.getMethod("equals", Object.class).equals(Object.class.getMethod("equals", Object.class));
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("has overridden the default equals(Object) method");
        }
    }

    private static class HasDefaultConstructor
    extends BaseMatcher<Class<?>> {
        private HasDefaultConstructor() {
        }

        public boolean matches(Object item) {
            Class clazz = (Class)item;
            try {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                return Modifier.isPublic(constructor.getModifiers());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        public void describeTo(Description description) {
            description.appendText("a class with the default constructor");
        }
    }

    private static class FormValidationKindMatcher
    extends BaseMatcher<FormValidation> {
        private final FormValidation.Kind kind;

        public FormValidationKindMatcher(FormValidation.Kind kind) {
            kind.getClass();
            this.kind = kind;
        }

        public boolean matches(Object o) {
            FormValidation v = (FormValidation)o;
            return v.kind == this.kind;
        }

        public void describeTo(Description description) {
            description.appendText("of kind ");
            description.appendValue((Object)this.kind);
        }
    }

    private static class FormValidationCauseMatcher
    extends BaseMatcher<FormValidation> {
        private final Class<? extends Throwable> cause;

        public FormValidationCauseMatcher(Class<? extends Throwable> cause) {
            cause.getClass();
            this.cause = cause;
        }

        public boolean matches(Object o) {
            FormValidation v = (FormValidation)o;
            return v.getMessage().contains(this.cause.getName());
        }

        public void describeTo(Description description) {
            description.appendText("caused by ");
            description.appendValue(this.cause);
        }
    }

    private static class PrivateConstructorThrows
    extends BaseMatcher<Class<?>> {
        private final Class<? extends Throwable> cause;

        public PrivateConstructorThrows(Class<? extends Throwable> cause) {
            this.cause = cause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean matches(Object o) {
            Class clazz = (Class)o;
            try {
                Constructor c = clazz.getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPrivate(c.getModifiers())) {
                    return false;
                }
                boolean accessible = c.isAccessible();
                try {
                    c.setAccessible(true);
                    c.newInstance(new Object[0]);
                    return false;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e;
                    while (t != null) {
                        if (this.cause.isInstance(t)) {
                            boolean bl = true;
                            return bl;
                        }
                        t = ((Throwable)t).getCause();
                    }
                    return false;
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    return false;
                }
                finally {
                    c.setAccessible(accessible);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("with a private constructor that throws ");
            description.appendValue(this.cause);
        }
    }
}

