/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.CloseProofOutputStream;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.Launcher;
import hudson.Main;
import hudson.PluginManager;
import hudson.Util;
import hudson.WebAppMain;
import hudson.console.AnnotatedLargeText;
import hudson.init.InitMilestone;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DownloadService;
import hudson.model.Executor;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.UpdateSite;
import hudson.model.UserProperty;
import hudson.model.View;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.WorkUnit;
import hudson.remoting.Callable;
import hudson.remoting.Which;
import hudson.security.ACL;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.csrf.CrumbIssuer;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tools.ToolProperty;
import hudson.util.PersistedList;
import hudson.util.ReflectionUtils;
import hudson.util.StreamTaskListener;
import hudson.util.jna.GNUCLibrary;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.management.ThreadInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsAdaptor;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.security.ApiTokenProperty;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.AjaxController;
import org.htmlunit.DefaultCssErrorHandler;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.FailingHttpStatusCodeException;
import org.htmlunit.HttpMethod;
import org.htmlunit.Page;
import org.htmlunit.PageCreator;
import org.htmlunit.WebClientUtil;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.WebResponseListener;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextFactory;
import org.htmlunit.corejs.javascript.debug.Debugger;
import org.htmlunit.cssparser.parser.CSSErrorHandler;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSParseException;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomNodeUtil;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlElementUtil;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlFormUtil;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.host.xml.XMLHttpRequest;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.WebResponseWrapper;
import org.htmlunit.xml.XmlPage;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;
import org.jvnet.hudson.test.ClosureExecuterAction;
import org.jvnet.hudson.test.DeltaSupportLogFormatter;
import org.jvnet.hudson.test.EndOfTestListener;
import org.jvnet.hudson.test.FakeLauncher;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonPageCreator;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.JavaNetReverseProxy;
import org.jvnet.hudson.test.JenkinsComputerConnectorTester;
import org.jvnet.hudson.test.JenkinsRecipe;
import org.jvnet.hudson.test.LenientRunnable;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.MockFolder;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.PretendSlave;
import org.jvnet.hudson.test.RandomlyFails;
import org.jvnet.hudson.test.SimpleCommandLauncher;
import org.jvnet.hudson.test.TestCrumbIssuer;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.TestPluginManager;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.WithoutJenkins;
import org.jvnet.hudson.test.recipes.WithTimeout;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JenkinsRule
implements TestRule,
MethodRule,
RootAction {
    protected TestEnvironment env;
    protected Description testDescription;
    @Deprecated
    public Hudson hudson;
    public Jenkins jenkins;
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    public String contextPath = "/jenkins";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();
    protected List<JenkinsRecipe.Runner> recipes = new ArrayList<JenkinsRecipe.Runner>();
    private List<WebClient> clients = new ArrayList<WebClient>();
    protected JavaScriptDebugger jsDebugger = new JavaScriptDebugger();
    @Deprecated
    public boolean useLocalPluginManager;
    public int timeout = Integer.getInteger("jenkins.test.timeout", new DisableOnDebug(null).isDebugging() ? 0 : 180);
    private PluginManager pluginManager = TestPluginManager.INSTANCE;
    public JenkinsComputerConnectorTester computerConnectorTester = new JenkinsComputerConnectorTester(this);
    private boolean origDefaultUseCache = true;
    private static final Logger XML_HTTP_REQUEST_LOGGER = Logger.getLogger(XMLHttpRequest.class.getName());
    private static final Logger SPRING_LOGGER = Logger.getLogger("org.springframework");
    private static final Logger LOGGER;
    public static final List<ToolProperty<?>> NO_PROPERTIES;
    public static final int SLAVE_DEBUG_PORT;
    public static final MimeTypes MIME_TYPES;

    public Jenkins getInstance() {
        return this.jenkins;
    }

    public void before() throws Throwable {
        RandomlyFails rf;
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            h.setFormatter((Formatter)((Object)new DeltaSupportLogFormatter()));
        }
        if (Thread.interrupted()) {
            LOGGER.warning("was interrupted before start");
        }
        if (Functions.isWindows()) {
            URLConnection aConnection = new File(".").toURI().toURL().openConnection();
            this.origDefaultUseCache = aConnection.getDefaultUseCaches();
            aConnection.setDefaultUseCaches(false);
        }
        if (Boolean.getBoolean("ignore.random.failures") && (rf = (RandomlyFails)this.testDescription.getAnnotation(RandomlyFails.class)) != null) {
            throw new AssumptionViolatedException("Known to randomly fail: " + rf.value());
        }
        this.env = new TestEnvironment(this.testDescription);
        this.env.pin();
        this.recipe();
        AbstractProject.WORKSPACE.toString();
        hudson.model.User.clear();
        try {
            Field theInstance = Jenkins.class.getDeclaredField("theInstance");
            theInstance.setAccessible(true);
            if (theInstance.get(null) != null) {
                LOGGER.warning("Jenkins.theInstance was not cleared by a previous test, doing that now");
                theInstance.set(null, null);
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        try {
            this.hudson = this.newHudson();
            this.jenkins = this.hudson;
            if (this.jenkins.getInitLevel() != InitMilestone.COMPLETED) {
                throw new Exception("Jenkins initialization has not reached the COMPLETED initialization stage. Current state is " + this.jenkins.getInitLevel() + ". Likely there is an issue with the Initialization task graph (e.g. usage of @Initializer(after = InitMilestone.COMPLETED)). See JENKINS-37759 for more info");
            }
        }
        catch (Exception e) {
            Field f = Jenkins.class.getDeclaredField("theInstance");
            f.setAccessible(true);
            f.set(null, null);
            throw e;
        }
        this.jenkins.setCrumbIssuer((CrumbIssuer)new TestCrumbIssuer());
        JenkinsRule._configureJenkinsForTest(this.jenkins);
        this.configureUpdateCenter();
        this.jenkins.getActions().add(this);
        JenkinsLocationConfiguration.get().setUrl(this.getURL().toString());
    }

    public static void _configureJenkinsForTest(Jenkins jenkins) throws Exception {
        jenkins.setNoUsageStatistics(Boolean.valueOf(true));
        jenkins.servletContext.setAttribute("app", (Object)jenkins);
        jenkins.servletContext.setAttribute("version", (Object)"?");
        WebAppMain.installExpressionFactory((ServletContextEvent)new ServletContextEvent(jenkins.servletContext));
        jenkins.getJDKs().add(new JDK("default", System.getProperty("java.home")));
    }

    static void dumpThreads() {
        ThreadInfo[] threadInfos = Functions.getThreadInfos();
        Functions.ThreadGroupMap m = Functions.sortThreadsAndGetGroupMap((ThreadInfo[])threadInfos);
        for (ThreadInfo ti : threadInfos) {
            System.err.println(Functions.dumpThreadInfo((ThreadInfo)ti, (Functions.ThreadGroupMap)m));
        }
    }

    protected void configureUpdateCenter() throws Exception {
        JenkinsRule._configureUpdateCenter(this.jenkins);
    }

    public static void _configureUpdateCenter(Jenkins jenkins) throws Exception {
        String updateCenterUrl;
        JenkinsRule.jettyLevel(Level.WARNING);
        try {
            updateCenterUrl = "http://localhost:" + JavaNetReverseProxy.getInstance().localPort + "/update-center.json";
        }
        finally {
            JenkinsRule.jettyLevel(Level.INFO);
        }
        DownloadService.neverUpdate = true;
        UpdateSite.neverUpdate = true;
        PersistedList sites = jenkins.getUpdateCenter().getSites();
        sites.clear();
        sites.add((Object)new UpdateSite("default", updateCenterUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after() throws Exception {
        try {
            if (this.jenkins != null) {
                for (EndOfTestListener tl : this.jenkins.getExtensionList(EndOfTestListener.class)) {
                    tl.onTearDown();
                }
            }
            for (WebClient client : this.clients) {
                if (client.getJavaScriptEngine() != null) {
                    WebClientUtil.waitForJSExec(client);
                }
                try {
                    WebClient webClient = client;
                    try {
                        if (client.getCurrentWindow() == null) continue;
                        client.getPage("about:blank");
                    }
                    finally {
                        if (webClient == null) continue;
                        webClient.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            this.clients.clear();
        }
        finally {
            JenkinsRule._stopJenkins(this.server, this.tearDowns, this.jenkins);
            System.gc();
            try (SetConsoleLogger ignored = new SetConsoleLogger("hudson.XmlFile", Level.FINEST);){
                this.env.dispose();
            }
            finally {
                if (Functions.isWindows()) {
                    URLConnection aConnection = new File(".").toURI().toURL().openConnection();
                    aConnection.setDefaultUseCaches(this.origDefaultUseCache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _stopJenkins(Server server, List<LenientRunnable> tearDowns, Jenkins jenkins) {
        RuntimeException exception = new RuntimeException("One or more problems while shutting down Jenkins");
        JenkinsRule.jettyLevel(Level.WARNING);
        try {
            server.stop();
        }
        catch (Exception e) {
            exception.addSuppressed(e);
        }
        finally {
            JenkinsRule.jettyLevel(Level.INFO);
        }
        if (tearDowns != null) {
            for (LenientRunnable r : tearDowns) {
                try {
                    r.run();
                }
                catch (Exception e) {
                    exception.addSuppressed(e);
                }
            }
        }
        if (jenkins != null) {
            jenkins.cleanUp();
        }
        ExtensionList.clearLegacyInstances();
        DescriptorExtensionList.clearLegacyInstances();
        if (exception.getSuppressed().length > 0) {
            throw exception;
        }
    }

    private static void jettyLevel(Level level) {
        Logger.getLogger("org.eclipse.jetty").setLevel(level);
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return this.apply(base, Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)method.getName(), (Annotation[])method.getAnnotations()));
    }

    public Statement apply(final Statement base, final Description description) {
        if (description.getAnnotation(WithoutJenkins.class) != null) {
            return base;
        }
        Statement wrapped = new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                JenkinsRule.this.testDescription = description;
                Thread t = Thread.currentThread();
                String o = t.getName();
                t.setName("Executing " + JenkinsRule.this.testDescription.getDisplayName());
                System.out.println("=== Starting " + JenkinsRule.this.testDescription.getDisplayName());
                JenkinsRule.this.before();
                Throwable testFailure = null;
                try {
                    ACL.impersonate((Authentication)ACL.SYSTEM);
                    try {
                        base.evaluate();
                    }
                    catch (Throwable th) {
                        testFailure = th;
                        try {
                            throw new BreakException();
                        }
                        catch (BreakException breakException) {
                            RandomlyFails rf = (RandomlyFails)JenkinsRule.this.testDescription.getAnnotation(RandomlyFails.class);
                            if (rf != null) {
                                System.err.println("Note: known to randomly fail: " + rf.value());
                            }
                            throw th;
                        }
                    }
                }
                finally {
                    try {
                        JenkinsRule.this.after();
                    }
                    catch (Exception e) {
                        if (testFailure != null) {
                            testFailure.addSuppressed(e);
                            throw testFailure;
                        }
                        throw e;
                    }
                    finally {
                        JenkinsRule.this.testDescription = null;
                        t.setName(o);
                    }
                }
            }
        };
        final int testTimeout = this.getTestTimeoutOverride(description);
        if (testTimeout <= 0) {
            System.out.println("Test timeout disabled.");
            return wrapped;
        }
        final Statement timeoutStatement = Timeout.seconds((long)testTimeout).apply(wrapped, description);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    timeoutStatement.evaluate();
                }
                catch (TestTimedOutException x) {
                    LOGGER.warning(String.format("Test timed out (after %d seconds).", testTimeout));
                    JenkinsRule.dumpThreads();
                    throw x;
                }
            }
        };
    }

    private int getTestTimeoutOverride(Description description) {
        WithTimeout withTimeout = (WithTimeout)description.getAnnotation(WithTimeout.class);
        return withTimeout != null ? withTimeout.value() : this.timeout;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "self";
    }

    protected Hudson newHudson() throws Exception {
        JenkinsRule.jettyLevel(Level.WARNING);
        ServletContext webServer = this.createWebServer();
        File home = this.homeLoader.allocate();
        for (JenkinsRecipe.Runner r : this.recipes) {
            r.decorateHome(this, home);
        }
        try {
            Hudson hudson = new Hudson(home, webServer, this.getPluginManager());
            return hudson;
        }
        catch (InterruptedException x) {
            throw new AssumptionViolatedException("Jenkins startup interrupted", (Throwable)x);
        }
        finally {
            JenkinsRule.jettyLevel(Level.INFO);
        }
    }

    public PluginManager getPluginManager() {
        if (this.jenkins == null) {
            return this.useLocalPluginManager ? null : this.pluginManager;
        }
        return this.jenkins.getPluginManager();
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.useLocalPluginManager = false;
        this.pluginManager = pluginManager;
        if (this.jenkins != null) {
            throw new IllegalStateException("Too late to override the plugin manager");
        }
    }

    public JenkinsRule with(PluginManager pluginManager) {
        this.setPluginManager(pluginManager);
        return this;
    }

    public File getWebAppRoot() throws Exception {
        return WarExploder.getExplodedDir();
    }

    protected ServletContext createWebServer() throws Exception {
        return this.createWebServer(null);
    }

    protected ServletContext createWebServer(@CheckForNull BiConsumer<WebAppContext, Server> contextAndServerConsumer) throws Exception {
        this.server = JenkinsRule._createWebServer(this.contextPath, x -> {
            this.localPort = x;
        }, this.getClass().getClassLoader(), this.localPort, this::configureUserRealm, contextAndServerConsumer);
        LOGGER.log(Level.INFO, "Running on {0}", this.getURL());
        return ((ContextHandler)this.server.getChildHandlerByClass(ContextHandler.class)).getServletContext();
    }

    public static Server _createWebServer(String contextPath, Consumer<Integer> portSetter, ClassLoader classLoader, int localPort, Supplier<LoginService> loginServiceSupplier) throws Exception {
        return JenkinsRule._createWebServer(contextPath, portSetter, classLoader, localPort, loginServiceSupplier, null);
    }

    public static Server _createWebServer(String contextPath, Consumer<Integer> portSetter, ClassLoader classLoader, int localPort, Supplier<LoginService> loginServiceSupplier, @CheckForNull BiConsumer<WebAppContext, Server> contextAndServerConsumer) throws Exception {
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setName("Jetty (JenkinsRule)");
        Server server = new Server((ThreadPool)qtp);
        WebAppContext context = new WebAppContext(WarExploder.getExplodedDir().getPath(), contextPath);
        context.setClassLoader(classLoader);
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        context.addBean((Object)new NoListenerConfiguration(context));
        server.setHandler((org.eclipse.jetty.server.Handler)context);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)context, null);
        context.setMimeTypes(MIME_TYPES);
        context.getSecurityHandler().setLoginService(loginServiceSupplier.get());
        context.setResourceBase(WarExploder.getExplodedDir().getPath());
        ServerConnector connector = new ServerConnector(server);
        HttpConfiguration config = ((HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
        config.setRequestHeaderSize(12288);
        config.setHttpCompliance(HttpCompliance.RFC7230);
        config.setUriCompliance(UriCompliance.LEGACY);
        connector.setHost("localhost");
        if (System.getProperty("port") != null) {
            connector.setPort(Integer.parseInt(System.getProperty("port")));
        } else if (localPort != 0) {
            connector.setPort(localPort);
        }
        server.addConnector((Connector)connector);
        if (contextAndServerConsumer != null) {
            contextAndServerConsumer.accept(context, server);
        }
        server.start();
        portSetter.accept(connector.getLocalPort());
        return server;
    }

    protected LoginService configureUserRealm() {
        return JenkinsRule._configureUserRealm();
    }

    public static LoginService _configureUserRealm() {
        HashLoginService realm = new HashLoginService();
        realm.setName("default");
        UserStore userStore = new UserStore();
        realm.setUserStore(userStore);
        userStore.addUser("alice", (Credential)new Password("alice"), new String[]{"user", "female"});
        userStore.addUser("bob", (Credential)new Password("bob"), new String[]{"user", "male"});
        userStore.addUser("charlie", (Credential)new Password("charlie"), new String[]{"user", "male"});
        return realm;
    }

    public <T extends TopLevelItem> T createProject(Class<T> type, String name) throws IOException {
        return (T)this.jenkins.createProject(type, name);
    }

    public <T extends TopLevelItem> T createProject(Class<T> type) throws IOException {
        return (T)this.jenkins.createProject(type, this.createUniqueProjectName());
    }

    public FreeStyleProject createFreeStyleProject() throws IOException {
        return this.createFreeStyleProject(this.createUniqueProjectName());
    }

    public FreeStyleProject createFreeStyleProject(String name) throws IOException {
        return this.createProject(FreeStyleProject.class, name);
    }

    public MockFolder createFolder(String name) throws IOException {
        return this.createProject(MockFolder.class, name);
    }

    protected String createUniqueProjectName() {
        return "test" + this.jenkins.getItems().size();
    }

    public Launcher.LocalLauncher createLocalLauncher() {
        return new Launcher.LocalLauncher((TaskListener)StreamTaskListener.fromStdout());
    }

    @Deprecated
    public File createTmpDir() throws IOException {
        return this.env.temporaryDirectoryAllocator.allocate();
    }

    @NonNull
    public DumbSlave createSlave(boolean waitForChannelConnect) throws Exception {
        DumbSlave slave = this.createSlave();
        if (waitForChannelConnect) {
            long start = System.currentTimeMillis();
            while (slave.getChannel() == null) {
                if (System.currentTimeMillis() > start + 10000L) {
                    throw new IllegalStateException("Timed out waiting on DumbSlave channel to connect.");
                }
                Thread.sleep(200L);
            }
        }
        return slave;
    }

    public void disconnectSlave(DumbSlave slave) throws Exception {
        slave.getComputer().disconnect((OfflineCause)new OfflineCause.ChannelTermination(new Exception("terminate")));
        long start = System.currentTimeMillis();
        while (slave.getChannel() != null) {
            if (System.currentTimeMillis() > start + 10000L) {
                throw new IllegalStateException("Timed out waiting on DumbSlave channel to disconnect.");
            }
            Thread.sleep(200L);
        }
    }

    @NonNull
    public DumbSlave createSlave() throws Exception {
        return this.createSlave("", null);
    }

    @NonNull
    public DumbSlave createSlave(@CheckForNull Label l) throws Exception {
        return this.createSlave(l, null);
    }

    public DummySecurityRealm createDummySecurityRealm() {
        return new DummySecurityRealm();
    }

    public URL getURL() throws IOException {
        return new URL("http://localhost:" + this.localPort + this.contextPath + "/");
    }

    @NonNull
    public DumbSlave createSlave(@CheckForNull EnvVars env) throws Exception {
        return this.createSlave("", env);
    }

    @NonNull
    public DumbSlave createSlave(@CheckForNull Label l, @CheckForNull EnvVars env) throws Exception {
        return this.createSlave(l == null ? null : l.getExpression(), env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public DumbSlave createSlave(@CheckForNull String labels, @CheckForNull EnvVars env) throws Exception {
        Jenkins jenkins = this.jenkins;
        synchronized (jenkins) {
            int sz = this.jenkins.getNodes().size();
            return this.createSlave("slave" + sz, labels, env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public DumbSlave createSlave(@NonNull String nodeName, @CheckForNull String labels, @CheckForNull EnvVars env) throws Exception {
        Jenkins jenkins = this.jenkins;
        synchronized (jenkins) {
            DumbSlave slave = new DumbSlave(nodeName, new File(this.jenkins.getRootDir(), "agent-work-dirs/" + nodeName).getAbsolutePath(), this.createComputerLauncher(env));
            if (labels != null) {
                slave.setLabelString(labels);
            }
            slave.setRetentionStrategy(RetentionStrategy.NOOP);
            this.jenkins.addNode((hudson.model.Node)slave);
            return slave;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PretendSlave createPretendSlave(FakeLauncher faker) throws Exception {
        Jenkins jenkins = this.jenkins;
        synchronized (jenkins) {
            int sz = this.jenkins.getNodes().size();
            String nodeName = "slave" + sz;
            PretendSlave slave = new PretendSlave(nodeName, new File(this.jenkins.getRootDir(), "agent-work-dirs/" + nodeName).getAbsolutePath(), "", this.createComputerLauncher(null), faker);
            this.jenkins.addNode((hudson.model.Node)slave);
            return slave;
        }
    }

    @NonNull
    public ComputerLauncher createComputerLauncher(@CheckForNull EnvVars env) throws URISyntaxException, IOException {
        int sz = this.jenkins.getNodes().size();
        return new SimpleCommandLauncher(String.format("\"%s/bin/java\" %s %s -Xmx512m -XX:+PrintCommandLineFlags -jar \"%s\"", System.getProperty("java.home"), SLAVE_DEBUG_PORT > 0 ? " -Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=" + (SLAVE_DEBUG_PORT + sz) : "", "-Djava.awt.headless=true", new File(this.jenkins.getJnlpJars("slave.jar").getURL().toURI()).getAbsolutePath()), env);
    }

    @NonNull
    public DumbSlave createOnlineSlave() throws Exception {
        return this.createOnlineSlave(null);
    }

    @NonNull
    public DumbSlave createOnlineSlave(@CheckForNull Label l) throws Exception {
        return this.createOnlineSlave(l, null);
    }

    @NonNull
    public DumbSlave createOnlineSlave(@CheckForNull Label l, @CheckForNull EnvVars env) throws Exception {
        DumbSlave s = this.createSlave(l, env);
        this.waitOnline((Slave)s);
        return s;
    }

    @NonNull
    public String createApiToken(@NonNull hudson.model.User user) {
        ApiTokenProperty apiTokenProperty = (ApiTokenProperty)user.getProperty(ApiTokenProperty.class);
        try {
            if (apiTokenProperty == null) {
                apiTokenProperty = new ApiTokenProperty();
                user.addProperty((UserProperty)apiTokenProperty);
            }
            String tokenRandomName = "TestToken_" + (int)Math.floor(Math.random() * 1000000.0);
            return apiTokenProperty.generateNewToken((String)tokenRandomName).plainValue;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnline(Slave s) throws Exception {
        Computer computer = s.toComputer();
        AtomicBoolean run = new AtomicBoolean(true);
        AnnotatedLargeText logText = computer.getLogText();
        Computer.threadPoolForRemoting.submit(() -> {
            long pos = 0L;
            while (run.get() && !logText.isComplete()) {
                pos = logText.writeLogTo(pos, (OutputStream)System.out);
                Thread.sleep(100L);
            }
            return null;
        });
        try {
            if (s.getLauncher().isLaunchSupported()) {
                LOGGER.info(() -> "Launching " + s.getNodeName() + "\u2026");
                computer.connect(false).get();
                LOGGER.info(() -> "\u2026finished launching " + s.getNodeName() + ".");
            } else {
                LOGGER.info(() -> "Waiting for " + s.getNodeName() + " to come online\u2026");
                while (!computer.isOnline()) {
                    Thread.sleep(100L);
                }
                LOGGER.info(() -> "\u2026" + s.getNodeName() + " is now online.");
            }
        }
        finally {
            run.set(false);
        }
    }

    public void showAgentLogs(Slave s, LoggerRule loggerRule) throws Exception {
        this.showAgentLogs(s, loggerRule.getRecordedLevels());
    }

    public void showAgentLogs(Slave s, Map<String, Level> loggers) throws Exception {
        s.getChannel().call((Callable)new RemoteLogDumper(s.getNodeName(), loggers, true));
    }

    public void interactiveBreak() throws Exception {
        System.out.println("Jenkins is running at " + this.getURL());
        new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())).readLine();
    }

    public <T> T last(List<T> items) {
        return items.get(items.size() - 1);
    }

    public void pause() throws IOException {
        new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())).readLine();
    }

    public Page search(String q) throws Exception {
        return new WebClient().search(q);
    }

    public JSONWebResponse getJSON(@NonNull String path) throws IOException {
        WebClient webClient = this.createWebClient();
        return webClient.getJSON(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONWebResponse postJSON(@NonNull String path, @NonNull Object json) throws IOException, SAXException {
        assert (!path.startsWith("/"));
        URL postUrl = new URL(this.getURL().toExternalForm() + path);
        HttpURLConnection conn = (HttpURLConnection)postUrl.openConnection();
        conn.setDoOutput(true);
        long startTime = System.currentTimeMillis();
        try {
            WebResponseData webResponseData;
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            NameValuePair crumb = this.getCrumbHeaderNVP();
            conn.setRequestProperty(crumb.getName(), crumb.getValue());
            byte[] content = json.toString().getBytes(StandardCharsets.UTF_8);
            conn.setRequestProperty("Content-Length", String.valueOf(content.length));
            try (OutputStream os = conn.getOutputStream();){
                os.write(content);
                os.flush();
            }
            try (InputStream responseStream = conn.getInputStream();){
                byte[] bytes = responseStream.readAllBytes();
                webResponseData = new WebResponseData(bytes, conn.getResponseCode(), conn.getResponseMessage(), this.extractHeaders(conn));
            }
            WebResponse webResponse = new WebResponse(webResponseData, postUrl, HttpMethod.POST, System.currentTimeMillis() - startTime);
            JSONWebResponse jSONWebResponse = new JSONWebResponse(webResponse);
            return jSONWebResponse;
        }
        finally {
            conn.disconnect();
        }
    }

    private List<NameValuePair> extractHeaders(HttpURLConnection conn) {
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        Set<Map.Entry<String, List<String>>> headerFields = conn.getHeaderFields().entrySet();
        for (Map.Entry<String, List<String>> headerField : headerFields) {
            String name = headerField.getKey();
            if (name == null) continue;
            List<String> values = headerField.getValue();
            for (String value : values) {
                if (value == null) continue;
                headers.add(new NameValuePair(name, value));
            }
        }
        return headers;
    }

    public void configRoundtrip() throws Exception {
        this.submit(this.createWebClient().goTo("configure").getFormByName("config"));
    }

    public <P extends Item> P configRoundtrip(P job) throws Exception {
        this.submit(this.createWebClient().getPage(job, "configure").getFormByName("config"));
        return job;
    }

    public <B extends Builder> B configRoundtrip(B before) throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        p.getBuildersList().add(before);
        this.configRoundtrip(p);
        return (B)((Builder)p.getBuildersList().get(before.getClass()));
    }

    public <P extends Publisher> P configRoundtrip(P before) throws Exception {
        FreeStyleProject p = this.createFreeStyleProject();
        p.getPublishersList().add(before);
        this.configRoundtrip(p);
        return (P)((Publisher)p.getPublishersList().get(before.getClass()));
    }

    public <C extends ComputerConnector> C configRoundtrip(C before) throws Exception {
        this.computerConnectorTester.connector = before;
        this.submit(this.createWebClient().goTo("self/computerConnectorTester/configure").getFormByName("config"));
        return (C)this.computerConnectorTester.connector;
    }

    public hudson.model.User configRoundtrip(hudson.model.User u) throws Exception {
        this.submit(this.createWebClient().goTo(u.getUrl() + "/configure").getFormByName("config"));
        return u;
    }

    public <N extends hudson.model.Node> N configRoundtrip(N node) throws Exception {
        this.submit(this.createWebClient().goTo("computer/" + node.getNodeName() + "/configure").getFormByName("config"));
        return (N)this.jenkins.getNode(node.getNodeName());
    }

    public <V extends View> V configRoundtrip(V view) throws Exception {
        this.submit(this.createWebClient().getPage(view, "configure").getFormByName("viewConfig"));
        return view;
    }

    public <C extends Cloud> C configRoundtrip(C cloud) throws Exception {
        Cloud cloudConfig = this.jenkins.getCloud(cloud.name);
        if (cloudConfig != null) {
            this.jenkins.clouds.remove((Object)cloudConfig);
        }
        this.jenkins.clouds.add(cloud);
        this.jenkins.save();
        this.submit(this.createWebClient().goTo("configureClouds/").getFormByName("config"));
        return (C)this.jenkins.getCloud(cloud.name);
    }

    public <R extends Run> R assertBuildStatus(Result status, R r) throws Exception {
        if (status == r.getResult()) {
            return r;
        }
        String msg = "unexpected build status; build log was:\n------\n" + JenkinsRule.getLog(r) + "\n------\n";
        MatcherAssert.assertThat((String)msg, (Object)r.getResult(), (Matcher)Matchers.is((Object)status));
        return r;
    }

    public <R extends Run> R assertBuildStatus(Result status, Future<? extends R> r) throws Exception {
        MatcherAssert.assertThat((String)"build was actually scheduled", r, (Matcher)Matchers.notNullValue());
        return (R)this.assertBuildStatus(status, (Run)r.get());
    }

    public boolean isGoodHttpStatus(int status) {
        if (400 <= status && status <= 417) {
            return false;
        }
        return 500 > status || status > 505;
    }

    public void assertGoodStatus(Page page) {
        MatcherAssert.assertThat((Object)this.isGoodHttpStatus(page.getWebResponse().getStatusCode()), (Matcher)Matchers.is((Object)true));
    }

    public <R extends Run> R assertBuildStatusSuccess(R r) throws Exception {
        this.assertBuildStatus(Result.SUCCESS, r);
        return r;
    }

    public <R extends Run> R assertBuildStatusSuccess(Future<? extends R> r) throws Exception {
        return this.assertBuildStatus(Result.SUCCESS, r);
    }

    @NonNull
    public <J extends Job<J, R>, R extends Run<J, R>> R buildAndAssertSuccess(@NonNull J job) throws Exception {
        return this.buildAndAssertStatus(Result.SUCCESS, job);
    }

    @NonNull
    public <J extends Job<J, R>, R extends Run<J, R>> R buildAndAssertStatus(@NonNull Result status, final @NonNull J job) throws Exception {
        QueueTaskFuture f = new ParameterizedJobMixIn<J, R>(){

            protected J asJob() {
                return job;
            }
        }.scheduleBuild2(0, new Action[0]);
        return this.assertBuildStatus(status, (Future<? extends R>)f);
    }

    @NonNull
    public FreeStyleBuild buildAndAssertSuccess(@NonNull FreeStyleProject job) throws Exception {
        return (FreeStyleBuild)this.assertBuildStatusSuccess((Future)job.scheduleBuild2(0));
    }

    public void assertLogContains(String substring, Run run) throws IOException {
        MatcherAssert.assertThat((Object)JenkinsRule.getLog(run), (Matcher)Matchers.containsString((String)substring));
    }

    public void assertLogNotContains(String substring, Run run) throws IOException {
        MatcherAssert.assertThat((Object)JenkinsRule.getLog(run), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)substring)));
    }

    public static String getLog(Run run) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            run.getLogText().writeLogTo(0L, (OutputStream)baos);
        }
        catch (FileNotFoundException x) {
            return "";
        }
        return baos.toString(run.getCharset());
    }

    public <R extends Run<?, ?>> R waitForCompletion(R r) throws InterruptedException {
        WorkUnit workUnit;
        Executor executor = r.getExecutor();
        if (executor != null && (workUnit = executor.getCurrentWorkUnit()) != null) {
            try {
                Queue.Executable r2 = (Queue.Executable)workUnit.context.future.get();
                Assert.assertSame(r, (Object)r2);
            }
            catch (ExecutionException x) {
                throw new RuntimeException(x);
            }
        }
        while (r.isLogUpdated()) {
            Thread.sleep(100L);
        }
        return r;
    }

    public <R extends Run<?, ?>> R waitForMessage(String message, R r) throws IOException, InterruptedException {
        while (!JenkinsRule.getLog(r).contains(message)) {
            if (!r.isLogUpdated()) {
                this.assertLogContains(message, r);
            }
            Thread.sleep(100L);
        }
        return r;
    }

    public void assertXPath(HtmlPage page, String xpath) {
        HtmlElement documentElement = page.getDocumentElement();
        Assert.assertNotNull((String)("There should be an object that matches XPath:" + xpath), DomNodeUtil.selectSingleNode((DomNode)documentElement, xpath));
    }

    public void assertXPath(DomNode page, String xpath) {
        List nodes = page.getByXPath(xpath);
        MatcherAssert.assertThat((String)("There should be an object that matches XPath:" + xpath), (Object)nodes.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    public void assertXPathValue(DomNode page, String xpath, String expectedValue) {
        Object node = page.getFirstByXPath(xpath);
        Assert.assertNotNull((String)"no node found", (Object)node);
        Assert.assertTrue((String)("the found object was not a Node " + xpath), (boolean)(node instanceof Node));
        Node n = (Node)node;
        String textString = n.getTextContent();
        Assert.assertEquals((String)("xpath value should match for " + xpath), (Object)expectedValue, (Object)textString);
    }

    public void assertXPathValueContains(DomNode page, String xpath, String needle) {
        Object node = page.getFirstByXPath(xpath);
        Assert.assertNotNull((String)"no node found", (Object)node);
        Assert.assertTrue((String)("the found object was not a Node " + xpath), (boolean)(node instanceof Node));
        Node n = (Node)node;
        String textString = n.getTextContent();
        MatcherAssert.assertThat((Object)textString, (Matcher)Matchers.containsString((String)needle));
    }

    public void assertXPathResultsContainText(DomNode page, String xpath, String needle) {
        List nodes = page.getByXPath(xpath);
        MatcherAssert.assertThat((String)"no nodes matching xpath found", (Object)nodes.isEmpty(), (Matcher)Matchers.is((Object)false));
        boolean found = false;
        for (Object o : nodes) {
            Node n;
            String textString;
            if (!(o instanceof Node) || (textString = (n = (Node)o).getTextContent()) == null || !textString.contains(needle)) continue;
            found = true;
            break;
        }
        MatcherAssert.assertThat((String)"needle found in haystack", (Object)found, (Matcher)Matchers.is((Object)true));
    }

    public void assertAllImageLoadSuccessfully(HtmlPage p) {
        for (HtmlImage img : DomNodeUtil.selectNodes((DomNode)p, "//IMG")) {
            try {
                Assert.assertEquals((String)("Failed to load " + img.getSrcAttribute()), (long)200L, (long)img.getWebResponse(true).getStatusCode());
            }
            catch (IOException e) {
                throw new AssertionError((Object)("Failed to load " + img.getSrcAttribute()));
            }
        }
    }

    public void assertStringContains(String message, String haystack, String needle) {
        MatcherAssert.assertThat((String)message, (Object)haystack, (Matcher)Matchers.containsString((String)needle));
    }

    public void assertStringContains(String haystack, String needle) {
        MatcherAssert.assertThat((Object)haystack, (Matcher)Matchers.containsString((String)needle));
    }

    public void assertHelpExists(final Class<? extends Describable> type, final String properties) throws Exception {
        this.executeOnServer(new java.util.concurrent.Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Descriptor d = JenkinsRule.this.jenkins.getDescriptor(type);
                WebClient wc = JenkinsRule.this.createWebClient();
                for (String property : JenkinsRule.this.listProperties(properties)) {
                    String url = d.getHelpFile(property);
                    MatcherAssert.assertThat((String)("Help file for the property " + property + " is missing on " + type), (Object)url, (Matcher)Matchers.notNullValue());
                    wc.goTo(url);
                }
                return null;
            }
        });
    }

    private List<String> listProperties(String properties) {
        CopyOnWriteArrayList<String> props = new CopyOnWriteArrayList<String>(properties.split(","));
        for (String p : props) {
            if (!p.startsWith("-")) continue;
            props.remove(p);
            props.remove(p.substring(1));
        }
        return props;
    }

    public HtmlPage submit(HtmlForm form) throws Exception {
        return (HtmlPage)HtmlFormUtil.submit(form);
    }

    public HtmlPage submit(HtmlForm form, String name) throws Exception {
        for (HtmlElement e : form.getElementsByTagName("button")) {
            HtmlElement p = (HtmlElement)e.getParentNode().getParentNode();
            if (p.getAttribute("name").equals(name) && HtmlElementUtil.hasClassName(p, "yui-submit-button")) {
                return (HtmlPage)HtmlElementUtil.click(e);
            }
            if (!e.getAttribute("name").equals(name)) continue;
            return (HtmlPage)HtmlFormUtil.submit(form, e);
        }
        throw new AssertionError((Object)("No such submit button with the name " + name));
    }

    public HtmlInput findPreviousInputElement(HtmlElement current, String name) {
        return (HtmlInput)DomNodeUtil.selectSingleNode((DomNode)current, "(preceding::input[@name='_." + name + "'])[last()]");
    }

    public HtmlButton getButtonByCaption(HtmlForm f, String s) {
        for (HtmlElement b : f.getElementsByTagName("button")) {
            if (!b.getTextContent().trim().equals(s)) continue;
            return (HtmlButton)b;
        }
        return null;
    }

    public TaskListener createTaskListener() {
        return new StreamTaskListener((OutputStream)new CloseProofOutputStream((OutputStream)System.out));
    }

    public void assertEqualBeans(Object lhs, Object rhs, String properties) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        MatcherAssert.assertThat((String)"LHS", (Object)lhs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"RHS", (Object)rhs, (Matcher)Matchers.notNullValue());
        for (String p : properties.split(",")) {
            Object rp;
            Object lp;
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)lhs, (String)p);
            if (pd == null) {
                try {
                    Field f = lhs.getClass().getField(p);
                    lp = f.get(lhs);
                    rp = f.get(rhs);
                }
                catch (NoSuchFieldException e) {
                    MatcherAssert.assertThat((String)("No such property " + p + " on " + lhs.getClass()), (Object)pd, (Matcher)Matchers.notNullValue());
                    return;
                }
            } else {
                lp = PropertyUtils.getProperty((Object)lhs, (String)p);
                rp = PropertyUtils.getProperty((Object)rhs, (String)p);
            }
            if (lp != null && rp != null && lp.getClass().isArray() && rp.getClass().isArray()) {
                int m = Array.getLength(lp);
                int n = Array.getLength(rp);
                MatcherAssert.assertThat((String)("Array length is different for property " + p), (Object)n, (Matcher)Matchers.is((Object)m));
                for (int i = 0; i < m; ++i) {
                    MatcherAssert.assertThat((String)(p + "[" + i + "] is different"), (Object)Array.get(rp, i), (Matcher)Matchers.is((Object)Array.get(lp, i)));
                }
                return;
            }
            MatcherAssert.assertThat((String)("Property " + p + " is different"), (Object)rp, (Matcher)Matchers.is((Object)lp));
        }
    }

    public void setQuietPeriod(int qp) {
        JenkinsAdaptor.setQuietPeriod(this.jenkins, qp);
    }

    public void assertEqualDataBoundBeans(Object lhs, Object rhs) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (lhs == null && rhs == null) {
            return;
        }
        if (lhs == null) {
            Assert.fail((String)("lhs is null while rhs=" + rhs));
        }
        if (rhs == null) {
            Assert.fail((String)("rhs is null while lhs=" + lhs));
        }
        Constructor<?> lc = this.findDataBoundConstructor(lhs.getClass());
        Constructor<?> rc = this.findDataBoundConstructor(rhs.getClass());
        MatcherAssert.assertThat((String)"Data bound constructor mismatch. Different type?", rc, (Matcher)Matchers.is(lc));
        String[] names = ClassDescriptor.loadParameterNames(lc);
        Class<?>[] types = lc.getParameterTypes();
        MatcherAssert.assertThat((Object)types.length, (Matcher)Matchers.is((Object)names.length));
        this.assertEqualProperties(lhs, rhs, names, types);
        Map<String, Class<?>> lprops = this.extractDataBoundSetterProperties(lhs.getClass());
        Map<String, Class<?>> rprops = this.extractDataBoundSetterProperties(rhs.getClass());
        MatcherAssert.assertThat((String)"Data bound setters mismatch. Different type?", lprops, (Matcher)Matchers.is(rprops));
        ArrayList<String> setterNames = new ArrayList<String>();
        ArrayList setterTypes = new ArrayList();
        for (Map.Entry<String, Class<?>> e : lprops.entrySet()) {
            setterNames.add(e.getKey());
            setterTypes.add(e.getValue());
        }
        this.assertEqualProperties(lhs, rhs, setterNames.toArray(new String[0]), setterTypes.toArray(new Class[0]));
    }

    private void assertEqualProperties(@NonNull Object lhs, @NonNull Object rhs, @NonNull String[] names, @NonNull Class<?>[] types) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList<String> primitiveProperties = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            Object lv = ReflectionUtils.getPublicProperty((Object)lhs, (String)names[i]);
            Object rv = ReflectionUtils.getPublicProperty((Object)rhs, (String)names[i]);
            if (lv != null && rv != null && Iterable.class.isAssignableFrom(types[i])) {
                Iterable lcol = (Iterable)lv;
                Iterable rcol = (Iterable)rv;
                Iterator ltr = lcol.iterator();
                Iterator rtr = rcol.iterator();
                while (ltr.hasNext() && rtr.hasNext()) {
                    Object litem = ltr.next();
                    Object ritem = rtr.next();
                    if (this.findDataBoundConstructor(litem.getClass()) != null) {
                        this.assertEqualDataBoundBeans(litem, ritem);
                        continue;
                    }
                    MatcherAssert.assertThat(ritem, (Matcher)Matchers.is(litem));
                }
                MatcherAssert.assertThat((String)("collection size mismatch between " + lhs + " and " + rhs), (Object)(ltr.hasNext() ^ rtr.hasNext()), (Matcher)Matchers.is((Object)false));
                continue;
            }
            if (this.findDataBoundConstructor(types[i]) != null || lv != null && this.findDataBoundConstructor(lv.getClass()) != null || rv != null && this.findDataBoundConstructor(rv.getClass()) != null) {
                this.assertEqualDataBoundBeans(lv, rv);
                continue;
            }
            primitiveProperties.add(names[i]);
        }
        if (!primitiveProperties.isEmpty()) {
            this.assertEqualBeans(lhs, rhs, Util.join(primitiveProperties, (String)","));
        }
    }

    @NonNull
    private Map<String, Class<?>> extractDataBoundSetterProperties(@NonNull Class<?> c) {
        HashMap ret = new HashMap();
        while (c != null) {
            for (Field field : c.getDeclaredFields()) {
                if (field.getAnnotation(DataBoundSetter.class) == null) continue;
                field.setAccessible(true);
                ret.put(field.getName(), field.getType());
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                AbstractMap.SimpleEntry<String, Class<?>> nameAndType = this.extractDataBoundSetter((Method)accessibleObject);
                if (nameAndType == null || ret.containsKey(nameAndType.getKey())) continue;
                ret.put(nameAndType.getKey(), nameAndType.getValue());
            }
            c = c.getSuperclass();
        }
        return ret;
    }

    @CheckForNull
    private AbstractMap.SimpleEntry<String, Class<?>> extractDataBoundSetter(@NonNull Method m) {
        if (!Modifier.isPublic(m.getModifiers())) {
            return null;
        }
        if (!m.getName().startsWith("set")) {
            return null;
        }
        if (m.getParameterTypes().length != 1) {
            return null;
        }
        if (!m.isAnnotationPresent(DataBoundSetter.class)) {
            return null;
        }
        return new AbstractMap.SimpleEntry(Introspector.decapitalize(m.getName().substring(3)), m.getParameterTypes()[0]);
    }

    public void assertEqualDataBoundBeans(List<?> lhs, List<?> rhs) throws Exception {
        MatcherAssert.assertThat((Object)rhs.size(), (Matcher)Matchers.is((Object)lhs.size()));
        for (int i = 0; i < lhs.size(); ++i) {
            this.assertEqualDataBoundBeans(lhs.get(i), rhs.get(i));
        }
    }

    public Constructor<?> findDataBoundConstructor(Class<?> c) {
        for (Constructor<?> m : c.getConstructors()) {
            if (m.getAnnotation(DataBoundConstructor.class) == null) continue;
            return m;
        }
        return null;
    }

    public <T extends Descriptor<?>> T get(Class<T> d) {
        return (T)this.jenkins.getDescriptorByType(d);
    }

    public boolean isSomethingHappening() {
        if (!this.jenkins.getQueue().isEmpty()) {
            return true;
        }
        for (Computer n : this.jenkins.getComputers()) {
            if (n.isIdle()) continue;
            return true;
        }
        return false;
    }

    public void waitUntilNoActivity() throws Exception {
        this.waitUntilNoActivityUpTo(Integer.MAX_VALUE);
    }

    public void waitUntilNoActivityUpTo(int timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        int streak = 0;
        do {
            Thread.sleep(10L);
            streak = this.isSomethingHappening() ? 0 : ++streak;
            if (streak <= 5) continue;
            return;
        } while (System.currentTimeMillis() - startTime <= (long)timeout);
        ArrayList<Queue.Executable> building = new ArrayList<Queue.Executable>();
        for (Computer c : this.jenkins.getComputers()) {
            for (Executor e : c.getExecutors()) {
                if (!e.isBusy()) continue;
                building.add(e.getCurrentExecutable());
            }
            for (Executor e : c.getOneOffExecutors()) {
                if (!e.isBusy()) continue;
                building.add(e.getCurrentExecutable());
            }
        }
        JenkinsRule.dumpThreads();
        throw new AssertionError((Object)String.format("Jenkins is still doing something after %dms: queue=%s building=%s", timeout, List.of(this.jenkins.getQueue().getItems()), building));
    }

    public void recipe() throws Exception {
        this.recipeLoadCurrentPlugin();
        try {
            for (Annotation a : this.testDescription.getAnnotations()) {
                JenkinsRecipe r = a.annotationType().getAnnotation(JenkinsRecipe.class);
                if (r == null) continue;
                JenkinsRecipe.Runner<?> runner = r.value().newInstance();
                this.recipes.add(runner);
                this.tearDowns.add(() -> runner.tearDown(this, a));
                runner.setup(this, a);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void recipeLoadCurrentPlugin() throws Exception {
        Enumeration<URL> jpls = this.getClass().getClassLoader().getResources("the.jpl");
        Enumeration<URL> hpls = this.getClass().getClassLoader().getResources("the.hpl");
        final ArrayList<URL> all = Collections.list(jpls);
        all.addAll(Collections.list(hpls));
        if (all.isEmpty()) {
            return;
        }
        this.recipes.add(new JenkinsRecipe.Runner(){

            @Override
            public void decorateHome(JenkinsRule testCase, File home) throws Exception {
                JenkinsRule.decorateHomeFor(home, all);
            }
        });
    }

    static void decorateHomeFor(File home, List<URL> all) throws Exception {
        ArrayList<Jpl> jpls = new ArrayList<Jpl>();
        for (URL hpl : all) {
            Jpl jpl = new Jpl(home, hpl);
            jpl.loadManifest();
            jpls.add(jpl);
        }
        for (Jpl jpl : jpls) {
            jpl.resolveDependencies(jpls);
        }
    }

    public JenkinsRule withNewHome() {
        return this.with(HudsonHomeLoader.NEW);
    }

    public JenkinsRule withExistingHome(File source) throws Exception {
        return this.with(new HudsonHomeLoader.CopyExisting(source));
    }

    public JenkinsRule withPresetData(String name) {
        name = "/" + (String)name + ".zip";
        URL res = this.getClass().getResource((String)name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + (String)name);
        }
        return this.with(new HudsonHomeLoader.CopyExisting(res));
    }

    public JenkinsRule with(HudsonHomeLoader homeLoader) {
        this.homeLoader = homeLoader;
        return this;
    }

    public <V> V executeOnServer(java.util.concurrent.Callable<V> c) throws Exception {
        return this.createWebClient().executeOnServer(c);
    }

    protected Object writeReplace() {
        throw new AssertionError((Object)("JenkinsRule " + this.testDescription.getDisplayName() + " is not supposed to be serialized"));
    }

    public WebClient createWebClient() {
        WebClient webClient = new WebClient();
        webClient.getOptions().setFetchPolyfillEnabled(true);
        return webClient;
    }

    public Description getTestDescription() {
        return this.testDescription;
    }

    private NameValuePair getCrumbHeaderNVP() {
        return new NameValuePair(this.jenkins.getCrumbIssuer().getDescriptor().getCrumbRequestField(), this.jenkins.getCrumbIssuer().getCrumb(null));
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        Dispatcher.TRACE = true;
        MetaClass.NO_CACHE = true;
        System.setProperty("jenkins.model.Jenkins.SHOW_STACK_TRACE", "true");
        File dir = new File("src/main/resources");
        if (dir.exists() && MetaClassLoader.debugLoader == null) {
            try {
                MetaClassLoader.debugLoader = new MetaClassLoader((ClassLoader)new URLClassLoader(new URL[]{dir.toURI().toURL()}));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        SPRING_LOGGER.setLevel(Level.WARNING);
        Main.isUnitTest = true;
        XML_HTTP_REQUEST_LOGGER.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return !record.getMessage().contains("XMLHttpRequest.getResponseHeader() was called before the response was available.");
            }
        });
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", "-1");
        LOGGER = Logger.getLogger(HudsonTestCase.class.getName());
        NO_PROPERTIES = List.of();
        SLAVE_DEBUG_PORT = Integer.getInteger(HudsonTestCase.class.getName() + ".slaveDebugPort", -1);
        JenkinsRule.jettyLevel(Level.WARNING);
        try {
            MIME_TYPES = new MimeTypes();
        }
        finally {
            JenkinsRule.jettyLevel(Level.INFO);
        }
        MIME_TYPES.addMimeMapping("js", "application/javascript");
        Functions.DEBUG_YUI = true;
        if (Functions.isGlibcSupported()) {
            try {
                GNUCLibrary.LIBC.unsetenv("MAVEN_OPTS");
                GNUCLibrary.LIBC.unsetenv("MAVEN_DEBUG_OPTS");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to cancel out MAVEN_OPTS", e);
            }
        }
    }

    public static class TestBuildWrapper
    extends BuildWrapper {
        public Result buildResultInTearDown;

        public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            return new BuildWrapper.Environment(){

                public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                    buildResultInTearDown = build.getResult();
                    return true;
                }
            };
        }

        @Extension
        public static class TestBuildWrapperDescriptor
        extends BuildWrapperDescriptor {
            public boolean isApplicable(AbstractProject<?, ?> project) {
                return true;
            }

            public BuildWrapper newInstance(StaplerRequest req, @NonNull JSONObject formData) {
                throw new UnsupportedOperationException();
            }

            @NonNull
            public String getDisplayName() {
                return "TestBuildWrapper";
            }
        }
    }

    public class WebClient
    extends org.htmlunit.WebClient {
        private static final long serialVersionUID = -7944895389154288881L;
        private List<WebResponseListener> webResponseListeners = new ArrayList<WebResponseListener>();

        public WebClient() {
            this.setPageCreator((PageCreator)HudsonPageCreator.INSTANCE);
            JenkinsRule.this.clients.add(this);
            this.setAjaxController(new AjaxController(){
                private static final long serialVersionUID = -76034615893907856L;

                public boolean processSynchron(HtmlPage page, WebRequest settings, boolean async) {
                    return false;
                }
            });
            this.setCssErrorHandler(new CSSErrorHandler(){
                final CSSErrorHandler defaultHandler = new DefaultCssErrorHandler();

                public void warning(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.warning(exception);
                    }
                }

                public void error(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.error(exception);
                    }
                }

                public void fatalError(CSSParseException exception) throws CSSException {
                    if (!this.ignore(exception)) {
                        this.defaultHandler.fatalError(exception);
                    }
                }

                private boolean ignore(CSSParseException exception) {
                    return exception.getURI().contains("/yui/");
                }
            });
            AbstractJavaScriptEngine javaScriptEngine = this.getJavaScriptEngine();
            if (javaScriptEngine instanceof JavaScriptEngine) {
                ((JavaScriptEngine)javaScriptEngine).getContextFactory().addListener(new ContextFactory.Listener(){

                    public void contextCreated(Context cx) {
                        if (cx.getDebugger() == null) {
                            cx.setDebugger((Debugger)JenkinsRule.this.jsDebugger, null);
                        }
                    }

                    public void contextReleased(Context cx) {
                    }
                });
            }
        }

        public void addWebResponseListener(WebResponseListener listener) {
            this.webResponseListeners.add(listener);
        }

        public WebResponse loadWebResponse(WebRequest webRequest) throws IOException {
            WebResponse webResponse = super.loadWebResponse(webRequest);
            if (!this.webResponseListeners.isEmpty()) {
                for (WebResponseListener listener : this.webResponseListeners) {
                    listener.onLoadWebResponse(webRequest, webResponse);
                }
            }
            return webResponse;
        }

        public WebClient login(String username, String password) throws Exception {
            return this.login(username, password, false);
        }

        public boolean isJavaScriptEnabled() {
            return this.getOptions().isJavaScriptEnabled();
        }

        public void setJavaScriptEnabled(boolean enabled) {
            this.getOptions().setJavaScriptEnabled(enabled);
        }

        public WebClient withJavaScriptEnabled(boolean enabled) {
            this.setJavaScriptEnabled(enabled);
            return this;
        }

        public boolean isThrowExceptionOnFailingStatusCode() {
            return this.getOptions().isThrowExceptionOnFailingStatusCode();
        }

        public void setThrowExceptionOnFailingStatusCode(boolean enabled) {
            this.getOptions().setThrowExceptionOnFailingStatusCode(enabled);
        }

        public WebClient withThrowExceptionOnFailingStatusCode(boolean enabled) {
            this.setThrowExceptionOnFailingStatusCode(enabled);
            return this;
        }

        public boolean isRedirectEnabled() {
            return this.getOptions().isRedirectEnabled();
        }

        public void setRedirectEnabled(boolean enabled) {
            this.getOptions().setRedirectEnabled(enabled);
        }

        public WebClient withRedirectEnabled(boolean enabled) {
            this.setRedirectEnabled(enabled);
            return this;
        }

        public WebClient login(String username, String password, boolean rememberMe) throws Exception {
            HtmlForm form;
            block2: {
                HtmlPage page = this.goTo("login");
                form = page.getFormByName("login");
                form.getInputByName("j_username").setValue(username);
                form.getInputByName("j_password").setValue(password);
                try {
                    form.getInputByName("remember_me").setChecked(rememberMe);
                }
                catch (ElementNotFoundException e) {
                    if ($assertionsDisabled || !rememberMe) break block2;
                    throw new AssertionError();
                }
            }
            HtmlFormUtil.submit(form, null);
            return this;
        }

        public WebClient login(String username) throws Exception {
            this.login(username, username);
            return this;
        }

        public <V> V executeOnServer(final java.util.concurrent.Callable<V> c) throws Exception {
            final Exception[] t = new Exception[1];
            final AtomicReference r = new AtomicReference();
            ClosureExecuterAction cea = (ClosureExecuterAction)JenkinsRule.this.jenkins.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
            UUID id = UUID.randomUUID();
            cea.add(id, new Runnable(){

                @Override
                public void run() {
                    try {
                        StaplerResponse rsp = Stapler.getCurrentResponse();
                        rsp.setStatus(200);
                        rsp.setContentType("text/html");
                        r.set(c.call());
                    }
                    catch (Exception e) {
                        t[0] = e;
                    }
                }
            });
            this.goTo("closures/?uuid=" + id);
            if (t[0] != null) {
                throw t[0];
            }
            return r.get();
        }

        public HtmlPage search(String q) throws IOException, SAXException {
            HtmlPage top = this.goTo("");
            HtmlForm search = top.getFormByName("search");
            search.getInputByName("q").setValue(q);
            return (HtmlPage)HtmlFormUtil.submit(search, null);
        }

        public HtmlPage getPage(Run r) throws IOException, SAXException {
            return this.getPage(r, "");
        }

        public HtmlPage getPage(Run r, String relative) throws IOException, SAXException {
            return this.goTo(r.getUrl() + relative);
        }

        public HtmlPage getPage(Item item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(Item item, String relative) throws IOException, SAXException {
            return this.goTo(item.getUrl() + relative);
        }

        public HtmlPage getPage(hudson.model.Node item) throws IOException, SAXException {
            return this.getPage(item, "");
        }

        public HtmlPage getPage(hudson.model.Node item, String relative) throws IOException, SAXException {
            return this.goTo(item.toComputer().getUrl() + relative);
        }

        public HtmlPage getPage(View view) throws IOException, SAXException {
            return this.goTo(view.getUrl());
        }

        public HtmlPage getPage(View view, String relative) throws IOException, SAXException {
            return this.goTo(view.getViewUrl() + relative);
        }

        @Deprecated
        public Page getPage(String url) throws IOException, FailingHttpStatusCodeException {
            try {
                Page page = super.getPage(url);
                return page;
            }
            finally {
                WebClientUtil.waitForJSExec(this);
            }
        }

        public HtmlPage goTo(String relative) throws IOException, SAXException {
            Page p = this.goTo(relative, "text/html");
            if (p instanceof HtmlPage) {
                return (HtmlPage)p;
            }
            throw new AssertionError((Object)("Expected text/html but instead the content type was " + p.getWebResponse().getContentType()));
        }

        public Page goTo(String relative, @CheckForNull String expectedContentType) throws IOException, SAXException {
            Page p;
            assert (!relative.startsWith("/"));
            try {
                p = super.getPage(this.getContextPath() + relative);
                WebClientUtil.waitForJSExec(this);
            }
            catch (IOException x) {
                Throwable cause = x.getCause();
                if (cause instanceof SocketTimeoutException) {
                    throw new AssumptionViolatedException("failed to get " + relative + " due to read timeout", cause);
                }
                if (cause != null) {
                    cause.printStackTrace();
                }
                throw x;
            }
            if (expectedContentType != null) {
                MatcherAssert.assertThat((Object)p.getWebResponse().getContentType(), (Matcher)Matchers.is((Object)expectedContentType));
            }
            return p;
        }

        public XmlPage goToXml(String path) throws IOException, SAXException {
            Page page = this.goTo(path, "application/xml");
            if (page instanceof XmlPage) {
                return (XmlPage)page;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assertFails(String url, int statusCode) throws Exception {
            assert (!url.startsWith("/"));
            boolean currentConfiguration = this.isThrowExceptionOnFailingStatusCode();
            this.setThrowExceptionOnFailingStatusCode(true);
            try {
                Assert.fail((String)(url + " should have been rejected but produced: " + super.getPage(this.getContextPath() + url).getWebResponse().getContentAsString()));
            }
            catch (FailingHttpStatusCodeException x) {
                Assert.assertEquals((long)statusCode, (long)x.getStatusCode());
            }
            finally {
                this.setThrowExceptionOnFailingStatusCode(currentConfiguration);
            }
        }

        public String getContextPath() throws IOException {
            return JenkinsRule.this.getURL().toExternalForm();
        }

        public WebRequest addCrumb(WebRequest req) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(JenkinsRule.this.getCrumbHeaderNVP());
            List oldParams = req.getRequestParameters();
            if (oldParams != null) {
                params.addAll(oldParams);
            }
            req.setRequestParameters(params);
            return req;
        }

        public URL createCrumbedUrl(String relativePath) throws IOException {
            CrumbIssuer issuer = JenkinsRule.this.jenkins.getCrumbIssuer();
            String crumbName = issuer.getDescriptor().getCrumbRequestField();
            String crumb = issuer.getCrumb(null);
            if (relativePath.indexOf(63) == -1) {
                return new URL(this.getContextPath() + relativePath + "?" + crumbName + "=" + crumb);
            }
            return new URL(this.getContextPath() + relativePath + "&" + crumbName + "=" + crumb);
        }

        @NonNull
        public WebClient withBasicCredentials(@NonNull String login, @NonNull String passwordOrToken) {
            String authCode = Base64.getEncoder().encodeToString((login + ":" + passwordOrToken).getBytes(StandardCharsets.UTF_8));
            this.addRequestHeader("Authorization", "Basic " + authCode);
            return this;
        }

        @NonNull
        public WebClient withBasicCredentials(@NonNull String loginAndPassword) {
            return this.withBasicCredentials(loginAndPassword, loginAndPassword);
        }

        @NonNull
        public WebClient withBasicApiToken(@NonNull hudson.model.User user) {
            String apiToken = JenkinsRule.this.createApiToken(user);
            return this.withBasicCredentials(user.getId(), apiToken);
        }

        @NonNull
        public WebClient withBasicApiToken(@NonNull String userId) {
            hudson.model.User user = hudson.model.User.getById((String)userId, (boolean)true);
            return this.withBasicApiToken(user);
        }

        public HtmlPage eval(Runnable requestHandler) throws IOException, SAXException {
            ClosureExecuterAction cea = (ClosureExecuterAction)JenkinsRule.this.jenkins.getExtensionList(RootAction.class).get(ClosureExecuterAction.class);
            UUID id = UUID.randomUUID();
            cea.add(id, requestHandler);
            return this.goTo("closures/?uuid=" + id);
        }

        public JSONWebResponse getJSON(@NonNull String path) throws IOException {
            assert (!path.startsWith("/"));
            URL URLtoCall = new URL(JenkinsRule.this.getURL(), path);
            WebRequest getRequest = new WebRequest(URLtoCall, HttpMethod.GET);
            getRequest.setAdditionalHeader("Content-Type", "application/json");
            getRequest.setAdditionalHeader("Accept", "application/json");
            getRequest.setAdditionalHeader("Accept-Encoding", "*");
            return new JSONWebResponse(this.loadWebResponse(getRequest));
        }

        public JSONWebResponse putJSON(@NonNull String path, @NonNull JSON json) throws IOException {
            assert (!path.startsWith("/"));
            URL URLtoCall = new URL(JenkinsRule.this.getURL(), path);
            WebRequest putRequest = new WebRequest(URLtoCall, HttpMethod.PUT);
            putRequest.setRequestBody(json.toString());
            putRequest.setAdditionalHeader("Content-Type", "application/json");
            putRequest.setAdditionalHeader("Accept", "application/json");
            putRequest.setAdditionalHeader("Accept-Encoding", "*");
            return new JSONWebResponse(this.loadWebResponse(putRequest));
        }

        public JSONWebResponse postJSON(@NonNull String path, @NonNull JSON json) throws IOException {
            assert (!path.startsWith("/"));
            URL URLtoCall = new URL(JenkinsRule.this.getURL(), path);
            WebRequest postRequest = new WebRequest(URLtoCall, HttpMethod.POST);
            postRequest.setAdditionalHeader("Content-Type", "application/json");
            postRequest.setAdditionalHeader("Accept", "application/json");
            postRequest.setAdditionalHeader("Accept-Encoding", "*");
            postRequest.setRequestBody(json.toString());
            return new JSONWebResponse(this.loadWebResponse(postRequest));
        }
    }

    private static final class Jpl {
        private final File home;
        final URL jpl;
        Manifest m;
        private String shortName;

        Jpl(File home, URL jpl) {
            this.home = home;
            this.jpl = jpl;
        }

        void loadManifest() throws IOException {
            this.m = new Manifest(this.jpl.openStream());
            this.shortName = this.m.getMainAttributes().getValue("Short-Name");
            if (this.shortName == null) {
                throw new Error(this.jpl + " doesn't have the Short-Name attribute");
            }
            FileUtils.copyURLToFile((URL)this.jpl, (File)new File(this.home, "plugins/" + this.shortName + ".jpl"));
        }

        void resolveDependencies(List<Jpl> jpls) throws Exception {
            String dependencies = this.m.getMainAttributes().getValue("Plugin-Dependencies");
            if (dependencies != null) {
                block2: for (String dep : dependencies.split(",")) {
                    String suffix = ";resolution:=optional";
                    boolean optional = dep.endsWith(suffix);
                    if (optional) {
                        dep = dep.substring(0, dep.length() - suffix.length());
                    }
                    String[] tokens = dep.split(":");
                    String artifactId = tokens[0];
                    String version = tokens[1];
                    for (Jpl other : jpls) {
                        if (!other.shortName.equals(artifactId)) continue;
                        continue block2;
                    }
                    File dependencyJar = this.resolveDependencyJar(artifactId, version);
                    if (dependencyJar == null) {
                        if (optional) {
                            LOGGER.log(Level.INFO, "cannot resolve optional dependency {0} of {1}; skipping", new Object[]{dep, this.shortName});
                            continue;
                        }
                        throw new IOException("Could not resolve " + dep + " in " + System.getProperty("java.class.path"));
                    }
                    File dst = new File(this.home, "plugins/" + artifactId + ".jpi");
                    if (dst.exists() && dst.lastModified() == dependencyJar.lastModified()) continue;
                    try {
                        FileUtils.copyFile((File)dependencyJar, (File)dst);
                    }
                    catch (ClosedByInterruptException x) {
                        throw new AssumptionViolatedException("copying dependencies was interrupted", (Throwable)x);
                    }
                }
            }
        }

        @CheckForNull
        private File resolveDependencyJar(String artifactId, String version) throws Exception {
            Enumeration<URL> manifests = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL manifest = manifests.nextElement();
                InputStream is = manifest.openStream();
                Manifest m = new Manifest(is);
                is.close();
                if (!artifactId.equals(m.getMainAttributes().getValue("Short-Name"))) continue;
                return Which.jarFile((URL)manifest);
            }
            Enumeration<URL> jellies = this.getClass().getClassLoader().getResources("index.jelly");
            while (jellies.hasMoreElements()) {
                File hpi;
                File target;
                File jellyF;
                File classes;
                URL jellyU = jellies.nextElement();
                if (!jellyU.getProtocol().equals("file") || !(classes = (jellyF = new File(jellyU.toURI())).getParentFile()).getName().equals("classes") || !(target = classes.getParentFile()).getName().equals("target") || !(hpi = new File(target, artifactId + ".hpi")).isFile()) continue;
                return hpi;
            }
            return null;
        }
    }

    public static class JSONWebResponse
    extends WebResponseWrapper {
        public JSONWebResponse(WebResponse webResponse) throws IllegalArgumentException {
            super(webResponse);
        }

        public JSONObject getJSONObject() {
            String json = this.getContentAsString();
            return JSONObject.fromObject((Object)json);
        }
    }

    static final class RemoteLogDumper
    extends MasterToSlaveCallable<Void, RuntimeException> {
        private final String name;
        private final Map<String, Level> loggers;
        private final TaskListener stderr;
        private final long start = DeltaSupportLogFormatter.start;
        private static final List<Logger> loggerReferences = new LinkedList<Logger>();

        RemoteLogDumper(String name, Map<String, Level> loggers, boolean forward) {
            this.name = name;
            this.loggers = loggers;
            this.stderr = forward ? StreamTaskListener.fromStderr() : null;
        }

        public Void call() throws RuntimeException {
            final PrintStream ps = this.stderr != null ? this.stderr.getLogger() : System.err;
            Handler handler = new Handler(){
                final Formatter formatter = new DeltaSupportLogFormatter();

                @Override
                public void publish(LogRecord record) {
                    if (this.isLoggable(record)) {
                        ps.print(this.formatter.format(record).replaceAll("(?m)^([ 0-9.]*)", (String)(name != null ? "$1[" + name + "] " : "$1 ")));
                        ps.flush();
                    }
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            };
            handler.setLevel(Level.ALL);
            this.loggers.forEach((key, value) -> {
                Logger logger = Logger.getLogger(key);
                logger.setLevel((Level)value);
                logger.addHandler(handler);
                loggerReferences.add(logger);
            });
            DeltaSupportLogFormatter.start = this.start;
            if (this.name != null) {
                ps.println("Set up log dumper on " + this.name + ": " + this.loggers);
            } else {
                ps.println("Set up log dumper: " + this.loggers);
            }
            ps.flush();
            return null;
        }
    }

    public static class DummySecurityRealm
    extends AbstractPasswordBasedSecurityRealm {
        private final Map<String, Set<String>> groupsByUser = new HashMap<String, Set<String>>();

        DummySecurityRealm() {
        }

        protected UserDetails authenticate2(String username, String password) throws AuthenticationException {
            if (username.equals(password)) {
                return this.loadUserByUsername2(username);
            }
            throw new BadCredentialsException(username);
        }

        public UserDetails loadUserByUsername2(String username) throws UsernameNotFoundException {
            ArrayList<Object> auths = new ArrayList<Object>();
            auths.add(AUTHENTICATED_AUTHORITY2);
            Set<String> groups = this.groupsByUser.get(username);
            if (groups != null) {
                for (String g : groups) {
                    auths.add(new SimpleGrantedAuthority(g));
                }
            }
            return new User(username, "", true, true, true, true, auths);
        }

        public GroupDetails loadGroupByGroupname(final String groupname) throws UsernameNotFoundException {
            for (Set<String> groups : this.groupsByUser.values()) {
                if (!groups.contains(groupname)) continue;
                return new GroupDetails(){

                    public String getName() {
                        return groupname;
                    }
                };
            }
            throw new UsernameNotFoundException(groupname);
        }

        public void addGroups(String username, String ... groups) {
            Set gs = this.groupsByUser.computeIfAbsent(username, k -> new TreeSet());
            gs.addAll(List.of(groups));
        }
    }

    public static class BreakException
    extends Exception {
    }

    private static final class SetConsoleLogger
    implements AutoCloseable {
        private final Handler handler;
        private final Level priorHandlerLevel;
        private final Logger logger;
        private final Level priorLoggerLevel;

        public SetConsoleLogger(@NonNull String loggerName, @NonNull Level level) {
            this.logger = Logger.getLogger(loggerName);
            this.priorLoggerLevel = this.logger.getLevel();
            if (this.priorLoggerLevel == null || level.intValue() < this.priorLoggerLevel.intValue()) {
                this.logger.setLevel(level);
            }
            this.handler = Arrays.stream(Logger.getLogger("").getHandlers()).filter(ConsoleHandler.class::isInstance).findFirst().orElse(null);
            if (this.handler != null) {
                this.priorHandlerLevel = this.handler.getLevel();
                if (this.priorHandlerLevel == null || level.intValue() < this.priorHandlerLevel.intValue()) {
                    this.handler.setLevel(level);
                }
            } else {
                this.priorHandlerLevel = null;
            }
        }

        @Override
        public void close() {
            this.logger.setLevel(this.priorLoggerLevel);
            if (this.handler != null) {
                this.handler.setLevel(this.priorHandlerLevel);
            }
        }
    }
}

